/*
 * Init variable
 */
$menuSections = null;
var estimatedHeight = [];
$collapsedSection = null;

var intervalInitCounting;


/*
 * Launch screen
 */

$(document).ready(function() {
	// Launch image
	ResetLaunchSize();
	InitRatioLaunch();
	
	// Menu
	initAccordionMenu();
	adjustSectionShare();
});

InitInterval();

$(window).resize(function() {
	// Launch image
	ResetLaunchSize();
	InitRatioLaunch();
	
	// Menu
	adjustSectionShare();
});

function initAccordionMenu() {
    $menuSections = $('.slide-nav .section');

    for (var i = 0; i < $menuSections.length; i++) {
        $section = $menuSections.eq(i);
        estimatedHeight[i] = $section.height();

        $section.find('.title').on('click', function() {
            accordion($(this).parent());
        });

        $section.find('.title').on('touchstart', function (e) {
             $(this).trigger('click');
             e.preventDefault();
        });

        //hide other sections menu on first launch
        if (i > 0) {
            $section.find('.menu').hide();
        }
        else {
            $collapsedSection = $section;
        }
    }

    adjustSectionShare();
}

function accordion($obj) {
    $collapsedSection = $obj;
    $collapsedSection.find('.menu').slideDown(300);

    for (var i = 0; i < $menuSections.length; i++) {
        $section = $menuSections.eq(i);
        if ($section.is($collapsedSection) == false) {
            $section.find('.menu').slideUp(300);
        }
    }

    adjustSectionShare();
}

function adjustSectionShare(){
    $height = 0;
	
	if ($menuSections) {
	    for (var i = 0; i < $menuSections.length; i++) {
			$section = $menuSections.eq(i);
			if ($section.is($collapsedSection) == true) {
				$height += estimatedHeight[i];
			}
		}
    }
    $realContentHeight = $('.closeArea').height() + $height + 90 + $('.section-share').height(); //margin bottom 20px, top 20px by default

    $delta =  $('.slide-nav').height() - $realContentHeight;

    if ($delta > 0) {
        $('.section-share').css('display', 'none');
        $('.section-share-absolute').css('display', 'block');
    }
    else {
        $('.section-share').css('display', 'block');
        $('.section-share-absolute').css('display', 'none');
    }
}

function InitInterval() {
	var intervalInit = setInterval(function(){
		ResetLaunchSize();
		InitRatioLaunch();
		adjustSectionShare();
		
		if(intervalInitCounting === undefined) {
			intervalInitCounting = 1;
		} else {
			intervalInitCounting++;
		}
		
		if(intervalInitCounting > 6) {
			clearTimeout(intervalInit);
		}
	}, 500);
}

function ResetLaunchSize() {
	$(".launch").css("min-height", "100%");
	$(".launch").css("height", "100%");
	$(".launchRealImage").css("margin-top", "0px");
	$(".launchRealImage").css("margin-left", "0px");
	$(".launchRealImage").css("width", "100%");
	$(".launchRealImage").css("height", "auto");
}
function InitRatioLaunch() {
	var launchWidth = $(".launch").width();
	var launchHeight = $(".launch").height();
	
	var realImageWidth = $(".launchRealImage").width();
	var realImageHeight = $(".launchRealImage").height();
	
	if(realImageWidth === 0 ||
	   realImageHeight === 0) {
		return;
	}
	
	var maxHeight = launchWidth * (76 / 100); // ~~ aspect ratio is 1.3
	var minHeight = launchWidth * (49 / 100); // ~~ aspect ratio is 2.0..
	
	if(launchHeight < minHeight) {
		//alert("test");
	} else {
		$(".launch").css("min-height", "100%");
		$(".launch").css("height", "100%");
		
		if(realImageHeight < launchHeight) {
			$(".launchRealImage").css("width", "auto");
			$(".launchRealImage").css("height", "100%");
			//realImageWidth = $(".launchRealImage").width();
			//var marginLeftValue = -(realImageWidth - launchWidth) / 2;
			//$(".launchRealImage").css("margin-left", marginLeftValue);
		}
		
		if(realImageHeight > launchHeight) {
			var marginTopValue = -(realImageHeight - launchHeight) / 2;
			$(".launchRealImage").css("margin-top", marginTopValue);
		}
	}
	
}
 


// jQuery for page scrolling feature - requires jQuery Easing plugin
$(function() {
    $('a.page-scroll').bind('click', function(event) {
        var $anchor = $(this);
        $('html, body').stop().animate({
            scrollTop: $($anchor.attr('href')).offset().top
        }, 1500, 'easeInOutExpo');
        event.preventDefault();
    });
});

/*
 * Slide Menu
 */
$(".transparentWrapper").click(function() {
	toggleMenu();
});
$(".transparentWrapper").on('touchstart', function (e) {
     $(this).trigger('click');
     e.preventDefault();
});

$("#toggle-slide-menu").click(function() {
	toggleMenu();
	return false;
});
$("#toggle-slide-menu").on('touchstart', function (e) {
     $(this).trigger('click');
     e.preventDefault();
});

$(".toggle-menu-close").click(function() {
	toggleMenu();
	return false;
});
$(".toggle-menu-close").on('touchstart', function (e) {
     $(this).trigger('click');
     e.preventDefault();
});

$(".closeArea").click(function() {
	toggleMenu();
	return false;
});

	function toggleMenu() {
		toggleSlideMenu();
		toggleMenuIcon();
		toggleScrollingPage();
		toggleTransparentDiv();
	}

    function toggleSlideMenu() {
        var slideMenu = $(".slide-nav");
        var isOpenedMenu = slideMenu.hasClass("open");
        if( isOpenedMenu ) {
            slideMenu.removeClass("open");
        } else {
            slideMenu.addClass("open");
        }
    }
    
    function toggleMenuIcon() {
        var openedIcon = $(".toggle-menu-open");
        var closedIcon = $(".toggle-menu-close");
        var closeArea = $(".closeArea");
        var isShowingOpenedIcon = closedIcon.css("display") == "none";
        
        if( isShowingOpenedIcon ) {
            openedIcon.css("display", "none");
            closedIcon.css("display", "inline");
            closeArea.css("display", "inline");
        } else {
            openedIcon.css("display", "inline");
            closedIcon.css("display", "none");
            closeArea.css("display", "none");
        }
    }
    
    function toggleScrollingPage() {
        var isDisablingScrolling = jQuery("html").css("overflow") == "hidden" || jQuery("body").css("overflow") == "hidden";
        if(isDisablingScrolling) {
            // PC
            jQuery("html").css("overflow", "");
            //jQuery("body").css("overflow", "");
            
            // IOS
            $(document).unbind('touchmove');
            $(".slide-nav").unbind('touchmove');
            
        } else {
            // PC
            jQuery("html").css("overflow", "hidden");
            //jQuery("body").css("overflow", "hidden");
            
            // IOS
            $(document).on('touchmove', function() {
                toggleMenu();
                return false;
            });
            $(".slide-nav").on('touchmove', false);
            
        }
    }
    
    function toggleTransparentDiv() {
        var transparentDiv = jQuery(".transparentWrapper");
        var isHidden = transparentDiv.css("display") == "none";
        if(isHidden) {
            transparentDiv.css("display", "block");
        } else {
            transparentDiv.css("display", "none;");
        }
    }