<?php
	$document = $_SERVER['DOCUMENT_ROOT'];
	$request_uri = $_SERVER['REQUEST_URI'];
	$response_uri = $request_uri;
	
	

	$dirname = pathinfo($request_uri,  PATHINFO_DIRNAME);
	$extension = strtolower(pathinfo($request_uri,  PATHINFO_EXTENSION));
	$filename = pathinfo($request_uri, PATHINFO_FILENAME);
	

	$filename = $filename . "_retina";
	$response_uri = $dirname . '/' . $filename . '.' . $extension;


	
	if( isset($_COOKIE["pixel_ratio"]) == false ){
		$response_file = $document . $request_uri;
		
	} else {

		$pixel_ratio = $_COOKIE["pixel_ratio"];		
		
		if( $pixel_ratio >= 1.5 ) {	
			
			$response_file = $document . $response_uri;
			if(file_exists($response_file) == false) {
				
				$original_file = $document . $request_uri;
				
				$percent = 2;

				// Get new sizes
				list($width, $height) = getimagesize($original_file);
				$newwidth = $width * $percent;
				$newheight = $height * $percent;

				$destination        = ImageCreateTrueColor($newwidth, $newheight); // re-sized image

				// Load
				$destination = imagecreatetruecolor($newwidth, $newheight);
				if($extension == "jpg" || $extension == "jpeg") {
				   $source = imagecreatefromjpeg($original_file);
				}

				if($extension == "png") {
				   $source = imagecreatefrompng($original_file);

				   imagealphablending($destination, false);
				    imagesavealpha($destination,true);
				    $transparent = imagecolorallocatealpha($destination, 255, 255, 255, 127);
				    imagefilledrectangle($destination, 0, 0, $newwidth, $newheight, $transparent);
				}
				
				if($extension == "gif") {
				   $source = imagecreatefromgif($original_file);

				   imagealphablending($destination, false);
				    imagesavealpha($destination,true);
				    $transparent = imagecolorallocatealpha($destination, 255, 255, 255, 127);
				    imagefilledrectangle($destination, 0, 0, $newwidth, $newheight, $transparent);
				}

				// Resize
				imagecopyresized($destination, $source, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);

				// Output
				$response_file_temp = $document . $response_uri;
				$new_file_name = md5($response_file_temp);
				$response_file = $document . "/adaptive-image-cache/" . $new_file_name . '.' . $extension;
				
				if(file_exists($response_file) == false) {				
				
					if($extension == "jpg" || $extension == "jpeg") {
					   $quality = 100; //100%
					   imagejpeg($destination, $response_file, $quality);
					}
	
					if($extension == "png") {
					   $compress = 0; // no compress when write image
					   imagepng($destination, $response_file, $compress); 
					}
	
					if($extension == "gif") {
					   imagegif($destination, $response_file);
					}
				}

				imagedestroy($destination);
			}
			
		} else {
			$response_file = $document . $request_uri;
		}
	}

	
	
	
	header("Content-Type: image/".$extension);
	header('Content-Length: '.filesize($response_file));
	readfile($response_file);
	exit();
?>