jQuery(document).ready(function() {
	var container = jQuery('#container_masonry');
	
	if(container != null) {
		container.ready(function() {
			container.masonry({
				itemSelector : '.item_masonry',
				columnWidth: 100,
			    isFitWidth: true,
			    isAnimated: !Modernizr.csstransitions,
			    isAnimated: true,
			})
		})
		
		container.imagesLoaded( function(){
		  container.masonry();
			//container.masonry("prepended")
		});

		jQuery(".item_masonry").bind("mouseup", function() {
			var clickedItem = jQuery(this).children(".tooltip_masonry");

			if(jQuery(this).hasClass("selected_masonry")) {
				return;
			}

			var arrangeDiv = ""
			if(jQuery(".selected_masonry").length > 0) {
				arrangeDiv = jQuery(".selected_masonry");
			}
			
			jQuery(".item_masonry").removeClass('selected_masonry')

			jQuery(".item_masonry .tooltip_masonry").slideUp(500, function() {
				jQuery(this).css("display", "none");
				
			});
			
			clickedItem.css("display", "block");
			
			arrangeInColumn(jQuery(this), true);
			if(arrangeDiv != "") {
				arrangeInColumn(arrangeDiv, false);
			}
			
			jQuery(this).addClass("selected_masonry");
			clickedItem.slideDown(500);

			
		})
	}
})

function arrangeInColumn(clickedItem, down) {
	clicked_item_width = clickedItem.width();
	clicked_item_height = clickedItem.height();
	clicked_item_left = clickedItem.position().left;
	clicked_item_top = clickedItem.position().top;
	clicked_item_right = clicked_item_width + clicked_item_left;

	jQuery(".item_masonry").not(clickedItem).each(function( index ) {
		item_width = jQuery(this).width();
		item_left = jQuery(this).position().left;
		item_top = jQuery(this).position().top;
		item_right = item_width + item_left;
		
		if(down == true) {
			changedValue = '+=57'
		} else {
			changedValue = '-=57'
		}

		if((item_left >= clicked_item_left && item_left <= clicked_item_right && item_top >= clicked_item_top) ||
		   (item_right >= clicked_item_left && item_right <= clicked_item_right && item_top >= clicked_item_top)) {
			
			//jQuery(this).stop()
			jQuery(this).animate({
				top: (changedValue)
			})
		}
	});
}

