<?php
/**
 * Display links to active bbPress 2.x plugins/extensions settings' pages
 *
 * @package    bbPress Admin Bar Addition
 * @subpackage Plugin/Extension Support
 * @author     David Decker - DECKERWEB
 * @copyright  Copyright 2011-2012, David Decker - DECKERWEB
 * @license    http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link       http://genesisthemes.de/en/wp-plugins/bbpress-admin-bar-addition/
 * @link       http://twitter.com/#!/deckerweb
 *
 * @since 1.0
 * @version 1.1
 */

/**
 * GD bbPress Attachments (free, by Dev4Press)
 *
 * @since 1.0
 */
if ( ( function_exists( 'is_plugin_active' ) && is_plugin_active( 'gd-bbpress-attachments/gd-bbpress-attachments.php' ) ) || class_exists( 'gdbbPressAttachments' ) ) {
	$menu_items['ext-gdattachments'] = array(
		'parent' => $extensions,
		'title'  => __( 'GD bbPress Attachments', 'bbpaba' ),
		'href'   => admin_url( 'edit.php?post_type=forum&page=gdbbpress_attachments' ),
		'meta'   => array( 'target' => '', 'title' => __( 'GD bbPress Attachments', 'bbpaba' ) )
	);
}  // end-if bbP Attachments


/**
 * bbPress Moderation (free, by Ian Haycox)
 *
 * @since 1.3
 */
if ( ( function_exists( 'is_plugin_active' ) && is_plugin_active( 'bbpressmoderation/bbpressmoderation.php' ) ) || class_exists( 'bbPressModeration' ) ) {
	$menu_items['ext-bbpmoderation'] = array(
		'parent' => $extensions,
		'title'  => __( 'bbPress Moderation Settings', 'bbpaba' ),
		'href'   => admin_url( 'options-general.php?page=bbpressmoderation' ),
		'meta'   => array( 'target' => '', 'title' => __( 'bbPress Moderation Settings', 'bbpaba' ) )
	);
	$menu_items['s-bbpmoderation'] = array(
		'parent' => $bbpsettings,
		'title'  => __( 'Moderation Settings (Plugin)', 'bbpaba' ),
		'href'   => 'http://www.bbconverter.com/',
		'meta'   => array( 'title' => __( 'Moderation Settings (Plugin)', 'bbpaba' ) )
	);
}  // end-if bbP Moderation


/**
 * WangGuard (free, by WangGuard Team)
 *
 * @since 1.4
 */
if ( ( function_exists( 'is_plugin_active' ) && is_plugin_active( 'wangguard/wangguard-admin.php' ) ) || function_exists( 'wangguard_init' ) ) {

	// Entries at "Users" level submenu
	$menu_items['userswangguard'] = array(
		'parent' => $users,
		'title'  => __( 'WangGuard Moderation Queue', 'bbpaba' ),
		'href'   => admin_url( 'admin.php?page=wangguard_queue' ),
		'meta'   => array( 'target' => '', 'title' => __( 'WangGuard Moderation Queue', 'bbpaba' ) )
	);
	$menu_items['userswangguard-wizard'] = array(
		'parent' => $users,
		'title'  => __( 'WangGuard Wizard', 'bbpaba' ),
		'href'   => admin_url( 'admin.php?page=wangguard_wizard' ),
		'meta'   => array( 'title' => __( 'WangGuard Wizard', 'bbpaba' ) )
	);
	$menu_items['userswangguard-stats'] = array(
		'parent' => $users,
		'title'  => __( 'WangGuard Statistics', 'bbpaba' ),
		'href'   => admin_url( 'admin.php?page=wangguard_stats' ),
		'meta'   => array( 'title' => __( 'WangGuard Statistics', 'bbpaba' ) )
	);

	// Entries at "Extensions" level submenu
	$menu_items['extwangguard'] = array(
		'parent' => $extensions,
		'title'  => __( 'WangGuard Moderation Queue', 'bbpaba' ),
		'href'   => admin_url( 'admin.php?page=wangguard_queue' ),
		'meta'   => array( 'target' => '', 'title' => __( 'WangGuard Moderation Queue', 'bbpaba' ) )
	);
	$menu_items['extwangguard-wizard'] = array(
		'parent' => $extwangguard,
		'title'  => __( 'Wizard', 'bbpaba' ),
		'href'   => admin_url( 'admin.php?page=wangguard_wizard' ),
		'meta'   => array( 'title' => __( 'Wizard', 'bbpaba' ) )
	);
	$menu_items['extwangguard-stats'] = array(
		'parent' => $extwangguard,
		'title'  => __( 'Statistics', 'bbpaba' ),
		'href'   => admin_url( 'admin.php?page=wangguard_stats' ),
		'meta'   => array( 'title' => __( 'Statistics', 'bbpaba' ) )
	);
	$menu_items['extwangguard-config'] = array(
		'parent' => $extwangguard,
		'title'  => __( 'Configuration', 'bbpaba' ),
		'href'   => admin_url( 'admin.php?page=wangguard_conf' ),
		'meta'   => array( 'title' => __( 'Configuration', 'bbpaba' ) )
	);
}  // end-if WangGuard


/**
 * Members (free, by Justin Tadlock)
 *
 * @since 1.4
 */
if ( ( function_exists( 'is_plugin_active' ) && is_plugin_active( 'members/members.php' ) ) && current_user_can( 'edit_roles' ) ) {

	// Entries at "Users" level submenu
	$menu_items['u-members'] = array(
		'parent' => $users,
		'title'  => __( 'Members: Adjust Roles &amp; Capabilities', 'bbpaba' ),
		'href'   => admin_url( 'users.php?page=roles' ),
		'meta'   => array( 'target' => '', 'title' => __( 'Members: Adjust Roles &amp; Capabilities', 'bbpaba' ) )
	);
	$menu_items['u-members-add'] = array(
		'parent' => $users,
		'title'  => __( 'Members: Add new Role', 'bbpaba' ),
		'href'   => admin_url( 'users.php?page=role-new' ),
		'meta'   => array( 'title' => __( 'Members: Add new Role', 'bbpaba' ) )
	);
}  // end-if Members


/**
 * bbPress Post Toolbar (free, by master5o1)
 *
 * @since 1.0
 */
if ( ( function_exists( 'is_plugin_active' ) && is_plugin_active( 'bbpress-post-toolbar/bbpress-post-toolbar.php' ) ) || class_exists( 'class bbp_5o1_toolbar' ) ) {
	$menu_items['ext-posttoolbar'] = array(
		'parent' => $extensions,
		'title'  => __( 'bbPress Post Toolbar', 'bbpaba' ),
		'href'   => admin_url( 'plugins.php?page=bbpress-post-toolbar' ),
		'meta'   => array( 'target' => '', 'title' => __( 'bbPress Post Toolbar', 'bbpaba' ) )
	);
}  // end-if bbP Post Toolbar


/**
 * bbPress Antispam (free, by Daniel Huesken)
 *
 * @since 1.3
 */
if ( ( function_exists( 'is_plugin_active' ) && is_plugin_active( 'bbpress-antispam/bbpress-antispam.php' ) ) || class_exists( 'bbPress_Antispam' ) ) {
	$menu_items['ext-antispam'] = array(
		'parent' => $extensions,
		'title'  => __( 'bbPress Antispam Settings', 'bbpaba' ),
		'href'   => admin_url( 'options-general.php?page=bbpress#bbpress-antispam' ),
		'meta'   => array( 'target' => '', 'title' => __( 'bbPress Antispam Settings', 'bbpaba' ) )
	);
}  // end-if bbP Antispam


/**
 * bbPress reCaptcha (free, by Pippin Williamson)
 *
 * @since 1.0
 */
if ( ( function_exists( 'is_plugin_active' ) && is_plugin_active( 'bbpress-recaptcha/bbpress-recaptcha.php' ) ) ) {
	$menu_items['ext-recaptcha'] = array(
		'parent' => $extensions,
		'title'  => __( 'bbPress reCaptcha', 'bbpaba' ),
		'href'   => admin_url( 'options-general.php?page=bbpress-recaptcha-settings' ),
		'meta'   => array( 'target' => '', 'title' => __( 'bbPress reCaptcha', 'bbpaba' ) )
	);
}  // end-if bbP reCaptcha


/**
 * bbPress WP Tweaks (free, by veppa)
 *
 * @since 1.4
 */
if ( ( function_exists( 'is_plugin_active' ) && is_plugin_active( 'bbpress-wp-tweaks/bbpress-wp-tweaks.php' ) ) || class_exists( 'BbpressWpTweaks' ) ) {
	$menu_items['ext-wptweaks'] = array(
		'parent' => $extensions,
		'title'  => __( 'bbPress WP Tweaks', 'bbpaba' ),
		'href'   => admin_url( 'options-general.php?page=bbpress-wp-tweaks' ),
		'meta'   => array( 'target' => '', 'title' => __( 'bbPress WP Tweaks', 'bbpaba' ) )
	);
}  // end-if bbP WP Tweaks


/**
 * bbPress2 BBCode (free, by antonchanning + bOingball + Viper007Bond)
 *
 * @since 1.0
 */
if ( ( function_exists( 'is_plugin_active' ) && is_plugin_active( 'bbpress-bbcode/bbpress2-bbcode.php' ) ) || class_exists( 'BBCode' ) ) {
	$menu_items['ext-bbcode'] = array(
		'parent' => $extensions,
		'title'  => __( 'bbPress2 BBCode', 'bbpaba' ),
		'href'   => admin_url( 'options-general.php?page=bbPress2-bbcode' ),
		'meta'   => array( 'target' => '', 'title' => __( 'bbPress2 BBCode', 'bbpaba' ) )
	);
}  // end-if bbP BBCode


/**
 * bbPress2 Shortcode Whitelist (free, by antonchanning)
 *
 * @since 1.0
 */
if ( ( function_exists( 'is_plugin_active' ) && is_plugin_active( 'bbpress2-shortcode-whitelist/bbpress2-shortcode-whitelist.php' ) ) || class_exists( 'bbPressShortcodeWhitelist' ) ) {
	$menu_items['ext-shortcode-whitelist'] = array(
		'parent' => $extensions,
		'title'  => __( 'bbPress2 Shortcode Whitelist', 'bbpaba' ),
		'href'   => admin_url( 'options-general.php?page=bbPress2-shortcode-whitelist' ),
		'meta'   => array( 'target' => '', 'title' => __( 'bbPress2 Shortcode Whitelist', 'bbpaba' ) )
	);
}  // end-if bbP Shortcode Whitelist


/**
 * Custom Post Type Privacy (free, by Kev Price)
 *
 * @since 1.4
 */
if ( ( function_exists( 'is_plugin_active' ) && is_plugin_active( 'custom-post-type-privacy/custom-post-type-privacy.php' ) ) || class_exists( 'wp_cpt_sentry' ) ) {
	$menu_items['extcptprivacy'] = array(
		'parent' => $extensions,
		'title'  => __( 'Custom Post Type Privacy / User Groups', 'bbpaba' ),
		'href'   => admin_url( 'admin.php?page=custom-post-type-privacy/custom-post-type-privacy.php' ),
		'meta'   => array( 'target' => '', 'title' => __( 'Custom Post Type Privacy / User Groups', 'bbpaba' ) )
	);
	$menu_items['extcptprivacy-forums'] = array(
		'parent' => $extcptprivacy,
		'title'  => __( 'Adjust Forum Privacy', 'bbpaba' ),
		'href'   => admin_url( 'admin.php?page=cpt-sentry-forum' ),
		'meta'   => array( 'target' => '', 'title' => __( 'Adjust Forum Privacy', 'bbpaba' ) )
	);
	$menu_items['extcptprivacy-topics'] = array(
		'parent' => $extcptprivacy,
		'title'  => __( 'Adjust Topic Privacy', 'bbpaba' ),
		'href'   => admin_url( 'admin.php?page=cpt-sentry-topic' ),
		'meta'   => array( 'target' => '', 'title' => __( 'Adjust Topic Privacy', 'bbpaba' ) )
	);
}  // end-if bbP CPT Privacy


/**
 * bbConverter (free, by anointed + AWJunkies)
 *
 * @since 1.2
 */
if ( ( function_exists( 'is_plugin_active' ) && is_plugin_active( 'bbconverter/bbconverter.php' ) ) || class_exists( 'bbConverter' ) ) {
	$menu_items['extbbpconvert'] = array(
		'parent' => $extensions,
		'title'  => __( 'bbConverter', 'bbpaba' ),
		'href'   => admin_url( 'options-general.php?page=bbconverter' ),
		'meta'   => array( 'target' => '', 'title' => __( 'bbConverter', 'bbpaba' ) )
	);
	$menu_items['ext-bbconverter-site'] = array(
		'parent' => $extbbpconvert,
		'title'  => __( 'bbConverter Support Site', 'bbpaba' ),
		'href'   => 'http://www.bbconverter.com/',
		'meta'   => array( 'title' => __( 'bbConverter Support Site', 'bbpaba' ) )
	);
}  // end-if bbConverter


/**
 * WP SyntaxHighlighter (free, by redcocker)
 *
 * @since 1.3
 */
if ( ( function_exists( 'is_plugin_active' ) && is_plugin_active( 'wp-syntaxhighlighter/wp-syntaxhighlighter.php' ) ) || function_exists( 'wp_sh_language_array' ) ) {
	$menu_items['ext-wpsyntaxhighlighter'] = array(
		'parent' => $extensions,
		'title'  => __( 'WP SyntaxHighlighter', 'bbpaba' ),
		'href'   => admin_url( 'options-general.php?page=wp-syntaxhighlighter-options' ),
		'meta'   => array( 'target' => '', 'title' => __( 'WP SyntaxHighlighter', 'bbpaba' ) )
	);
}  // end-if WP Syntaxhighlighter
