<?php 
/**
 * Main plugin file. This plugin adds useful admin links and resources for the bbPress 2.x Forum Plugin to the WordPress Toolbar / Admin Bar.
 *
 * @package   bbPress Admin Bar Addition
 * @author    David Decker
 * @link      http://twitter.com/#!/deckerweb
 * @copyright Copyright 2011-2012, David Decker - DECKERWEB
 *
 * @credits Inspired and based on the plugin "WooThemes Admin Bar Addition" by Remkus de Vries @defries.
 * @link http://remkusdevries.com/
 * @link http://twitter.com/#!/defries
 *
 * Plugin Name: bbPress Admin Bar Addition
 * Plugin URI: http://genesisthemes.de/en/wp-plugins/bbpress-admin-bar-addition/
 * Description: This plugin adds useful admin links and resources for the bbPress 2.x Forum Plugin to the WordPress Toolbar / Admin Bar.
 * Version: 1.4
 * Author: David Decker - DECKERWEB
 * Author URI: http://deckerweb.de/
 * License: GPLv2
 * Text Domain: bbpaba
 * Domain Path: /languages/
 */

/**
 * Setting constants
 *
 * @since 1.0
 */
define( 'BBPABA_PLUGIN_BASEDIR', dirname( plugin_basename( __FILE__ ) ) );


add_action( 'init', 'ddw_bbpress_aba_init' );
/**
 * Load the text domain for translation of the plugin
 * 
 * @since 1.0
 */
function ddw_bbpress_aba_init() {

	load_plugin_textdomain( 'bbpaba', false, BBPABA_PLUGIN_BASEDIR . '/languages/' );
}


add_filter( 'plugin_row_meta', 'ddw_bbpress_aba_plugin_links', 10, 2 );
/**
 * Add various support links to plugin page
 *
 * @since 1.0
 *
 * @param  $bbpaba_links
 * @param  $bbpaba_file
 * @return strings plugin links
 */
function ddw_bbpress_aba_plugin_links( $bbpaba_links, $bbpaba_file ) {

	if ( !current_user_can( 'install_plugins' ) )
		return $bbpaba_links;

	if ( $bbpaba_file == BBPABA_PLUGIN_BASEDIR . '/bbpress-admin-bar-addition.php' ) {
		$bbpaba_links[] = '<a href="http://wordpress.org/extend/plugins/bbpress-admin-bar-addition/faq/" target="_new" title="' . __( 'FAQ', 'bbpaba' ) . '">' . __( 'FAQ', 'bbpaba' ) . '</a>';
		$bbpaba_links[] = '<a href="http://wordpress.org/tags/bbpress-admin-bar-addition?forum_id=10" target="_new" title="' . __( 'Support', 'bbpaba' ) . '">' . __( 'Support', 'bbpaba' ) . '</a>';
		$bbpaba_links[] = '<a href="' . __( 'http://genesisthemes.de/en/donate/', 'bbpaba' ) . '" target="_new" title="' . __( 'Donate', 'bbpaba' ) . '">' . __( 'Donate', 'bbpaba' ) . '</a>';
	}

	return $bbpaba_links;
}


add_action( 'admin_bar_menu', 'ddw_bbpress_aba_admin_bar_menu', 98 );
/**
 * Add new menu items to the WP Admin Bar.
 * 
 * @since 1.0
 * @version 1.1
 *
 * @global mixed $wp_admin_bar 
 */
function ddw_bbpress_aba_admin_bar_menu() {

	global $wp_admin_bar;

	/** Required bbPress/ WordPress cabability to display new admin bar entry */
	if ( !current_user_can( 'moderate' ) || !is_admin_bar_showing() )
		return;

	/** Set unique prefix */
	$prefix = 'ddw-bbpress-';
	
	/** Create parent menu item references */
	$bbpressbar = $prefix . 'admin-bar';		// root level
	$bbpsupport = $prefix . 'bbpsupport';			// sub level: bbp support
	$bbpknowledgebase = $prefix . 'bbpknowledgebase';	// sub level: bbp knowledgebase
	$bbpsites = $prefix . 'bbpsites';			// sub level: bbp sites
	$bbpsettings = $prefix . 'bbpsettings';			// sub level: bbp settings
	$forums = $prefix . 'forums';				// sub level: forums
	$topics = $prefix . 'topics';				// sub level: topics
	$replies = $prefix . 'replies';				// sub level: replies
	$users = $prefix . 'users';				// sub level: users
	$userswangguard = $prefix . 'userswangguard';			// third level plugin extension: wangguard
	$extensions = $prefix . 'extensions';			// sub level: support
	$extwangguard = $prefix . 'extwangguard';			// third level plugin extension: wangguard
	$extcptprivacy = $prefix . 'extcptprivacy';			// third level plugin extension: custom post type privacy
	$extbbpconvert = $prefix . 'extbbpconvert';			// third level plugin extension: bbconverter
	$bbpgroup = $prefix . 'bbpgroup';			// sub level: bbp group (resources)

	/**
	 * Check for WordPress version to add parent ids for resource links group
	 * Check against WP 3.3+ only function "wp_editor" - if true use "$bbpgroup" as parent (WP 3.3+ style)
	 * otherwise use "$bbpressbar" as parent (WP 3.1/3.2 style)
	 *
	 * @since 1.4
	 *
	 * @param $bbpgroup_check_item
	 */
	if ( function_exists( 'wp_editor' ) ) {
		$bbpgroup_check_item = $bbpgroup;
	} else {
		$bbpgroup_check_item = $bbpressbar;
	}

	/** Display these items also when bbPress plugin is not installed */
	$menu_items = array(
		// Support menu items
		'bbpsupport' => array(
			'parent' => $bbpgroup_check_item,
			'title'  => __( 'bbPress Support Forum', 'bbpaba' ),
			'href'   => 'http://bbpress.org/forums/',
			'meta'   => array( 'title' => __( 'bbPress Support Forum', 'bbpaba' ) )
		),
		'bbpsupporttag' => array(
			'parent' => $bbpsupport,
			'title'  => __( 'Only Topic Tag: bbpress-plugin', 'bbpaba' ),
			'href'   => 'http://bbpress.org/forums/tags/bbpress-plugin',
			'meta'   => array( 'title' => __( 'Only Topic Tag: bbpress-plugin', 'bbpaba' ) )
		),
		'bbpsupportwporg' => array(
			'parent' => $bbpsupport,
			'title'  => __( 'Free Support Forum (WP.org)', 'bbpaba' ),
			'href'   => 'http://wordpress.org/tags/bbpress?forum_id=10',
			'meta'   => array( 'title' => __( 'Free Support Forum (WP.org)', 'bbpaba' ) )
		),
		// Knowledge Base menu items
		'bbpknowledgebase' => array(
			'parent' => $bbpgroup_check_item,
			'title'  => __( 'bbPress Docs & FAQ', 'bbpaba' ),
			'href'   => 'http://bbpress.org/forums/topic/bbpress-20-faq',
			'meta'   => array( 'title' => __( 'bbPress Docs & FAQ', 'bbpaba' ) )
		),
		'bbpshortcodes' => array(
			'parent' => $bbpknowledgebase,
			'title'  => __( 'bbPress Shortcodes', 'bbpaba' ),
			'href'   => 'http://bbpress.org/forums/topic/bbpress-20-shortcodes',
			'meta'   => array( 'title' => __( 'bbPress Shortcodes', 'bbpaba' ) )
		),
		'bbphooks' => array(
			'parent' => $bbpknowledgebase,
			'title'  => __( 'bbPress 2.0 Hooks, Filters &amp; Components (Dev Docs)', 'bbpaba' ),
			'href'   => 'http://etivite.com/api-hooks/#bbpress',
			'meta'	 => array( 'title' => __( 'bbPress 2.0 Hooks, Filters &amp; Components (Dev Docs)', 'bbpaba' ) )
		),
		'bbpvideo' => array(
			'parent' => $bbpknowledgebase,
			'title'  => __( 'bbPress Installation Video', 'bbpaba' ),
			'href'   => 'http://www.youtube.com/watch?v=EDAp8M7CuPk&hd=1',
			'meta'	 => array( 'title' => __( 'bbPress Installation Video', 'bbpaba' ) )
		),
		'bbpgetstarted' => array(
			'parent' => $bbpknowledgebase,
			'title'  => __( 'Getting Started with bbPress (Smashing Magazine)', 'bbpaba' ),
			'href'   => 'http://wp.smashingmagazine.com/2011/11/15/getting-started-with-bbpress/',
			'meta'	 => array( 'title' => __( 'Getting Started with bbPress (Smashing Magazine)', 'bbpaba' ) )
		),
		// bbPress HQ menu items
		'bbpsites' => array(
			'parent' => $bbpgroup_check_item,
			'title'  => __( 'bbPress HQ', 'bbpaba' ),
			'href'   => 'http://bbpress.org/',
			'meta'   => array( 'title' => __( 'bbPress HQ', 'bbpaba' ) )
		),
		'bbpblog' => array(
			'parent' => $bbpsites,
			'title'  => __( 'Official Blog', 'bbpaba' ),
			'href'   => 'http://bbpress.org/blog/',
			'meta'   => array( 'title' => __( 'Official Blog', 'bbpaba' ) )
		),
		'bbpdevel' => array(
			'parent' => $bbpsites,
			'title'  => __( 'Development Updates', 'bbpaba' ),
			'href'   => 'http://bbpdevel.wordpress.com/',
			'meta'   => array( 'title' => __( 'Development Updates', 'bbpaba' ) )
		),
		'bbptrac' => array(
			'parent' => $bbpsites,
			'title'  => __( 'Trac: Tickets &amp; Bug Reports', 'bbpaba' ),
			'href'   => 'http://bbpress.trac.wordpress.org/roadmap',
			'meta'   => array( 'title' => __( 'Trac: Tickets &amp; Bug Reports', 'bbpaba' ) )
		),
		'bbpplugins' => array(
			'parent' => $bbpsites,
			'title'  => __( 'More free plugins/extensions at WP.org', 'bbpaba' ),
			'href'   => 'http://wordpress.org/extend/plugins/tags/bbpress/',
			'meta'   => array( 'title' => __( 'More free plugins/extensions at WP.org', 'bbpaba' ) )
		),
	);


	/** Display the following links only for these locales: de_DE, de_AT, de_CH, de_LU */
	if ( get_locale() == 'de_DE' || get_locale() == 'de_AT' || get_locale() == 'de_CH' || get_locale() == 'de_LU' ) {
		// German public community support forum
		$menu_items['bbp-forum-de'] = array(
			'parent' => $bbpgroup_check_item,
			'title'  => __( 'German Support Forum', 'bbpaba' ),
			'href'   => 'http://forum.wpde.org/bbpress/',
			'meta'   => array( 'title' => __( 'Public German Community Support Forum', 'bbpaba' ) )
		);
		// German language packs
		$menu_items['bbp-languages-de'] = array(
			'parent' => $bbpgroup_check_item,
			'title'  => __( 'German language files', 'bbpaba' ),
			'href'   => 'http://deckerweb.de/material/sprachdateien/bbpress-forum/',
			'meta'   => array( 'title' => __( 'German language files for bbPress 2.x plus some extensions', 'bbpaba' ) )
		);
	}  // end-if german locales


	/** Show these items only if bbPress plugin is actually installed */
	if ( class_exists( 'bbPress' ) ) {
		// Main settings section
		$menu_items['bbpsettings'] = array(
			'parent' => $bbpressbar,
			'title'  => __( 'bbPress Main Settings', 'bbpaba' ),
			'href'   => admin_url( 'options-general.php?page=bbpress' ),
			'meta'   => array( 'target' => '', 'title' => __( 'bbPress Main Settings', 'bbpaba' ) )
		);
		$menu_items['s-general-settings'] = array(
			'parent' => $bbpsettings,
			'title'  => __( 'Recount (Topics &amp; Replies)', 'bbpaba' ),
			'href'   => admin_url( 'tools.php?page=bbp-recount' ),
			'meta'   => array( 'target' => '', 'title' => __( 'Recount (Topics &amp; Replies)', 'bbpaba' ) )
		);
		$menu_items['s-widgets'] = array(
			'parent' => $bbpsettings,
			'title'  => __( 'bbPress Widgets', 'bbpaba' ),
			'href'   => admin_url( 'widgets.php' ),
			'meta'   => array( 'target' => '', 'title' => __( 'bbPress Widgets', 'bbpaba' ) )
		);
		// Forums section
		$menu_items['forums'] = array(
			'parent' => $bbpressbar,
			'title'  => __( 'Forums', 'bbpaba' ),
			'href'   => admin_url( 'edit.php?post_type=forum' ),
			'meta'   => array( 'target' => '', 'title' => __( 'Forums', 'bbpaba' ) )
		);
		$menu_items['f-add-forum'] = array(
			'parent' => $forums,
			'title'  => __( 'Add new Forum', 'bbpaba' ),
			'href'   => admin_url( 'post-new.php?post_type=forum' ),
			'meta'   => array( 'target' => '', 'title' => __( 'Add new Forum', 'bbpaba' ) )
		);
		// Topics section
		$menu_items['topics'] = array(
			'parent' => $bbpressbar,
			'title'  => __( 'Topics', 'bbpaba' ),
			'href'   => admin_url( 'edit.php?post_type=topic' ),
			'meta'   => array( 'target' => '', 'title' => __( 'Topics', 'bbpaba' ) )
		);
		$menu_items['t-add-topic'] = array(
			'parent' => $topics,
			'title'  => __( 'Add new Topic', 'bbpaba' ),
			'href'   => admin_url( 'post-new.php?post_type=topic' ),
			'meta'   => array( 'target' => '', 'title' => __( 'Add new Topic', 'bbpaba' ) )
		);
		$menu_items['t-topic-tags'] = array(
			'parent' => $topics,
			'title'  => __( 'Topic Tags', 'bbpaba' ),
			'href'   => admin_url( 'edit-tags.php?taxonomy=topic-tag&post_type=topic' ),
			'meta'   => array( 'target' => '', 'title' => __( 'Topic Tags', 'bbpaba' ) )
		);
		// Replies section
		$menu_items['replies'] = array(
			'parent' => $bbpressbar,
			'title'  => __( 'Replies', 'bbpaba' ),
			'href'   => admin_url( 'edit.php?post_type=reply' ),
			'meta'   => array( 'target' => '', 'title' => __( 'Replies', 'bbpaba' ) )
		);
		$menu_items['r-add-reply'] = array(
			'parent' => $replies,
			'title'  => __( 'Add new Reply', 'bbpaba' ),
			'href'   => admin_url( 'post-new.php?post_type=reply' ),
			'meta'   => array( 'target' => '', 'title' => __( 'Add new Reply', 'bbpaba' ) )
		);
		// Users section
		if ( current_user_can( 'edit_users' ) ) {
			$menu_items['users'] = array(
				'parent' => $bbpressbar,
				'title'  => __( 'Users', 'bbpaba' ),
				'href'   => admin_url( 'users.php' ),
				'meta'   => array( 'target' => '', 'title' => __( 'Users', 'bbpaba' ) )
			);
		}  // end-if can edit_users
		if ( current_user_can( 'add_users' ) ) {
			$menu_items['u-add-user'] = array(
				'parent' => $users,
				'title'  => __( 'Add new User', 'bbpaba' ),
				'href'   => admin_url( 'user-new.php' ),
				'meta'   => array( 'target' => '', 'title' => __( 'Add new User', 'bbpaba' ) )
			);
		}  // end-if can add_users

		/**
		 * Display last main item in the menu for active extensions/plugins
		 * ATTENTION: This is where plugins/extensions hook in on the sub-level hierarchy
		 *
		 * @since 1.0
		 */
		$menu_items['extensions'] = array(
			'parent' => $bbpressbar,
			'title'  => __( 'Active Extensions', 'bbpaba' ),
			'href'   => admin_url( 'plugins.php' ),
			'meta'   => array( 'target' => '', 'title' => __( 'Active Extensions', 'bbpaba' ) )
		);

	}  // end-if bbPress conditional


	/**
	 * Display links to active plugins/extensions settings' pages
	 *
	 * @since 1.0
	 * @version 1.1
	 */
		/** Include plugin file with plugin support links */
		require_once( 'bbpaba-plugins.php' );


	/** Allow menu items to be filtered, but pass in parent menu item IDs */
	$menu_items = (array) apply_filters( 'ddw_bbpress_aba_menu_items', $menu_items, $prefix, $bbpressbar, $bbpsupport, $bbpsites, $bbpsettings, $forums, $topics, $replies, $users, $userswangguard, $extensions, $extwangguard, $extcptprivacy, $extbbpconvert, $bbpgroup );

	/** Add the bbPress top-level item */
	$wp_admin_bar->add_menu( array(
		'id'    => $bbpressbar,
		'title' => __( 'bbPress', 'bbpaba' ),
		'href'  => admin_url( 'options-general.php?page=bbpress' ),
		'meta'  => array( 'class' => 'icon-bbpress', 'title' => __( 'bbPress Forums', 'bbpaba' ) )
	) );

	/** Loop through the menu items */
	foreach ( $menu_items as $id => $menu_item ) {
		
		// Add in the item ID
		$menu_item['id'] = $prefix . $id;

		// Add meta target to each item where it's not already set, so links open in new window/tab
		if ( ! isset( $menu_item['meta']['target'] ) )		
			$menu_item['meta']['target'] = '_blank';

		// Add class to links that open up in a new window/tab
		if ( '_blank' === $menu_item['meta']['target'] ) {
			if ( ! isset( $menu_item['meta']['class'] ) )
				$menu_item['meta']['class'] = '';
			$menu_item['meta']['class'] .= $prefix . 'bbpaba-new-tab';
		}

		// Add item
		$wp_admin_bar->add_menu( $menu_item );

	}  // end foreach

	/**
	 * Check for WordPress version to add resource links group
	 * Check against WP 3.3+ only function "wp_editor" - if true display group styling
	 * otherwise display links in WP 3.1/3.2 style
	 *
	 * @since 1.4
	 */
	if ( function_exists( 'wp_editor' ) ) {
		$wp_admin_bar->add_group( array(
			'parent' => $bbpressbar,
			'id'     => $bbpgroup,
			'meta'   => array( 'class' => 'ab-sub-secondary' )
		) );
	} else {
		$wp_admin_bar->add_menu( array(
			'parent' => $bbpressbar,
			'id'     => $bbpgroup
		) );
	}

}  // end of main function


add_action( 'wp_head', 'ddw_bbpress_aba_admin_style' );
add_action( 'admin_head', 'ddw_bbpress_aba_admin_style' );
/**
 * Add the styles for new WP Admin Bar entry
 * 
 * @since 1.0
 * @version 1.1
 */
function ddw_bbpress_aba_admin_style() {

	/** No styles if admin bar is disabled */
	if ( ! is_admin_bar_showing() )
		return;

	/**
	 * Add CSS styles to wp_head/admin_head
	 * Check against WP 3.3+ only function "wp_editor"
	 */
	/** Styles for WordPress 3.3 or higher */
	if ( function_exists( 'wp_editor' ) ) {

		?>
		<style type="text/css">
			#wpadminbar.nojs .ab-top-menu > li.menupop.icon-bbpress:hover > .ab-item,
			#wpadminbar .ab-top-menu > li.menupop.icon-bbpress.hover > .ab-item,
			#wpadminbar.nojs .ab-top-menu > li.menupop.icon-bbpress > .ab-item,
			#wpadminbar .ab-top-menu > li.menupop.icon-bbpress > .ab-item {
	      			 background-image: url(<?php echo plugins_url( 'bbpress-admin-bar-addition/images/bbpress-icon2.png',
	dirname( __FILE__ ) ); ?>);
				background-repeat: no-repeat;
				background-position: 0.85em 50%;
				padding-left: 30px;
			}
			#wp-admin-bar-ddw-bbpress-extensions {
	    			border-top: 1px solid;
				margin-bottom: -5px !important;
				padding-bottom: 3px !important;
				padding-top: 3px !important;
			}
			#wp-admin-bar-ddw-bbpress-bbp-forum-de > .ab-item:before,
			#wp-admin-bar-ddw-bbpress-bbp-languages-de > .ab-item:before {
				color: #ff9900;
				content: '• ';
			}
		</style>
		<?php

	/** Styles for WordPress prior 3.3 */
	} else {

		?>
		<style type="text/css">
			#wpadminbar .icon-bbpress > a {
				background: url(<?php echo plugins_url( 'bbpress-admin-bar-addition/images/bbpress-icon2.png', dirname( __FILE__ ) ); ?>) no-repeat 0.85em 50% transparent;
				padding-left: 30px;
			}
			#wp-admin-bar-ddw-bbpress-bbpsettings,
			#wp-admin-bar-ddw-bbpress-extensions {
	    			border-top: 1px solid;
			}
			#wp-admin-bar-ddw-bbpress-bbp-forum-de > a:before,
			#wp-admin-bar-ddw-bbpress-bbp-languages-de > a:before {
				color: #ff9900;
				content: '• ';
			}
		</style>
		<?php

	}  // end if else

}  // end of function ddw_bbpress_aba_admin_style
