<?php

    /*
    Plugin Name: bbPress Captcha
    Plugin URI: http://www.laptrinhvn.com   
    Description: Adds Captcha to the bbPress 2.0 topic reply form 
    Version: 1.00
    Author: Peter Son
    Author URI: http://www.laptrinhvn.com
    */

    require_once('recaptchalib.php');

    $bbpc_options = get_option('bbpc_settings');

    // adds the reCaptcha to front end
	function bbpc_display_topic_recaptcha() {

        global $bbpc_options;
        if(!current_user_can('manage_options')) {
            if(is_user_logged_in() && !isset($bbpc_options['show_to_logged_in']) || !isset($bbpc_options['show_to_new_topic']))
                return;

            $publickey = $bbpc_options['public_key'];
            echo '<p><label>Please input the captcha</label><br>' . recaptcha_get_html($publickey) . '</p>';
        }
    }
	add_action('bbp_theme_after_topic_form_content', 'bbpc_display_topic_recaptcha');
    
    function bbpc_display_reply_recaptcha() {

        global $bbpc_options;
        if(!current_user_can('manage_options')) {
            if(is_user_logged_in() && !isset($bbpc_options['show_to_logged_in']) || !isset($bbpc_options['show_to_new_reply']))
                return;

            $publickey = $bbpc_options['public_key'];
            echo '<p><label>Please input the captcha</label><br>' . recaptcha_get_html($publickey) . '</p>';
        }
    }
    add_action('bbp_theme_after_reply_form_content', 'bbpc_display_reply_recaptcha');
	
	function bbpc_display_register_recaptcha() {

        global $bbpc_options;
        if(!current_user_can('manage_options')) {
            if(is_user_logged_in() && !isset($bbpc_options['show_to_logged_in']) || !isset($bbpc_options['show_to_register']))
                return;

            $publickey = $bbpc_options['public_key'];
            echo '<p><label>Please input the captcha</label><br>' . recaptcha_get_html($publickey) . '</p>';
        }
    }
    add_action('register_form_middle', 'bbpc_display_register_recaptcha');

    function bbpc_validate_topic_recaptcha($reply_id) {
        if(!current_user_can('manage_options')) {    
            global $bbpc_options;

            if(is_user_logged_in() && !isset($bbpc_options['show_to_logged_in']) || !isset($bbpc_options['show_to_new_topic']))
                return;

            $privatekey = $bbpc_options['private_key'];
            $resp = recaptcha_check_answer(
            $privatekey,
            $_SERVER["REMOTE_ADDR"],
            $_POST["recaptcha_challenge_field"],
            $_POST["recaptcha_response_field"]
            );

            if (!$resp->is_valid) {
                bbp_add_error( 'bbp_reply_duplicate', __( '<strong>ERROR</strong>: The captcha you entered were incorrect', 'bbpress' ) );
            }
        }
    }
    add_action('bbp_new_topic_pre_extras', 'bbpc_validate_topic_recaptcha');

    function bbpc_validate_reply_recaptcha($reply_id) {
        if(!current_user_can('manage_options')) {	
            global $bbpc_options;

            if(is_user_logged_in() && !isset($bbpc_options['show_to_logged_in']) || !isset($bbpc_options['show_to_new_reply']))
                return;

            $privatekey = $bbpc_options['private_key'];
            $resp = recaptcha_check_answer(
            $privatekey,
            $_SERVER["REMOTE_ADDR"],
            $_POST["recaptcha_challenge_field"],
            $_POST["recaptcha_response_field"]
            );

            if (!$resp->is_valid) {
                bbp_add_error( 'bbp_reply_duplicate', __( '<strong>ERROR</strong>: The captcha you entered were incorrect', 'bbpress' ) );
            }
        }
    }
    add_action('bbp_new_reply_pre_extras', 'bbpc_validate_reply_recaptcha');

    function bbpc_validate_register_recaptcha($sanitized_user_login, $user_email) {
        if(!current_user_can('manage_options')) {    
            global $bbpc_options;

            if(is_user_logged_in() && !isset($bbpc_options['show_to_logged_in']) || !isset($bbpc_options['show_to_register']))
                return;

            $privatekey = $bbpc_options['private_key'];
            $resp = recaptcha_check_answer(
            $privatekey,
            $_SERVER["REMOTE_ADDR"],
            $_POST["recaptcha_challenge_field"],
            $_POST["recaptcha_response_field"]
            );

            if (!$resp->is_valid) {
                wp_safe_redirect("forums-register?rusername=".$sanitized_user_login."&remail=".urlencode($user_email)."&rnote=Input%20captcha%20is%20invalid,%20please%20try%20again.");
                exit();
            }
        }
    }
    add_action('register_post', 'bbpc_validate_register_recaptcha', 10, 2);

    function bbpc_settings_page() {
        global $bbpc_options;

    ?>
    <div class="wrap">
        <h2>bbPress reCaptcha Settings</h2>
        <?php
            if ( ! isset( $_REQUEST['updated'] ) )
                $_REQUEST['updated'] = false;
        ?>
        <?php if ( false !== $_REQUEST['updated'] ) : ?>
            <div class="updated fade"><p><strong><?php _e( 'Options saved' ); ?></strong></p></div>
            <?php endif; ?>
        <form method="post" action="options.php">

            <?php settings_fields( 'bbpc_settings_group' ); ?>

            <h4>reCaptcha Keys</h4>
            <p>
                <label for="bbpc_settings[public_key]"><?php _e( 'reCaptcha Public Key' ); ?></label><br/>
                <input id="bbpc_settings[public_key]" style="width: 300px;" name="bbpc_settings[public_key]" type="text" value="<?php echo $bbpc_options['public_key'];?>" />

            </p>
            <p class="description">This your own personal reCaptcha Public key. Go to <a href="https://www.google.com/recaptcha/admin/list">your account</a>, then click on your domain (or add a new one) to find your public key.</p>

            <p>
                <label for="bbpc_settings[private_key]"><?php _e( 'reCaptcha Private Key' ); ?></label><br/>
                <input id="bbpc_settings[private_key]" style="width: 300px;" name="bbpc_settings[private_key]" type="text" value="<?php echo $bbpc_options['private_key'];?>" />
            </p>
            <p class="description">This your own personal reCaptcha Private key. Go to <a href="https://www.google.com/recaptcha/admin/list">your account</a>, then click on your domain (or add a new one) to find your private key.</p>
            <p>
                <input id="bbpc_settings[show_to_logged_in]" name="bbpc_settings[show_to_logged_in]" type="checkbox" value="1" <?php checked('1', $bbpc_options['show_to_logged_in']); ?>/>
                <label for="bbpc_settings[show_to_logged_in]"><?php _e( 'Show to logged-in users?' ); ?></label><br/>
            </p>
			<p>
                <input id="bbpc_settings[show_to_new_topic]" name="bbpc_settings[show_to_new_topic]" type="checkbox" value="1" <?php checked('1', $bbpc_options['show_to_new_topic']); ?>/>
                <label for="bbpc_settings[show_to_new_topic]"><?php _e( 'Show on new topic form?' ); ?></label><br/>
            </p>
            <p>
                <input id="bbpc_settings[show_to_new_reply]" name="bbpc_settings[show_to_new_reply]" type="checkbox" value="1" <?php checked('1', $bbpc_options['show_to_new_reply']); ?>/>
                <label for="bbpc_settings[show_to_new_reply]"><?php _e( 'Show on new reply form?' ); ?></label><br/>
            </p>
			<p>
                <input id="bbpc_settings[show_to_register]" name="bbpc_settings[show_to_register]" type="checkbox" value="1" <?php checked('1', $bbpc_options['show_to_register']); ?>/>
                <label for="bbpc_settings[show_to_register]"><?php _e( 'Show on register form?' ); ?></label><br/>
            </p>
            <!-- save the options -->
            <p class="submit">
                <input type="submit" class="button-primary" value="<?php _e( 'Save Options' ); ?>" />
            </p>


        </form>
    </div><!--end wrap-->

    <?php
}

// register the plugin settings
function bbpc_register_settings() {
    register_setting( 'bbpc_settings_group', 'bbpc_settings' );
}

//call register settings function
add_action( 'admin_init', 'bbpc_register_settings' );

function bbpc_settings_menu() {
    // add settings page
    add_submenu_page('options-general.php', 'bbPress reCaptcha Settings', 'bbPress reCaptcha','manage_options', 'bbpress-recaptcha-settings', 'bbpc_settings_page');
}
add_action('admin_menu', 'bbpc_settings_menu');
