<?php
/*
* Plugin Name: bbPress Filter Spam Content
* Plugin URI: http://www.laptrinhvn.com/
* Description: filter spam reply by keyword in content    
* Version: 1.00
* Author: Peter Son
* Author URI: http://www.laptrinhvn.com/
*/

class ja_bbPress_Filter_Spam_Content {

    static $instance;

    function __construct() {

        self::$instance =& $this;

        // Admin area
        add_action( 'admin_init',           array( $this, 'admin_settings' ),       16      );
        add_filter( 'plugin_action_links',  array( $this, 'add_settings_link' ),    10, 3   );

        // Add action check spam
        //add_action( 'bbp_check_for_blacklist',   array( $this, 'bbp_blacklist_check' ) );

        // Triggers activation check
        register_activation_hook( __FILE__, array( $this, 'activation_hook' ) );
    }

    function activation_hook() {
        // Obviously, this wouldn't work to well without bbPress
        if( !class_exists( 'bbPress' ) ) {
            deactivate_plugins( plugin_basename(__FILE__) ); // Deactivate ourself
            wp_die( __('Sorry, you need to activate bbPress first.', 'ja_bbp_spam') );
        }

    }

    function add_settings_link( $links, $file ) {
        if ( plugin_basename( __FILE__ ) == $file ) {
            $settings_link = '<a href="' . admin_url( 'options-general.php?page=bbpress' ) . '#bbp_content_spam_filter">' . __( 'Settings', 'ja_bbp_spam' ) . '</a>';
            array_unshift( $links, $settings_link );
        }
        return $links;
    }

    function admin_settings() {

        // Add the section to primary bbPress options
        add_settings_section( 'ja_bbp_spam_options', __( 'Filter spam by content', 'ja_bbp_spam' ), array( $this, 'section_heading' ), 'bbpress' );

        // Add the content textarea
        add_settings_field( 'bbp_content_spam_filter', __( 'Keyword Spam', 'ja_bbp_spam' ), array( $this, 'content_spam_textarea' ), 'bbpress', 'ja_bbp_spam_options' );

        // Register our settings with the bbPress forum settings page
        register_setting( 'bbpress', 'bbp_content_spam_filter', array( $this, 'validate_content' ) );

    }

    function validate_content( $content ) {
        $content = esc_html( $content );
        return $content;
    }

    function section_heading() {
        _e( 'Filter spam content by keyword. One per line.', 'ja_bbp_spam' );
    }

    function content_spam_textarea() {
        $content_spam = get_option( 'bbp_content_spam_filter' );
        //$content_spam = str_replace( ' ', "\n", $content_spam );

        echo '<textarea id="bbp_content_spam_filter" cols="50" rows="4" name="bbp_content_spam_filter">' . $content_spam . '</textarea>';
    }

    function bbp_blacklist_check( $anonymous_data = false, $author_id = 0, $title = '', $content = '' ) {
        if ( !bbp_check_for_blacklist( $anonymous_data, $reply_author, $reply_title, $reply_content ) )
            bbp_add_error( 'bbp_filter_spam', __( '<strong>ERROR</strong>: Your reply cannot be created at this time.', 'bbpress' ) );

    }
    
    function bbp_check_for_blacklist( $anonymous_data = false, $author_id = 0, $title = '', $content = '' ) {

    // Bail if super admin is author
    if ( is_super_admin( $author_id ) )
        return true;

    // Define local variable
    $post = array();

    /** Blacklist *************************************************************/

    // Get the moderation keys
    $blacklist = trim( get_option( 'bbp_content_spam_filter' ) );

    // Bail if blacklist is empty
    if ( empty( $blacklist ) )
        return true;

    /** User Data *************************************************************/

    // Map anonymous user data
    if ( !empty( $anonymous_data ) ) {
        $post['author'] = $anonymous_data['bbp_anonymous_name'];
        $post['email']  = $anonymous_data['bbp_anonymous_email'];
        $post['url']    = $anonymous_data['bbp_anonymous_website'];

    // Map current user data
    } elseif ( !empty( $author_id ) ) {

        // Get author data
        $user = get_userdata( $author_id );

        // If data exists, map it
        if ( !empty( $user ) ) {
            $post['author'] = $user->display_name;
            $post['email']  = $user->user_email;
            $post['url']    = $user->user_url;
        }
    }

    // Current user IP and user agent
    $post['user_ip'] = bbp_current_author_ip();
    $post['user_ua'] = bbp_current_author_ua();

    // Post title and content
    $post['title']   = $title; 
    $post['content'] = $content; 

    /** Words *****************************************************************/

    // Get words separated by new lines
    $words = explode( "\n", $blacklist );

    // Loop through words
    foreach ( (array) $words as $word ) {

        // Trim the whitespace from the word
        $word = trim( $word );

        // Skip empty lines
        if ( empty( $word ) ) { continue; }

        // Do some escaping magic so that '#' chars in the
        // spam words don't break things:
        $word    = preg_quote( $word, '#' );
        $pattern = "#$word#i";

        // Loop through post data
        foreach( $post as $post_data ) {
            
            // Check each user data for current word
            if ( preg_match( $pattern, $post_data ) ) {
                
                // Post does not pass
                return false;
            }
        }
    }

    // Check passed successfully
    return true;
}

}

new ja_bbPress_Filter_Spam_Content();