<?php
    /**
    * Plugin Name: bbPress sub topic
    * Plugin URI: http://www.laptrinhvn.com/
    * Description: This Plugin add sub topic for the bbPress 2.x forum.
    * Version: 1.0
    * Author: Peter Son
    * Author URI: http://www.laptrinhvn.com/
    */
    //hook add select parent topic front end
    add_action('bbp_theme_after_topic_form_title' , 'bbp_parent_topic_drop_down_list');
    function bbp_parent_topic_drop_down_list(){
    ?><p>
        <label for="bbp_parent_topic_id">Parent Topic:</label>
        <br/>
        <select id="bbp_parent_topic_id" name="bbp_parent_topic_id">
            <?php
                if(current_user_can('manage_options')){
                ?>
                <option value="">(No Parent)</option>   
                <?php
                }
                
                $forum_id = bbp_get_forum_id();
                $args = array( 'post_type' => 'topic', 'post_parent' => $forum_id, 'numberposts' => -1, 'orderby' => 'title', 'order'=> 'ASC' );
                $topics =  get_posts($args);
                foreach($topics as $topic){
                    if(get_post_meta($topic->ID, '_bbp_parent_topic_id', true) == null) {
                    ?><option value="<?php echo($topic->ID); ?>"><?php echo($topic->post_title ); ?></option><?php   
                    }
                }
            ?>                                        
        </select>                                                                                  
    </p><?php
    }

    //hook save topic
    add_action('bbp_new_topic', bbp_sub_topic_save_topic);
    function bbp_sub_topic_save_topic($topic_id){

        global $wpdb;                                         
        $parent_topic_id = $_POST['bbp_parent_topic_id'];
        if ( !empty( $_POST['bbp_parent_topic_id'] ) ) {

            //add post meta
            $parent_topic_forum = bbp_get_topic_forum_id($parent_topic_id);
            update_post_meta($topic_id, '_bbp_parent_topic_id', $parent_topic_id);
            update_post_meta($topic_id, '_bbp_forum_id', $parent_topic_forum);                                                 
            $wpdb->update( $wpdb->posts, array( 'post_parent' => $parent_topic_id ), array( 'ID' => $topic_id ));
        } else {
            //delete post meta
            $parent_topic_id = get_post_meta($topic_id, '_bbp_parent_topic_id', true);
            if(!empty($parent_topic_id)){
                $parent_topic_forum = bbp_get_topic_forum_id($parent_topic_id);
                delete_post_meta($topic_id, '_bbp_parent_topic_id');                   
                $wpdb->update( $wpdb->posts, array( 'post_parent' => $parent_topic_forum ), array( 'ID' => $topic_id ));
            }
        }

        return $topic_id;

    }

    //hook into the topic atributes meta box
    add_action('bbp_topic_metabox' , 'bbp_sub_topic_attributes_mb');
    function bbp_sub_topic_attributes_mb($topic_id){   
        $query = array('post_parent' => $topic_id, 'post_type' => 'topic', 'orderby' => 'title', 'order' => 'ASC');
        $posts = get_posts($query);
        if($posts == null) {     
            $parent_topic_id = get_post_meta($topic_id, '_bbp_parent_topic_id', true); 
            if(empty($parent_topic_id)){
                $parent_topic_id = $_REQUEST['parent_topic_id'];  
            }                                                     
        ?>            
        <hr />                                                                                       
        <p>
            <strong>Parent Topic:</strong>
            <br/>
            <select id="bbp_parent_topic_id" name="bbp_parent_topic_id">
		<?php
			if(current_user_can('manage_options')){
                ?>
                <option value="">(No Parent)</option>
                <?php
			}
                    $args = array( 'post_type' => 'topic', 'numberposts' => -1, 'order'=> 'ASC', 'orderby' => 'title' );
                    $topics =  get_posts($args);
                    foreach($topics as $topic){
                        if(get_post_meta($topic->ID, '_bbp_parent_topic_id', true) == null && $topic->ID != $topic_id){
                        ?><option value="<?php echo($topic->ID); ?>" <?php if($topic->ID == $parent_topic_id) echo ('selected'); ?>><?php echo($topic->post_title ); ?></option><?php
                        }                
                    }
                ?>                                        
            </select>                                                                                  
        </p>

        <?php
        }
    }

    //hook into the topic save hook.
    add_action( 'bbp_topic_attributes_metabox_save' , 'bbp_sub_topic_attributes_mb_save' );
    function bbp_sub_topic_attributes_mb_save($topic_id){

        global $wpdb;                                         
        $parent_topic_id = $_POST['bbp_parent_topic_id'];
        if ( !empty( $_POST['bbp_parent_topic_id'] ) ) {

            //add post meta
            $parent_topic_forum = bbp_get_topic_forum_id($parent_topic_id);
            update_post_meta($topic_id, '_bbp_parent_topic_id', $parent_topic_id);
            update_post_meta($topic_id, '_bbp_forum_id', $parent_topic_forum);                                                
            $wpdb->update( $wpdb->posts, array( 'post_parent' => $parent_topic_id ), array( 'ID' => $topic_id ));
        } else {
            //delete post meta
            $parent_topic_id = get_post_meta($topic_id, '_bbp_parent_topic_id', true);
            if(!empty($parent_topic_id)){
                $parent_topic_forum = bbp_get_topic_forum_id($parent_topic_id);
                delete_post_meta($topic_id, '_bbp_parent_topic_id');                   
                $wpdb->update( $wpdb->posts, array( 'post_parent' => $parent_topic_forum ), array( 'ID' => $topic_id ));
            }
        }

        return $topic_id;

    }

    //hook into the topic insert hook
    function bbp_sub_topic_set_post_parent($data , $postarr){
        $data['post_parent'] = get_post_meta($data['guid'], '_bbp_forum_id', true);
        return $data;
    }

    //hook actions post in admin
    add_filter( 'post_row_actions', 'bbp_add_sub_topic_action', 10, 3 );
    function bbp_add_sub_topic_action( $actions, $topic ){
        $parent_topic_id = get_post_meta($topic->ID, '_bbp_parent_topic_id', true);
        if($parent_topic_id == null){
            $actions['subtopic'] = '<a href="' . get_admin_url() . 'post-new.php?post_type=topic&parent_topic_id=' .  $topic->ID . '" title="Add sub topic">Sub topic</a>';
        }
        return $actions;
    }

    //hook into 
    add_action( 'add_meta_boxes', 'sub_topic_create_meta_box' );
    function sub_topic_create_meta_box() {
        $topic_id = $_REQUEST['post'];
        if($topic_id != null){                  
            $query = array('post_parent' => $topic_id, 'post_type' => 'topic', 'orderby' => 'title', 'order' => 'ASC');
            $posts = get_posts($query);
            if($posts != null) {
                add_meta_box( 'sub-topic-meta-box', 'Sub topic', 'bbp_sub_topic_meta_box', $type->name, 'advanced', 'high' );
            }
        }
    }

    function bbp_sub_topic_meta_box(){
        $topic_id = $_REQUEST['post'];                  
        $query = array('post_parent' => $topic_id, 'post_type' => 'topic', 'orderby' => 'title', 'order' => 'ASC');
        $posts = get_posts($query);
        if($posts != null) {
            $text = '<ul>';
            foreach ($posts as $post) {
                $text .= '<li><a href="' . get_admin_url() . 'post.php?post=' . $post->ID . '&action=edit">' . $post->post_title . '</a></li>';
            }
            $text .= '</ul>';
            echo $text;
            //add_meta_box( 'sub-topic-meta-box', 'Sub topic', 'bbp_sub_topic_meta_box', $type->name, 'advanced', 'high' );
        }
    }

    //hook into view topic
    add_action('bbp_template_before_single_topic', 'bbp_sub_topic_get_children', 10);
    function bbp_sub_topic_get_children(){
        $topic_id = bbp_get_topic_id();                  
        $query = array('post_parent' => $topic_id, 'post_type' => 'topic', 'orderby' => 'title', 'order' => 'ASC');
        $posts = get_posts($query);
        if($posts != null) { ?>       
        <table id="bbp-sub-topic" class="bbp-topics" >
            <thead>
                <tr>
                    <th class="bbp-topic-title"><?php _e( 'Topic', 'bbpress' ); ?></th>
                    <th class="bbp-topic-voice-count"><?php _e( 'Voices', 'bbpress' ); ?></th>
                    <th class="bbp-topic-reply-count"><?php bbp_show_lead_topic() ? _e( 'Replies', 'bbpress' ) : _e( 'Posts', 'bbpress' ); ?></th>
                    <th class="bbp-topic-freshness"><?php _e( 'Freshness', 'bbpress' ); ?></th>
                </tr>
            </thead>

            <tbody>

                <?php foreach ($posts as $post) { ?>

                    <tr id="topic-<?php $post->ID; ?>" <?php bbp_topic_class(); ?>>

                        <td class="bbp-topic-title">

                            <a href="<?php bbp_topic_permalink($post->ID); ?>" title="<?php bbp_topic_title($post->ID); ?>"><b><?php bbp_topic_title($post->ID); ?></b></a>

                            <br/>
                            <i><small><?php echo bbp_get_topic_excerpt($post->ID, 100); ?></small></i>

                            <br/><br/>
                        </td>

                        <td class="bbp-topic-voice-count"><?php bbp_topic_voice_count($post->ID); ?></td>

                        <td class="bbp-topic-reply-count"><?php bbp_show_lead_topic() ? bbp_topic_reply_count($post->ID) : bbp_topic_post_count($post->ID); ?></td>

                        <td class="bbp-topic-freshness">           

                            <?php bbp_topic_freshness_link($post->ID); ?>

                            <p class="bbp-topic-meta">

                                <span class="bbp-topic-freshness-author"><?php bbp_author_link( array( 'post_id' => bbp_get_topic_last_active_id($post->ID), 'size' => 14 ) ); ?></span>

                            </p>
                        </td>

                    </tr>
                    <?php
                    }
                ?>

            </tbody>

        </table>
        <?php
        }
    }
    
    add_action('admin_footer', 'bbp_sub_topic_ajax'); 
    function bbp_sub_topic_ajax(){
        $script = '<script type="text/javascript">
        
        function GetXmlHttpObject()
        {
            if (window.XMLHttpRequest)
            {
                // code for IE7+, Firefox, Chrome, Opera, Safari
                return new XMLHttpRequest();
            }
            if (window.ActiveXObject)
            {
                // code for IE6, IE5
                return new ActiveXObject("Microsoft.XMLHTTP");
            }
            return null;
        } 

        function AjaxFunction(forum_id)
        {
            xmlhttp=GetXmlHttpObject();
            if (xmlhttp==null)
            {
                alert ("Your browser does not support XML HTTP Request");
                return;
            }
            var url="';
       $script = $script . trailingslashit(WP_PLUGIN_URL.'/'.str_replace(basename( __FILE__),"",plugin_basename(__FILE__))) . 'get-parent-topic.php";
            url=url+"?forum_id="+forum_id;
            url=url+"&sid="+Math.random();
            xmlhttp.onreadystatechange=stateck;
            xmlhttp.open("GET",url,true);
            xmlhttp.send(null);
        }
        
        function stateck() {
            if(xmlhttp.readyState==4 && xmlhttp.status == 200)
            {
                // Before adding new we must remove previously loaded elements
                for(j=document.post.bbp_parent_topic_id.options.length-1;j>0;j--)
                {
                    document.post.bbp_parent_topic_id.remove(j);
                }
                
                var myarray=eval(xmlhttp.responseText);
                    
                    for (i=0;i<myarray.length;i+=2)
                    {
                        var optn = document.createElement("OPTION");
                        optn.text = myarray[i+1];
                        optn.value = myarray[i];
                        document.post.bbp_parent_topic_id.options.add(optn);
                    }
                
            }
        }        
        
        var forumDropDownList = document.getElementById("parent_id");
        forumDropDownList.setAttribute("onChange", "AjaxFunction(this.value);" );
        </script>';
        echo $script;
    }
?>
