<?php

/**
 * Template Name: bbPress - Create Topic
 *
 * @package bbPress
 * @subpackage Theme
 */

?>

<?php get_header(); ?>

		<div id="container">
			<div id="content" role="main">

				<?php do_action( 'bbp_template_notices' ); ?>

				<?php while ( have_posts() ) : the_post(); ?>

					<div id="bbp-new-topic" class="bbp-new-topic">
						<h1 class="entry-title"><?php the_title(); ?></h1>
						
						<div id="accountPanel" style="display: none; float: right">
						<?php if ( is_user_logged_in() ) { ?>
						 <a href="<?php echo wp_logout_url(); ?>">Logout</a>
						<?php } else { ?>
						 <a href="<?php echo get_option('siteurl') ?>/forums-login">Login</a> / <a href="<?php echo get_option('siteurl') ?>/forums-register">Register</a>
						<?php } ?>
				   </div>
					
					<script>
						urlString=window.location.href;
						if(urlString.indexOf("/forums") != -1) {
							document.getElementById("accountPanel").style.display = "block";
						}
					</script>
					
					<div style="clear:both"></div>
						
						<div class="entry-content">

							<?php the_content(); ?>

							<?php bbp_get_template_part( 'bbpress/form', 'topic' ); ?>

						</div>
					</div><!-- #bbp-new-topic -->

				<?php endwhile; ?>

			</div><!-- #content -->
		</div><!-- #container -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>
