<?php
    /*
    * Plugin Name: BBPress Tiny Editor
    * Plugin URI: http://www.laptrinhvn.com/
    * Description: Add a tiny editor to bbpress
    * Version: 1.00
    * Author: Peter Son
    * Author URI: http://www.laptrinhvn.com/
    */

    $bbpress_tinyeditor = new bbpress_tinyeditor();
    $bbpress_tinyeditor->init();

    class bbpress_tinyeditor {

        function init(){                        
            add_action('init', array('bbpress_tinyeditor', 'disable_filter_kses'));   
            add_action('wp_head', array('bbpress_tinyeditor', 'add_to_head'));   
            add_action('wp_footer', array('bbpress_tinyeditor', 'add_to_footer'));       
        }

        function disable_filter_kses() {
            remove_filter( 'bbp_new_reply_pre_content', 'wp_filter_kses' );
            add_filter( 'bbp_get_reply_content', array('bbpress_tinyeditor', 'wpautop'), 29 );
        }

        function wpautop($content){                            
            $content = str_replace('<br />', '<br/>', $content);
            return $content;
        } 

        function add_to_head(){
            $css_url = trailingslashit(WP_PLUGIN_URL.'/'.str_replace(basename( __FILE__),"",plugin_basename(__FILE__))) . 'style.css';
            $css_url = '<link rel="stylesheet" href="'.$css_url.'" />';
            $js_url = trailingslashit(WP_PLUGIN_URL.'/'.str_replace(basename( __FILE__),"",plugin_basename(__FILE__))) . 'tinyeditor.js';
            $js_url = '<script type="text/javascript" src="' . $js_url . '"></script>';
            $output = "\n" . $css_url . "\n" . $js_url . "\n";
            echo stripslashes($output);wpautop($output);
        }

        function add_to_footer(){
		$use_advancedEditor = true;
		if( stristr($_SERVER['HTTP_USER_AGENT'],'ipad') ) {
			if(strpos($_SERVER['HTTP_USER_AGENT'], 'OS 4') ||
			   strpos($_SERVER['HTTP_USER_AGENT'], 'OS 3') ||
			   strpos($_SERVER['HTTP_USER_AGENT'], 'OS 2') ||
			   strpos($_SERVER['HTTP_USER_AGENT'], 'CPU like Mac OS X') ) { 
				$use_advancedEditor = false;
			};
		}

            if($use_advancedEditor) {
		$output = "<script type='text/javascript'>
                new TINY.editor.edit('editor',{
                id:'bbp_reply_content',
                width:584,
                height:175,
                cssclass:'te',
                controlclass:'tecontrol',
                rowclass:'teheader',
                dividerclass:'tedivider',
                controls:['bold','italic','underline','strikethrough','|','subscript','superscript','|',
                'orderedlist','unorderedlist','|','outdent','indent','|','leftalign',
                'centeralign','rightalign','blockjustify','|','unformat','|','undo','redo','n',
                'font','size','style','|','image','hr','link','unlink','|','cut','copy','paste','print'],
                footer:true,
                fonts:['Verdana','Arial','Georgia','Trebuchet MS'],
                xhtml:true,
                cssfile:'style.css',
                bodyid:'editor',
                footerclass:'tefooter',
                toggle:{text:'source',activetext:'wysiwyg',cssclass:'toggle'},
                resize:{cssclass:'resize'}
                });

                var submitButton = document.getElementById('bbp_reply_submit');
                if(submitButton != null) { 
                submitButton.onclick = function () { editor.post(); }; }
                </script>";
            
                $output = $output . "<script type='text/javascript'>
                new TINY.editor.edit('editor1',{
                id:'bbp_topic_content',
                width:584,
                height:175,
                cssclass:'te',
                controlclass:'tecontrol',
                rowclass:'teheader',
                dividerclass:'tedivider',
                controls:['bold','italic','underline','strikethrough','|','subscript','superscript','|',
                'orderedlist','unorderedlist','|','outdent','indent','|','leftalign',
                'centeralign','rightalign','blockjustify','|','unformat','|','undo','redo','n',
                'font','size','style','|','image','hr','link','unlink','|','cut','copy','paste','print'],
                footer:true,
                fonts:['Verdana','Arial','Georgia','Trebuchet MS'],
                xhtml:true,
                cssfile:'style.css',
                bodyid:'editor',
                footerclass:'tefooter',
                toggle:{text:'source',activetext:'wysiwyg',cssclass:'toggle'},
                resize:{cssclass:'resize'}
                });

                var submitButton = document.getElementById('bbp_topic_submit');
                if(submitButton != null) { 
                submitButton.onclick = function () { editor1.post(); }; }
                </script>";
            } else {
		/*$output = "<script type='text/javascript'>
                new TINY.editor.edit('editor',{
                id:'bbp_reply_content',
                width:584,
                height:175,
                cssclass:'te',
                controlclass:'tecontrol',
                rowclass:'teheader',
                dividerclass:'tedivider',
                controls:[],
                footer:true,
                fonts:[],
                xhtml:true,
                cssfile:'style.css',
                bodyid:'editor',
                footerclass:'tefooter',
                toggle:{text:'wysiwyg',activetext:'source',cssclass:'toggle'},
                resize:{cssclass:'resize'}
                });

                var submitButton = document.getElementById('bbp_reply_submit');
                if(submitButton != null) { 
                submitButton.onclick = function () { editor.post(); }; }
                </script>";
            
                $output = $output . "<script type='text/javascript'>
                new TINY.editor.edit('editor1',{
                id:'bbp_topic_content',
                width:584,
                height:175,
                cssclass:'te',
                controlclass:'tecontrol',
                rowclass:'teheader',
                dividerclass:'tedivider',
                controls:[],
                footer:true,
                fonts:[],
                xhtml:true,
                cssfile:'style.css',
                bodyid:'editor',
                footerclass:'tefooter',
                toggle:{text:'wysiwyg',activetext:'source',cssclass:'toggle'},
                resize:{cssclass:'resize'}
                });

                var submitButton = document.getElementById('bbp_topic_submit');
                if(submitButton != null) { 
                submitButton.onclick = function () { editor1.post(); }; }
                </script>";*/

	    }

            echo stripslashes($output);
        }
    }
?>
