<?php
/*
Plugin Name: iMaters WP FAQ
Plugin URI: http://code.imasters.com.br/wordpress/plugins/imasters-wp-faq/
Description: iMasters WP FAQ is used to manage FAQ in your WordPress based site. Organize your FAQ's in categories and put them in posts or pages.
Version: 0.2
Author: Apiki
Author URI: http://www.apiki.com
*/

/*  Copyright 2009  Apiki (email : leandro@apiki.com)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/**
 * Create class IMASTERS_WP_FAQ
 */
class IMASTERS_WP_FAQ {

    function IMASTERS_WP_FAQ(){

        global $wpdb;

        /**
         * Name of database plugin table
         */
        $wpdb->imasters_wp_faq = $wpdb->prefix . "imasters_wp_faq";
        $wpdb->imasters_wp_faq_categories = $wpdb->prefix . "imasters_wp_faq_categories";

        /**
         * Define how many faq's per page
         */
        define('FAQS_PER_PAGE', 15);

        /**
         * Define the version of this plugin
         */
        define('IMASTERS_WP_FAQ_VERSION', 0.1);

        /**
         * Define the version of this database
         */
        define('IMASTERS_WP_FAQ_DB_VERSION', 0.1) ;

        /**
         * Call the function referer shortcode
         */
        add_shortcode('imasters-wp-faq', array( &$this,'faq_shortcode') );

        /**
         * Call the function with Text Domain for translations
         */
        add_action('init', array( &$this, 'textdomain') );


        // init process for button control
        add_action('init', array( &$this, 'faq_addbuttons' ) );

        /**
         * Call the function to build the plugin menu
         */
        add_action( 'admin_menu', array( &$this, 'menu' ) );

        /**
         * Call the function to build the plugin database
         */
        add_action( 'activate_imasters-wp-faq/imasters-wp-faq.php', array( &$this, 'install' ) );

        /**
         * Call the function to insert the JavaScript and CSS for admin
         */
        add_action( 'admin_head', array( &$this, 'admin_header' ) );

        /**
         * Call the function to insert the JavaScript and CSS for template
         */
        add_action( 'wp_head', array( &$this, 'template_header' ) );

        

        // Modify the version when tinyMCE plugins are changed.
        add_filter('tiny_mce_version', array( &$this, 'faq_change_tinymce_version'));

    }

    /**
     * Create Text Domain for translations
     */
    function textdomain()
    {
        load_plugin_textdomain( 'imasters-wp-faq', False , WP_PLUGIN_DIR . 'wp-content/plugins/imasters-wp-faq/assets/languages' );
    }

    /**
     * This function insert CSS and JS in admin plugin
     */
    function admin_header()
    {
        if ( strpos( $_GET['page'], 'imasters-wp-faq' ) !== false ) :
            $faq_scripts_ver = filemtime( dirname( __FILE__ ) . '/assets/javascript/imasters-wp-faq-backend-scripts.js' );
            wp_enqueue_script( 'faq.scripts', WP_PLUGIN_URL . '/imasters-wp-faq/assets/javascript/imasters-wp-faq-backend-scripts.js', false, $faq_scripts_ver );
            echo "\n<!-- START - Generated by iMaters WP FAQ " . IMASTERS_WP_FAQ_VERSION . " -->";
            echo "\n" . '<link rel="stylesheet" type="text/css" media="screen" href="' . WP_PLUGIN_URL . '/imasters-wp-faq/assets/css/imasters-wp-faq-backend-styles.css" />';
            wp_print_scripts( array( 'jquery', 'faq.scripts' ) );
            echo "\n<!-- END - Generated by iMasters WP FAQ " . IMASTERS_WP_FAQ_VERSION . " -->\n";
        endif;
    }

    /**
     * This function insert CSS and JS in template plugin
     */
    function template_header()
    {
        echo "\n<!-- START - Generated by iMasters WP FAQ " . IMASTERS_WP_FAQ_VERSION . " -->";
        if ( get_option('imasters_wp_faq_insert_js') == 1 ) :
            $faq_scripts_ver = filemtime( dirname( __FILE__ ) . '/assets/javascript/imasters-wp-faq-frontend-scripts.js' );
            wp_enqueue_script( 'faq.scripts', WP_PLUGIN_URL . '/imasters-wp-faq/assets/javascript/imasters-wp-faq-frontend-scripts.js', false, $faq_scripts_ver );
            wp_print_scripts( array( 'jquery', 'faq.scripts' ) );
        endif;
        echo "\n" . '<link rel="stylesheet" type="text/css" media="screen" href="' . WP_PLUGIN_URL . '/imasters-wp-faq/assets/css/imasters-wp-faq-frontend-styles.css" />';
        echo "\n<!-- END - Generated by iMasters WP FAQ " . IMASTERS_WP_FAQ_VERSION . " -->\n";
    }

    /**
     * This metod build the menu used by this plugin
     */
    function menu()
    {
        /**
         * Create the menu parent page
         */
        if ( function_exists('add_menu_page') ) :
            add_menu_page( __('iMasters WP FAQ', 'imasters-wp-faq'), __('iMasters WP FAQ', 'imasters-wp-faq'), 'imaster-wp-faq', 'imasters-wp-faq/imasters-wp-faq-manager.php', '' , plugins_url( 'imasters-wp-faq/assets/images/imasters.png' ) );
        endif;

        /**
         * Create the submenu pages
         */
        if ( function_exists('add_submenu_page') ) :
            add_submenu_page( 'imasters-wp-faq/imasters-wp-faq-manager.php' , __('Manager FAQ\'s', 'imasters-wp-faq'),      __('Manager FAQ\'s', 'imasters-wp-faq'),        'imaster-wp-faq', 'imasters-wp-faq/imasters-wp-faq-manager.php');
            add_submenu_page( 'imasters-wp-faq/imasters-wp-faq-manager.php' , __('Manager categories', 'imasters-wp-faq'),  __('Manager categories', 'imasters-wp-faq'),    'imaster-wp-faq', 'imasters-wp-faq/imasters-wp-faq-manager-categories.php');
            add_submenu_page( 'imasters-wp-faq/imasters-wp-faq-manager.php' , __('Settings', 'imasters-wp-faq'),            __('Settings', 'imasters-wp-faq'),              'imaster-wp-faq', 'imasters-wp-faq/imasters-wp-faq-settings.php');
            add_submenu_page( 'imasters-wp-faq/imasters-wp-faq-manager.php' , __('Help', 'imasters-wp-faq'),                __('Help', 'imasters-wp-faq'),                  'imaster-wp-faq', 'imasters-wp-faq/imasters-wp-faq-help.php');
            add_submenu_page( 'imasters-wp-faq/imasters-wp-faq-manager.php' , __('Uninstall', 'imasters-wp-faq'),           __('Uninstall', 'imasters-wp-faq'),             'imaster-wp-faq', 'imasters-wp-faq/imasters-wp-faq-uninstall.php');
        endif;
    }

    /**
     * This metod instal plugin, build tables of database
     */
    function install()
    {
        global $wpdb;


       $role = get_role( 'administrator' );
       if( !$role->has_cap( 'imaster-wp-faq' ) ) :
            $role->add_cap( 'imaster-wp-faq' );
        endif;

        /**
         * This file contains the dbDelta function, and it´s not loaded by default.
         */
        require_once ABSPATH . 'wp-admin/upgrade-functions.php';

        /**
         * Check if the table imasters_wp_faq was already created
         */
        if ( $wpdb->get_var("SHOW TABLES LIKE '$wpdb->imasters_wp_faq'") != $wpdb->imasters_wp_faq ) :

            $sql_faq = "CREATE TABLE " . $wpdb->imasters_wp_faq . " (
                faq_id              INT( 11 )       UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
                faq_category_id     INT( 11 )       UNSIGNED NOT NULL,
                faq_topic           VARCHAR( 250 )  NOT NULL,
                faq_answer          TEXT            NOT NULL,
                faq_registered_at   TIMESTAMP       NOT NULL DEFAULT CURRENT_TIMESTAMP
                )  ENGINE = MYISAM COMMENT = 'Table used by iMasters WP FAQ WordPress plugin';
            ";

            /**
             * This function examines the current table structure, compares it to the desired table structure, and either adds or modifies the table as necessary
             */
            dbDelta($sql_faq);

        endif;

        /**
         * Check if the table imasters_wp_faq_category was already created
         */
        if ( $wpdb->get_var("SHOW TABLES LIKE '$wpdb->imasters_wp_faq_categories'") != $wpdb->imasters_wp_faq_categories ) :

            $sql_faq_cat = "CREATE TABLE " . $wpdb->imasters_wp_faq_categories . " (
                category_id     INT( 11 )       UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
                category_name   VARCHAR( 150 )  NOT NULL
                ) ENGINE = MYISAM COMMENT = 'Table used by iMasters WP FAQ Wordpress Plugin';
            ";

            /**
             * This function examines the current table structure, compares it to the desired table structure, and either adds or modifies the table as necessary
             */
            dbDelta($sql_faq_cat);

        endif;

        /**
         * Define JavaScript colapse checked
         */
        add_option( 'imasters_wp_faq_insert_js', 1 );

        /**
         * Add option IMASTERS FAQ DB VERSION
         */
        add_option( 'imasters_wp_faq_db_version', IMASTERS_WP_FAQ_DB_VERSION );
    }

    /**
     * Function add FAQ in database
     *
     * @param	array	$_POST
     * @return	bool
     */
    function add_faq( $_POST )
    {
        global $wpdb;

        /**
         * Import variables into the current symbol table from an array
         */
        extract($_POST, EXTR_SKIP);

        $added = $wpdb->query( $wpdb->prepare ("
            INSERT INTO $wpdb->imasters_wp_faq
            (
                faq_category_id,
                faq_topic,
                faq_answer
            )
            VALUES
            (
                %d,
                '%s',
                '%s'
            )
            ",
            $faq_category_id,
            $faq_topic,
            $faq_answer
        ));

        if ( $added )
            return true;
        
        return false;
    }

    /**
     * Function edit FAQ
     *
     * @param	array	$_POST
     * @return	bool
     */
    function edit_faq( $_POST )
    {
        global $wpdb;

        /**
         * Import variables into the current symbol table from an array
         */
        extract($_POST, EXTR_SKIP);

        $updated = $wpdb->query( $wpdb->prepare ("
            UPDATE $wpdb->imasters_wp_faq
            SET
                faq_category_id = %d,
                faq_topic       = '%s',
                faq_answer      = '%s'
            WHERE
                faq_id		= %d
            ",
            $faq_category_id,
            $faq_topic,
            $faq_answer,
            $faq_id
        ));

        if ( $updated )
            return true;
        
        return false;
    }

    /**
     * Function add category in database
     *
     * @param	array	$_POST
     * @return	bool
     */
    function add_category( $_POST )
    {
        global $wpdb;

        /**
         * Import variables into the current symbol table from an array
         */
        extract($_POST, EXTR_SKIP);

        $added = $wpdb->query( $wpdb->prepare ("
            INSERT INTO $wpdb->imasters_wp_faq_categories
            (
                category_name
            )
            VALUES
            (
                '%s'
            )
            ",
            $category_name
        ));

        if ( $added )
            return true;

        return false;
    }

    /**
     * Function edit category
     *
     * @param	array	$_POST
     * @return	bool
     */
    function edit_category( $_POST )
    {
        global $wpdb;

        /**
         * Import variables into the current symbol table from an array
         */
        extract($_POST, EXTR_SKIP);

        $updated = $wpdb->query( $wpdb->prepare ("
            UPDATE $wpdb->imasters_wp_faq_categories
            SET
                category_name   = '%s'
            WHERE
                category_id     = %d
            ",
            $category_name,
            $category_id
        ));

        if ( $updated )
            return true;

        return false;
    }

    /**
     * Function call imasters wp faq shortcode
     *
     * [imasters-wp-faq cat_id=""]
     * @return imasters_wp_faq_embedded()
     */
    function faq_shortcode($atts)
    {
        extract($atts);
        
        global $objiMastersWPFaq;

        return $objiMastersWPFaq->get_embedded( $cat, $filters );
    }

    /**
     * This function get link
     *
     * @global obj $post
     * @param  str $letter
     * @return str
     */
    function get_link( $letter )
    {
        global $post;

        $current_page = get_permalink( $post->ID );

        $params = array(
            'iwpfaq_order' => $letter
        );

        return add_query_arg( $params, $current_page );
    }

    /**
     * Get url to see all faq's
     *
     * @return str
     */
    function get_url_to_all()
    {
        $link =  get_permalink( get_the_ID() );

        return $link;
    }

    /**
     * Function embedded the shortcode [imasters-wp-faq]
     */
    function get_embedded( $cat_id , $filters)
    {
        global $wpdb;

        /**
             * Show FAQs by character order
             */
            if( isset( $_GET['iwpfaq_order'] ) and !empty( $_GET['iwpfaq_order'] ) ) :

                $iwpfaq_order = $_GET['iwpfaq_order'];

                $objFaqs = $wpdb->get_results("
                    SELECT faq_category_id, faq_topic, faq_answer
                    FROM $wpdb->imasters_wp_faq
                    WHERE
                    faq_topic LIKE '$iwpfaq_order%'
                    AND
                    faq_category_id = $cat_id
                    ORDER BY faq_topic"
                );

            else :

                /**
                 * Show all FAQs
                 */
                $objFaqs = $wpdb->get_results("
                    SELECT faq_category_id, faq_topic, faq_answer
                    FROM $wpdb->imasters_wp_faq
                    WHERE
                    faq_category_id = $cat_id
                    ORDER BY faq_topic
                ");

            endif;

        if( $filters  == 'yes' && $objFaqs ) :
            /**
             * List characteres for order
             */
            $faq_template_order  = '<p><ul class="imasters-wp-faq-filters">';

            /**
             * Return the values of characters
             */
            for( $i=65; $i<91; $i++ ) :
                $faq_template_order .= sprintf( '<li%s><a href="%s">%s</a></li>', ( $_GET['iwpfaq_order'] == chr( $i ) ) ? ' class="active"' : '', $this->get_link( chr( $i ) ), chr( $i ) );
            endfor;

            $faq_template_order .= sprintf('<li><a href="%s">%s</a></li>', $this->get_url_to_all(), __('All', 'imasters-wp-faq'));
            $faq_template_order .= '</ul></p>';

            $output = $faq_template_order;

        endif;

        /**
         * Listing FAQ's
         */
         if( $objFaqs ) :

            $faq_template_content = '<dl class="imasters-wp-faq-listing">';
            
            foreach( $objFaqs as $objFaq ) :
                    $faq_template_content .= '<dt>';
                    $faq_template_content .= $this->clean_chars( $objFaq->faq_topic );
                    $faq_template_content .= '</dt>';
                    $faq_template_content .= '<dd>';
                    $faq_template_content .= nl2br( $this->clean_chars( $objFaq->faq_answer ) );
                    $faq_template_content .= '</dd>';
            endforeach;
            
            $faq_template_content .= '</dl>';

            $output .= $faq_template_content;

        else :
            //$output .= __('<p>No FAQ found.</p>', 'imasters-wp-faq');
            $output .= __('<p>No FAQ found.</p>', 'imasters-wp-faq');
        endif;
        
        /**
         * Show html FAQ's
         */
        return $output;
    }

    /*
     * Clean the chairs of variables
     *
     * @param string strvalue
     * @return string
     */
    function clean_chars($strvalue)
    {
        $value = htmlspecialchars( stripslashes( $strvalue ) );

        return $value;
    }

    /**
     * This function get categories for list in admin
     * 
     * @global obj $wpdb
     * @return obj
     */
    function get_categories()
    {
        global $wpdb;

        $objCategories = $wpdb->get_results("
            SELECT * FROM $wpdb->imasters_wp_faq_categories
            ORDER BY category_name
        ");

        return $objCategories;
    }

    /**
     * Get name of categories
     *
     * @global obj $wpdb
     * @param  int $category_id
     * @return str
     */
    function get_category_name( $category_id )
    {
        global $wpdb;

        $objCatName = $wpdb->get_var("
            SELECT category_name FROM $wpdb->imasters_wp_faq_categories
            WHERE category_id = $category_id
        ");

        return $objCatName;
    }

    /**
     * This function chech if the category is used by any faq
     *
     * @global obj $wpdb
     * @param  int $cat_id
     * @return int
     */
    function is_used_by_faq( $cat_id )
    {
        global $wpdb;

        $is_used = $wpdb->get_var("
            SELECT COUNT(*) FROM $wpdb->imasters_wp_faq
            WHERE faq_category_id = $cat_id
        ");

        return $is_used;
    }

    function faq_addbuttons() {
	// Add only in Rich Editor mode
	//if(!current_user_can('edit_posts') && ! current_user_can('edit_pages')) {
         //           return;
           // }
            //if(get_user_option('rich_editing') == 'true') {
	// add the button for wp25 in a new way
		add_filter('mce_external_plugins', array( &$this, 'add_faq_tinymce_plugin'), 5);
		add_filter('mce_buttons', array( &$this, 'register_faq_button') , 5);
           // }
    }

    // used to insert button in wordpress 2.5x editor
    function register_faq_button($buttons) {
            array_push($buttons, "separator", "faq");
            return $buttons;
    }

    // Load the TinyMCE plugin : editor_plugin.js (wp2.5)
    function add_faq_tinymce_plugin($plugin_array) {
            $plugin_array['faq'] = get_option('siteurl').'/wp-content/plugins/imasters-wp-faq/assets/javascript/editor_plugin.js';
            return $plugin_array;
    }

    function faq_change_tinymce_version($version) {
	return ++$version;
    }

}
//Create capability from plugin management
$role = get_role('administrator');
	if(!$role->has_cap('manage_faq')) {
		$role->add_cap('manage_faq');
        }
/**
 * Instance of the iMasters FAQ to run the constructor
 */
$objiMastersWPFaq = new IMASTERS_WP_FAQ();
?>