<?php

/***********************************************************/
/*                                                         */
/* Fonction Ajax d'association d'un SLA avec une compagnie */
/*                                                         */
/***********************************************************/

function wats_admin_associate_sla_with_company()
{
	global $wats_settings,$wpdb;

	check_ajax_referer('wats-company-management');
	
	if (!current_user_can('administrator'))
		die('-1');
		
	wats_load_settings();
	$companyvalue = stripslashes_deep($_POST['companyvalue']);
	$slavalue = stripslashes_deep($_POST['slavalue']);

	$count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $wpdb->usermeta WHERE meta_key = %s AND meta_value = %s",$wats_settings['company_meta_key_profile'],html_entity_decode($companyvalue)));
	
	if ($count == 0)
	{
		$message_result = array('success' => "FALSE", 'error' => __("Error : entry not found in the DB!",'WATS'));
	}
	else
	{
		if ($wats_settings['profile_sla_enabled'] == 1 && wats_is_numeric($slavalue))
		{
			if ($slavalue != 0)
			{
				$users = $wpdb->get_results($wpdb->prepare("SELECT user_id FROM $wpdb->usermeta WHERE meta_key = %s AND meta_value = %s",$wats_settings['company_meta_key_profile'],html_entity_decode($companyvalue)));
				foreach ($users AS $user)
				{
					update_user_meta($user->user_id,'wats_sla',$slavalue);
				}
				$message_result = array('success' => "TRUE", 'error' => __("SLA succesfully assigned!",'WATS'));
			}
			else
			{
				$wpdb->query($wpdb->prepare("DELETE wp1 FROM $wpdb->usermeta AS wp1 JOIN $wpdb->usermeta AS wp2 WHERE wp1.user_id = wp2.user_id AND wp1.meta_key = %s AND wp2.meta_key = %s AND wp2.meta_value = %s",'wats_sla',$wats_settings['company_meta_key_profile'],html_entity_decode($companyvalue)));
				
				$message_result = array('success' => "TRUE", 'error' => __("SLA succesfully removed!",'WATS'));
			}
		}
		else
		{
			$message_result = array('success' => "FALSE", 'error' => __("Error : can't assign this SLA!",'WATS'));
		}
	}
	
	echo json_encode($message_result);
	exit;
}

/***********************************************************************************/
/*                                                                                 */
/* Fonction de construction d'un slecteur d'utilisateurs  partir d'une compagnie */
/*                                                                                 */
/***********************************************************************************/

function wats_get_user_list_from_company()
{
	global $wats_settings,$wpdb,$current_user;

	check_ajax_referer('wats-edit-ticket');
	
	if (!current_user_can('administrator'))
		die('-1');

	wats_load_settings();
	$companyvalue = stripslashes_deep($_POST['idcompany']);

	$count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $wpdb->usermeta WHERE meta_key = %s AND meta_value = %s",$wats_settings['company_meta_key_profile'],html_entity_decode($companyvalue)));
	if ($companyvalue != 0 && $count == 0)
	{
		$message_result = array('success' => "FALSE", 'error' => __("Error : entry not found in the DB!",'WATS'));
	}
	else
	{
		$userlist = wats_build_user_list_from_company(0,0,$companyvalue);
		$output = '+ '.__('User','WATS').' : <select name="wats_select_ticket_originator" id="wats_select_ticket_originator" class="wats_select">';
		foreach ($userlist AS $userlogin => $username)
		{
			$output .= '<option value="'.$userlogin.'" ';
			if ($current_user->user_login == $userlogin) $output .= 'selected';
			$output .= '>'.$username.'</option>';
		}
		$output .=  '</select>';
			
		$message_result = array('success' => "TRUE", 'error' => $output,'WATS');
	}
	
	echo json_encode($message_result);
	exit;
}

/*******************************************/
/*                                         */
/* Fonction de suppression d'une compagnie */
/*                                         */
/*******************************************/

function wats_admin_remove_company_entry()
{
	global $wats_settings,$wpdb;

	check_ajax_referer('wats-company-management');
	
	if (!current_user_can('administrator'))
		die('-1');
		
	wats_load_settings();
	$companyvalue = stripslashes_deep($_POST['companyvalue']);

	$count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $wpdb->usermeta WHERE meta_key = %s AND meta_value = %s",$wats_settings['company_meta_key_profile'],html_entity_decode($companyvalue)));
	
	if ($count == 0)
	{
		$message_result = array('success' => "FALSE", 'error' => __("Error : entry not found in the DB!",'WATS'));
	}
	else
	{
		$wpdb->query($wpdb->prepare("DELETE FROM $wpdb->usermeta WHERE meta_key = %s AND meta_value = %s",$wats_settings['company_meta_key_profile'],html_entity_decode($companyvalue)));
		
		do_action('wats_user_to_company_mapping_remove',$companyvalue);
		
		$message_result = array('success' => "TRUE", 'error' => __("Entry successfully removed!",'WATS'));
	}
	
	echo json_encode($message_result);
	exit;
}

/**************************************************/
/*                                                */
/* Fonction de mise  jour du nom d'une compagnie */
/*                                                */
/**************************************************/

function wats_admin_update_company_entry()
{
	global $wats_settings,$wpdb;

	check_ajax_referer('wats-company-management');
	
	if (!current_user_can('administrator'))
		die('-1');
		
	wats_load_settings();
	$newvalue = stripslashes_deep($_POST['newvalue']);
	$previousvalue = stripslashes_deep($_POST['previousvalue']);
	
	$count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $wpdb->usermeta WHERE meta_key = %s AND meta_value = %s",$wats_settings['company_meta_key_profile'],html_entity_decode($previousvalue)));
	
	if ($count == 0)
	{
		$message_result = array('success' => "FALSE", 'error' => __("Error : entry not found in the DB!",'WATS'));
	}
	else if (strlen($newvalue) == 0)
	{
		$message_result = array('success' => "FALSE", 'error' => __("Error : please enter a company!",'WATS'));
	}	
	else
	{
		$wpdb->query($wpdb->prepare("UPDATE $wpdb->usermeta SET meta_value = %s WHERE meta_key = %s AND meta_value = %s",html_entity_decode($newvalue),$wats_settings['company_meta_key_profile'],html_entity_decode($previousvalue)));
		
		do_action('wats_user_to_company_mapping_update',$newvalue,$previousvalue);
		
		$message_result = array('success' => "TRUE", 'newvalue' => esc_html($newvalue), 'error' => __("Entry successfully updated!",'WATS'));
	}
	
	echo json_encode($message_result);
	exit;
}

/***********************************************************************************/
/*                                                                                 */
/* Fonction de conversion d'une liste d'utilisateur en liste d'urls vers le profil */
/*                                                                                 */
/***********************************************************************************/

function wats_convert_userlist_into_profile_urls($userlist,$slalist)
{
	global $wats_settings;
	
	$userlist = explode(",", $userlist);
	
	$x = 0;
	$list = '';
	$wats_slas = $wats_settings['wats_slas'];
	foreach ($userlist AS $user)
	{
		if ($x == 0)
		{
			$x = 1;
		}
		else
			$list .= ", ";
		$list .= '<a href="user-edit.php?user_id='.$user.'" style="text-decoration:none;">'.esc_html(wats_get_full_name($user));
		if (is_array($slalist) && isset($slalist[$user]))
			$list .= ' ('.$wats_slas[$slalist[$user]].')';
		$list .= '</a>';
	}
	
	return $list;
}

/*************************************************/
/*                                               */
/* Fonction d'insertion d'une nouvelle compagnie */
/*                                               */
/*************************************************/

function wats_admin_insert_company_entry()
{
	global $wats_settings,$wpdb;

	check_ajax_referer('wats-company-management');
	
	if (!current_user_can('administrator'))
		die('-1');
		
	wats_load_settings();
	$companyvalue = stripslashes_deep($_POST['companyvalue']);
	if ($wats_settings['profile_sla_enabled'] == 1)
		$slavalue = stripslashes_deep($_POST['slavalue']);
	$userid = wats_get_user_ID_from_user_login(stripslashes_deep($_POST['uservalue']));
			
	if ($userid == 0)
	{
		$message_result = array('success' => "FALSE", 'error' => __("Error : please select a user!",'WATS'));
	}
	else if (strlen($companyvalue) == 0)
	{
		$message_result = array('success' => "FALSE", 'error' => __("Error : please enter a company!",'WATS'));
	}	
	else
	{
		update_user_meta($userid,$wats_settings['company_meta_key_profile'],$companyvalue);
		if ($wats_settings['profile_sla_enabled'] == 1 && wats_is_numeric($slavalue) && $slavalue != 0)
			update_user_meta($userid,'wats_sla',$slavalue);
		else
			delete_user_meta($userid,'wats_sla');
			
		do_action('wats_user_to_company_mapping_add',$userid,$companyvalue);
			
		$message_result = array('success' => "FALSE", 'error' => __("Entry successfully added!",'WATS'));
	}
	
	echo json_encode($message_result);
	exit;
}

/********************************************************/
/*                                                      */
/* Fonction de construction de la liste des compagnies  */
/* view 0 : pas de valeur "None"					    */
/* view 1 : valeur "None" au dbut					    */
/* view 2 : valeur "None" si utilisateur sans compagnie */
/*                                                      */
/********************************************************/

function wats_build_company_list($view)
{
	global $wpdb,$wats_settings;

	$company_list = array();
	
	if ($view == 1)
		$company_list[0] = __('None','WATS');
	else if ($view == 2)
	{
		$count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $wpdb->users AS wp1 WHERE NOT EXISTS (SELECT * FROM $wpdb->usermeta AS wp2 WHERE wp1.ID = wp2.user_ID AND wp2.meta_key = %s)",$wats_settings['company_meta_key_profile']));
		
		if ($count > 0)
			$company_list[0] = __('None','WATS');
	}
		
	$companies = $wpdb->get_results($wpdb->prepare("SELECT meta_value, GROUP_CONCAT(user_id) as userlist FROM $wpdb->usermeta WHERE meta_key = %s GROUP BY meta_value ORDER BY meta_value",$wats_settings['company_meta_key_profile']));
	
	foreach ($companies AS $company)
	{
		$company_list[$company->meta_value] = $company->userlist;
	}
	
	return $company_list;
}

function wats_build_user_list_with_sla()
{
	global $wpdb;
	
	$slas = $wpdb->get_results($wpdb->prepare("SELECT user_id, meta_value FROM $wpdb->usermeta WHERE meta_key = %s",'wats_sla'));
	
	$list = array();
	foreach ($slas AS $sla)
	{
		$list[$sla->user_id] = $sla->meta_value;
	}

	return $list;
}

/*************************************************************/
/*                                                           */
/* Fonction d'affichage de la page de gestion des compagnies */
/*                                                           */
/*************************************************************/

function wats_company_management_show_table_interface()
{
	global $wats_settings;

	$output = '<table class="widefat" cellspacing="0" id="tablecompany" style="text-align:center;"><thead><tr class="thead">';
	$output .= '<th scope="col" class="manage-column" style="text-align:center;">'.__('Company','WATS').'</th>';
	$output .= '<th scope="col" class="manage-column" style="text-align:center;">'.__('Users','WATS').'</th>';
    $output .= '<th scope="col" class="manage-column" style="text-align:center;">'.__('Selection','WATS').'</th>';
    $output .= '</tr></thead><tbody class="list:user user-list">';
	
	$company_list = wats_build_company_list(0);

	if ($wats_settings['profile_sla_enabled'] == 1)
		$sla_list = wats_build_user_list_with_sla();
	else
		$sla_list = '';

	$x = 0;
	foreach ($company_list AS $company => $userlist)
	{
		$x = 1;
		$output .= '<tr><td class="wats_editable">'.esc_html($company).'</td><td>'.wats_convert_userlist_into_profile_urls($userlist,$sla_list).'</td>';
		$output .= '<td><input type="checkbox" name="company_check" id="company_check" value="'.esc_attr($company).'" /></td></tr>';
	}
	
	if ($x == 0)
		$output .= '<tr valign="middle"><td colspan="3" style="text-align:center">'.__('No entry','WATS').'</td></tr>';
	
	$output .= '</tbody></table>';
	
	return $output;
}

/*************************************************************/
/*                                                           */
/* Fonction d'affichage de la page de gestion des compagnies */
/*                                                           */
/*************************************************************/

function wats_company_management_admin_menu()
{
	global $wpdb, $wats_settings;
	
	wats_load_settings();
	echo '<H2><div style="text-align:center">'.__('WATS Company Management','WATS').'</div></H2>';
	
	
	echo '<form action="" method="post">';
	wp_nonce_field('wats-company-management');
	
	echo '<H3><a style="cursor:pointer;" title="'.__('Click to get some help!', 'WATS').'" onclick=javascript:wats_invert_visibility("associate_new_company_tip");>'.__('Associate user with a company','WATS').'</a></H3>';
	echo __('Company name','WATS').' : <input type="text" name="company_name" id="company_name" size=30><br /><br />';
	if ($wats_settings['profile_sla_enabled'] == 1)
	{
		$wats_slas = $wats_settings['wats_slas'];
		echo __('Service level agreement','WATS').' : ';
		echo '<select name="sla_list" id="sla_list">';
		echo '<option value="0">'.__('None','WATS').'</option>';
		foreach ($wats_slas AS $key => $value)
			echo '<option value="'.esc_attr($key).'">'.esc_html($value).'</option>';
		echo '</select><br /><br />';
	}
	echo __('User','WATS').' : <select name="user_list" id="user_list" class="wats_select">';
	$userlist = wats_build_user_list(0,0);
	foreach ($userlist AS $userlogin => $username)
	{
        echo '<option value="'.$userlogin.'" >'.$username.'</option>';
	}
	echo '</select><br /><br />';

	echo '<input type="submit" id="add_new_company" name="add_new_company" value="'.__('Associate user with company','WATS').'" class="button-primary" /><div id="resultaddcompany"></div><br />';
	echo '<div class="wats_tip" id="associate_new_company_tip">';
	echo __('The selected user will be associated with the company name entered. If the user was already associated with a company, the existing entry will be updated and therefore previous company will disappear.','WATS').'<br /></div><br />';
	
	if ($wats_settings['profile_sla_enabled'] == 1)
	{
		echo '<H3><a style="cursor:pointer;" title="'.__('Click to get some help!', 'WATS').'" onclick=javascript:wats_invert_visibility("assign_sla_tip");>'.__('Assign SLA to all users of a company','WATS').'</a></H3>';
		$wats_slas = $wats_settings['wats_slas'];
		echo __('Service level agreement','WATS').' : ';
		echo '<select name="sla_list_company" id="sla_list_company">';
		echo '<option value="0">'.__('None','WATS').'</option>';
		foreach ($wats_slas AS $key => $value)
			echo '<option value="'.esc_attr($key).'">'.esc_html($value).'</option>';
		echo '</select><br /><br />';
		echo __('Company','WATS').' : ';
		$company_list = wats_build_company_list(0);
		echo '<select name="wats_company_list" id="wats_company_list">';
		foreach ($company_list AS $key => $value)
		{
			echo '<option value="'.esc_attr($key).'">'.esc_html($key).'</option>';
		}
		echo '</select><br /><br />';
		echo '<input type="submit" id="associate_sla" name="associate_sla" value="'.__('Assign SLA to users of company','WATS').'" class="button-primary" /><div id="resultassignsla"></div><br />';
		echo '<div class="wats_tip" id="assign_sla_tip">';
		echo __('All users associated to the selected company will have their SLA updated. If the value "None" is selected, the SLA associated to the users is removed.','WATS').'<br /></div><br />';
	}
	
	echo '<H3>'.__('Manage existing companies','WATS').'</H3>';
	echo wats_company_management_show_table_interface();   
	echo '<br /><input type="submit" id="remove_company" name="remove_company" value="'.__('Remove selected items','WATS').'" class="button-primary" /><div id="resultsupcompany"></div><br /><br />';
	echo '</form>';
	
	echo '<H3>'.__('Statistics and exceptions','WATS').'</H3>';
	$count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(DISTINCT (meta_value)) FROM $wpdb->usermeta WHERE meta_key = %s",$wats_settings['company_meta_key_profile']));
	echo __('Number of companies','WATS').' : '.$count.'<br />';
	$count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(meta_value) FROM $wpdb->usermeta WHERE meta_key = %s",$wats_settings['company_meta_key_profile']));
	echo __('Number of users associated to a company','WATS').' : '.$count.'<br /><br />';
	$userlist = $wpdb->get_results($wpdb->prepare("SELECT ID FROM $wpdb->users AS wp1 WHERE NOT EXISTS (SELECT * FROM $wpdb->usermeta AS wp2 WHERE wp1.ID = wp2.user_ID AND wp2.meta_key = %s)",$wats_settings['company_meta_key_profile']));
	$x = 0;
	$list = '';
	foreach ($userlist as $user)
	{
		if ($x == 0)
			$x = 1;
		else
			$list .= ',';
		$list .= $user->ID;
	}
	
	if (strlen($list) > 0)
		echo __('List of users not associated to any company','WATS').' : '.wats_convert_userlist_into_profile_urls($list,'').'<br /><br />';
	
	return;
}
?>