<?php

/************************************************************/
/*                                                          */
/* Fonction de v?rification de l'ouverture des commentaires */
/*                                                          */
/************************************************************/

function wats_get_ticket_update_rights()
{
	global $wats_settings, $current_user, $post;
	
	wats_load_settings();
	
	if ($wats_settings['ticket_status_key_enabled'] == 1 && get_post_meta($post->ID,'wats_ticket_status',true) == wats_get_closed_status_id() && !current_user_can('administrator'))
		return false;
	else if ($wats_settings['visibility'] == 2 && (!is_user_logged_in() || (is_user_logged_in() && !current_user_can('administrator') && $current_user->ID != $post->post_author && ($wats_settings['ticket_visibility_same_company'] == 0 || wats_check_user_same_company($current_user->ID,$post->post_author) == false))))
		return false;

	return true;
}

/************************************************************/
/*                                                          */
/* Fonction de renvoi du message d'erreur pour l'ouverture des commentaires */
/*                                                          */
/************************************************************/

function wats_get_ticket_update_rights_message()
{
	global $wats_settings, $current_user, $post;
	
	wats_load_settings();
	
	$output = '';
	if ($wats_settings['ticket_status_key_enabled'] == 1 && get_post_meta($post->ID,'wats_ticket_status',true) == wats_get_closed_status_id() && !current_user_can('administrator'))
	{
		$output .= '<div id="ticket_is_closed">'.__('The ticket is closed. Only administrators could reopen it.','WATS').'</div>';
	}
	else if ($wats_settings['visibility'] == 2 && (!is_user_logged_in() || (is_user_logged_in() && !current_user_can('administrator') && $current_user->ID != $post->post_author && ($wats_settings['ticket_visibility_same_company'] == 0 || wats_check_user_same_company($current_user->ID,$post->post_author) == false))))
	{
		$output .= '<div id="ticket_is_read_only">'.__('Only admins and ticket author can update this ticket.','WATS').'</div>';
	}
		
	return $output;
}


/*********************************************************/
/*                                                       */
/* Fonction de v?rification de la visibilit? des tickets */
/*                                                       */
/*********************************************************/

function wats_check_visibility_rights()
{
	global $wats_settings, $current_user, $post;

	if ($wats_settings['visibility'] == 0)
		return true;
	else if ($wats_settings['visibility'] == 1 && is_user_logged_in())
		return true;
	else if ($wats_settings['visibility'] == 2 && is_user_logged_in() && (current_user_can('administrator') || $current_user->ID == $post->post_author || (!is_admin() && $wats_settings['ticket_visibility_read_only_capability'] == 1 && current_user_can('wats_ticket_read_only')) || ($wats_settings['ticket_visibility_same_company'] == 1 && wats_check_user_same_company($current_user->ID,$post->post_author) == true)))
		return true;
		
	return false;
}

/***************************************************/
/*                                                 */
/* Fonction de g?n?ration du rapport au format xml */
/*                                                 */
/***************************************************/

function wats_ticket_listing_get_xml()
{

	header("Content-type: application/octet-stream");
	header("Content-Disposition: attachment; filename=tickets-list.xls;");
	header("Content-Type: application/ms-excel");
	header("Pragma: no-cache");
	header("Expires: 0");

	$output = '<?xml version="1.0"?>'."\n";
	$output .= '<?mso-application progid="Excel.Sheet"?>'."\n";
	$output .= '<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet" 
				xmlns:o="urn:schemas-microsoft-com:office:office" 
				xmlns:x="urn:schemas-microsoft-com:office:excel" 
				xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet" 
				xmlns:html="http://www.w3.org/TR/REC-html40">'."\n";
				
	$output .= '<Styles>';
	$output .= '<Style ss:ID="Default" ss:Name="Normal"><Alignment ss:Vertical="Bottom"/><Borders/><Font/><Interior/><NumberFormat/><Protection/></Style>';
	$output .= '<Style ss:ID="s45"><Alignment ss:Horizontal="Center" ss:Vertical="Center"/><Borders> <Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="2" ss:Color="#C0C0C0"/></Borders><Font ss:FontName="Verdana" x:Family="Swiss" ss:Size="12" ss:Color="#333333" ss:Bold="1" ss:Underline="Single"/></Style>';
	$output .= '<Style ss:ID="s51"><Alignment ss:Horizontal="Center" ss:Vertical="Center" ss:WrapText="1"/><Borders><Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="2" ss:Color="#C0C0C0"/><Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="2" ss:Color="#C0C0C0"/><Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="2" ss:Color="#C0C0C0"/><Border ss:Position="Top" ss:LineStyle="Continuous" ss:Weight="2" ss:Color="#C0C0C0"/></Borders><Font ss:FontName="Verdana" x:Family="Swiss" ss:Size="8" ss:Bold="1"/><Interior ss:Color="#99CCFF" ss:Pattern="Solid"/></Style>';
	$output .= '<Style ss:ID="s52"><Alignment ss:Horizontal="Center" ss:Vertical="Center" ss:WrapText="1"/><Borders><Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="2" ss:Color="#C0C0C0"/><Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="2" ss:Color="#C0C0C0"/><Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="2" ss:Color="#C0C0C0"/></Borders><Font ss:FontName="Verdana" x:Family="Swiss" ss:Size="9" ss:Color="#333333"/><Interior ss:Color="#FFFFFF" ss:Pattern="Solid"/></Style>';
	$output .= '<Style ss:ID="s53"><Alignment ss:Horizontal="Center" ss:Vertical="Center" ss:WrapText="1"/><Borders><Border ss:Position="Bottom" ss:LineStyle="Continuous" ss:Weight="2" ss:Color="#C0C0C0"/><Border ss:Position="Left" ss:LineStyle="Continuous" ss:Weight="2" ss:Color="#C0C0C0"/><Border ss:Position="Right" ss:LineStyle="Continuous" ss:Weight="2" ss:Color="#C0C0C0"/></Borders><Font ss:FontName="Verdana" x:Family="Swiss" ss:Size="9" ss:Color="#0000FF" ss:Underline="Single"/><Interior ss:Color="#FFFFFF" ss:Pattern="Solid"/></Style>';
	$output .= '</Styles>'."\n";
	$output .= "<Worksheet ss:Name='".__('Tickets listing','WATS')."'>\n";
	$output .= '<Table ss:ExpandedColumnCount="256" x:FullColumns="1" x:FullRows="1" ss:DefaultColumnWidth="60">'."\n";
	$output .= '<Column ss:AutoFitWidth="0" ss:Width="65.25" ss:Span="255"/>';

	$output .= wats_ticket_list_ajax_processing(2);
	$output .= "</Table></Worksheet></Workbook>\n";
	
	echo $output;
	die;
	
	return;
}

/*******************************************************/
/*                                                     */
/* Fonction de processing Ajax de la liste des tickets */
/*                                                     */
/*******************************************************/

function wats_ticket_list_ajax_processing($view)
{
	global $wats_settings, $current_user;

	wats_load_settings();
	if ($view != 2)
	{
		$view = $_POST['view'];
		check_ajax_referer('filter-wats-tickets-list');
	}
	
	if ($view == 1 || $view == 2)
	{
		$idtype = $_POST['wats_select_ticket_type_tl'];
		$idpriority = $_POST['wats_select_ticket_priority_tl'];
		$idstatus = $_POST['wats_select_ticket_status_tl'];
		$idstatusop = $_POST['wats_select_ticket_status_operator'];
		$idproduct = $_POST['wats_select_ticket_product_tl'];
		
		if (($wats_settings['visibility'] == 0) || ($wats_settings['visibility'] == 1 && is_user_logged_in()) || ($wats_settings['visibility'] == 2 && is_user_logged_in() && (current_user_can('administrator') || ($wats_settings['ticket_visibility_read_only_capability'] == 1 && current_user_can('wats_ticket_read_only')))))
		{
			$idauthor = isset($_POST['wats_select_ticket_author_tl']) ? stripslashes_deep($_POST['wats_select_ticket_author_tl']) : 0;
			if ($wats_settings['ticket_assign'] != 0)
				$idowner = isset($_POST['wats_select_ticket_owner_tl']) ? stripslashes_deep($_POST['wats_select_ticket_owner_tl']) : 0;
		}
		else if ($wats_settings['visibility'] == 2 && !current_user_can('administrator') && $wats_settings['ticket_visibility_same_company'] == 1)
		{
			if (wats_check_user_same_company($current_user->ID,wats_get_user_ID_from_user_login(stripslashes_deep($_POST['wats_select_ticket_author_tl']))) == true)
				$idauthor = isset($_POST['wats_select_ticket_author_tl']) ? stripslashes_deep($_POST['wats_select_ticket_author_tl']) : 0;
			else
				$idauthor = "0";
			$idowner = "0";
		}
		else
		{
			$idauthor = "0";
			$idowner = "0";
		}
		
		if ($wats_settings['ticket_assign'] == 0)
			$idowner = "0";
		
		if ((current_user_can('administrator') || ($wats_settings['ticket_visibility_read_only_capability'] == 1 && current_user_can('wats_ticket_read_only'))) && $wats_settings['filter_ticket_listing'] == 1)
			$idauthormetavalue = stripslashes_deep($_POST['wats_select_ticket_author_meta_value_tl']);
		else
			$idauthormetavalue = "0";

		$categoryfilter = stripslashes_deep($_POST['categoryfilter']);
		$categorylistfilter = stripslashes_deep($_POST['categorylistfilter']);
		if ($view == 1)
		{
			$listecf = isset($_POST['liste']) ? json_decode(stripslashes($_POST['liste'])) : 0;
		        if(is_array($listecf))      {
			        foreach ($listecf as $key => $table){
                        if(is_array($table)){
				            foreach ($table as $subkey => $value)
					            $liste[$subkey] = $value;
                        }
			        }
                }
			unset($listecf);
		}
		
		$wats_ticket_custom_field_values = $wats_settings['wats_ticket_custom_fields'];
		
		$listecf = array();
		if (is_array($wats_ticket_custom_field_values))
		foreach ($wats_ticket_custom_field_values as $key => $table)
		{
			if ($table['ftlf'] == 1 || ($table['ftlf'] == 2 && current_user_can('administrator')))
			{
				if ($view == 1)
				{
					if (isset($liste['wats_cf_'.$table['meta_key']]) && strlen($liste['wats_cf_'.$table['meta_key']]) > 0)
						$listecf[$table['meta_key']] = $liste['wats_cf_'.$table['meta_key']];
				}
				else if ($view == 2)
				{
					if (isset($_POST['wats_cf_'.$table['meta_key']]) && strlen($_POST['wats_cf_'.$table['meta_key']]) > 0)
						$listecf[$table['meta_key']] = stripslashes($_POST['wats_cf_'.$table['meta_key']]);
				}
			}
		}

		
		$output = wats_list_tickets($categoryfilter, $categorylistfilter, $view, $idtype, $idpriority, $idstatus, $idproduct, $idowner, $idauthor, $idauthormetavalue, $idstatusop, $listecf);
		if ($view == 1)
		{
			echo $output;
			exit;
		}
		else if ($view == 2)
		{
			return $output;
		}
	}
	
	return;
}

/********************************************************************************/
/*                                                                              */
/* Fonction de filtrage sur le contenu pour l'affichage de la table des tickets */
/*                                                                              */
/********************************************************************************/

function wats_list_tickets_filter($content)
{
    return (preg_replace_callback(WATS_TICKET_LIST_REGEXP, 'wats_list_tickets_args', $content));
}

/********************************************************************************/
/*                                                                              */
/* Fonction de filtrage des param?tres pour l'affichage de la table des tickets */
/*                                                                              */
/********************************************************************************/

function wats_list_tickets_args($args)
{
	global $wpdb, $post, $wats_ticket_list_shortcode, $wats_settings, $current_user;
	
	wats_load_settings();
	
	$wats_ticket_list_shortcode = true;
	$args = explode(" ", rtrim($args[0], "]"));
	$cats = get_the_category($post->ID);

	$catlist = array();
	foreach ($cats as $cat)
	{	
		$catlist[] = $cat->cat_ID;
	}
	
	if (is_array($catlist))
		$catlist = implode(',',$catlist);
	else
		$catlist = 1;
	
	$wats_default_ticket_listing_default_query = $wats_settings['wats_default_ticket_listing_default_query'];
	
	if ($wats_settings['ticket_type_key_enabled'] == 1)
		$type = $wats_default_ticket_listing_default_query['type'];
	else
		$type = 0;
	
	if ($wats_settings['ticket_priority_key_enabled'] == 1)
		$priority = $wats_default_ticket_listing_default_query['priority'];
	else
		$priority = 0;
		
	if ($wats_settings['ticket_status_key_enabled'] == 1)
	{
		$status = $wats_default_ticket_listing_default_query['status'];
		$status_op = $wats_default_ticket_listing_default_query['status_op'];
	}
	else
	{
		$status = 0;
		$status_op = 0;
	}
		
	if ($wats_settings['ticket_product_key_enabled'] == 1)
		$product = $wats_default_ticket_listing_default_query['product'];
	else
		$product = 0;
		
	if (($wats_settings['visibility'] == 0) || ($wats_settings['visibility'] == 1 && is_user_logged_in()) || ($wats_settings['visibility'] == 2 && is_user_logged_in() && (current_user_can('administrator') || ($wats_settings['ticket_visibility_read_only_capability'] == 1 && current_user_can('wats_ticket_read_only')))))
	{
		if ($wats_default_ticket_listing_default_query['author'] == 1 && is_user_logged_in())
			$author = $current_user->user_login;
		else
			$author = 0;
		
		if ($wats_settings['ticket_assign'] != 0)
		{
			if ($wats_default_ticket_listing_default_query['owner'] == '2' && is_user_logged_in())
				$owner = $current_user->user_login;
			else if ($wats_default_ticket_listing_default_query['owner'] == '1')
				$owner = 1;
			else
				$owner = 0;
		}
		else
			$owner = 0;
	}
	else if ($wats_settings['visibility'] == 2 && !current_user_can('administrator') && $wats_settings['ticket_visibility_same_company'] == 1)
	{
		if ($wats_default_ticket_listing_default_query['author'] == 1 && is_user_logged_in())
			$author = $current_user->user_login;
		else
			$author = 0;
		$owner = 0;
	}
	else
	{
		$author = 0;
		$owner = 0;
	}

	
	return (wats_list_tickets($args[1],$catlist,0,$type,$priority,$status,$product,$owner,$author,0,$status_op,0));
}

/**************************************************************/
/*                                                            */
/* Fonction d'affichage des filtres pour la liste des tickets */
/*                                                            */
/**************************************************************/

function wats_list_tickets_filters()
{
	global $wats_settings, $current_user;
	
	$wats_ticket_priority = isset($wats_settings['wats_priorities']) ? $wats_settings['wats_priorities'] : 0;
	$wats_ticket_type = isset($wats_settings['wats_types']) ? $wats_settings['wats_types'] : 0;
	$wats_ticket_status = isset($wats_settings['wats_statuses']) ? $wats_settings['wats_statuses'] : 0;
	$wats_ticket_product = isset($wats_settings['wats_products']) ? $wats_settings['wats_products'] : 0;
	
	$wats_default_ticket_listing_default_query = $wats_settings['wats_default_ticket_listing_default_query'];
	
	$output = '</p>';
	
	if (!is_user_logged_in() && $wats_settings['visibility'] != 0)
	{
		$output .= __('Please authenticate yourself to view the tickets in the ticket list.','WATS').'<br /><br />';
		$output .= '<form action="'.get_bloginfo('url').'/wp-login.php" method="post">';
		$output .= '<table class="wats_submit_form_login_table"><tbody>';
		$output .= '<tr><td>'.__('User','WATS').'</td><td><input type="text" class="input" name="log" id="log" style="width:12em;" /></td></tr>';
		$output .= '<tr><td>'.__('Password','WATS').'</td><td><input type="password" class="input" name="pwd" id="pwd" style="width:12em;" /></td></tr>';
		$output .= '<tr><td><input type="submit" name="submit" value="'.__('Log In').'" class="button" /></td>';
		$output .= '<td><input name="rememberme" id="rememberme" type="checkbox" value="forever" /> '.__('Remember Me').'</td></tr></tbody></table>';
		$output .= '<input type="hidden" name="redirect_to" value="'.$_SERVER['REQUEST_URI'].'"/>';
		$output .= '</form><br />';
	}
	
	$output .= '<form id="wats_frontend_ticket_listing_form" action="" method="post">'."\n";
	$output .= wp_nonce_field('filter-wats-tickets-list','_wpnonce_ticket_list',true,false)."\n";
	
	$output .= '<div id="wats_frontend_ticket_listing_div">';
	
	if ($wats_settings['ticket_type_key_enabled'] == 1)
	{
		$output .= '<div id="wats_ticket_type_tl">'."\n";
		$output .= __('Ticket type','WATS').' : '."\n";
		$output .= '<select name="wats_select_ticket_type_tl" id="wats_select_ticket_type_tl" class="wats_select">'."\n";
		$output .= '<option value="0"';
		if ($wats_default_ticket_listing_default_query['type'] == 0)
			$output .= ' selected ';
		$output .= '>'.esc_html__('Any','WATS').'</option>'."\n";
		if (is_array($wats_ticket_type))
		foreach ($wats_ticket_type as $key => $value)
		{	
			$output .= '<option value="'.$key.'"';
			if ($wats_default_ticket_listing_default_query['type'] == $key)
				$output .= ' selected ';	
			$output .= '>'.esc_html__($value,'WATS').'</option>'."\n";
		}
		$output .= '</select></div>'."\n";
	}
	
	if ($wats_settings['ticket_priority_key_enabled'] == 1)
	{
		$output .= '<div id="wats_ticket_priority_tl">'."\n";
		$output .= __('Ticket priority','WATS').' : '."\n";
		$output .= '<select name="wats_select_ticket_priority_tl" id="wats_select_ticket_priority_tl" class="wats_select">'."\n";
		$output .= '<option value="0"';
		if ($wats_default_ticket_listing_default_query['priority'] == 0)
			$output .= ' selected ';
		$output .= '>'.esc_html__('Any','WATS').'</option>'."\n";
		if (is_array($wats_ticket_priority))
		foreach ($wats_ticket_priority as $key => $value)
		{	
			$output .= '<option value="'.$key.'"';
			if ($wats_default_ticket_listing_default_query['priority'] == $key)
				$output .= ' selected ';	
			$output .= '>'.esc_html__($value,'WATS').'</option>'."\n";
		}
		$output .= '</select></div>'."\n";
	}
	
	if ($wats_settings['ticket_status_key_enabled'] == 1)
	{
		$output .= '<div id="wats_ticket_status_tl">'."\n";
		$output .=  __('Ticket status','WATS').' '."\n";
		$output .= '<select name="wats_select_ticket_status_operator" id="wats_select_ticket_status_operator" class="wats_select">'."\n";
		$output .= '<option value="0"';
		if ($wats_default_ticket_listing_default_query['status_op'] == 0)
			$output .= ' selected ';
		$output .= '>==</option>'."\n";
		$output .= '<option value="1"';
		if ($wats_default_ticket_listing_default_query['status_op'] == 1)
			$output .= ' selected ';
		$output .= '>!=</option>'."\n";
		$output .= '</select> '."\n";
		$output .= '<select name="wats_select_ticket_status_tl" id="wats_select_ticket_status_tl" class="wats_select">'."\n";
		$output .= '<option value="0"';
		if ($wats_default_ticket_listing_default_query['status'] == 0)
			$output .= ' selected ';
		$output .= '>'.esc_html__('Any','WATS').'</option>'."\n";
		if (is_array($wats_ticket_status))
		foreach ($wats_ticket_status as $key => $value)
		{	
			$output .= '<option value="'.$key.'"';
			if ($wats_default_ticket_listing_default_query['status'] == $key)
				$output .= ' selected ';	
			$output .= '>'.esc_html__($value,'WATS').'</option>'."\n";
		}
		$output .= '</select></div>'."\n";
	}
	
	if ($wats_settings['ticket_product_key_enabled'] == 1)
	{
		$output .= '<div id="wats_ticket_product_tl">'."\n";
		$output .= __('Ticket product','WATS').' : '."\n";
		$output .= '<select name="wats_select_ticket_product_tl" id="wats_select_ticket_product_tl" class="wats_select">'."\n";
		$output .= '<option value="0"';
		if ($wats_default_ticket_listing_default_query['product'] == 0)
			$output .= ' selected ';
		$output .= '>'.esc_html__('Any','WATS').'</option>'."\n";
		if (is_array($wats_ticket_product))
		foreach ($wats_ticket_product as $key => $value)
		{	
			$output .= '<option value="'.$key.'"';
			if ($wats_default_ticket_listing_default_query['product'] == $key)
				$output .= ' selected ';	
			$output .= '>'.esc_html__($value,'WATS').'</option>'."\n";
		}
		$output .= '</select></div>'."\n";
	}
	
	$wats_ticket_custom_field_values = $wats_settings['wats_ticket_custom_fields'];
	if (is_array($wats_ticket_custom_field_values))
	foreach ($wats_ticket_custom_field_values as $key => $table)
	{
		if ($table['ftlf'] == 1 || ($table['ftlf'] == 2 && current_user_can('administrator')))
		{
			$output .= '<div class="wats_frontend_ticket_custom_field">';
			$output .= esc_html($table['name']).' : <input type="text" name="wats_cf_'.$table['meta_key'].'" id="wats_cf_'.$table['meta_key'].'" value="" /></div>';
		}
	}
	
	if (($wats_settings['visibility'] == 0) || ($wats_settings['visibility'] == 1 && is_user_logged_in()) || ($wats_settings['visibility'] == 2 && is_user_logged_in() && (current_user_can('administrator') || (!current_user_can('administrator') && $wats_settings['ticket_visibility_same_company'] == 1) || ($wats_settings['ticket_visibility_read_only_capability'] == 1 && current_user_can('wats_ticket_read_only')))))
	{
		if ($wats_settings['visibility'] == 2 && !current_user_can('administrator') && $wats_settings['ticket_visibility_same_company'] == 1)
		{
			$my_company = get_user_meta($current_user->ID,$wats_settings['company_meta_key_profile'],true);
			if (strlen($my_company) > 0)
				$userlist = wats_build_user_list_from_company(__('Any','WATS'),0,$my_company);
			else
				$userlist = array();
		}
		else
			$userlist = wats_build_user_list(__('Any','WATS'),0);

		if (sizeof($userlist) > 2)
		{
			$output .= '<div id="wats_ticket_author_tl">'."\n";
			$output .= __('Ticket author','WATS').' : '."\n";
			
			$output .= '<select name="wats_select_ticket_author_tl" id="wats_select_ticket_author_tl" class="wats_select">'."\n";
			foreach ($userlist AS $userlogin => $username)
			{
				$output .= '<option value="'.esc_attr($userlogin).'"';
				if (($wats_default_ticket_listing_default_query['author'] == '0' && $userlogin == '0') || ($wats_default_ticket_listing_default_query['author'] == '1' && $userlogin == $current_user->user_login))
					$output .= ' selected ';
				$output .= '>'.esc_html($username).'</option>'."\n";
			}
			$output .= '</select></div>'."\n";
		}
	
		if ((current_user_can('administrator') || ($wats_settings['ticket_visibility_read_only_capability'] == 1 && current_user_can('wats_ticket_read_only'))) && $wats_settings['filter_ticket_listing'] == 1)
		{
			$output .= '<div id="wats_ticket_author_meta_tl">'."\n";
			$output .= __('Ticket author','WATS').' ('.$wats_settings['filter_ticket_listing_meta_key'].') : ';
			$metakeyvalues = wats_build_list_meta_values($wats_settings['filter_ticket_listing_meta_key']);
			$output .= '<select name="wats_select_ticket_author_meta_value_tl" id="wats_select_ticket_author_meta_value_tl" class="wats_select">'."\n";
			$output .= '<option value="0">'.__('Any','WATS').'</option>'."\n";
			foreach ($metakeyvalues AS $value)
			{
				$output .= '<option value="'.esc_attr($value).'">'.esc_html($value).'</option>'."\n";
			}
			$output .= '</select></div>'."\n";
		}
	
		if ($wats_settings['ticket_assign'] != 0 && (($wats_settings['visibility'] == 0) || ($wats_settings['visibility'] == 1 && is_user_logged_in()) || ($wats_settings['visibility'] == 2 && is_user_logged_in() && (current_user_can('administrator') || ($wats_settings['ticket_visibility_read_only_capability'] == 1 && current_user_can('wats_ticket_read_only'))))))
		{
			$output .= '<div id="wats_ticket_owner_tl">'."\n";
			$output .= __('Ticket owner','WATS').' : '."\n";
			$userlist = wats_build_user_list(0,0);
			$output .= '<select name="wats_select_ticket_owner_tl" id="wats_select_ticket_owner_tl" class="wats_select">'."\n";
			$output .= '<option value="0"';
			if ($wats_default_ticket_listing_default_query['owner'] == 0)
				$output .= ' selected ';
			$output .= '>'.esc_html__('Any','WATS').'</option>'."\n";
			$output .= '<option value="1"';
			if ($wats_default_ticket_listing_default_query['owner'] == 1)
				$output .= ' selected ';
			$output .= '>'.esc_html__('None','WATS').'</option>'."\n";
			foreach ($userlist AS $userlogin => $username)
			{
				$output .= '<option value="'.esc_attr($userlogin).'"';
				if ($wats_default_ticket_listing_default_query['owner'] == '2' && $userlogin == $current_user->user_login)
					$output .= ' selected ';
				$output .= '>'.esc_html($username).'</option>'."\n";
			}
			$output .= '</select></div>'."\n";
		}
	}
	
	$output .= '<div class="wats_submit_tl">'."\n";
	$output .= '<input class="button-primary" type="submit" id="filter" name="filter" value="'.__('Filter','WATS').'" />  ';
	$output .= '<input class="button-primary" type="submit" id="wats_export" name="wats_export" value="'.__('Export','WATS').'" />';
	$output .= '</div></div>'."\n";
	
	return($output);
}

/********************************************************/
/*                                                      */
/* Fonction d'affichage du listing des tickets          */
/* Argument 1 : filtre cat?gorie (0 : all, 1 : current) */
/* View 0 : chargement HTML direct                      */
/* View 1 : chargement Ajax                             */
/* View 2 : rapport XML			                        */
/*                                                      */
/********************************************************/

function wats_list_tickets($filtercategory, $catlist, $view, $idtype, $idpriority, $idstatus, $idproduct, $idowner, $idauthor, $idauthormetavalue, $idstatusop, $listecf)
{
	global $wpdb, $wats_settings, $current_user, $wats_default_ticket_listing_columns;

	wats_load_settings();

	$joinoptions = 0;
	$leftjoin = "";
	$where = "";
	if ($view == 0 || $view == 1 || $view == 2)
	{
		if ($idtype > 0 && $wats_settings['ticket_type_key_enabled'] == 1)
		{
			$leftjoin = " LEFT JOIN $wpdb->postmeta AS wp1 ON $wpdb->posts.ID = wp1.post_id ";
			$where = " AND (wp1.meta_key = 'wats_ticket_type' AND wp1.meta_value = '$idtype')";
			$joinoptions = 1;
		}
		
		if ($idpriority > 0 && $wats_settings['ticket_priority_key_enabled'] == 1)
		{
			$leftjoin .= " LEFT JOIN $wpdb->postmeta AS wp2 ON $wpdb->posts.ID = wp2.post_id ";
			$where .= " AND (wp2.meta_key = 'wats_ticket_priority' AND wp2.meta_value = '$idpriority')";
			$joinoptions = 1;
		}
		
		if ($idstatus > 0 && $wats_settings['ticket_status_key_enabled'] == 1)
		{
			if ($idstatusop == 1)
				$idstatusop = '!=';
			else
				$idstatusop = '=';
			$leftjoin .= " LEFT JOIN $wpdb->postmeta AS wp3 ON $wpdb->posts.ID = wp3.post_id ";
			$where .= " AND (wp3.meta_key = 'wats_ticket_status' AND wp3.meta_value ".$idstatusop." '$idstatus')";
			$joinoptions = 1;
		}
		
		if ($idproduct > 0 && $wats_settings['ticket_product_key_enabled'] == 1)
		{
			$leftjoin .= " LEFT JOIN $wpdb->postmeta AS wp6 ON $wpdb->posts.ID = wp6.post_id ";
			$where .= " AND (wp6.meta_key = 'wats_ticket_product' AND wp6.meta_value = '$idproduct')";
			$joinoptions = 1;
		}
		
		if ($idauthor != "0")
		{
			$idauthor = wats_get_user_ID_from_user_login($idauthor);
			$where .= " AND $wpdb->posts.post_author = '$idauthor'";
			$joinoptions = 1;
		}
		
		if ($idowner != "0" && $idowner != "1")
		{
			$leftjoin .= " LEFT JOIN $wpdb->postmeta AS wp4 ON $wpdb->posts.ID = wp4.post_id ";
			$where .= " AND (wp4.meta_key = 'wats_ticket_owner' AND wp4.meta_value = '".esc_sql($idowner)."')";
			$joinoptions = 1;
		}
		else if ($idowner == "1")
		{
			$leftjoin .= " LEFT JOIN $wpdb->postmeta AS wp4 ON $wpdb->posts.ID = wp4.post_id ";
			$where .= " AND (wp4.meta_key = 'wats_ticket_owner' AND wp4.meta_value = '0')";
			$joinoptions = 1;
		}
		
		if ($idauthormetavalue != "0")
		{
			$key = $wats_settings['filter_ticket_listing_meta_key'];
			$leftjoin .= " LEFT JOIN $wpdb->usermeta AS wp5 ON $wpdb->posts.post_author = wp5.user_id ";
			$where .= " AND (wp5.meta_key = '$key' AND wp5.meta_value = '".esc_sql($idauthormetavalue)."')";
			$joinoptions = 1;
		}
		
		if (is_array($listecf))
		{
			$joinid = 10;

			foreach ($listecf as $key => $value)
			{
				$leftjoin .= " LEFT JOIN $wpdb->postmeta AS wp".$joinid." ON $wpdb->posts.ID = wp".$joinid.".post_id ";
				$where .= " AND (wp".$joinid.".meta_key = '".esc_sql($key)."' AND wp".$joinid.".meta_value = '".esc_sql($value)."')";
				$joinoptions = 1;
				$joinid++;
			}
		}
	}
	$group_by = ' GROUP BY ID';
	$order_by = ' ORDER BY post_date DESC';
	
	if (current_user_can('administrator'))
		$post_status = " ($wpdb->posts.post_status = 'publish' OR $wpdb->posts.post_status = 'pending')";
	else
		$post_status = " $wpdb->posts.post_status = 'publish'";
	
	if ($filtercategory == 0)
	{
		if ($wats_settings['visibility'] == 0)
			$tickets = $wpdb->get_results($wpdb->prepare("SELECT ID, post_title, post_author, post_date FROM $wpdb->posts".$leftjoin." WHERE $wpdb->posts.post_type = 'ticket' AND".$post_status.$where.$group_by.$order_by));
		else if ($wats_settings['visibility'] == 1 && is_user_logged_in())
			$tickets = $wpdb->get_results($wpdb->prepare("SELECT ID, post_title, post_author, post_date FROM $wpdb->posts".$leftjoin." WHERE $wpdb->posts.post_type = 'ticket' AND".$post_status.$where.$group_by.$order_by));
		else if ($wats_settings['visibility'] == 2 && is_user_logged_in() && (current_user_can('administrator') || ($wats_settings['ticket_visibility_read_only_capability'] == 1 && current_user_can('wats_ticket_read_only'))))
			$tickets = $wpdb->get_results($wpdb->prepare("SELECT ID, post_title, post_author, post_date FROM $wpdb->posts".$leftjoin." WHERE $wpdb->posts.post_type = 'ticket' AND".$post_status.$where.$group_by.$order_by));
		else if ($wats_settings['visibility'] == 2 && is_user_logged_in() && $wats_settings['ticket_visibility_same_company'] == 1)
		{
			$liste = "'".implode("','",wats_build_user_array_from_company($current_user->ID))."'";
			$tickets = $wpdb->get_results($wpdb->prepare("SELECT ID, post_title, post_author, post_date FROM $wpdb->posts".$leftjoin." WHERE $wpdb->posts.post_type = 'ticket' AND $wpdb->posts.post_author IN(".$liste.") AND".$post_status.$where.$group_by.$order_by));
		}
		else if ($wats_settings['visibility'] == 2 && is_user_logged_in())
			$tickets = $wpdb->get_results($wpdb->prepare("SELECT ID, post_title, post_author, post_date FROM $wpdb->posts".$leftjoin." WHERE $wpdb->posts.post_type = 'ticket' AND $wpdb->posts.post_author = $current_user->ID AND".$post_status.$where.$group_by.$order_by));
	}
	else if ($filtercategory == 1)
	{
		if ($wats_settings['visibility'] == 0)
			$tickets = $wpdb->get_results($wpdb->prepare("SELECT ID, post_title, post_author, post_date FROM $wpdb->posts LEFT JOIN $wpdb->term_relationships ON $wpdb->posts.ID = $wpdb->term_relationships.object_id LEFT JOIN $wpdb->term_taxonomy ON $wpdb->term_taxonomy.term_taxonomy_id = $wpdb->term_relationships.term_taxonomy_id ".$leftjoin." WHERE  $wpdb->posts.post_type = 'ticket' AND $wpdb->term_taxonomy.taxonomy = 'category' AND $wpdb->term_taxonomy.term_id IN(".esc_sql($catlist).") AND".$post_status.$where.$group_by.$order_by));
		else if ($wats_settings['visibility'] == 1 && is_user_logged_in())
			$tickets = $wpdb->get_results($wpdb->prepare("SELECT ID, post_title, post_author, post_date FROM $wpdb->posts LEFT JOIN $wpdb->term_relationships ON $wpdb->posts.ID = $wpdb->term_relationships.object_id LEFT JOIN $wpdb->term_taxonomy ON $wpdb->term_taxonomy.term_taxonomy_id = $wpdb->term_relationships.term_taxonomy_id ".$leftjoin." WHERE  $wpdb->posts.post_type = 'ticket' AND $wpdb->term_taxonomy.taxonomy = 'category' AND $wpdb->term_taxonomy.term_id IN(".esc_sql($catlist).") AND".$post_status.$where.$group_by.$order_by));
		else if ($wats_settings['visibility'] == 2 && is_user_logged_in() && (current_user_can('administrator') || ($wats_settings['ticket_visibility_read_only_capability'] == 1 && current_user_can('wats_ticket_read_only'))))
			$tickets = $wpdb->get_results($wpdb->prepare("SELECT ID, post_title, post_author, post_date FROM $wpdb->posts LEFT JOIN $wpdb->term_relationships ON $wpdb->posts.ID = $wpdb->term_relationships.object_id LEFT JOIN $wpdb->term_taxonomy ON $wpdb->term_taxonomy.term_taxonomy_id = $wpdb->term_relationships.term_taxonomy_id ".$leftjoin." WHERE  $wpdb->posts.post_type = 'ticket' AND $wpdb->term_taxonomy.taxonomy = 'category' AND $wpdb->term_taxonomy.term_id IN(".esc_sql($catlist).") AND".$post_status.$where.$group_by.$order_by));
		else if ($wats_settings['visibility'] == 2 && is_user_logged_in() && $wats_settings['ticket_visibility_same_company'] == 1)
		{
			$liste = "'".implode("','",wats_build_user_array_from_company($current_user->ID))."'";
			$tickets = $wpdb->get_results($wpdb->prepare("SELECT ID, post_title, post_author, post_date FROM $wpdb->posts LEFT JOIN $wpdb->term_relationships ON $wpdb->posts.ID = $wpdb->term_relationships.object_id LEFT JOIN $wpdb->term_taxonomy ON $wpdb->term_taxonomy.term_taxonomy_id = $wpdb->term_relationships.term_taxonomy_id ".$leftjoin." WHERE  $wpdb->posts.post_type = 'ticket' AND $wpdb->posts.post_author IN(".$liste.") AND $wpdb->term_taxonomy.taxonomy = 'category' AND $wpdb->term_taxonomy.term_id IN(".esc_sql($catlist).") AND".$post_status.$where.$group_by.$order_by));
		}
		else if ($wats_settings['visibility'] == 2 && is_user_logged_in())
			$tickets = $wpdb->get_results($wpdb->prepare("SELECT ID, post_title, post_author, post_date FROM $wpdb->posts LEFT JOIN $wpdb->term_relationships ON $wpdb->posts.ID = $wpdb->term_relationships.object_id LEFT JOIN $wpdb->term_taxonomy ON $wpdb->term_taxonomy.term_taxonomy_id = $wpdb->term_relationships.term_taxonomy_id ".$leftjoin." WHERE  $wpdb->posts.post_type = 'ticket' AND $wpdb->posts.post_author = $current_user->ID AND $wpdb->term_taxonomy.taxonomy = 'category' AND $wpdb->term_taxonomy.term_id IN(".esc_sql($catlist).") AND".$post_status.$where.$group_by.$order_by));
	}

	$output = "";
	if ($view == 0)
	{
		$output .= wats_list_tickets_filters();
		$output .= '<input class="button-primary" type="hidden" id="categoryfilter" name="categoryfilter" value="'.esc_attr($filtercategory).'" />';
		$output .= '<input class="button-primary" type="hidden" id="categorylistfilter" name="categorylistfilter" value="'.esc_attr($catlist).'" />';
		$output .= '</form>';
		$output .= '<div id="resultticketlist">';
	}

	$colspan = 0;
	
	if ($view != 2)
	{
		$output .= '<table class="wats_table" cellspacing="0" id="tableticket" style="text-align:center;"><thead><tr class="thead">';
		$starttag = '<th scope="col"><div style="text-align:center;">';
		$endtag = '</div></th>';
	}
	else
	{
		$output .= '<Row ss:AutoFitHeight="0" ss:Height="37.5">'."\n";
		$starttag = '<Cell ss:StyleID="s51"><Data ss:Type="String">';
		$endtag = '</Data></Cell>'."\n";
	}
	
	$wats_default_ticket_listing_active_columns = $wats_settings['wats_default_ticket_listing_active_columns'];
	
	if ($wats_default_ticket_listing_active_columns['id'] == 1)
	{
		if (($wats_settings['numerotation'] == 1) || ($wats_settings['numerotation'] == 2))
		{
			$output .= $starttag.'ID'.$endtag;
			$colspan++;
		}
	}
	
	if ($wats_default_ticket_listing_active_columns['title'] == 1)
	{
		$output .= $starttag.__('Title','WATS').$endtag;
		$colspan++;
	}
	
	if ($wats_default_ticket_listing_active_columns['category'] == 1)
	{
		$output .= $starttag.__('Category','WATS').$endtag;
		$colspan++;	
	}
	
	if ($wats_default_ticket_listing_active_columns['author'] == 1)
	{
		$output .= $starttag.__('Author','WATS').$endtag;
		$colspan++;
	}
	
	if ($wats_settings['meta_column_ticket_listing'] == 1 && (current_user_can('administrator') || ($wats_settings['ticket_visibility_read_only_capability'] == 1 && current_user_can('wats_ticket_read_only'))))
	{
		$output .= $starttag.$wats_settings['meta_column_ticket_listing_meta_key'].$endtag;
		$colspan++;
	}
	
	if ($wats_default_ticket_listing_active_columns['owner'] == 1)
	{
		if ($wats_settings['ticket_assign'] != 0)
		{
			$output .= $starttag.__('Owner','WATS').$endtag;
			$colspan++;
		}
	}
	
	if ($wats_default_ticket_listing_active_columns['creation_date'] == 1)
	{
		$output .= $starttag.__('Creation date','WATS').$endtag;
		$colspan++;
	}
		
	if ($wats_default_ticket_listing_active_columns['modification_date'] == 1)
	{
		$output .= $starttag.__('Last modification date','WATS').$endtag;
		$colspan++;
	}
	
	if ($wats_default_ticket_listing_active_columns['last_updater'] == 1)
	{
		$output .= $starttag.__('Last modification author','WATS').$endtag;
		$colspan++;
	}

	if ($wats_default_ticket_listing_active_columns['type'] == 1 && $wats_settings['ticket_type_key_enabled'] == 1)
	{
		$output .= $starttag.__('Type','WATS').$endtag;
		$colspan++;
	}
	
	if ($wats_default_ticket_listing_active_columns['priority'] == 1 && $wats_settings['ticket_priority_key_enabled'] == 1)
	{
		$output .= $starttag.__('Priority','WATS').$endtag;
		$colspan++;
	}
	
	if ($wats_default_ticket_listing_active_columns['status'] == 1 && $wats_settings['ticket_status_key_enabled'] == 1)
	{
		$output .= $starttag.__('Status','WATS').$endtag;
		$colspan++;
	}
	
	if ($wats_default_ticket_listing_active_columns['product'] == 1 && $wats_settings['ticket_product_key_enabled'] == 1)
	{
		$output .= $starttag.__('Product','WATS').$endtag;
		$colspan++;
	}
	
	$wats_ticket_custom_field_values = $wats_settings['wats_ticket_custom_fields'];
	if (is_array($wats_ticket_custom_field_values))
	foreach ($wats_ticket_custom_field_values as $key => $table)
	{
		if ($table['ftltc'] == 1 || ($table['ftltc'] == 2 && current_user_can('administrator')))
		{
			$output .= $starttag.esc_html($table['name']).$endtag;
			$colspan++;
		}
	}
	
	if ($view != 2)
	{
		$output .= '</tr></thead><tbody>';
		$rowstarttag = '<tr>';
		$starttag = '<td>';
		$endtag = '</td>';
		$rowendtag = '</tr>';
	}
	else
	{
		$output .= '</Row>'."\n";
		$rowstarttag = '<Row ss:AutoFitHeight="1">'."\n";
		$starttag = '<Cell ss:StyleID="s52"><Data ss:Type="String">';
		$endtag = '</Data></Cell>'."\n";
		$rowendtag = '</Row>'."\n";
	}

    $alt = false;
	
	$x = 0;
	if ($tickets)
	foreach ($tickets as $ticket)
	{
		$x = 1;
	
		if ($view == 1 && $alt == true)
			$output .= '<tr class="alternate">';
		else
			$output .= $rowstarttag;
		
		if ($wats_default_ticket_listing_active_columns['id'] == 1)
		{
			if (($wats_settings['numerotation'] == 1) || ($wats_settings['numerotation'] == 2))
				$output .= $starttag.wats_get_ticket_number($ticket->ID).$endtag;
		}
		
		if ($wats_default_ticket_listing_active_columns['title'] == 1)
		{
			if ($view != 2)
				$output .= $starttag.'<a href="'.get_post_permalink($ticket->ID).'">'.esc_html($ticket->post_title).'</a>'.$endtag;
			else
				$output .=  '<Cell ss:StyleID="s53" ss:HRef="'.get_post_permalink($ticket->ID).'"><Data ss:Type="String">'.esc_html($ticket->post_title).$endtag;
		}

		if ($wats_default_ticket_listing_active_columns['category'] == 1)
		{
			$categories = get_the_category($ticket->ID);
			if (!empty($categories))
			{
				$out = array();
				foreach ($categories as $c)
				{
					$out[] = esc_html(sanitize_term_field('name', $c->name, $c->term_id, 'category', 'display'));
		
				}
				$output .= $starttag.join(', ',$out).$endtag;
			} 
			else
			{
				$output .= $starttag.__('Uncategorized','WATS').$endtag;
			}
		}
		
		if ($wats_default_ticket_listing_active_columns['author'] == 1)
		{
			if (function_exists('get_the_author_meta'))
				$output .= $starttag.get_the_author_meta('nickname',$ticket->post_author).$endtag;
			else
				$output .= $starttag.get_the_author($ticket->post_author).$endtag;
		}
			
		if ($wats_settings['meta_column_ticket_listing'] == 1 && (current_user_can('administrator') || ($wats_settings['ticket_visibility_read_only_capability'] == 1 && current_user_can('wats_ticket_read_only'))))
		{
			if ($wats_settings['meta_column_ticket_listing_meta_key'] == "user_email")
				$output .= $starttag.esc_html(get_the_author_meta('user_email',$ticket->post_author)).$endtag;
			else
				$output .= $starttag.esc_html(get_user_meta($ticket->post_author,$wats_settings['meta_column_ticket_listing_meta_key'],true)).$endtag;
		}

		if ($wats_default_ticket_listing_active_columns['owner'] == 1)
		{
			if ($wats_settings['ticket_assign'] != 0)
			{
				$ticket_owner = get_post_meta($ticket->ID,'wats_ticket_owner',true);
				if ($ticket_owner)
					$output .= $starttag.get_post_meta($ticket->ID,'wats_ticket_owner',true).$endtag;
				else
					$output .= $starttag.__('None','WATS').$endtag;
			}
		}
		
		if ($wats_default_ticket_listing_active_columns['creation_date'] == 1)
			$output .= $starttag.get_post_time('M d, Y',false,$ticket,false).$endtag;
		
		if ($wats_default_ticket_listing_active_columns['modification_date'] == 1)
		{
			$comments = $wpdb->get_row($wpdb->prepare("SELECT comment_ID, comment_date FROM $wpdb->comments WHERE comment_post_ID = ".$ticket->ID." ORDER BY comment_date DESC LIMIT 1"));
			if (!is_object($comments))
				$date = 0;
			else
				$date = $comments->comment_date;
			
			if (strtotime($ticket->post_date) > strtotime($date))
				$last_modification_date = mysql2date('M d, Y',$ticket->post_date,false);
			else
				$last_modification_date = mysql2date('M d, Y',$comments->comment_date,false);
			$output .= $starttag.$last_modification_date.$endtag;
		}
		
		if ($wats_default_ticket_listing_active_columns['last_updater'] == 1)
		{
			if (!is_object($comments))
				$comments = $wpdb->get_row($wpdb->prepare("SELECT comment_ID, comment_date FROM $wpdb->comments WHERE comment_post_ID = ".$ticket->ID." ORDER BY comment_date DESC LIMIT 1"));
			
			if (!is_object($comments))
			{
				if (function_exists('get_the_author_meta'))
					$output .= $starttag.get_the_author_meta('nickname',$ticket->post_author).$endtag;
				else
					$output .= $starttag.get_the_author($ticket->post_author).$endtag;
			}
			else
			{
				$output .= $starttag.get_comment_author($comments->comment_ID).$endtag;
			}
		}
		
		if ($wats_default_ticket_listing_active_columns['type'] == 1 && $wats_settings['ticket_type_key_enabled'] == 1)
			$output .= $starttag.wats_ticket_get_type($ticket).$endtag;
		if ($wats_default_ticket_listing_active_columns['priority'] == 1 && $wats_settings['ticket_priority_key_enabled'] == 1)
			$output .= $starttag.wats_ticket_get_priority($ticket).$endtag;
		if ($wats_default_ticket_listing_active_columns['status'] == 1 && $wats_settings['ticket_status_key_enabled'] == 1)
			$output .= $starttag.wats_ticket_get_status($ticket).$endtag;
		if ($wats_default_ticket_listing_active_columns['product'] == 1 && $wats_settings['ticket_product_key_enabled'] == 1)
			$output .= $starttag.wats_ticket_get_product($ticket).$endtag;
			
		if (is_array($wats_ticket_custom_field_values))
		foreach ($wats_ticket_custom_field_values as $key => $table)
		{
			if ($table['ftltc'] == 1 || ($table['ftltc'] == 2 && current_user_can('administrator')))
			{
				$output .= $starttag.esc_html(get_post_meta($ticket->ID,$table['meta_key'],true)).$endtag;
			}
		}
			
		$output .= $rowendtag;
		$alt = !$alt;
	}
	
	if ($x == 0)
	{
		if ($view != 2)
		{
			$output .= '<tr valign="middle"><td colspan="'.$colspan.'" style="text-align:center">'.__('No entry','WATS').'</td></tr>';
		}
		else
		{
			$freespan = $colspan - 1;
			$output .= '<Row ss:AutoFitHeight="0" ss:Height="38.25">'."\n".'<Cell ss:MergeAcross="'.$freespan.'" ss:StyleID="s52"><Data ss:Type="String">'."\n";
			$output .= __('No entry','WATS');
			$output .= "\n".'</Data></Cell></Row>'."\n";
		}
	}
	
	if ($view != 2)
		$output .= '</tbody></table><br />';
	else
	{
		$freespan = $colspan - 1;
		$output = '<Row ss:AutoFitHeight="0" ss:Height="38.25">'."\n".'<Cell ss:MergeAcross="'.$freespan.'" ss:StyleID="s45"><Data ss:Type="String">'."\n".__('Ticket Listing', 'WATS')."\n".'</Data></Cell></Row>'."\n".$output;
	}

	if ($view == 0)
		$output .= '</div><p>';
	
	return ($output);
}

/************************************************************************************************/
/*                                                                                              */
/* Fonction de filtrage sur le contenu pour l'affichage du formulaire de soumission des tickets */
/*                                                                                              */
/************************************************************************************************/

function wats_ticket_submit_form_filter($content)
{
	return (preg_replace_callback(WATS_TICKET_SUBMIT_FORM, 'wats_ticket_submit_form', $content));
}

/****************************************************************/
/*                                                              */
/* Fonction d'affichage du formulaire de soumission des tickets */
/*                                                              */
/****************************************************************/

function wats_ticket_submit_form()
{
	global $current_user, $wats_settings, $wats_frontend_submission_form_shortcode;
	
	$wats_frontend_submission_form_shortcode = true;

	if ($wats_settings['frontend_submit_form_access'] == 1 || ($wats_settings['frontend_submit_form_access'] == 2 && is_user_logged_in()))
	{
		$output = '<form action="" method="post" id="wats_frontend_ticket_submission_form">';
		$output .= wp_nonce_field('filter-wats-submit-form','_wpnonce_ticket_submit_form',true,false);

		$code = '<div class="wats_ticket_form_title">'.__('User details','WATS').'</div>';
		if (is_user_logged_in())
			$code .= '<p align="left">'.__('Logged in as ', 'WATS').$current_user->user_login.'</p>';
		else
		{
			$code .= '<p align="left">'.__('Name', 'WATS').' '.__('(required)','WATS').' <input type="text" name="name" id="name" value="" size="22" /></p>';
			$code .= '<p align="left">'.__('Mail', 'WATS').' '.__('(required)', 'WATS').' <input type="text" name="email" id="email" value="" size="22" /></p>';
			$code .= '<p align="left">'.__('Website', 'WATS').' <input type="text" name="url" id="url" value="" size="22" /></p><br />';
		}
		$output_array['user_details'] = $code;

		$code = '<div class="wats_select_ticket_details_frontend wats_ticket_form_title">'.__('Ticket details','WATS').'</div><br />';
		$code .= wats_ticket_details_meta_box(null,1).'<br />';
		
		$output_array['ticket_metas'] = $code;
		
		$code = '<div class="wats_select_ticket_category_frontend"><label class="wats_label">'.__('Category', 'WATS').' : </label>';
		$code .= '<select class="wats_select" name="wats_cat_list" id="wats_cat_list" size="1">';
		add_filter('list_terms_exclusions','wats_list_terms_exclusions');
		$categories = get_categories('type=post&hide_empty=0');
		foreach ($categories as $category)
		{
			$code .= '<option value="'.$category->cat_ID.'" >'.esc_html($category->cat_name).'</option>';
		}
		$code .= '</select></div><br />';
		
		$output_array['category'] = $code;
				
		$code = '<div class="wats_ticket_form_title wats_ticket_frontend_submission_form_title">'.__('Ticket title', 'WATS').'<br />';
		$code .= '<input type="text" name="ticket_title" id="ticket_title" value="" size="60" /></div><br />';
		
		$output_array['ticket_title'] = $code;
		
		$code = '<div class="wats_ticket_form_title wats_ticket_frontend_submission_form_description">'.__('Ticket description', 'WATS').'<br />';
		$code .= '<textarea name="ticket_content" id="ticket_content" cols="60" rows="10"></textarea></div><br />';

		$output_array['ticket_description'] = $code;
		
		$output_array = apply_filters('wats_ticket_submit_form_output_array',$output_array);
		
		foreach ($output_array as $key => $value)
		{
			$output .= $value;
		}
		
		$output .= '<input name="submit_ticket" type="submit" id="submit_ticket" value="'.__('Submit ticket', 'WATS').'" />';
		$output .= '<div id="resultticketsubmitform"></div>';
		$output .= '</form><br />';
	}
	else if ($wats_settings['frontend_submit_form_access'] == 2)
	{
		$output = __('Please authenticate yourself to be able to access the ticket submission form.','WATS');
		$output .= '<form action="'.get_bloginfo('url').'/wp-login.php" method="post">';
		$output .= '<table class="wats_submit_form_login_table"><tbody>';
		$output .= '<tr><td>'.__('User','WATS').'</td><td><input type="text" class="input" name="log" id="log" style="width:12em;" /></td></tr>';
		$output .= '<tr><td>'.__('Password','WATS').'</td><td><input type="password" class="input" name="pwd" id="pwd" style="width:12em;" /></td></tr>';
		$output .= '<tr><td><input type="submit" name="submit" value="'.__('Log In').'" class="button" /></td>';
		$output .= '<td><input name="rememberme" id="rememberme" type="checkbox" value="forever" /> '.__('Remember Me').'</td></tr></tbody></table>';
		$output .= '<input type="hidden" name="redirect_to" value="'.$_SERVER['REQUEST_URI'].'"/>';
		$output .= '</form>';
	}
	else if ($wats_settings['frontend_submit_form_access'] == 0)
		$output = __('Sorry, the ticket submission form access has been disabled by the admin.','WATS');

	return ($output);
}

/*********************************************************/
/*                                                       */
/* Fonction de processing Ajax de soumission d'un ticket */
/*                                                       */
/*********************************************************/

function wats_ticket_submit_form_ajax_processing()
{
	global $wats_settings, $current_user;

	wats_load_settings();
	check_ajax_referer('filter-wats-submit-form');
	$create_metas = 0;
	$wats_ticket_assign = $wats_settings['ticket_assign'];
	$role = array_shift($current_user->roles);
	$user_can_assign = 0;
	if (isset($role) && $wats_settings['ticket_assignment_'.$role] == 1)
		$user_can_assign = 1;

	if ($_POST['view'] == 1 && ($wats_settings['frontend_submit_form_access'] == 1 || ($wats_settings['frontend_submit_form_access'] == 2 && is_user_logged_in())))
	{
		$post_title = stripslashes_deep(strip_tags($_POST['ticket_title']));
		$post_content = stripslashes_deep(strip_tags($_POST['ticket_content'], '<br><i><b><u><strong>'));
		$error = '';

		$listecf = isset($_POST['liste']) ? json_decode(stripslashes($_POST['liste'])) : 0;
		
/*		if (!wats_is_string($post_title))
			$error .= __('The ticket title is empty or contains invalid characters. ','WATS');
		
		if (!wats_is_paragraph($post_content))
			$error .= __('The ticket description is empty or contains invalid characters. ','WATS');*/
		
		$post_category = wats_is_numeric($_POST['category']) ? array($_POST['category']) : array(get_option('default_email_category'));
		$post_type = 'ticket';
		
		if (is_user_logged_in())
		{
			if (current_user_can('administrator') && $wats_settings['call_center_ticket_creation'] == 1)
				$post_author = wats_get_user_ID_from_user_login(stripslashes_deep($_POST['author']));
			else
				$post_author = $current_user->ID;
		}
		else
		{
			$name = esc_html($_POST['name']);
			$email = esc_html($_POST['email']);
			$url = esc_html($_POST['url']);
			if (!wats_is_string(stripslashes($name)))
				$error .= __('The name is empty or contains invalid characters. ','WATS');
			if (is_email($email))
			{
				$userdata = get_user_by_email($email);
				if ($userdata)
					$post_author = $userdata->ID;
				else
				{
					$post_author = wats_get_user_ID_from_user_login($wats_settings['submit_form_default_author']);
					$create_metas = 1;
				}
			}
			else
				$error .= __('The email address is empty or contains invalid characters. ','WATS');
		}
		
		if ($wats_settings['frontend_submit_form_ticket_status'] == 0)
			$post_status = 'pending';
		else if ($wats_settings['frontend_submit_form_ticket_status'] == 1)
		{
			if (is_user_logged_in())
				$post_status = 'publish';
			else
				$post_status = 'pending';
		}
		else if ($wats_settings['frontend_submit_form_ticket_status'] == 2)
		{
			if (is_user_logged_in())
			{
				$user = new WP_User($post_author);
				$post_status = ($user->has_cap('publish_posts')) ? 'publish' : 'pending';
			}
			else
				$post_status = 'pending';
		}
		else if ($wats_settings['frontend_submit_form_ticket_status'] == 3)
			$post_status = 'publish';
		else
			$post_status = 'pending';

		$post_data = compact('post_content','post_title','post_author','post_category', 'post_status', 'post_type');
		$post_data = add_magic_quotes($post_data);

		if (strlen($error))
			echo __('Error : ','WATS').$error;
		else
		{
			$post_ID = wp_insert_post($post_data, new WP_Error);
			
			if (is_wp_error($post_ID))
				echo "\n" . $post_ID->get_error_message();
			else
			{
				if ($wats_settings['ticket_status_key_enabled'] == 1 && isset($_POST['idstatus']) && $_POST['idstatus'] > 0)
					add_post_meta($post_ID,'wats_ticket_status',$_POST['idstatus']);
				if ($wats_settings['ticket_type_key_enabled'] == 1 && isset($_POST['idtype']) && $_POST['idtype'] > 0)
					add_post_meta($post_ID,'wats_ticket_type',$_POST['idtype']);
				if ($wats_settings['ticket_priority_key_enabled'] == 1 && isset($_POST['idpriority']) && $_POST['idpriority'] > 0)
					add_post_meta($post_ID,'wats_ticket_priority',$_POST['idpriority']);
				if ($wats_settings['ticket_product_key_enabled'] == 1 && isset($_POST['idproduct']) && $_POST['idproduct'] > 0)
					add_post_meta($post_ID,'wats_ticket_product',$_POST['idproduct']);
				//add_post_meta($post_ID,'wats_ticket_number',wats_get_latest_ticket_number()+1);
				if ($create_metas == 1)
				{
					add_post_meta($post_ID,'wats_ticket_author_name',$name);
					add_post_meta($post_ID,'wats_ticket_author_email',$email);
					add_post_meta($post_ID,'wats_ticket_author_url',$url);
				}
				
				if ($wats_ticket_assign == 1 || ($wats_ticket_assign == 2 && $user_can_assign == 1))
				{
					if (isset($_POST['idowner']))
						add_post_meta($post_ID,'wats_ticket_owner',$_POST['idowner']);
				}
				
				if (is_array($listecf))
				{
					foreach ($listecf as $key => $table)
					{
						foreach ($table as $subkey => $value)
							$liste[$subkey] = $value;
					}

					$wats_ticket_custom_field_values = $wats_settings['wats_ticket_custom_fields'];
					
					if (is_array($wats_ticket_custom_field_values))
					foreach ($wats_ticket_custom_field_values as $key => $table)
					{
						if ($table['fsf'] == 4 || ($table['fsf'] == 5 && current_user_can('administrator')))
						{
							if (isset($liste['wats_cf_'.$table['meta_key']]))
								update_post_meta($post_ID,$table['meta_key'],$liste['wats_cf_'.$table['meta_key']]);
						}
					}
				}

				$ticketnumber = wats_get_ticket_number($post_ID);
				if ($ticketnumber != 0)
					$output = __('Ticket ','WATS').$ticketnumber.__(' has been successfully created!','WATS').'<br />';
				else
					$output = __('Ticket has been successfully created!','WATS').'<br />';
				if ($post_status == 'publish')
					$output .= __('You can access it ','WATS').'<a href="'.get_permalink($post_ID).'">'.__('here','WATS').'</a>.';
				else
					$output .= __('You will be able to access it ','WATS').'<a href="'.get_permalink($post_ID).'">'.__('here','WATS').'</a> '.__('when an admin would have approved it','WATS').'.';
				echo $output;
				wats_fire_admin_notification($post_ID);
				
				do_action('wats_ticket_frontend_submission_saved_meta',$post_ID);
			}
		}
	}
	else
		echo __('Error : can\'t submit form','WATS');
	
	exit;
}

/****************************************/
/*                                      */
/* Fonction de v?rification d'un ticket */
/*                                      */
/****************************************/

function wats_is_ticket($post)
{
	if (get_post_type($post) == "ticket")
		return true;
	
	return false;
}

/******************************/
/*                            */
/* Fonction d'ajout du footer */
/*                            */
/******************************/

function wats_wp_footer()
{

	return;
}

/*********************************************************/
/*                                                       */
/* Fonction de redirection de la template pour un ticket */
/*                                                       */
/*********************************************************/

function wats_ticket_template_loader($template)
{
	global $wp_query, $wats_settings;

	if (is_singular() && wats_is_ticket($wp_query->post) == true)
	{
		if (wats_check_visibility_rights())
		{
			if ($wats_settings['template_selector'] == 0)
			{
				$template = str_replace('single-ticket','single',get_single_template());
				add_filter('the_content','wats_single_ticket_content_filter',10,1);
			}
			else
			{
				if (file_exists(TEMPLATEPATH.'/single-ticket.php')) $template = TEMPLATEPATH.'/single-ticket.php';
				else $template = WATS_THEME_PATH.'/single-ticket.php';
			}
		}
		else
		{
			if (file_exists(TEMPLATEPATH.'/ticket-access-denied.php')) $template = TEMPLATEPATH.'/ticket-access-denied.php';
			else $template = WATS_THEME_PATH.'/ticket-access-denied.php';
		}
	}
	
	return($template);
}

/**************************************************************/
/*                                                            */
/* Fonction d'affichage du message d'acc?s interdit au ticket */
/*                                                            */
/**************************************************************/

function wats_ticket_access_denied()
{
	global $post;

	if (!is_user_logged_in())
	{
		$output = '<p>'.__('Please authenticate yourself to view this ticket.', 'WATS').'</p>';
		$output .= '<form action="'.get_bloginfo('url').'/wp-login.php" method="post">';
		$output .= '<table class="wats_submit_form_login_table"><tbody>';
		$output .= '<tr><td>'.__('User','WATS').'</td><td><input type="text" class="input" name="log" id="log" style="width:12em;" /></td></tr>';
		$output .= '<tr><td>'.__('Password','WATS').'</td><td><input type="password" class="input" name="pwd" id="pwd" style="width:12em;" /></td></tr>';
		$output .= '<tr><td><input type="submit" name="submit" value="'.__('Log In').'" class="button" /></td>';
		$output .= '<td><input name="rememberme" id="rememberme" type="checkbox" value="forever" /> '.__('Remember Me').'</td></tr></tbody></table>';
		$output .= '<input type="hidden" name="redirect_to" value="'.$_SERVER['REQUEST_URI'].'"/>';
		$output .= '</form>';
		echo apply_filters('wats_filter_single_ticket_access_login_form',$output,$post);
	}
	else
	{
		$output = '<blockquote>'.__('Sorry, you don\'t have the rights to browse this ticket.','WATS').' ';
		$output .= __('If you believe that you should have access to it, please contact the website administrator.','WATS').'<blockquote>';
		echo apply_filters('wats_filter_single_ticket_access_denied',$output,$post);
	}
	
	return;
}

/****************************************************/
/*                                                  */
/* Fonction de filtrage du contenu du single ticket */
/*                                                  */
/****************************************************/

function wats_single_ticket_content_filter($content)
{
	global $wats_settings, $post;

	$output = '';
	if (wats_check_visibility_rights())
	{
		$output .= '<div id="wats_single_ticket_metas">';
		if ($wats_settings['ticket_priority_key_enabled'] == 1)
			$output .= '<div id="wats_single_ticket_priority"><label class="wats_label">'.__("Current priority : ",'WATS').'</label>'.wats_ticket_get_priority($post).'</div>';
		if ($wats_settings['ticket_status_key_enabled'] == 1)
			$output .= '<div id="wats_single_ticket_status"><label class="wats_label">'.__("Current status : ",'WATS').'</label>'.wats_ticket_get_status($post).'</div>';
		if ($wats_settings['ticket_type_key_enabled'] == 1)
			$output .= '<div id="wats_single_ticket_type"><label class="wats_label">'.__("Ticket type : ",'WATS').'</label>'.wats_ticket_get_type($post).'</div>';
		if ($wats_settings['ticket_product_key_enabled'] == 1)
			$output .= '<div id="wats_single_ticket_product"><label class="wats_label">'.__("Ticket product : ",'WATS').'</label>'.wats_ticket_get_product($post).'</div>';
		$output .= wats_ticket_get_custom_fields_frontend_ticket_template($post);
		$output .= '<div id="wats_single_ticket_originator"><label class="wats_label">'.__("Ticket originator : ",'WATS').'</label>'.get_the_author().'</div>';
		if ($wats_settings['ticket_assign'] != 0)
			$output .= '<div id="wats_single_ticket_owner"><label class="wats_label">'.__("Current ticket owner : ",'WATS').'</label>'.wats_ticket_get_owner($post).'</div>';
		if (current_user_can('administrator'))
		{
			$ticket_author_name = get_post_meta($post->ID,'wats_ticket_author_name',true);
			if ($ticket_author_name)
				$output .= '<div id="wats_single_ticket_author_name"><label class="wats_label">'.__('Ticket author name : ','WATS').'</label>'.$ticket_author_name.'</div>';
			$ticket_author_email = get_post_meta($post->ID,'wats_ticket_author_email',true);
			if ($ticket_author_email)
				$output .= '<div id="wats_single_ticket_author_email"><label class="wats_label">'.__('Ticket author email : ','WATS').'</label>'.'<a href="mailto:'.$ticket_author_email.'">'.$ticket_author_email.'</a></div>';
			$ticket_author_url = get_post_meta($post->ID,'wats_ticket_author_url',true);
			if ($ticket_author_url)
				$output .= '<div id="wats_single_ticket_author_url"><label class="wats_label">'.__('Ticket author url : ','WATS').'</label>'.'<a href="'.$ticket_author_url.'">'.$ticket_author_url.'</a></div>';
		}
		$output .= '</div>';
		$content = $output.$content;
	}
	else
	{
		wp_die(__('You are not allowed to view this ticket.','WATS'));
	}

	return $content;
}

/*************************************************/
/*                                               */
/* Fonction de filtrage pour inclure les tickets */
/*                                               */
/*************************************************/

function wats_posts_where($where)
{
	global $wpdb, $wats_settings, $current_user;
	
	if ((!is_home() || $wats_settings['wats_home_display'] == 1) && (!is_admin()) && (!is_page()) && (!is_search()))
	{
		if ($wats_settings['visibility'] == 0)
			$where = str_replace($wpdb->posts.".post_type = 'post' AND","(".$wpdb->posts.".post_type = 'post' OR ".$wpdb->posts.".post_type = 'ticket') AND", $where);
		else if ($wats_settings['visibility'] == 1 && is_user_logged_in())
			$where = str_replace($wpdb->posts.".post_type = 'post' AND","(".$wpdb->posts.".post_type = 'post' OR ".$wpdb->posts.".post_type = 'ticket') AND", $where);
		else if ($wats_settings['visibility'] == 2 && is_user_logged_in() && (current_user_can('administrator') || ($wats_settings['ticket_visibility_read_only_capability'] == 1 && current_user_can('wats_ticket_read_only'))))
			$where = str_replace($wpdb->posts.".post_type = 'post' AND","(".$wpdb->posts.".post_type = 'post' OR ".$wpdb->posts.".post_type = 'ticket') AND", $where);
		else if ($wats_settings['visibility'] == 2 && is_user_logged_in() && !is_admin() && $wats_settings['ticket_visibility_same_company'] == 1)
		{
			$liste = "'".implode("','",wats_build_user_array_from_company($current_user->ID))."'";
			$where = str_replace($wpdb->posts.".post_type = 'post' AND","(".$wpdb->posts.".post_type = 'post' OR (".$wpdb->posts.".post_type = 'ticket' AND ".$wpdb->posts.".post_author IN(".$liste."))) AND", $where);
		}
		else if ($wats_settings['visibility'] == 2 && is_user_logged_in())
			$where = str_replace($wpdb->posts.".post_type = 'post' AND","(".$wpdb->posts.".post_type = 'post' OR (".$wpdb->posts.".post_type = 'ticket' AND ".$wpdb->posts.".post_author = ".$current_user->ID.")) AND", $where);
	}
	
	if (is_admin() && isset($_GET['post_type']) && $_GET['post_type'] == 'ticket')
	{
		if ($wats_settings['visibility'] == 2 && !current_user_can('administrator'))
		{
			if ($wats_settings['ticket_visibility_same_company'] == 1)
			{
				$liste = "'".implode("','",wats_build_user_array_from_company($current_user->ID))."'";
				$where = str_replace($wpdb->posts.".post_type = 'ticket' AND"," (".$wpdb->posts.".post_type = 'ticket' AND ".$wpdb->posts.".post_author IN(".$liste.")) AND",$where);
			}
			else
				$where = str_replace($wpdb->posts.".post_type = 'ticket' AND",$wpdb->posts.".post_type = 'ticket' AND ".$wpdb->posts.".post_author = ".$current_user->ID." AND", $where);
		}
	}

	if (is_search())
	{
		if ($wats_settings['visibility'] == 1 && !is_user_logged_in())
			$where = str_replace(", 'ticket'","", $where);
		else if ($wats_settings['visibility'] == 2 && is_user_logged_in() && !current_user_can('administrator') && ($wats_settings['ticket_visibility_read_only_capability'] == 0 || !current_user_can('wats_ticket_read_only')))
		{
			$where = str_replace(", 'ticket'","", $where);
			if (!is_admin() && $wats_settings['ticket_visibility_same_company'] == 1)
			{
				$liste = "'".implode("','",wats_build_user_array_from_company($current_user->ID))."'";
				$where .= " OR (".$wpdb->posts.".post_type = 'ticket' AND ".$wpdb->posts.".post_author IN(".$liste."))";
			}
			else
				$where .= " OR (".$wpdb->posts.".post_type = 'ticket' AND ".$wpdb->posts.".post_author = ".$current_user->ID.")";
		}
		else if ($wats_settings['visibility'] == 2 && !is_user_logged_in())
		{
			$where = str_replace(", 'ticket'","", $where);
		}
	}

	return($where);
}

/*******************************************************************/
/*                                                                 */
/* Fonction de filtrage pour inclure les tickets dans les archives */
/*                                                                 */
/*******************************************************************/

function wats_get_archives($where)
{
	$where = str_replace( " post_type = 'post' AND", " (post_type = 'post' OR post_type = 'ticket') AND", $where);

	return($where);
}

/****************************************************************************/
/*                                                                          */
/* Fonction de redirection de la template pour les commentaires d'un ticket */
/*                                                                          */
/****************************************************************************/

function wats_comments_template($template)
{
	global $wp_query, $wats_settings;

	if (wats_is_ticket($wp_query->post) == true)
	{
		if (wats_check_visibility_rights())
		{
			if ($wats_settings['template_selector'] == 0)
			{
				add_filter('comments_open','wats_ticket_comments_open',10,2);
				add_action('comment_form_comments_closed','wats_ticket_comments_closed',10);
			
				if (wats_get_ticket_update_rights() == true)
					add_filter('comment_form_field_comment','wats_comment_form_after_fields',10,1);
			}
			else
			{
				if (file_exists(TEMPLATEPATH.'/comments-ticket.php')) $template = TEMPLATEPATH.'/comments-ticket.php';
				else $template = WATS_THEME_PATH.'/comments-ticket.php';
			}
		}
		else
		{
			wp_die(__('You are not allowed to view this ticket.','WATS'));
		}
	}

	add_filter('comment_class','wats_comment_class');
	
	return($template);
}

/****************************************************************************/
/*                                                                          */
/* Fonction de fermeture des commentaires WP */
/*                                                                          */
/****************************************************************************/

function wats_ticket_comments_open($open,$post_id)
{
	if (wats_get_ticket_update_rights() == false)
		return false;
	else
		return true;
}

/****************************************************************************/
/*                                                                          */
/* Fonction d'affichage de la raison de la fermeture des commentaires sur le ticket */
/*                                                                          */
/****************************************************************************/

function wats_ticket_comments_closed()
{
	echo apply_filters('wats_get_ticket_update_rights_message_filter',wats_get_ticket_update_rights_message());
	
	return;
}

/****************************************************************************/
/*                                                                          */
/* Fonction d'affichage des tickets metas dans le formulaire des commentaires */
/*                                                                          */
/****************************************************************************/

function wats_comment_form_after_fields($args)
{
	global $post;
	
	wats_ticket_details_meta_box($post);
	
	return $args;
}

/************************************/
/*                                  */
/* Fonction d'ajout d'une classe CSS pour les commentaires internes */
/*                                  */
/************************************/

function wats_comment_class($classes)
{

	if (get_comment_meta(get_comment_ID(),'wats_internal_update',true) == 1)
	{
		$classes[] = 'wats_internal_update';
	}
	
	return $classes;
}

/************************************/
/*                                  */
/* Fonction d'ajout d'une taxonomie */
/*                                  */
/************************************/

function wats_register_taxonomy()
{
	global $wats_settings;

	$taxonomies[] =  'category';
	if ($wats_settings['tickets_tagging'] == 1)
		$taxonomies[] = 'post_tag';

	$plugin_url = trailingslashit(get_option('siteurl')) . 'wp-content/plugins/' . basename(dirname(__FILE__)) .'/';
	$labels = array('name' => __('Tickets','WATS'),
					'singular_name' => __('ticket','WATS'),
					'add_new' => __('Add New','WATS'),
					'add_new_item' => __('Add New Ticket','WATS'),
					'edit_item' => __('Edit Ticket','WATS'),
					'new_item' => __('New Ticket','WATS'),
					'view_item' => __('View Ticket','WATS'),
					'search_items' => __('Search Ticket','WATS'),
					'not_found' =>  __('No tickets found','WATS'),
					'not_found_in_trash' => __('No tickets found in Trash','WATS'), 
					'parent_item_colon' => '');
	$args = array('labels' => $labels,
				  'public' => true,
				  'publicly_queryable' => true,
				  'show_ui' => true, 
				  'query_var' => true,
				  'rewrite' => true,
				  'capability_type' => 'post',
				  'hierarchical' => false,
				  'menu_position' => null,
				  'menu_icon' => $plugin_url.'img/support.png',
				  'supports' => array('title','editor','comments'),
				  'register_meta_box_cb' => 'wats_ticket_meta_boxes',
				  'taxonomies' => $taxonomies);
	register_post_type('ticket',$args);
	
	return;
}

/*********************************************************/
/*                                                       */
/* Fonction de calcul du nombre d'?l?ments par cat?gorie */
/*                                                       */
/*********************************************************/

function wats_update_ticket_term_count($terms)
{
	global $wpdb;
 
    foreach ((array) $terms as $term)
	{
        $count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $wpdb->term_relationships, $wpdb->posts WHERE $wpdb->posts.ID = $wpdb->term_relationships.object_id AND post_status = 'publish' AND (post_type = 'ticket' OR post_type = 'post') AND term_taxonomy_id = %d", $term));
        $wpdb->update($wpdb->term_taxonomy, compact('count'), array('term_taxonomy_id' => $term));
    }
}

/******************************************************/
/*                                                    */
/* Fonction d'ajout du num?ro de ticket dans le titre */
/*                                                    */
/******************************************************/

function wats_title_insert_ticket_number($title, $postID = 0)
{
	global $wats_printing_inline_data;

	if (get_post_type($postID) == "ticket" && $wats_printing_inline_data == false)
	{
		$value = wats_get_ticket_number($postID);
		
		if ($value)
			return($value." ".$title);
	}
	
	if (is_admin() && $wats_printing_inline_data == false)
		$wats_printing_inline_data = true;

	return ($title);
}

/*******************************************************/
/*                                                     */
/* Fonction de modification des liens previous et next */
/*                                                     */
/*******************************************************/

function wats_ticket_get_previous_next_post_where($where)
{
	global $wats_settings, $current_user;

	$searched_pattern = array(" AND p.post_type = 'ticket'"," AND p.post_type = 'post'");
	if ($wats_settings['visibility'] == 0)
		$where = str_replace($searched_pattern, " AND (p.post_type = 'post' OR p.post_type = 'ticket')", $where);
	else if ($wats_settings['visibility'] == 1 && is_user_logged_in())
		$where = str_replace($searched_pattern, " AND (p.post_type = 'post' OR p.post_type = 'ticket')", $where);
	else if ($wats_settings['visibility'] == 2 && is_user_logged_in() && (current_user_can('administrator') || ($wats_settings['ticket_visibility_read_only_capability'] == 1 && current_user_can('wats_ticket_read_only'))))
		$where = str_replace($searched_pattern, " AND (p.post_type = 'post' OR p.post_type = 'ticket')", $where);
	else if ($wats_settings['visibility'] == 2 && is_user_logged_in() && !is_admin() && $wats_settings['ticket_visibility_same_company'] == 1)
	{
		$liste = "'".implode("','",wats_build_user_array_from_company($current_user->ID))."'";
		$where = str_replace($searched_pattern, " AND (p.post_type = 'post' OR (p.post_type = 'ticket' AND p.post_author IN(".$liste.")))", $where);
	}
	else if ($wats_settings['visibility'] == 2 && is_user_logged_in())
		$where = str_replace($searched_pattern, " AND (p.post_type = 'post' OR (p.post_type = 'ticket' AND p.post_author = ".$current_user->ID."))", $where);

	return ($where);
}

/***************************************/
/*                                     */
/* Fonction de filtrage des cat?gories */
/*                                     */
/***************************************/

function wats_list_terms_exclusions($args)
{
	global $wats_settings;
	
	$where = "";
	if (isset($wats_settings['wats_categories']))
	{
		$list = $wats_settings['wats_categories'];
		$catlist = array();
		foreach ($list as $key => $value)
		{
			$catlist[] = $key;
		}
		$catlist = implode(',',$catlist);
		$where = " AND t.term_id IN ($catlist)";
	}
	
	return $where;
}

/****************************************************/
/*                                                  */
/* Fonction de filtrage du flux RSS des commentaire */
/*                                                  */
/****************************************************/

function wats_filter_comments_rss($cwhere)
{

	$cwhere = $cwhere." AND post_type != 'ticket'";
	
	return $cwhere;
}

/****************************************************/
/*                                                  */
/* Fonction pour ajouter des colonnes personnalis?e */
/*                                                  */
/****************************************************/

function wats_edit_post_column($defaults)
{
	global $wats_settings;

	if ($defaults)
	{
		if ($wats_settings['ticket_type_key_enabled'] == 1)
			$defaults['type'] = __('Type','WATS');
		if ($wats_settings['ticket_priority_key_enabled'] == 1)
			$defaults['priority'] = __('Priority','WATS');
		if ($wats_settings['ticket_status_key_enabled'] == 1)
			$defaults['status'] = __('Status','WATS');
		$defaults['title'] = __('Ticket','WATS');
		if ($wats_settings['ticket_product_key_enabled'] == 1)
			$defaults['product'] = __('Product','WATS');
		unset($defaults['tags']);
		return $defaults;
	}
	
	return;
}

/*****************************************************/
/*                                                   */
/* Fonction pour remplir les colonnes personnalis?es */
/*                                                   */
/*****************************************************/

function wats_edit_post_custom_column($column_name, $post_id)
{
	global $wats_settings;
	
	$wats_ticket_priority = isset($wats_settings['wats_priorities']) ? $wats_settings['wats_priorities'] : 0;
	$wats_ticket_type = isset($wats_settings['wats_types']) ? $wats_settings['wats_types'] : 0;
	$wats_ticket_status = isset($wats_settings['wats_statuses']) ? $wats_settings['wats_statuses'] : 0;
	$wats_ticket_product = isset($wats_settings['wats_products']) ?  $wats_settings['wats_products'] : 0;
	
	if ($column_name == 'priority')
	{
		$ticket_priority = get_post_meta($post_id,'wats_ticket_priority',true);
		if (wats_is_numeric($ticket_priority) && isset($wats_ticket_priority[$ticket_priority]))
			echo $wats_ticket_priority[$ticket_priority];
	}
	else if ($column_name == 'status')
	{
		$ticket_status = get_post_meta($post_id,'wats_ticket_status',true);
		if (wats_is_numeric($ticket_status) && isset($wats_ticket_status[$ticket_status]))
			echo $wats_ticket_status[$ticket_status];
	}
	else if ($column_name == 'type')
	{
		$ticket_type = get_post_meta($post_id,'wats_ticket_type',true);
		if (wats_is_numeric($ticket_type) && isset($wats_ticket_type[$ticket_type]))
			echo $wats_ticket_type[$ticket_type];
	}
	else if ($column_name == 'product')
	{
		$ticket_product = get_post_meta($post_id,'wats_ticket_product',true);
		if (wats_is_numeric($ticket_product) && isset($wats_ticket_product[$ticket_product]))
			echo $wats_ticket_product[$ticket_product];
	}
	
	return;
}

/*************************************************/
/*                                               */
/* Fonction de rewrite du title dans le frontend */
/*                                               */
/*************************************************/

function wats_wp_title($title)
{
	global $post;

	if (is_single() && $post->post_type == 'ticket')
	{
		$title = $post->post_title." | ";
	}
	
	return $title;
}

/*************************************************/
/*                                               */
/* Fonction de filtrage des posts rows actions */
/*                                               */
/*************************************************/

function wats_post_row_actions($actions, $post)
{
	global $wats_printing_inline_data;
	
	$wats_printing_inline_data = false;

	return $actions;
}

/*************************************************/
/*                                               */
/* Fonction de filtrage des commentaires */
/*                                               */
/*************************************************/

function wats_get_comments_clauses($clauses)
{
	global $wpdb, $wats_settings, $current_user;
	
	if (!current_user_can('administrator'))
	{
		if ($wats_settings['visibility'] == 2 && is_user_logged_in())
		{
			$clauses['join'] = " AS wp1 LEFT JOIN ".$wpdb->posts." AS wp3 ON wp1.comment_post_id = wp3.ID ";
			$clauses['where'] .= " AND wp3.post_author = ".$current_user->ID." AND NOT EXISTS (SELECT * FROM ".$wpdb->commentmeta." AS wp2 WHERE wp1.comment_ID = wp2.comment_id AND wp2.meta_key = 'wats_internal_update' AND wp2.meta_value = 1) ";
		}
		else if (($wats_settings['visibility'] == 1 && is_user_logged_in()) || $wats_settings['visibility'] == 0)
		{
			$clauses['join'] = " AS wp1 ";
			$clauses['where'] .= " AND NOT EXISTS (SELECT * FROM ".$wpdb->commentmeta." AS wp2 WHERE wp1.comment_ID = wp2.comment_id AND wp2.meta_key = 'wats_internal_update' AND wp2.meta_value = 1) ";
		}
		else
		{
			$clauses['join'] = " AS wp1 LEFT JOIN ".$wpdb->posts." AS wp3 ON wp1.comment_post_id = wp3.ID ";
			$clauses['where'] .= " AND wp3.post_type != 'ticket' AND NOT EXISTS (SELECT * FROM ".$wpdb->commentmeta." AS wp2 WHERE wp1.comment_ID = wp2.comment_id AND wp2.meta_key = 'wats_internal_update' AND wp2.meta_value = 1) ";
		}
	}
	
	return $clauses;
}

function wats_comments_array($comments,$post_id)
{
	if (!current_user_can('administrator'))
	{
		foreach ($comments AS $key => $comment)
		{
			if (get_comment_meta($comment->comment_ID,'wats_internal_update',true) == 1)
			{
				unset($comments[$key]);
			}
		}
	}
	
	return $comments;	
}

function wats_get_comments_number($count, $post_id)
{
	global $wpdb;

	if (!current_user_can('administrator'))
	{
		$count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM ".$wpdb->posts." AS wp1 LEFT JOIN ".$wpdb->comments." AS wp2 ON wp1.ID = wp2.comment_post_id WHERE wp1.ID = %d AND NOT EXISTS (SELECT * FROM ".$wpdb->commentmeta." AS wp3 WHERE wp2.comment_ID = wp3.comment_id AND wp3.meta_key = 'wats_internal_update' AND wp3.meta_value = 1)",$post_id));
	}
	
	return $count;
}

?>