<?php
/*
Plugin Name: WP Redirect After Login
Description: Redirect to previous page when login successfully
Version: 1.0
*/

function my_login_redirect($redirect_to, $request){
    global $current_user;
    get_currentuserinfo();
    //is there a user to check?
    if(is_array($current_user->roles))
    {
        //check for admins
      /*
        if(in_array("administrator", $current_user->roles))
            return home_url("/blog/");
        else
            return home_url("/blog/");
      */
      if(!isset($_SESSION["session_url_when_login"]) || $_SESSION["session_url_when_login"] == "") {
	return home_url();
      }
      return  str_replace("?loggedout=true", "", $_SESSION["session_url_when_login"]);
    }
}
add_filter("login_redirect", "my_login_redirect", 10, 3);


function set_session_url() {
  if (!session_id())
    session_start();
  
  $url = $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
  if(strpos($url,'/login.php') === false && 
     strpos($url,'/wp-content') === false && 
     strpos($url,'/forums-login') === false && 
     strpos($url,'/forums-lost-password') === false && 
     strpos($url,'/forums-register') === false &&
     strpos($url,'.css') === false &&
     strpos($url,'/wp-includes/') === false) {
    $_SESSION["session_url_when_login"] = "http://" . $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
  }
}
add_filter("get_header", "set_session_url");


function cp_admin_init() {
  if (!session_id())
    session_start();
}
add_action(‘init’, ‘cp_admin_init’);