<?php 

// change the default style.css to a new file
add_filter('stylesheet_uri', 'change_css');
function change_css() {
	return get_bloginfo('template_url') . '/pcstyles.css';
}

// modify/remove class attributes in nav. menu
add_filter('nav_menu_css_class', 'my_css_attributes_filter', 100, 1);
add_filter('nav_menu_item_id', 'my_css_attributes_filter', 100, 1);
add_filter('page_css_class', 'my_css_attributes_filter', 100, 1);

//function my_css_attributes_filter($var) {
  //return is_array($var) ? array() : '';
//}

// keep particular classes if needed
function my_css_attributes_filter($var) {
  return is_array($var) ? array_intersect($var, array('current', 'current_home', 'current_page_item', 'current-menu-item', 'current-menu-parent', 'current-page-ancestor')) : '';
}

// Remove empty classes in custom menu list
function remove_empty_classes($menu) {
    $menu = preg_replace('/ class=""/','',$menu);
    return $menu;
}
add_filter ('wp_nav_menu','remove_empty_classes');

add_theme_support( 'menus' );
//Register WordPress Menus
function register_menu() {
register_nav_menus(array('primary'=>'HomeNav', 'secondary'=>'NotesplusappNav', 'product_menu'=>'ProductNav', 'about_menu'=>'AboutNav', 'notesabout_menu'=>'NotesaboutNav', 'notesdevelopment_menu'=>'NotesdevelopmentNav', 'notessupport_menu'=>'NotessupportNav'));
}
add_action( 'init' , 'register_menu' );


//sidebar widgets
if ( function_exists('register_sidebar') ) {
	/*register_sidebar(array(
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h4 class="widgettitle">',
		'after_title' => '</h4>',
	));
	*/
	register_sidebar(array(
		'before_widget' => '<div class="roundBox">',
		'after_widget' => '</div></div>
            <div class="roundBoxBottom">&nbsp;</div>
        </div>',
		'before_title' => '<div class="roundBoxTop"><h4 class="widgettitle">',
		'after_title' => '</h4></div><div class="roundBoxBody"><div id="%1$s" class="widget %2$s">',
	));
}


//custom comment template
function mytheme_comment($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?>
   <li>
		<p class="comment-author">
			<?php echo get_avatar($comment,$size='42',$default='<path_to_url>' ); ?>
			<?php printf(__('<cite>%s</cite>'), get_comment_author_link()) ?><br />
			<small><?php comment_date('M d, Y'); ?> @ <?php comment_time('H:i:s'); ?><?php edit_comment_link('Edit',' [',']') ?></small>
		</p>
		<div class="commententry" id="commententry-<?php comment_ID() ?>">
			<?php if ($comment->comment_approved == '0') : ?>
			<p><em><?php _e('Your comment is awaiting moderation.') ?></em></p>
			<?php endif; ?>
		
			<?php comment_text() ?>
		</div>
		
		<p class="reply">
		<?php comment_reply_link(array_merge( $args, array('add_below' => 'commententry', 'depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
		</p>

<?php
        }


?>
