<?php

/* Register navigation menu */
function register_menu() {
	register_nav_menus(array('homeMenu'=>'HomeNav', 'notesplusappMenu'=>'notesplusNav', 'inkrediableMenu'=>'inkrediableMenu'));
}
add_action( 'init' , 'register_menu' );
add_theme_support( 'menus' );
/* End navigation menu */


/* Custom Menu */
class custom_walker extends Walker_Nav_Menu
{
	/**
	 * @see Walker::start_el()
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference. Used to append additional content.
	 * @param object $item Menu item data object.
	 * @param int $depth Depth of menu item. Used for padding.
	 * @param int $current_page Menu item ID.
	 * @param object $args
	 */
	function start_el(&$output, $item, $depth, $args) {
		global $wp_query;
		$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

		$class_names = $value = '';

		$classes = empty( $item->classes ) ? array() : (array) $item->classes;
		$classes[] = 'menu-item-' . $item->ID;

		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
		$class_names = ' class="' . esc_attr( $class_names ) . '"';

		$id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args );
		$id = strlen( $id ) ? ' id="' . esc_attr( $id ) . '"' : '';

		$divMenuStyle = '';
		if( $item->title == "Home" ) {
			$divMenuStyle = 'style="width:700px"';
		} else if( $item->title == "Support" ) {
			$divMenuStyle = 'style="width:760px;padding-top:30px;"';
		} else if( $item->title == "Development" ) {
			$divMenuStyle = 'style="width:180px;padding-top:40px;"';
		}

		if( $depth == 0 ) {
			$output .= $indent . '<div class="submenu depth-' . $depth . ' ' . $item->title . '" '.$divMenuStyle. '>';
		} else {
			$output .= $indent . '<li' . $id . $value . /*$class_names .*/'>';
		}

		$attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
		$attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
		$attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
		$attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';

		$linkStyle = "";
		if( $item->title == "New in Version 4.0" ) {
			$linkStyle = 'style="width:200px;"';
		} else if( $item->title == "Frequently Asked Questions" ) {
			$linkStyle = 'style="width:260px;"';
		} else if( $item->title == "Frequently Asked Questions" ) {
			$linkStyle = 'style="width:180px;"';
		} else if( $item->title == "A Wholly Different Approach on Handwriting on Tablets" ) {
			$linkStyle = 'style="width:700px;"';
		}  else if( $item->title == "Beta Tester Forum" ) {
			$linkStyle = 'style="width:180px;"';
		}

		$item_output = $args->before;
		$item_output .= '<a'. $attributes . ' ' . $linkStyle . '>';
		$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
		$item_output .= '</a>';
		$item_output .= $args->after;

		$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
	}

	/**
	 * @see Walker::end_el()
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference. Used to append additional content.
	 * @param object $item Page data object. Not used.
	 * @param int $depth Depth of page. Not Used.
	 */
	function end_el(&$output, $item, $depth) {

		if( $depth == 0 ) {
			$output .= "</div>\n";
		} else {
			$output .= "</li>\n";
		}


	}
}
/* Custom menu */

?>
