/*
 * Launch screen
 */

$(document).ready(function() {
	InitRatioLaunch();
});

$(window).resize(function() {
	ResetLaunchSize();
	InitRatioLaunch();
});

function ResetLaunchSize() {
	$(".launch").css("min-height", "100%");
	$(".launch").css("height", "100%");
	$(".launchRealImage").css("margin-top", "0px");
	$(".launchRealImage").css("margin-left", "0px");
	$(".launchRealImage").css("width", "20%");
	$(".launchRealImage").css("height", "auto");
}

function InitRatioLaunch() {
	var launchWidth = $(".launch").width();
	var launchHeight = $(".launch").height();
	
	var realImageWidth = $(".launchRealImage").width();
	var realImageHeight = $(".launchRealImage").height();
	
	var maxHeight = launchWidth * (76 / 100); // ~~ aspect ratio is 1.3
	var minHeight = launchWidth * (49 / 100); // ~~ aspect ratio is 2.0..
	
	if(launchHeight > maxHeight || launchHeight < minHeight) {
		$(".launch").css("min-height", "0px");
		$(".launch").css("height", "auto");
	} else {
		$(".launch").css("min-height", "100%");
		$(".launch").css("height", "100%");
		
		if(realImageHeight < launchHeight) {
			$(".launchRealImage").css("width", "auto");
			$(".launchRealImage").css("height", "100%");
			realImageWidth = $(".launchRealImage").width();
			var marginLeftValue = -(realImageWidth - launchWidth) / 2;
			$(".launchRealImage").css("margin-left", marginLeftValue);
		}
		
		if(realImageHeight > launchHeight) {
			var marginTopValue = -(realImageHeight - launchHeight) / 2;
			$(".launchRealImage").css("margin-top", marginTopValue);
		}
	}
	
}
 
/*
 * Image Slider
 */
 
$(".navigationButton.next").click(function() {
	$(".sliderContainer").animate({
		marginLeft: "-=100%"
	});
});

$(".navigationButton.previous").click(function() {
	$(".sliderContainer").animate({
		marginLeft: "+=100%"
	});
});
 
// jQuery for page scrolling feature - requires jQuery Easing plugin
$(function() {
    $('a.page-scroll').bind('click', function(event) {
        var $anchor = $(this);
        $('html, body').stop().animate({
            scrollTop: $($anchor.attr('href')).offset().top
        }, 1500, 'easeInOutExpo');
        event.preventDefault();
    });
});

/*
 * Slide Menu
 */
$(".transparentWrapper").click(function() {
	toggleMenu();
});
 
$("#toggle-slide-menu").click(function() {
	toggleMenu();
	return false;
});
$(".toggle-menu-close").click(function() {
	toggleMenu();
	return false;
});
$(".closeArea").click(function() {
	toggleMenu();
	return false;
});

	function toggleMenu() {
		toggleSlideMenu();
		toggleMenuIcon();
		toggleScrollingPage();
		toggleTransparentDiv();
	}

	function toggleSlideMenu() {
		var slideMenu = $(".slide-nav");
		var isOpenedMenu = slideMenu.hasClass("open");
		
		if( isOpenedMenu ) {
			slideMenu.removeClass("open");
		} else {
			slideMenu.addClass("open");
		}
	}
	
	function toggleMenuIcon() {
		var openedIcon = $(".toggle-menu-open");
		var closedIcon = $(".toggle-menu-close");
		var closeArea = $(".closeArea");
		var isShowingOpenedIcon = closedIcon.css("display") == "none";
		
		if( isShowingOpenedIcon ) {
			openedIcon.css("display", "none");
			closedIcon.css("display", "inline");
			closeArea.css("display", "inline");
		} else {
			openedIcon.css("display", "inline");
			closedIcon.css("display", "none");
			closeArea.css("display", "none");
		}
	}
	
	function toggleScrollingPage() {
		var isDisablingScrolling = jQuery("html").css("overflow") == "hidden" || jQuery("body").css("overflow") == "hidden";
		if(isDisablingScrolling) {
			// PC
			jQuery("html").css("overflow", "");
			jQuery("body").css("overflow", "");
			
			// IOS
			$(document).unbind('touchmove');
			$(".slide-nav").unbind('touchmove');
			
		} else {
			// PC
			jQuery("html").css("overflow", "hidden");
			jQuery("body").css("overflow", "hidden");
			
			// IOS
			$(document).on('touchmove', function() {
				toggleMenu();
				return false;
			});
			$(".slide-nav").on('touchmove', false);
			
		}
	}
	
	function toggleTransparentDiv() {
		var transparentDiv = jQuery(".transparentWrapper");
		var isHidden = transparentDiv.css("display") == "none";
		if(isHidden) {
			transparentDiv.css("display", "block");
		} else {
			transparentDiv.css("display", "none;");
		}
	}