<?php
    /**
    * Plugin Name: bbPress Search
    * Plugin URI: http://www.laptrinhvn.com/
    * Description: This Plugin search for the bbPress 2.x forum plugin post types independent from the regular WordPress search.
    * Version: 1.0
    * Author: Peter Son
    * Author URI: http://www.laptrinhvn.com/
    */

    add_action('wp_footer', 'bbpress_search_modify_form');
    add_filter('pre_get_posts', 'bbpress_search_cumtommize_query');
    add_filter( 'bbp_get_theme_compat_templates', 'bbp_search_get_theme_compat_templates' );

    function bbpress_search_modify_form(){
        $output = '';
        $post_type = get_post_type();
        if($post_type == 'forum' || $post_type == 'topic' || $post_type == 'reply') {
            $output = "
            <script type='text/javascript'>
            var post_type = document.createElement('input');
            post_type.setAttribute('type','hidden');
            post_type.setAttribute('name','type');
            post_type.setAttribute('value','forum');
            var searchsubmit = document.getElementById('searchform');
            searchsubmit.appendChild(post_type);
            </script>";
        } 
        echo stripslashes($output);
    }

    function bbpress_search_cumtommize_query($query){

        $post_type = $_REQUEST['type'];
        if($post_type == 'forum') {
            if ($query->is_search) { 
                $query->set('post_type', array('topic'));
            };
        }
        return $query;
    }

    function bbp_search_get_theme_compat_templates( $templates ) {

        /** Let bbPress use the current theme's native search.php for displaying the search results */
        if ( isset( $_GET['s'] ) )
            array_unshift( $templates, 'search.php' );
        return $templates;
    }
    
?>
