<?php
    /*
    * Plugin Name: BBPress Tiny Editor
    * Plugin URI: http://www.laptrinhvn.com/
    * Description: Add a tiny editor to bbpress
    * Version: 1.00
    * Author: Peter Son
    * Author URI: http://www.laptrinhvn.com/
    */

    $bbpress_tinyeditor = new bbpress_tinyeditor();
    $bbpress_tinyeditor->init();

    class bbpress_tinyeditor {

        function init(){                        
            add_action('init', array('bbpress_tinyeditor', 'disable_filter_kses'));   
            add_action('wp_head', array('bbpress_tinyeditor', 'add_to_head'));   
            add_action('wp_footer', array('bbpress_tinyeditor', 'add_to_footer'));       
        }

        function disable_filter_kses() {
            remove_filter( 'bbp_new_reply_pre_content', 'wp_filter_kses' );
            add_filter( 'bbp_get_reply_content', array('bbpress_tinyeditor', 'wpautop'), 29 );
        }

        function wpautop($content){                            
            $content = str_replace('<br />', '<br/>', $content);
            return $content;
        } 

        function add_to_head(){
            $css_url = trailingslashit(WP_PLUGIN_URL.'/'.str_replace(basename( __FILE__),"",plugin_basename(__FILE__))) . 'style.css';
            $css_url = '<link rel="stylesheet" href="'.$css_url.'" />';
            $js_url = trailingslashit(WP_PLUGIN_URL.'/'.str_replace(basename( __FILE__),"",plugin_basename(__FILE__))) . 'tinyeditor.js';
            $js_url = '<script type="text/javascript" src="' . $js_url . '"></script>';
            $output = "\n" . $css_url . "\n" . $js_url . "\n";
            echo stripslashes($output);wpautop($output);
        }

        function add_to_footer(){
            //echo get_post_type();
            //if(get_post_type()== 'topic'){
                $output = "<script type='text/javascript'>
                new TINY.editor.edit('editor',{
                id:'bbp_reply_content',
                width:'100%',
                height:175,
                cssclass:'te',
                controlclass:'tecontrol',
                rowclass:'teheader',
                dividerclass:'tedivider',
                controls:['bold','italic','underline','strikethrough','|','subscript','superscript','|',
                'orderedlist','unorderedlist','|','outdent','indent','|','leftalign',
                'centeralign','rightalign','blockjustify','|','unformat','|','undo','redo','n',
                'font','size','style','|','image','hr','link','unlink','|','cut','copy','paste','print'],
                footer:true,
                fonts:['Optima','Helvetica','Vernada','sans-serif'],
                xhtml:true,
                cssfile:'/wp-content/plugins/bbpress_tinyeditor/style.css',
                bodyid:'editor',
                footerclass:'tefooter',
                toggle:{text:'wysiwyg',activetext:'source',cssclass:'toggle'},
                resize:{cssclass:'resize'}
                });
				try
				{
					var submitButton = document.getElementById('bbp_reply_submit');
					submitButton.onclick = function () { editor.post(); }; 
				}
				catch(err)
				{
				  //Handle errors here
				}
				
                </script>";
            //} else {
                $output = $output . "<script type='text/javascript'>
                new TINY.editor.edit('editor1',{
                id:'bbp_topic_content',
                width:'100%',
                height:175,
                cssclass:'te',
                controlclass:'tecontrol',
                rowclass:'teheader',
                dividerclass:'tedivider',
                controls:['bold','italic','underline','strikethrough','|','subscript','superscript','|',
                'orderedlist','unorderedlist','|','outdent','indent','|','leftalign',
                'centeralign','rightalign','blockjustify','|','unformat','|','undo','redo','n',
                'font','size','style','|','image','hr','link','unlink','|','cut','copy','paste','print'],
                footer:true,
                fonts:['Optima','Helvetica','Vernada','sans-serif'],
                xhtml:true,
                cssfile:'/wp-content/plugins/bbpress_tinyeditor/style.css',
                bodyid:'editor',
                footerclass:'tefooter',
                toggle:{text:'wysiwyg',activetext:'source',cssclass:'toggle'},
                resize:{cssclass:'resize'}
                });
				
				try
				{
					var submitButton = document.getElementById('bbp_topic_submit');
					submitButton.onclick = function () { editor1.post(); }; 
				}
				catch(err)
				{
				  //Handle errors here
				}
				
                </script>";
            //}

            echo stripslashes($output);
        }
    }
    
    add_filter('bbp_get_form_topic_content', 'bbp_get_form_topic_content_add_tag_p');
    
    function bbp_get_form_topic_content_add_tag_p($content) {
    	return wpautop($content);
    }
?>
