<?php
/*
Plugin Name: Email rename
Description: Will rename in ticket
Version: 1.0
Author: Thuc.Le
Author URI: http://thuc.com.vn
*/

add_filter('wp_mail_from', 'email_rename_from', 15);
add_filter('wp_mail_from_name', 'email_rename_from_name', 15);
add_filter('comment_notification_headers', 'email_rename_headers_2', 15);

function email_rename_from() {
	global $current_user;
	
	if(is_user_logged_in()) {
		get_currentuserinfo();
		$user_email = $current_user->user_email;
		
		if($user_email == "" && isset($_POST["email"])) {
			$user_email = $_POST["email"];
		}
		
		if($user_email == "" && isset($_POST["bbp_anonymous_email"])) {
			$user_email = $_POST["bbp_anonymous_email"];
		}
		
	} else {
		if($user_email == "" && isset($_POST["email"])) {
			$user_email = $_POST["email"];
		}
		
		if($user_email == "" && isset($_POST["bbp_anonymous_email"])) {
			$user_email = $_POST["bbp_anonymous_email"];
		}
	}
	
	if($user_email == "") {
		$user_email = "wordpress@notesplusapp.com";
	}
	return $user_email;
}


function email_rename_from_name() {
	global $current_user;

	if(is_user_logged_in()) {
		get_currentuserinfo();
		$user_name = $current_user->display_name;
		
		if($user_name == "") {
			$user_name = $current_user->user_nicename;
		}
		if($user_name == "") {
			$user_name = $current_user->user_login;
		}
		if($user_name == "" && isset($_POST["author"])) {
			$user_name = $_POST["author"];
		}
		if($user_name == "" && isset($_POST["bbp_anonymous_name"])) {
			$user_name = $_POST["bbp_anonymous_name"];
		}
		if($user_name == "") {
			$user_name = get_option('blogname');
		}
		return $user_name;
	} else {
		if(isset($_POST["author"])) {
			$user_name = $_POST["author"];
		}
		if($user_name == "" && isset($_POST["bbp_anonymous_name"])) {
			$user_name = $_POST["bbp_anonymous_name"];
		}
		if($user_name == "") {
			$user_name = get_option('blogname');
		}
		return $user_name;
	}
}

function email_rename_headers_2($message_headers = "", $comment_id = "") {
	global $current_user;

	if(is_user_logged_in()) {
		get_currentuserinfo();
		$user_name = $current_user->display_name;
		
		if($user_name == "") {
			$user_name = $current_user->user_nicename;
		}
		if($user_name == "") {
			$user_name = $current_user->user_login;
		}
		if($user_name == "" && isset($_POST["author"])) {
			$user_name = $_POST["author"];
		}
		if($user_name == "" && isset($_POST["bbp_anonymous_name"])) {
			$user_name = $_POST["bbp_anonymous_name"];
		}
	} else {
		if(isset($_POST["author"])) {
			$user_name = $_POST["author"];
		}
		if($user_name == "" && isset($_POST["bbp_anonymous_name"])) {
			$user_name = $_POST["bbp_anonymous_name"];
		}
		if(isset($_POST["email"])) {
			$email_post = $_POST["email"];
		}
		
	}
	
	if($user_name == "") {
		return $message_headers; // Doesn't change anything
	}
	
	$blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
	
	$message_headers = preg_replace('/' . $blogname . '/', $user_name, $message_headers, 1);

	if($email_post == "") {
		return $message_headers;
	}	
	
	$wp_email = 'wordpress@' . preg_replace('#^www\.#', '', strtolower($_SERVER['SERVER_NAME']));
	
	$message_headers = preg_replace('/' . $wp_email . '/', $email_post, $message_headers, 1);
}

function email_rename_headers($comment_id) {
	$comment = get_comment( $comment_id );

	$from = "From: \"$comment->comment_author\" <$wp_email>";
	if ( '' != $comment->comment_author_email )
		$reply_to = "Reply-To: \"$comment->comment_author_email\" <$comment->comment_author_email>";

	$message_headers = "$from\n"
		. "Content-Type: text/plain; charset=\"" . get_option('blog_charset') . "\"\n";

	if ( isset($reply_to) )
		$message_headers .= $reply_to . "\n";

	return $message_headers;
}


add_filter('bbp_subscription_mail_message', 'fixing_bug_bbpress_send_email', 15);

function fixing_bug_bbpress_send_email($message = "", $reply_id = "", $topic_id = "", $user_id = "") {
		if(stripos($message, " wrote:", 0) === 0) {
			$name = "Guest";
			
			if(isset($_POST["bbp_anonymous_name"]) && $_POST["bbp_anonymous_name"] != "") {
				$name = $_POST["bbp_anonymous_name"];
			} else if(isset($_POST["bbp_anonymous_email"]) && $_POST["bbp_anonymous_email"] != "") {
				$name = $_POST["bbp_anonymous_email"];
			}
			
			$name = "'" . $name . "'";
			
			$message =  $name . $message;
		} 
		
		if(stripos($message, "#reply-", 0) !== false) {
			
			$url = $_SERVER['REQUEST_URI'];
			if(isset($_POST["_wp_http_referer"])) {
				$url = $_POST["_wp_http_referer"];
			}
			
			if(isset($_POST["bbp_topic_id"])) {
				$topic_id = $_POST["bbp_topic_id"];
			}
			
			preg_match_all('/#reply-(\\d+)/', $message, $matches);
			if(isset($matches) && $matches != null && count($matches) > 1 && count($matches[1]) > 0) {
			 	$reply_id = bbp_get_reply_id($matches[1][0]);
			}
			
			$reply_page = get_reply_page_for_forum_notification( $reply_id );
			
			
			$message = str_replace("#reply-", "/page/" . $reply_page . "#reply-", $message);
			
		}
		
		return $message;
	
}

function get_reply_page_for_forum_notification($reply_id){
	
	$reply_id = bbp_get_reply_id($reply_id);

	if(isset($_REQUEST["inreplyto"]) && $_POST["inreplyto"] != "" && $_POST["inreplyto"] != "0") {
		
		$reply_to_id = $_REQUEST["inreplyto"];
		
		return ucc_btr_get_page_of_reply($reply_to_id);
		
	} else {
		
		$topic_id = $_REQUEST["bbp_topic_id"];
		
		
		return ucc_btr_get_pages_of_topic($topic_id);
	}
	
}

function ucc_btr_get_pages_of_topic( $topic_id, $all = false ) {
	global $wpdb;

	$topic_id = bbp_get_topic_id($topic_id);

	$post_status = join( ',', array( bbp_get_public_status_id(), bbp_get_closed_status_id() ) );
	if ( bbp_get_view_all( 'edit_others_replies' ) || $all ) {
		$post_status = join( ',', array( bbp_get_public_status_id(), bbp_get_closed_status_id(), bbp_get_spam_status_id(), bbp_get_trash_status_id() ) );
	}
	$post_status = explode( ',', $post_status );
	$post_status_in_array = array();
	foreach ( $post_status as $ps )
		$post_status_in_array[] = $wpdb->prepare( "%s", $ps );
	$post_status_in_array = implode( ',', $post_status_in_array );

	$sql = $wpdb->prepare( "
		SELECT count(*) FROM
			(SELECT DISTINCT post_content FROM {$wpdb->posts} p
			WHERE p.post_parent = %d
				AND p.post_type = %s
				AND p.post_status IN ( {$post_status_in_array} )
				AND (
					NOT EXISTS (
						SELECT pm.* FROM {$wpdb->postmeta} pm WHERE p.ID = pm.post_id AND pm.meta_key = '_ucc_btr_in_reply_to'
					) OR EXISTS (
						SELECT pm.* FROM {$wpdb->postmeta} pm WHERE p.ID = pm.post_id AND pm.meta_key = '_ucc_btr_in_reply_to' AND pm.meta_value = 0
					) OR EXISTS (
						SELECT pm.* FROM {$wpdb->postmeta} pm WHERE p.ID = pm.post_id AND pm.meta_key = '_ucc_btr_in_reply_to' AND pm.meta_value = %d
			) ) ORDER BY p.post_date_gmt ASC) as subTable",
		$topic_id, bbp_get_reply_post_type(), $topic_id
	);
	
	$previous = $wpdb->get_var( $sql );

	$posts_per_page = get_option( '_bbp_replies_per_page' );
	$page = ceil( ( $previous + 1 ) / $posts_per_page );	

	return $page;
}

?>