<?php
$flags = array('ae',
				'af',
				'al',
				'am',
				'ar',
				'at',
				'au',
				'az',
				'ba',
				'bd',
				'be',
				'bg',
				'bh',
				'bn',
				'bo',
				'br',
				'by',
				'bz',
				'ca',
				'ch',
				'ci',
				'cl',
				'cn',
				'co',
				'cr',
				'cs',
				'cy',
				'cz',
				'da',
				'de',
				'dk',
				'do',
				'dz',
				'ec',
				'ee',
				'eg',
				'el',
				'en',
				'eo',
				'es',
				'eu',
				'fi',
				'fo',
				'fr',
				'gb',
				'ge',
				'gr',
				'gt',
				'hk',
				'hn',
				'hr',
				'hu',
				'id',
				'ie',
				'il',
				'in',
				'iq',
				'ir',
				'is',
				'it',
				'ja',
				'jm',
				'jo',
				'jp',
				'kk',
				'kp',
				'kr',
				'kw',
				'ky',
				'lb',
				'li',
				'lk',
				'ls',
				'lt',
				'lu',
				'lv',
				'ly',
				'ma',
				'mk',
				'mm',
				'mo',
				'mt',
				'mx',
				'my',
				'nb',
				'ni',
				'nl',
				'nn',
				'no',
				'nz',
				'om',
				'pa',
				'pe',
				'ph',
				'pk',
				'pl',
				'pr',
				'pt',
				'py',
				'qa',
				'ro',
				'rs',
				'ru',
				'sa',
				'se',
				'sg',
				'si',
				'sk',
				'sq',
				'sv',
				'sy',
				'th',
				'tn',
				'tr',
				'tt',
				'tw',
				'tz',
				'ua',
				'us',
				'uy',
				'uz',
				've',
				'vn',
				'xh',
				'ye',
				'za',
				'zu') ; 



$countries = array(
	'af' => array('af_AF'),
	'ar' => array('ar_AE','ar_BH','ar_DZ','ar_EG','ar_IQ','ar_JO','ar_KW','ar_LB','ar_LY','ar_MA','ar_OM','ar_QA','ar_SA','ar_SY','ar_TN','ar_YE'),
	'az' => array('az_AZ'),
	'be' => array('be_BY'),
	'bg' => array('bg_BG'),
	'by' => array('by_BY'),
	'ca' => array('ca_ES'),
	'cs' => array('cs_CZ'),
	'da' => array('da_DK'),
	'de' => array('de_AT','de_CH','de_DE','de_LU'),
	'el' => array('el_CY','el_GR', 'el_EL'),
	'en' => array('en_AU','en_CA','en_GB','en_IE','en_NZ','en_PH','en_US','en_ZA'),
	'es' => array('es_AR','es_BO','es_CL','es_CO','es_CR','es_DO','es_EC','es_ES','es_GT','es_HN','es_MX','es_NI','es_PA','es_PE','es_PR','es_PY','es_SV','es_UY','es_VE'),
	'et' => array('et_EE'),
	'eo' => array('eo_EO'),
	'eu' => array('eu_ES'),
	'fa' => array('fa_IR'),
	'fi' => array('fi_FI'),
	'fo' => array('fo_FO'),
	'fr' => array('fr_BE','fr_CA','fr_CH','fr_FR','fr_LU'),
	'fy' => array('fy_NL'),
	'ga' => array('ga_IE'),
	'he' => array('he_IL'),
	'hi' => array('hi_IN'),
	'hr' => array('hr_HR'),
	'hu' => array('hu_HU'),
	'id' => array('id_ID'),
	'in' => array('in_ID'),
	'is' => array('is_IS'),
	'it' => array('it_CH','it_IT'),
	'ja' => array('ja_JP'),
	'kk' => array('kk_KK'),
	'ko' => array('ko_KR'),
	'ky' => array('ky_KY'),
	'lb' => array('lb_LB'),
	'lt' => array('lt_LT'),
	'lv' => array('lv_LV'),
	'mk' => array('mk_MK'),
	'nb' => array('nb_NB', 'nb_NO'),
	'nl' => array('nl_BE','nl_NL'),
	'nn' => array('nn_NN'),
	'no' => array('no_NO'),
	'pl' => array('pl_PL'),
	'pt' => array('pt_BR','pt_PT'),
	'ro' => array('ro_RO'),
	'ru' => array('ru_RU'),
	'sk' => array('sk_SK'),
	'sl' => array('sl_SI'),
	'sq' => array('sq_AL'),
	'sr' => array('sr_BA','sr_CS', 'sr_RS'),
	'sv' => array('sv_SE'),
	'th' => array('th_TH'),
	'tl' => array('tl_PH'),
	'tr' => array('tr_TR'),
	'uk' => array('uk_UA'),
	'vi' => array('vi_VN'),
	'xh' => array('xh_XH'),
	'zh' => array('zh_CN','zh-MO','zh_HK','zh_SG','zh_TW'),
	'zu' => array('zu_ZU'),
);

$language_names = array(
	'af' => array(
		'lang-native' => 'Afrikaans',
		'country-www' => 'af'
	),
	'ar' => array(
		'lang-native' => 'العربية/الإمارات',
		'country-www' => 'ar'
	),
	'az' => array (
		'lang-native' => 'Azərbaycan',
		'country-www' => 'az'
	),
	'be' => array(
		'lang-native' => 'Беларускі',
		'country-www' => 'be'
	),
	'bg' => array(
		'lang-native' => 'Български',
		'country-www' => 'bg'
	),
	'by' => array(
		'lang-native' => 'Беларускі',
		'country-www' => 'by'
	),
	'ca' => array(
		'lang-native' => 'Сatalà',
		'country-www' => 'ca'
	),
	'ckb' => array(
		'lang-native' => 'Kurdi',
		'country-www' => ''
	),
	'cs' => array(
		'lang-native' => 'Čeština',
		'country-www' => 'cs'
	),
	'da' => array(
		'lang-native' => 'Dansk',
		'country-www' => 'da'
	),
	'de' => array(
		'lang-native' => 'Deutsch',
		'country-www' => 'de'
	),
	'el' => array(
		'lang-native' => 'Ελληνικά',
		'country-www' => 'el'
	),
	'en' => array(
		'lang-native' => 'English',
		'country-www' => 'en'
	),
	'eo' => array(
		'lang-native' => 'Esperanto',
		'country-www' => 'eo'
	),
	'es' => array(
		'lang-native' => 'Español',
		'country-www' => 'es'
	),
	'et' => array(
		'lang-native' => 'Eesti',
		'country-www' => 'et'
	),
	'eu' => array(	
		'lang-native' => 'Euskara',
		'country-www' => 'eu'
	),
	'fa' => array(
		'lang-native' => 'فارسی',
		'country-www' => 'fa'
	),
	'fi' => array(
		'lang-native' => 'Suomi',
		'country-www' => 'fi'
	),
	'fo' => array(
		'lang-native' => 'Føroyskt',
		'country-www' => 'fo'
	),
	'fr' => array(
		'lang-native' => 'Français',
		'country-www' => 'fr'
	),
	'fy' => array(
		'lang-native' => 'Frysk',
		'country-www' => 'fy'
	),
	'ga' => array(
		'lang-native' => 'Gaeilge',
		'country-www' => 'ga'
	),
	'he' => array(
		'lang-native' => 'עברית',
		'country-www' => 'he'
	),
	'hi' => array(
		'lang-native' => 'हिन्दी',
		'country-www' => 'hi'
	),
	'hr' => array(
		'lang-native' => 'Hrvatski',
		'country-www' => 'hr'
	),
	'hu' => array(
		'lang-native' => 'Magyar',
		'country-www' => 'hu'
	),
	'id' => array(
		'lang-native' => 'Bahasa',
		'country-www' => 'id'
	),
	'in' => array(
		'lang-native' => 'Bahasa',
		'country-www' => 'in'
	),
	'is' => array(	
		'lang-native' => 'Íslenska',
		'country-www' => 'is'
	),
	'it' => array(
		'lang-native' => 'Italiano',
		'country-www' => 'it'
	),
	'ja' => array(
		'lang-native' => '日本語',
		'country-www' => 'ja'
	),
	'kk' => array(
		'lang-native' => 'Қазақша',
		'country-www' => 'kk'
	),
	'ko' => array(
		'lang-native' => '한국어',
		'country-www' => 'ko'
	),
	'ky' => array(
		'lang-native' => 'Кыргызча',
		'country-www' => 'ky'
	),
	'lb' => array(
		'lang-native' => 'Lëtzebuergesch',
		'country-www' => 'lb'
	),
	'lt' => array(
		'lang-native' => 'Lietuvių',
		'country-www' => 'lt'
	),
	'lv' => array(
		'lang-native' => 'Latviešu',
		'country-www' => 'lv'
	),
	'mk' => array(
		'lang-native' => 'Македонски',
		'country-www' => 'mk'
	),
	'nb' => array(
		'lang-native' => '‪Norsk Bokmål‬',
		'country-www' => 'nb'
	),
	'nl' => array(
		'lang-native' => 'Nederlands',
		'country-www' => 'nl'
	),
	'nn' => array(
		'lang-native' => 'Norsk',
		'country-www' => 'nn'
	),
	'pl' => array(
		'lang-native' => 'Polski',
		'country-www' => 'pl'
	),
	'pt' => array(
		'lang-native' => 'Português',
		'country-www' => 'pt'
	),
	'ro' => array(
		'lang-native' => 'Română',
		'country-www' => 'ro'
	),
	'ru' => array(
		'lang-native' => 'Русский',
		'country-www' => 'ru'
	),
	'sk' => array(
		'lang-native' => 'Slovenčina',
		'country-www' => 'sk'
	),
	'sl' => array(
		'lang-native' => 'Slovenščina',
		'country-www' => 'sl'
	),
	'sr' => array(
		'lang-native' => 'Српски',
		'country-www' => 'sr'
	),
	'sv' => array(
		'lang-native' => 'Svenska',
		'country-www' => 'sv'
	),
	'th' => array(
		'lang-native' => 'ไทย/ประเทศไทย',
		'country-www' => 'th'
	),
	'tl' => array(
		'lang-native' => 'Tagalog',
		'country-www' => 'tl'
	),
	'tr' => array(
		'lang-native' => 'Türkçe',
		'country-www' => 'tr'
	),
	'uk' => array(
		'lang-native' => 'Українська',
		'country-www' => 'uk'
	),
	'vi' => array(
		'lang-native' => 'Tiếng Việt',
		'country-www' => 'vi'
	),
	'xh' => array(
		'lang-native' => 'isiXhosa',
		'country-www' => 'xh'
	),
	'zh' => array(
		'lang-native' => '中文',
		'country-www' => 'zh'
	),
	'zu' => array(
		'lang-native' => 'isiZulu', 
		'country-www' => 'zu'
	)
);

//based on http://translate.sourceforge.net/wiki/l10n/pluralforms
$csp_l10n_plurals = array(
	'af' => "nplurals=2; plural=n != 1;",
	'ar' => "nplurals=6; plural=n==0 ? 0 : n==1 ? 1 : n==2 ? 2 : n%100>=3 && n%100<=10 ? 3 : n%100>=11 ? 4 : 5;",
	'az' => "nplurals=2; plural=n != 1;",
	'be' => "nplurals=3; plural=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2);",
	'bg' => "nplurals=2; plural=n != 1;",
	'by' => "nplurals=3; plural=n%100/10==1 ? 2 : n%10==1 ? 0 : (n+9)%10>3 ? 2 : 1;",
	'ca' => "nplurals=2; plural=n != 1;",
	'cs' => "nplurals=3; plural=n%100/10==1 ? 2 : n%10==1 ? 0 : (n+9)%10>3 ? 2 : 1;",
	'da' => "nplurals=2; plural=n != 1;",
	'de' => "nplurals=2; plural=n != 1;",
	'el' => "nplurals=2; plural=n != 1;",
	'en' => "nplurals=2; plural=n != 1;",
	'es' => "nplurals=2; plural=n != 1;",
	'et' => "nplurals=2; plural=n != 1;",
	'eo' => "nplurals=2; plural=n != 1;",
	'eu' => "nplurals=2; plural=n != 1;",
	'fa' => "nplurals=1; plural=0;",
	'fi' => "nplurals=2; plural=n != 1;",
	'fo' => "nplurals=2; plural=n != 1;",
	'fr' => "nplurals=2; plural=n>1;",
	'fy' => "nplurals=2; plural=n != 1;",
	'ga' => "nplurals=5; plural=n==1 ? 0 : n==2 ? 1 : n<7 ? 2 : n<11 ? 3 : 4;",
	'he' => "nplurals=2; plural=n != 1;",
	'hi' => "nplurals=2; plural=n != 1;",
	'hr' => "nplurals=3; plural=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2);",
	'hu' => "nplurals=1; plural=0;",
	'id' => "nplurals=2; plural=n != 1;",
	'in' => "nplurals=2; plural=n != 1;",
	'is' => "nplurals=2; plural=(n%10!=1 || n%100==11);",
	'it' => "nplurals=2; plural=n != 1;",
	'ja' => "nplurals=1; plural=0;",
	'kk' => "nplurals=1; plural=0;",
	'ko' => "nplurals=1; plural=0;",
	'ky' => "nplurals=2; plural=n != 1;",
	'lb' => "nplurals=2; plural=n != 1;",
	'lt' => "nplurals=3; plural=n%10==1 && n%100!=11 ? 0 : n%10>=2 && (n%100<10 || n%100>=20) ? 1 : 2;",
	'lv' => "nplurals=3; plural=n%10==1 && n%100!=11 ? 0 : n != 0 ? 1 : 2;",
	'mk' => "nplurals=2; plural= n==1 || n%10==1 ? 0 : 1;",
	'nb' => "nplurals=2; plural=n != 1;",
	'nl' => "nplurals=2; plural=n != 1;",
	'nn' => "nplurals=2; plural=n != 1;",
	'no' => "nplurals=2; plural=n != 1;",
	'pl' => "nplurals=3; plural=n==1 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2;",
	'pt' => "nplurals=2; plural=n != 1;",
	'ro' => "nplurals=3; plural=(n==1 ? 0 : (n==0 || (n%100 > 0 && n%100 < 20)) ? 1 : 2); ",
	'ru' => "nplurals=3; plural=n%100/10==1 ? 2 : n%10==1 ? 0 : (n+9)%10>3 ? 2 : 1;",
	'sk' => "nplurals=3; plural=(n==1) ? 1 : (n>=2 && n<=4) ? 2 : 0;",
	'sl' => "nplurals=4; plural=n%100==1 ? 0 : n%100==2 ? 1 : n%100==3 || n%100==4 ? 2 : 3;",
	'sq' => "nplurals=2; plural=n != 1;", //may not be correct!
	'sr' => "nplurals=3; plural=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2);",
	'sv' => "nplurals=2; plural=n != 1;",
	'th' => "nplurals=1; plural=0;",
	'tl' => "nplurals=2; plural=n != 1;",
	'tr' => "nplurals=1; plural=0;",
	'uk' => "nplurals=3; plural=n%100/10==1 ? 2 : n%10==1 ? 0 : (n+9)%10>3 ? 2 : 1;",
	'vi' => "nplurals=1; plural=0;",
	'xh' => "nplurals=2; plural=n != 1;",
	'zh' => "nplurals=1; plural=0;",
	'zu' => "nplurals=2; plural=n != 1;",
);

$code_locales = array(
	'af_AF' => array (
		'country' => "South Africa",
		'country-www' => 'af',
		'lang' => 'Afrikaans',
		'lang-native' => 'Afrikaans',
		'lang-www' => 'af-AF',
		'dir' => 'ltr',
		'ms-loc' => 'afk',
		'ms-cp' => 'CP1252',
		'google-api' => false,
	),
	'ar_AE' => array (
		'country' => "U.A.E.",
		'country-www' => 'ae',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/الإمارات',
		'lang-www' => 'ar-AE',
		'dir' => 'rtl',
		'ms-loc' => 'aru',
		'ms-cp' => 'CP1256',
		'google-api' => true,
	),
	'ar_BH' => array (
		'country' => "Bahrain",
		'country-www' => 'bh',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/البحرين',
		'lang-www' => 'ar-BH',
		'dir' => 'rtl',
		'ms-loc' => 'arh',
		'ms-cp' => 'CP1256',
		'google-api' => true,
	),
	'ar_DZ' => array (
		'country' => "Algeria",
		'country-www' => 'dz',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/الجزائر',
		'lang-www' => 'ar-DZ',
		'dir' => 'rtl',
		'ms-loc' => 'arg',
		'ms-cp' => 'CP1256',
		'google-api' => true,
	),
	'ar_EG' => array (
		'country' => "Egypt",
		'country-www' => 'eg',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/مصر',
		'lang-www' => 'ar-EG',
		'dir' => 'rtl',
		'ms-loc' => 'are',
		'ms-cp' => 'CP1256',
		'google-api' => true,
	),
	'ar_IQ' => array (
		'country' => "Iraq",
		'country-www' => 'iq',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/العراق',
		'lang-www' => 'ar-IQ',
		'dir' => 'rtl',
		'ms-loc' => 'ari',
		'ms-cp' => 'CP1256',
		'google-api' => true,
	),
	'ar_JO' => array (
		'country' => "Jordan",
		'country-www' => 'jo',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/الأردن',
		'lang-www' => 'ar-JO',
		'dir' => 'rtl',
		'ms-loc' => 'arj',
		'ms-cp' => 'CP1256',
		'google-api' => true,
	),
	'ar_KW' => array (
		'country' => "Kuwait",
		'country-www' => 'kw',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/الكويت',
		'lang-www' => 'ar-KW',
		'dir' => 'rtl',
		'ms-loc' => 'ark',
		'ms-cp' => 'CP1256',
		'google-api' => true,
	),
	'ar_LB' => array (
		'country' => "Lebanon",
		'country-www' => 'lb',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/لبنان',
		'lang-www' => 'ar-LB',
		'dir' => 'rtl',
		'ms-loc' => 'arb',
		'ms-cp' => 'CP1256',
		'google-api' => true,
	),
	'ar_LY' => array (
		'country' => "Libya",
		'country-www' => 'ly',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/ليبيا',
		'lang-www' => 'ar-LY',
		'dir' => 'rtl',
		'ms-loc' => 'arl',
		'ms-cp' => 'CP1256',
		'google-api' => true,
	),
	'ar_MA' => array (
		'country' => "Morocco",
		'country-www' => 'ma',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/المغرب',
		'lang-www' => 'ar-MA',
		'dir' => 'rtl',
		'ms-loc' => 'arm',
		'ms-cp' => 'CP1256',
		'google-api' => true,
	),
	'ar_OM' => array (
		'country' => "Oman",
		'country-www' => 'om',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/سلطنة عمان',
		'lang-www' => 'ar-OM',
		'dir' => 'rtl',
		'ms-loc' => 'aro',
		'ms-cp' => 'CP1256',
		'google-api' => true,
	),
	'ar_QA' => array (
		'country' => "Qatar",
		'country-www' => 'qa',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/قطر',
		'lang-www' => 'ar-QA',
		'dir' => 'rtl',
		'ms-loc' => 'arq',
		'ms-cp' => 'CP1256',
		'google-api' => true,
	),
	'ar_SA' => array (
		'country' => "Saudi Arabia",
		'country-www' => 'sa',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/السعودية',
		'lang-www' => 'ar-SA',
		'dir' => 'rtl',
		'ms-loc' => 'ara',
		'ms-cp' => 'CP1256',
		'google-api' => true,
	),
	'ar_SY' => array (
		'country' => "Syria",
		'country-www' => 'sy',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/سوريا',
		'lang-www' => 'ar-SY',
		'dir' => 'rtl',
		'ms-loc' => 'ars',
		'ms-cp' => 'CP1256',
		'google-api' => true,
	),
	'ar_TN' => array (
		'country' => "Tunisia",
		'country-www' => 'tn',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/تونس',
		'lang-www' => 'ar-TN',
		'dir' => 'rtl',
		'ms-loc' => 'art',
		'ms-cp' => 'CP1256',
		'google-api' => true,
	),
	'ar_YE' => array (
		'country' => "Yemen",
		'country-www' => 'ye',
		'lang' => 'Arabic',
		'lang-native' => 'العربية/اليمن',
		'lang-www' => 'ar-YE',
		'dir' => 'rtl',
		'ms-loc' => 'ary',
		'ms-cp' => 'CP1256',
		'google-api' => true,
	),
	'az_AZ' => array (
		'country' => "Azerbaijan",
		'country-www' => 'az',
		'lang' => 'Azeri (Latin)',
		'lang-native' => 'Azərbaycan',
		'lang-www' => 'az-AZ',
		'dir' => 'ltr',
		'ms-loc' => 'aze',
		'ms-cp' => 'CP1254',
		'google-api' => true,
	),
	'be_BY' => array (
		'country' => "Belarus",
		'country-www' => 'by',
		'lang' => 'Belarusian',
		'lang-native' => 'Беларускі',
		'lang-www' => 'be-BY',
		'dir' => 'ltr',
		'ms-loc' => 'bel',
		'ms-cp' => 'CP1251',
		'google-api' => false,
	),
	'bg_BG' => array (
		'country' => "Bulgaria",
		'country-www' => 'bg',
		'lang' => 'Bulgarian',
		'lang-native' => 'Български',
		'lang-www' => 'bg-BG',
		'dir' => 'ltr',
		'ms-loc' => 'bgr',
		'ms-cp' => 'CP1251',
		'google-api' => true,
	),
	'by_BY' => array (
		'country' => "Belarus",
		'country-www' => 'by',
		'lang' => 'Belarusian',
		'lang-native' => 'Беларускі',
		'lang-www' => 'by-BY',
		'dir' => 'ltr',
		'ms-loc' => 'bel',
		'ms-cp' => 'CP1251',
		'google-api' => false,
	),
	'ca_ES' => array (
		'country' => "Spain",
		'country-www' => 'es',
		'lang' => 'Catalan',
		'lang-native' => 'Сatalà/Espanya',
		'lang-www' => 'ca-ES',
		'dir' => 'ltr',
		'ms-loc' => 'cat',
		'ms-cp' => 'CP1252',
		'google-api' => false,
	),
	'cs_CZ' => array (
		'country' => "Czech Republic",
		'country-www' => 'cz',
		'lang' => 'Czech',
		'lang-native' => 'Čeština',
		'lang-www' => 'cs-CZ',
		'dir' => 'ltr',
		'ms-loc' => 'csy',
		'ms-cp' => 'CP1250',
		'google-api' => true,
	),
	'da_DK' => array (
		'country' => "Denmark",
		'country-www' => 'dk',
		'lang' => 'Danish',
		'lang-native' => 'Dansk',
		'lang-www' => 'da-DK',
		'dir' => 'ltr',
		'ms-loc' => 'dan',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'de_AT' => array (
		'country' => "Austria",
		'country-www' => 'at',
		'lang' => 'German',
		'lang-native' => 'Deutsch/Österreich',
		'lang-www' => 'de-AT',
		'dir' => 'ltr',
		'ms-loc' => 'dea',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'de_CH' => array (
		'country' => "Switzerland",
		'country-www' => 'ch',
		'lang' => 'German',
		'lang-native' => 'Deutsch/Schweiz',
		'lang-www' => 'de-CH',
		'dir' => 'ltr',
		'ms-loc' => 'des',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'de_DE' => array (
		'country' => "Germany",
		'country-www' => 'de',
		'lang' => 'German',
		'lang-native' => 'Deutsch/Deutschland',
		'lang-www' => 'de-DE',
		'dir' => 'ltr',
		'ms-loc' => 'deu',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'de_LU' => array (
		'country' => "Luxembourg",
		'country-www' => 'lu',
		'lang' => 'German',
		'lang-native' => 'Deutsch/Luxemburg',
		'lang-www' => 'de-LU',
		'dir' => 'ltr',
		'ms-loc' => 'del',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'el_CY' => array (
		'country' => "Greece",
		'country-www' => 'cy',
		'lang' => 'Greek',
		'lang-native' => 'Ελληνικά/Κύπρος',
		'lang-www' => 'el-CY',
		'dir' => 'ltr',
		'ms-loc' => 'ell',
		'ms-cp' => 'CP1253',
		'google-api' => true,
	),
	'el_GR' => array (
		'country' => "Greece",
		'country-www' => 'gr',
		'lang' => 'Greek',
		'lang-native' => 'Ελληνικά/Ελλάδα',
		'lang-www' => 'el-GR',
		'dir' => 'ltr',
		'ms-loc' => 'ell',
		'ms-cp' => 'CP1253',
		'google-api' => true,
	),
	'el_EL' => array (
		'country' => "Greece",
		'country-www' => 'el',
		'lang' => 'Greek',
		'lang-native' => 'Ελληνικά/Ελλάδα',
		'lang-www' => 'el-EL',
		'dir' => 'ltr',
		'ms-loc' => 'ell',
		'ms-cp' => 'CP1253',
		'google-api' => true,
	),
	'en_AU' => array (
		'country' => "Australia",
		'country-www' => 'au',
		'lang' => 'English',
		'lang-native' => 'English/Australia',
		'lang-www' => 'en-AU',
		'dir' => 'ltr',
		'ms-loc' => 'ena',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'en_CA' => array (
		'country' => "Canada",
		'country-www' => 'ca',
		'lang' => 'English',
		'lang-native' => 'English/Canada',
		'lang-www' => 'en-CA',
		'dir' => 'ltr',
		'ms-loc' => 'enc',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'en_GB' => array (
		'country' => "United Kingdom",
		'country-www' => 'gb',
		'lang' => 'English',
		'lang-native' => 'English/United Kingdom',
		'lang-www' => 'en-GB',
		'dir' => 'ltr',
		'ms-loc' => 'eng',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'en_IE' => array (
		'country' => "Ireland",
		'country-www' => 'ie',
		'lang' => 'English',
		'lang-native' => 'English/Ireland',
		'lang-www' => 'en-IE',
		'dir' => 'ltr',
		'ms-loc' => 'eni',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'en_NZ' => array (
		'country' => "New Zealand",
		'country-www' => 'nz',
		'lang' => 'English',
		'lang-native' => 'English/New Zealand',
		'lang-www' => 'en-NZ',
		'dir' => 'ltr',
		'ms-loc' => 'enz',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'en_PH' => array (
		'country' => "Republic of the Philippines",
		'country-www' => 'ph',
		'lang' => 'English',
		'lang-native' => 'English/Philippines',
		'lang-www' => 'en-PH',
		'dir' => 'ltr',
		'ms-loc' => 'enp',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'en_US' => array (
		'country' => "United States",
		'country-www' => 'us',
		'lang' => 'English',
		'lang-native' => 'English/United States',
		'lang-www' => 'en-US',
		'dir' => 'ltr',
		'ms-loc' => 'enu',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'en_ZA' => array (
		'country' => "South Africa",
		'country-www' => 'za',
		'lang' => 'English',
		'lang-native' => 'English/South Africa',
		'lang-www' => 'en-ZA',
		'dir' => 'ltr',
		'ms-loc' => 'ens',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'eo_EO' => array (
		'country' => "-n.a.-",
		'country-www' => 'eo',
		'lang' => 'Esperanto',
		'lang-native' => 'Esperanto',
		'lang-www' => 'eo-EO',
		'dir' => 'ltr',
		'ms-loc' => 'enu',
		'ms-cp' => 'CP1252',
		'google-api' => false,
	),	
	'es_AR' => array (
		'country' => "Argentina",
		'country-www' => 'ar',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Argentina',
		'lang-www' => 'es-AR',
		'dir' => 'ltr',
		'ms-loc' => 'ess',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'es_BO' => array (
		'country' => "Bolivia",
		'country-www' => 'bo',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Bolivia',
		'lang-www' => 'es-BO',
		'dir' => 'ltr',
		'ms-loc' => 'esb',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'es_CL' => array (
		'country' => "Chile",
		'country-www' => 'cl',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Chile',
		'lang-www' => 'es-CL',
		'dir' => 'ltr',
		'ms-loc' => 'esl',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'es_CO' => array (
		'country' => "Colombia",
		'country-www' => 'co',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Colombia',
		'lang-www' => 'es-CO',
		'dir' => 'ltr',
		'ms-loc' => 'eso',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'es_CR' => array (
		'country' => "Costa Rica",
		'country-www' => 'cr',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Costa Rica',
		'lang-www' => 'es-CR',
		'dir' => 'ltr',
		'ms-loc' => 'esc',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'es_DO' => array (
		'country' => "Dominican Republic",
		'country-www' => 'do',
		'lang' => 'Spanish',
		'lang-native' => 'Español/República Dominicana',
		'lang-www' => 'es-DO',
		'dir' => 'ltr',
		'ms-loc' => 'esd',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'es_EC' => array (
		'country' => "Ecuador",
		'country-www' => 'ec',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Ecuador',
		'lang-www' => 'es-EC',
		'dir' => 'ltr',
		'ms-loc' => 'esf',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'es_ES' => array (
		'country' => "Spain",
		'country-www' => 'es',
		'lang' => 'Spanish',
		'lang-native' => 'Español/España',
		'lang-www' => 'es-ES',
		'dir' => 'ltr',
		'ms-loc' => 'esp',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'es_GT' => array (
		'country' => "Guatemala",
		'country-www' => 'gt',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Guatemala',
		'lang-www' => 'es-GT',
		'dir' => 'ltr',
		'ms-loc' => 'esg',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'es_HN' => array (
		'country' => "Honduras",
		'country-www' => 'hn',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Honduras',
		'lang-www' => 'es-HN',
		'dir' => 'ltr',
		'ms-loc' => 'esh',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'es_MX' => array (
		'country' => "Mexico",
		'country-www' => 'mx',
		'lang' => 'Spanish',
		'lang-native' => 'Español/México',
		'lang-www' => 'es-MX',
		'dir' => 'ltr',
		'ms-loc' => 'esm',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'es_NI' => array (
		'country' => "Nicaragua",
		'country-www' => 'ni',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Nicaragua',
		'lang-www' => 'es-NI',
		'dir' => 'ltr',
		'ms-loc' => 'esi',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'es_PA' => array (
		'country' => "Panama",
		'country-www' => 'pa',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Panamá',
		'lang-www' => 'es-PA',
		'dir' => 'ltr',
		'ms-loc' => 'esa',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'es_PE' => array (
		'country' => "Peru",
		'country-www' => 'pe',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Perú',
		'lang-www' => 'es-PE',
		'dir' => 'ltr',
		'ms-loc' => 'esr',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'es_PR' => array (
		'country' => "Puerto Rico",
		'country-www' => 'pr',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Puerto Rico',
		'lang-www' => 'es-PR',
		'dir' => 'ltr',
		'ms-loc' => 'esu',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'es_PY' => array (
		'country' => "Paraguay",
		'country-www' => 'py',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Paraguay',
		'lang-www' => 'es-PY',
		'dir' => 'ltr',
		'ms-loc' => 'esz',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'es_SV' => array (
		'country' => "El Salvador",
		'country-www' => 'sv',
		'lang' => 'Spanish',
		'lang-native' => 'Español/El Salvador',
		'lang-www' => 'es-SV',
		'dir' => 'ltr',
		'ms-loc' => 'ese',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'es_UY' => array (
		'country' => "Uruguay",
		'country-www' => 'uy',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Uruguay',
		'lang-www' => 'es-UY',
		'dir' => 'ltr',
		'ms-loc' => 'esy',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'es_VE' => array (
		'country' => "Venezuela",
		'country-www' => 've',
		'lang' => 'Spanish',
		'lang-native' => 'Español/Venezuela',
		'lang-www' => 'es-VE',
		'dir' => 'ltr',
		'ms-loc' => 'esv',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'et_EE' => array (
		'country' => "Estonia",
		'country-www' => 'ee',
		'lang' => 'Estonian',
		'lang-native' => 'Eesti/Eesti',
		'lang-www' => 'et-EE',
		'dir' => 'ltr',
		'ms-loc' => 'eti',
		'ms-cp' => 'CP1257',
		'google-api' => false,
	),
	'eu_ES' => array (
		'country' => "Basque",
		'country-www' => 'eu',
		'lang' => 'Basque',
		'lang-native' => 'Euskara/Basque',
		'lang-www' => 'eu-ES',
		'dir' => 'ltr',
		'ms-loc' => 'eh',
		'ms-cp' => 'CP1257',
		'google-api' => false,
	),
	'fa_IR' => array (
		'country' => "Iran",
		'country-www' => 'ir',
		'lang' => 'Farsi',
		'lang-native' => 'فارسی',
		'lang-www' => 'fa-IR',
		'dir' => 'rtl',
		'ms-loc' => 'far',
		'ms-cp' => 'CP1252',
		'google-api' => false,
	),
	'fi_FI' => array (
		'country' => "Finland",
		'country-www' => 'fi',
		'lang' => 'Finnish',
		'lang-native' => 'Suomi',
		'lang-www' => 'fi-FI',
		'dir' => 'ltr',
		'ms-loc' => 'fin',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'fo_FO' => array (
		'country' => "Faroe Islands",
		'country-www' => 'fo',
		'lang' => 'Faroese',
		'lang-native' => 'Føroyskt',
		'lang-www' => 'fo-FO',
		'dir' => 'ltr',
		'ms-loc' => 'fos',
		'ms-cp' => 'CP1252',
		'google-api' => false,
	),
	'fr_BE' => array (
		'country' => "Belgium",
		'country-www' => 'be',
		'lang' => 'French',
		'lang-native' => 'Français/Belgique',
		'lang-www' => 'fr-BE',
		'dir' => 'ltr',
		'ms-loc' => 'frb',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'fr_CA' => array (
		'country' => "Canada",
		'country-www' => 'ca',
		'lang' => 'French',
		'lang-native' => 'Français/Canada',
		'lang-www' => 'fr-CA',
		'dir' => 'ltr',
		'ms-loc' => 'frc',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'fr_CH' => array (
		'country' => "Switzerland",
		'country-www' => 'ch',
		'lang' => 'French',
		'lang-native' => 'Français/Suisse',
		'lang-www' => 'fr-CH',
		'dir' => 'ltr',
		'ms-loc' => 'frs',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'fr_FR' => array (
		'country' => "France",
		'country-www' => 'fr',
		'lang' => 'French',
		'lang-native' => 'Français/France',
		'lang-www' => 'fr-FR',
		'dir' => 'ltr',
		'ms-loc' => 'fra',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'fr_LU' => array (
		'country' => "Luxembourg",
		'country-www' => 'lu',
		'lang' => 'French',
		'lang-native' => 'Français/Luxembourg',
		'lang-www' => 'fr-LU',
		'dir' => 'ltr',
		'ms-loc' => 'frl',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'fy_NL' => array (
		'country' => "Netherlands",
		'country-www' => 'nl',
		'lang' => 'Frisian',
		'lang-native' => 'Frysk',
		'lang-www' => 'fy-NL',
		'dir' => 'ltr',
		'ms-loc' => 'fyn',
		'ms-cp' => 'CP1252',
		'google-api' => false,
	),
	'ga_IE' => array (
		'country' => "Ireland",
		'country-www' => 'ie',
		'lang' => 'Irish',
		'lang-native' => 'Gaeilge/Éire',
		'lang-www' => 'ga-IE',
		'dir' => 'ltr',
		'ms-loc' => 'ire',
		'ms-cp' => 'CP1252',
		'google-api' => false,
	),
	'gl_ES' => array (
		'country' => "Spain",
		'country-www' => 'es',
		'lang' => 'Galician',
		'lang-native' => 'Galician/Galicia',
		'lang-www' => 'gl-ES',
		'dir' => 'ltr',
		'ms-loc' => 'esp',
		'ms-cp' => 'CP1252',
		'google-api' => true,		
	),	
	'he_IL' => array (
		'country' => "Israel",
		'country-www' => 'il',
		'lang' => 'Hebrew',
		'lang-native' => 'עברית',
		'lang-www' => 'he-IL',
		'dir' => 'rtl',
		'ms-loc' => 'heb',
		'ms-cp' => 'CP1255',
		'google-api' => false,
	),
	'hi_IN' => array (
		'country' => "India",
		'country-www' => 'in',
		'lang' => 'Hindi',
		'lang-native' => 'हिन्दी',
		'lang-www' => 'hi-IN',
		'dir' => 'ltr',
		'ms-loc' => 'hin',
		'ms-cp' => 'CP1255',
		'google-api' => false,
	),
	'hr_HR' => array (
		'country' => "Croatia",
		'country-www' => 'hr',
		'lang' => 'Croatian',
		'lang-native' => 'Hrvatski',
		'lang-www' => 'hr-HR',
		'dir' => 'ltr',
		'ms-loc' => 'hrv',
		'ms-cp' => 'CP1250',
		'google-api' => true,
	),
	'hu_HU' => array (
		'country' => "Hungary",
		'country-www' => 'hu',
		'lang' => 'Hungarian',
		'lang-native' => 'Magyar',
		'lang-www' => 'hu-HU',
		'dir' => 'ltr',
		'ms-loc' => 'hun',
		'ms-cp' => 'CP1250',
		'google-api' => false,
	),
	'id_ID' => array (
		'country' => "Indonesia",
		'country-www' => 'id',
		'lang' => 'Indonesian',
		'lang-native' => 'Bahasa Indonesia',
		'lang-www' => 'id-ID',
		'dir' => 'ltr',
		'ms-loc' => 'ind',
		'ms-cp' => 'CP1252',
		'google-api' => false,
	),
	'in_ID' => array (
		'country' => "Indonesia",
		'country-www' => 'id',
		'lang' => 'Indonesian',
		'lang-native' => 'Bahasa Indonesia/Indonesia',
		'lang-www' => 'in-ID',
		'dir' => 'ltr',
		'ms-loc' => 'ind',
		'ms-cp' => 'CP1252',
		'google-api' => false,
	),
	'is_IS' => array (
		'country' => "Iceland",
		'country-www' => 'is',
		'lang' => 'Icelandic',
		'lang-native' => 'Íslenska/Ísland',
		'lang-www' => 'is-IS',
		'dir' => 'ltr',
		'ms-loc' => 'isl',
		'ms-cp' => 'CP1252',
		'google-api' => false,
	),
	'it_CH' => array (
		'country' => "Switzerland",
		'country-www' => 'ch',
		'lang' => 'Italian',
		'lang-native' => 'Italiano/Svizzera',
		'lang-www' => 'it-CH',
		'dir' => 'ltr',
		'ms-loc' => 'its',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'it_IT' => array (
		'country' => "Italy",
		'country-www' => 'it',
		'lang' => 'Italian',
		'lang-native' => 'Italiano/Italia',
		'lang-www' => 'it-IT',
		'dir' => 'ltr',
		'ms-loc' => 'ita',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'ja_JP' => array (
		'country' => "Japan",
		'country-www' => 'jp',
		'lang' => 'Japanese',
		'lang-native' => '日本語',
		'lang-www' => 'ja-JP',
		'dir' => 'ltr',
		'ms-loc' => 'jpn',
		'ms-cp' => 'CP932',
		'google-api' => true,
	),
	'kk_KK' => array (
		'country' => "Kazakhstan",
		'country-www' => 'kk',
		'lang' => 'Kazakh',
		'lang-native' => 'Қазақша',
		'lang-www' => 'kk-KK',
		'dir' => 'ltr',
		'ms-loc' => 'kkz',
		'ms-cp' => 'CP1251',
		'google-api' => false,
	),
	'ko_KR' => array (
		'country' => "Korea",
		'country-www' => 'kr',
		'lang' => 'Korean',
		'lang-native' => '한국어',
		'lang-www' => 'ko-KR',
		'dir' => 'ltr',
		'ms-loc' => 'kor',
		'ms-cp' => 'CP949',
		'google-api' => true,
	),
	'ky_KY' => array (
		'country' => "Kyrgyzstan",
		'country-www' => 'ky',
		'lang' => 'Kyrgyz',
		'lang-native' => 'Кыргызча',
		'lang-www' => 'ky-KY',
		'dir' => 'ltr',
		'ms-loc' => 'kyr',
		'ms-cp' => 'CP1251',
		'google-api' => false,
	),
	'lb_LB' => array (
		'country' => "Luxembourg",
		'country-www' => 'lb',
		'lang' => 'Luxembourgish',
		'lang-native' => 'Lëtzebuergesch',
		'lang-www' => 'lb-LB',
		'dir' => 'ltr',
		'ms-loc' => 'lbx',
		'ms-cp' => 'CP1252',
		'google-api' => false,
	),
	'lt_LT' => array (
		'country' => "Lithuania",
		'country-www' => 'lt',
		'lang' => 'Lithuanian',
		'lang-native' => 'Lietuvių/Lietuva',
		'lang-www' => 'lt-LT',
		'dir' => 'ltr',
		'ms-loc' => 'lth',
		'ms-cp' => 'CP1257',
		'google-api' => false,
	),
	'lv_LV' => array (
		'country' => "Latvia",
		'country-www' => 'lv',
		'lang' => 'Latvian',
		'lang-native' => 'Latviešu/Latvija',
		'lang-www' => 'lv-LV',
		'dir' => 'ltr',
		'ms-loc' => 'lvi',
		'ms-cp' => 'CP1257',
		'google-api' => false,
	),
	'mk_MK' => array (
		'country' => "Former Yugoslav Republic of Macedonia",
		'country-www' => 'mk',
		'lang' => 'FYRO Macedonian',
		'lang-native' => 'Македонски/Македонија',
		'lang-www' => 'mk-MK',
		'dir' => 'ltr',
		'ms-loc' => 'mki',
		'ms-cp' => 'CP1251',
		'google-api' => false,
	),
	'nb_NB' => array (
		'country' => "Norway",
		'country-www' => 'no',
		'lang' => 'Norwegian (Bokmal)',
		'lang-native' => '‪Norsk Bokmål‬',
		'lang-www' => 'nb-NB',
		'dir' => 'ltr',
		'ms-loc' => 'nor',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'nb_NO' => array (
		'country' => "Norway",
		'country-www' => 'no',
		'lang' => 'Norwegian (Bokmal)',
		'lang-native' => '‪Norsk Bokmål‬',
		'lang-www' => 'nb-NO',
		'dir' => 'ltr',
		'ms-loc' => 'nor',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'nl_BE' => array (
		'country' => "Belgium",
		'country-www' => 'be',
		'lang' => 'Dutch',
		'lang-native' => 'Nederlands / België',
		'lang-www' => 'nl-BE',
		'dir' => 'ltr',
		'ms-loc' => 'nlb',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'nl_NL' => array (
		'country' => "Netherlands",
		'country-www' => 'nl',
		'lang' => 'Dutch',
		'lang-native' => 'Nederlands / Nederland',
		'lang-www' => 'nl-NL',
		'dir' => 'ltr',
		'ms-loc' => 'nld',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'nn_NN' => array (
		'country' => "Norway",
		'country-www' => 'nn',
		'lang' => 'Norwegian-Nynorsk',
		'lang-native' => 'Norsk / Nynorsk',
		'lang-www' => 'nn-NN',
		'dir' => 'ltr',
		'ms-loc' => 'non',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'no_NO' => array (
		'country' => "Norway",
		'country-www' => 'no',
		'lang' => 'Norwegian-Nynorsk',
		'lang-native' => 'Norsk / Norge',
		'lang-www' => 'no-NO',
		'dir' => 'ltr',
		'ms-loc' => 'non',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'pl_PL' => array (
		'country' => "Poland",
		'country-www' => 'pl',
		'lang' => 'Polish',
		'lang-native' => 'Polski/Polska',
		'lang-www' => 'pl-PL',
		'dir' => 'ltr',
		'ms-loc' => 'plk',
		'ms-cp' => 'CP1250',
		'google-api' => true,
	),
	'pt_BR' => array (
		'country' => "Brazil",
		'country-www' => 'br',
		'lang' => 'Portuguese',
		'lang-native' => 'Português/Brasil',
		'lang-www' => 'pt-BR',
		'dir' => 'ltr',
		'ms-loc' => 'ptb',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'pt_PT' => array (
		'country' => "Portugal",
		'country-www' => 'pt',
		'lang' => 'Portuguese',
		'lang-native' => 'Português/Portugal',
		'lang-www' => 'pt-PT',
		'dir' => 'ltr',
		'ms-loc' => 'ptg',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'ro_RO' => array (
		'country' => "Romania",
		'country-www' => 'ro',
		'lang' => 'Romanian',
		'lang-native' => 'Română/România',
		'lang-www' => 'ro-RO',
		'dir' => 'ltr',
		'ms-loc' => 'rom',
		'ms-cp' => 'CP1250',
		'google-api' => true,
	),
	'ru_RU' => array (
		'country' => "Russia",
		'country-www' => 'ru',
		'lang' => 'Russian',
		'lang-native' => 'Русский/Россия',
		'lang-www' => 'ru-RU',
		'dir' => 'ltr',
		'ms-loc' => 'rus',
		'ms-cp' => 'CP1251',
		'google-api' => true,
	),
	'sk_SK' => array (
		'country' => "Slovakia",
		'country-www' => 'sk',
		'lang' => 'Slovak',
		'lang-native' => 'Slovenčina/Slovenská republika',
		'lang-www' => 'sk-SK',
		'dir' => 'ltr',
		'ms-loc' => 'sky',
		'ms-cp' => 'CP1250',
		'google-api' => false,
	),
	'sl_SI' => array (
		'country' => "Slovenia",
		'country-www' => 'si',
		'lang' => 'Slovenian',
		'lang-native' => 'Slovenščina/Slovenija',
		'lang-www' => 'sl-SI',
		'dir' => 'ltr',
		'ms-loc' => 'slv',
		'ms-cp' => 'CP1250',
		'google-api' => false,
	),
	'sq_AL' => array (
	   'country' => "Albania",
	   'country-www' => 'al',
	   'lang' => 'Albanian',
	   'lang-native' => 'Shqip',
	   'lang-www' => 'sq-AL',
	   'dir' => 'ltr',
	   'ms-loc' => 'sqi',
	   'ms-cp' => 'CP1250',
	   'google-api' => true,
    ),
	'sr_BA' => array (
		'country' => "Bosnia and Herzegovina",
		'country-www' => 'ba',
		'lang' => 'Serbian (Cyrillic)',
		'lang-native' => 'Српски/Босна и Херцеговина',
		'lang-www' => 'sr-BA',
		'dir' => 'ltr',
		'ms-loc' => 'srn',
		'ms-cp' => 'CP1251',
		'google-api' => false,
	),
	'sr_CS' => array (
		'country' => "Serbia and Montenegro",
		'country-www' => 'cs',
		'lang' => 'Serbian (Cyrillic)',
		'lang-native' => 'Српски/Србија и Црна Гора',
		'lang-www' => 'sr-CS',
		'dir' => 'ltr',
		'ms-loc' => 'srb',
		'ms-cp' => 'CP1251',
		'google-api' => false,
	),
	'sr_RS' => array (
		'country' => "Serbia",
		'country-www' => 'rs',
		'lang' => 'Serbian',
		'lang-native' => 'Srpski/Srbija',
		'lang-www' => 'sr-RS',
		'dir' => 'ltr',
		'ms-loc' => 'srb',
		'ms-cp' => 'CP1251',
		'google-api' => false,
	),
	'sv_SE' => array (
		'country' => "Sweden",
		'country-www' => 'se',
		'lang' => 'Swedish',
		'lang-native' => 'Svenska/Sverige',
		'lang-www' => 'sv-SE',
		'dir' => 'ltr',
		'ms-loc' => 'sve',
		'ms-cp' => 'CP1252',
		'google-api' => true,
	),
	'th_TH' => array (
		'country' => "Thailand",
		'country-www' => 'th',
		'lang' => 'Thai',
		'lang-native' => 'ไทย/ประเทศไทย',
		'lang-www' => 'th-TH',
		'dir' => 'ltr',
		'ms-loc' => 'tha',
		'ms-cp' => 'CP874',
		'google-api' => false,
	),
	'tl_PH' => array (
		'country' => "Philippines",
		'country-www' => 'ph',
		'lang' => 'Tagalog',
		'lang-native' => 'Tagalog/Philippines',
		'lang-www' => 'tl-PH',
		'dir' => 'ltr',
		'ms-loc' => '',
		'ms-cp' => '',
		'google-api' => false,
	),
	'tr_TR' => array (
		'country' => "Turkey",
		'country-www' => 'tr',
		'lang' => 'Turkish',
		'lang-native' => 'Türkçe',
		'lang-www' => 'tr-TR',
		'dir' => 'ltr',
		'ms-loc' => 'trk',
		'ms-cp' => 'CP1254',
		'google-api' => false,
	),
	'uk_UA' => array (
		'country' => "Ukraine",
		'country-www' => 'ua',
		'lang' => 'Ukrainian',
		'lang-native' => 'Українська',
		'lang-www' => 'uk-UA',
		'dir' => 'ltr',
		'ms-loc' => 'ukr',
		'ms-cp' => 'CP1251',
		'google-api' => false,
	),
	'vi_VN' => array (
		'country' => "Viet Nam",
		'country-www' => 'vn',
		'lang' => 'Vietnamese',
		'lang-native' => 'Tiếng Việt',
		'lang-www' => 'vi-VN',
		'dir' => 'ltr',
		'ms-loc' => 'vit',
		'ms-cp' => 'CP1258',
		'google-api' => false,
	),
	'xh_XH' => array (
		'country' => "South Africa",
		'country-www' => 'xh',
		'lang' => 'Xhosa',
		'lang-native' => 'isiXhosa',
		'lang-www' => 'xh-XH',
		'dir' => 'ltr',
		'ms-loc' => 'xho',
		'ms-cp' => 'CP1252',
		'google-api' => false,
	),
	'zh_CN' => array (
		'country' => "People's Republic of China",
		'country-www' => 'cn',
		'lang' => 'Chinese',
		'lang-native' => '中文(中华人民共和国)',
		'lang-www' => 'zh-CN',
		'dir' => 'ltr',
		'ms-loc' => 'chs',
		'ms-cp' => 'CP936',
		'google-api' => true,
	),
	'zh_MO' => array (
		'country' => "Macau S.A.R.",
		'country-www' => 'mo',
		'lang' => 'Chinese',
		'lang-native' => '中文(澳門特别行政區)',
		'lang-www' => 'zh-MO',
		'dir' => 'ltr',
		'ms-loc' => 'zhm',
		'ms-cp' => 'CP950',
		'google-api' => true,
	),
	'zh_HK' => array (
		'country' => "Hong Kong S.A.R.",
		'country-www' => 'hk',
		'lang' => 'Chinese',
		'lang-native' => '中文(香港特别行政區)',
		'lang-www' => 'zh-HK',
		'dir' => 'ltr',
		'ms-loc' => 'zhh',
		'ms-cp' => 'CP950',
		'google-api' => true,
	),
	'zh_SG' => array (
		'country' => "Singapore",
		'country-www' => 'sg',
		'lang' => 'Chinese',
		'lang-native' => '中文(新加坡)',
		'lang-www' => 'zh-SG',
		'dir' => 'ltr',
		'ms-loc' => 'zhi',
		'ms-cp' => 'CP936',
		'google-api' => true,
	),
	'zh_TW' => array (
		'country' => "Taiwan",
		'country-www' => 'tw',
		'lang' => 'Chinese',
		'lang-native' => '中文(台灣)',
		'lang-www' => 'zh-TW',
		'dir' => 'ltr',
		'ms-loc' => 'cht',
		'ms-cp' => 'CP950',
		'google-api' => true,
	),
	'zu_ZU' => array (
		'country' => "South Africa",
		'country-www' => 'zu',
		'lang' => 'Zulu',
		'lang-native' => 'isiZulu',
		'lang-www' => 'zu-ZU',
		'dir' => 'ltr',
		'ms-loc' => 'zul',
		'ms-cp' => 'CP1252',
		'google-api' => false,
	),
);
?>