<?php

/*
Plugin Name: WangGuard
Plugin URI: http://www.wangguard.com
Description: <strong>Stop Sploggers</strong>. It is very important to use <a href="http://www.wangguard.com" target="_new">WangGuard</a> at least for a week, reporting your site's unwanted users as sploggers from the Users panel. WangGuard will learn at that time to protect your site from sploggers in a much more effective way. WangGuard protects each web site in a personalized way using information provided by Administrators who report sploggers world-wide, that's why it's very important that you report your sploggers to WangGuard. The longer you use WangGuard, the more effective it will become.
Version: 1.6-RC4
Author: WangGuard
Author URI: http://www.wangguard.com
License: GPL2
*/	

/*  Copyright 2010  WangGuard (email : admin@wangguard.com)
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as
    published by the Free Software Foundation.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

	define('WANGGUARD_VERSION', '1.6-RC4');
	define('WANGGUARD_PLUGIN_FILE', 'wangguard/wangguard-admin.php');
	define('WANGGUARD_README_URL', 'http://plugins.trac.wordpress.org/browser/wangguard/trunk/readme.txt?format=txt');
	define('WANGGUARD_API_HOST', 'rest.wangguard.com');
	define('WANGGUARD_REST_PATH', '/');
	define('WANGGUARD_API_PORT', '80');
	
	
	// Debug WangGuard
	//error_reporting(E_ALL);
	//ini_set("display_errors", 1);
	
	//Which file are we are getting called from?
	$wuangguard_parent = basename($_SERVER['SCRIPT_NAME']);
	$wangguard_is_network_admin = function_exists("is_multisite") && function_exists( 'is_network_admin' );
	
	if ($wangguard_is_network_admin)$wangguard_is_network_admin = is_multisite();
	include_once 'wangguard-xml.php';
	include_once 'wangguard-core.php';
	$wangguard_api_key = get_site_option('wangguard_api_key');
	$wangguard_cronjob_run_options = array("daily"=> __('Once a day', 'wangguard'),"wangguard_3days"=> __('Every 3 days', 'wangguard'),"wangguard_5days"=> __('Every 5 days', 'wangguard'),"wangguard_weekly"=> __('Weekly', 'wangguard'),"wangguard_2weeks"=> __('Two Weeks', 'wangguard'));
	$wangguard_cronjob_actions_options = array("f"=>__('Flag detected Sploggers as Sploggers and Spam users', 'wangguard') ,"d"=>__('Delete detected Sploggers', 'wangguard'));
	$wangguard_cronjob_lookup_options = array("7"=>__('Week', 'wangguard') ,"5"=>__('5 days', 'wangguard'),"3"=>__('3 days', 'wangguard'),"1"=>__('1 day', 'wangguard'));
	/********************************************************************/	
	/*** CONFIG BEGINS ***/	
	/********************************************************************/
	include_once 'wangguard-conf.php';
	include_once 'wangguard-queue.php';
	include_once 'wangguard-wizard.php';
	include_once 'wangguard-cronjobs.php';
	include_once 'wangguard-stats.php';
	include_once 'wangguard-users.php';
	include_once 'wangguard-user-info.php';
	include_once 'wangguard-help.php';
	include_once 'wangguard-about.php';
	include_once 'wangguard-compatible-plugins.php';
	include_once 'wangguard-addons.php';
	/********************************************************************/	
	/*** CONFIG ENDS ***/	
	/********************************************************************/
	
	/********************************************************************/	
	/*** ADD & VALIDATE SECURITY QUESTIONS ON REGISTER BEGINS ***/	
	/********************************************************************/	
	
	// for wp regular
	if ( get_site_option("wangguard-add-honeypot")=='1') {
				add_action('register_form','wangguard_add_hfield_1' , rand(1,10));
				add_action('register_form','wangguard_add_hfield_2' , rand(1,10));
				add_action('register_form','wangguard_add_hfield_3' , rand(1,10));
				add_action('register_form','wangguard_add_hfield_4' , rand(1,10));

				}
	add_action('register_form','wangguard_register_add_question');
	add_action('register_post','wangguard_signup_validate',10,3);
	
	// for WooCommerce
	include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	
	if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
		add_action('woocommerce_after_checkout_validation','wangguard_plugin_woocommerce_checkout_signup');
	}
	$wangguard_add_mu_filter_actions = true;
	//Calling to functions for BuddyPress
	
	function wangguard_buddypress_init() {
		require( dirname( __FILE__ ) . '/wangguard-buddypress.php' );
		}
	add_action( 'bp_include', 'wangguard_buddypress_init' );
       // if (has_action( 'bp_include', 'wangguard_buddypress_init' ) ) $wangguard_add_mu_filter_actions = false;
		// for wpmu and (buddypress versions before 1.1)
		if ( defined( 'BP_VERSION' ) ) $wangguard_add_mu_filter_actions = false;
		if($wangguard_add_mu_filter_actions){
		if ( get_site_option("wangguard-add-honeypot")=='1') {
				add_action('signup_extra_fields','wangguard_add_hfield_1' , rand(1,10));
				add_action('signup_extra_fields','wangguard_add_hfield_2' , rand(1,10));
				add_action('signup_extra_fields','wangguard_add_hfield_3' , rand(1,10));
				add_action('signup_extra_fields','wangguard_add_hfield_4' , rand(1,10));
			}
		add_action('signup_extra_fields', 'wangguard_register_add_question_mu' );
		add_filter('wpmu_validate_user_signup', 'wangguard_wpmu_signup_validate_mu', 90);
		}
	/**
 * Checks MX record for an email domain's
 * 
 * @param type $email
 * @return boolean 
 */
	function wangguard_mx_record_is_ok($email) {
		//checks if an associated MX record is found on the server's DNS for the email domain
		//option is activated and getmxrr() function exists?
		$wangguard_mx_ok = function_exists('getmxrr');
		
		if ( !$wangguard_mx_ok || get_site_option("wangguard-verify-dns-mx")!='1')return true;
		$email = explode("@" , $email);
		
		if( count($email) != 2 )return true;
		$mxr = array();
		$ret = getmxrr($email[1] , $mxr);
		return $ret && count($mxr);
	}

	/**
 * Cleans username from an email address
 */
	function wangguard_get_clean_gmail_username($email) {
		//Cleans dots and + from gmail.com and googlemail.com addresses, lowercases the username and returns it. Returns false otherwise.
		$email = explode("@" , $email);
		
		if( count($email) != 2 )return false;
		$email[1] = strtolower($email[1]);
		
		if ( ($email[1]  ==  "gmail.com") || ($email[1]  ==  "googlemail.com") ) {
			$email[0] = str_replace(".", "" , $email[0]);
			//if the gmail address has a plus sign, remove from it to the end as gmail ignores that
			
			if ( strpos(  $email[0]  ,  "+") !== false) {
				$email[0] = substr($email[0] , 0 , strpos(  $email[0]  ,  "+"));
			}

			return strtolower($email[0]);
		} else return false;
	}

	/**
 * Checks wheter an alias of an email already exists
 * 
 * @global type $wpdb
 * @param type $email
 * @return boolean 
 */
	function wangguard_email_aliases_exists($email) {
		global $wpdb;
		//option is activated?
		
		if ( get_site_option("wangguard-verify-gmail")!='1')  return false;
		//cleans the email
		$guser = wangguard_get_clean_gmail_username($email);
		
		if ($guser !== false) {
			//if the email already exists, WP catches it, there's no need for WangGuard to check for aliases
			
			if (email_exists($email))return false;
			//get gmail.com and googlemail.com registered users
			$gmailaddresses = $wpdb->get_results("select user_email from {$wpdb->users}

		 where LOWER(user_email) LIKE '%@gmail.com' OR LOWER(user_email) LIKE '%@googlemail.com'");
		
		if (!empty ($gmailaddresses)) {
			foreach ($gmailaddresses as $r) {
				$existing = wangguard_get_clean_gmail_username($r->user_email);
				
				if ($existing == $guser)return true;
			}

		}

	}

	return false;
}
$wangguard_NonceHName = 'wangguard-hidden-field-check';
$wangguard_NonceFName = 'wangguard-hidden-display-check';
$wangguard_NoncePName = 'wangguard-hidden-position-check';
$wangguard_NonceCName = 'wangguard-hidden-check-check';
$wangguard_HPrefix = 'signup_';
$wangguard_FPrefix = 'newsignup_';
//$prefix = $wpdb->prefix;

/**
 * Get a random string
 */
function wangguard_randomstring($rndLen) {
	$chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
	$str = '';
	$strlen = strlen($chars);
	for ($i=0; $i < $rndLen; $i++){
		$str .= substr($chars, mt_rand(0, $strlen - 1), 1);
	}

	return $str;
}

function wangguard_add_hfield_1() {
	global $wangguard_NonceHName , $wangguard_HPrefix;
	$nonceAct = $wangguard_NonceHName;
	$nonceValue = wp_create_nonce( $nonceAct );
	$fieldID = wangguard_randomstring(mt_rand(6,10));
	$nonce_field = '<![if !IE]><input autocomplete="off" type="hidden" id="' . $fieldID . '" name="' . $wangguard_HPrefix . $nonceValue . '" value="" /><![endif]>';
	echo $nonce_field;
}

function wangguard_add_hfield_2() {
	global $wangguard_NonceFName , $wangguard_FPrefix;
	$style = wangguard_randomstring(mt_rand(6,10));
	$fieldID = wangguard_randomstring(mt_rand(6,10));
	echo '<![if !IE]><style type="text/css">.'.$style.' {visibility:hidden!important; display:none!important;}</style>';
	$nonceAct = $wangguard_NonceFName;
	$nonceValue = wp_create_nonce( $nonceAct );
	$nonce_field = '<div class="'.$style.'"><input autocomplete="off" type="text" id="' . $fieldID . '" name="' . $wangguard_FPrefix . $nonceValue . '" value="" /></div><![endif]>';
	echo $nonce_field;
}

function wangguard_add_hfield_3() {
	global $wangguard_NoncePName;
	$style = wangguard_randomstring(mt_rand(6,10));
	$fieldID = wangguard_randomstring(mt_rand(6,10));
	$cssStyle = 'visibility:hidden!important; display:none!important; position:absolute; top:-'.mt_rand(10000 , 20000).'px;';
	$question = wangguard_randomstring(mt_rand(6,10));
	$nonceAct = $wangguard_NoncePName;
	$nonceValue = wp_create_nonce( $nonceAct );
	$nonce_field = '<![if !IE]><div style="' .$cssStyle.'"><label for="'.$nonceValue.'">'.$question.'</label><br/><input autocomplete="off" tabindex="'.mt_rand(9999,99999).'" type="text" id="' . $fieldID . '" name="' . $nonceValue . '" value="" /></div><![endif]>';
	echo $nonce_field;
}

function wangguard_add_hfield_4() {
	global $wangguard_NonceCName;
	$style = wangguard_randomstring(mt_rand(6,10));
	$fieldID = wangguard_randomstring(mt_rand(6,10));
	echo '<![if !IE]><style type="text/css">.'.$style.' {visibility:hidden!important; display:none!important;}</style>';
	$nonceAct = $wangguard_NonceCName;
	$nonceValue = wp_create_nonce( $nonceAct );
	$nonce_field = '<div class="'.$style.'"><input autocomplete="off" type="text" value="" id="' . $fieldID . '" name="' . $nonceValue . '" /></div><![endif]>';
	echo $nonce_field;
}

/**
 * WangGuard nonce
 */
function wangguard_get_nonce_value($action) {
	$user = wp_get_current_user();
	$uid = (int) $user->ID;
	$i = wp_nonce_tick();
	return substr(wp_hash($i . $action . $uid, 'nonce'), -12, 10);
}

/**
 * Validates if there is suspicius activity on signup
 * 
 * @global string $wangguard_NonceHName
 * @global string $wangguard_HPrefix
 * @global string $wangguard_NonceFName
 * @global string $wangguard_FPrefix
 * @global string $wangguard_NoncePName
 * @global string $wangguard_NonceCName
 * @param type $userEmail
 * @return boolean 
 */
function wangguard_validate_hfields($userEmail) {
	global $wangguard_NonceHName , $wangguard_HPrefix;
	global $wangguard_NonceFName , $wangguard_FPrefix;
	global $wangguard_NoncePName;
	global $wangguard_NonceCName;
	
	$hNonce = wangguard_get_nonce_value($wangguard_NonceHName);
	$fNonce = wangguard_get_nonce_value($wangguard_NonceFName);
	$pNonce = wangguard_get_nonce_value($wangguard_NoncePName);
	$cNonce = wangguard_get_nonce_value($wangguard_NonceCName);
	$validated =  empty ($_POST[$wangguard_HPrefix.$hNonce]) &&empty ($_POST[$wangguard_FPrefix.$fNonce]) &&empty ($_POST[$pNonce]) &&empty ($_POST[$cNonce]);
	
	if (!$validated) {
		wangguard_report_email($userEmail , wangguard_getRemoteIP() , wangguard_getRemoteProxyIP() , true);
	}

	return $validated;
}

//*********** WPMU ***********
/**
 * Adds a security question if any exists
 * 
 * @global type $wpdb
 * @param type $errors 
 */
function wangguard_register_add_question_mu($errors) {
	global $wpdb;
	$table_name = $wpdb->base_prefix . "wangguardquestions";
	//Get one random question from the question table
	$qrs = $wpdb->get_row("select * from $table_name order by RAND() LIMIT 1");
	
	if (!is_null($qrs)) {
		$question = $qrs->Question;
		$questionID = $qrs->id;
		$html = '
			<label for="wangguardquestansw">' . $question . '</label>';
		echo $html;
		
		if ( $errmsg = $errors->get_error_message('wangguardquestansw') ) {
			echo '<p class="error">'.$errmsg.'</p>';
		}

		$html = '
			<input type="text" name="wangguardquestansw" id="wangguardquestansw" class="wangguard-mu-register-field" value="" maxlength="50" />
			<input type="hidden" name="wangguardquest" value="'.$questionID.'" />';
		echo $html;
	}

}

/**
 * Validates security question
 * 
 * @global type $wangguard_bp_validated
 * @param type $param
 * @return array
 */
function wangguard_wpmu_signup_validate_mu($result) {
	global $wangguard_bp_validated;
	
	if ( strpos($_SERVER['PHP_SELF'], 'wp-admin') !== false ) {
		return $result;
	}
	if ($_POST['signup_email']) return;
	if( $_POST['user_email'] ){$user_email = $_POST['user_email'];}else{$user_email=$user_email;}
		//$user_email = $_POST['user_email'];

	//BP1.1+ calls the new BP filter first (wangguard_signup_validate_bp11) and then the legacy MU filters (this one), if the BP new 1.1+ filter has been already called, silently return
	
	if ($wangguard_bp_validated)return $result;
	
	if (!wangguard_validate_hfields($user_email)) {
		$result['errors']->add('user_name',  __('<strong>ERROR</strong>: Banned by WangGuard <a href="http://www.wangguard.com/faq" target="_new">Is it an error?</a> Perhaps you tried to register many times.', 'wangguard'));
		return $result;
	}

	$answerOK = wangguard_question_repliedOK();
	//If at least a question exists on the questions table, then check the provided answer
	
	if (!$answerOK)    $result['errors']->add('wangguardquestansw',  __('<strong>ERROR</strong>: The answer to the security question is invalid.', 'wangguard')); else {
		//check domain against the list of selected blocked domains
		$blocked = wangguard_is_domain_blocked($user_email);
		
		if ($blocked) {
			$result['errors']->add('user_email',   __('<strong>ERROR</strong>: Domain not allowed.', 'wangguard'));
		} else {
			$reported = wangguard_is_email_reported_as_sp($user_email , wangguard_getRemoteIP() , wangguard_getRemoteProxyIP());
			
			if ($reported) $result['errors']->add('user_email',   __('<strong>ERROR</strong>: Banned by WangGuard <a href="http://www.wangguard.com/faq" target="_new">Is it an error?</a> Perhaps you tried to register many times.', 'wangguard')); else
			if (wangguard_email_aliases_exists($user_email))$result['errors']->add('user_email',   __('<strong>ERROR</strong>: Duplicate alias email found by WangGuard.', 'wangguard')); else
			if (!wangguard_mx_record_is_ok($user_email))$result['errors']->add('user_email',   __("<strong>ERROR</strong>: WangGuard couldn't find an MX record associated with your email domain.", 'wangguard'));
		}
		
	}
	
	return $result;
}

//*********** WPMU ***********
//*********** BP1.1+ ***********
/**
 * Adds a security question if any exists
 * 
 * @global type $wpdb
 * @return array 
 */
function wangguard_register_add_question_bp11(){
	global $wpdb;
	
	if ( strpos($_SERVER['PHP_SELF'], 'wp-admin') !== false ) {
		return $param;
	}

	$table_name = $wpdb->base_prefix . "wangguardquestions";
	//Get one random question from the question table
	$qrs = $wpdb->get_row("select * from $table_name order by RAND() LIMIT 1");
	
	if (!is_null($qrs)) {
		$question = $qrs->Question;
		$questionID = $qrs->id;
		$html = '
		<div class="register-section" style=" width: 200px; clear:left; margin-top:-10px;">
			<label for="wangguardquestansw">' . $question . '</label>';
		echo $html;
		do_action( 'bp_wangguardquestansw_errors' );
		$html = '
			<input type="text" name="wangguardquestansw" id="wangguardquestansw" value="" maxlength="50" />
			<input type="hidden" name="wangguardquest" value="'.$questionID.'" />
			</div>';
		echo $html;
	}

}


function wangguard_fix_bp_slashes_maybe($str) {
	
	if (defined('BP_VERSION')) {
		
		if ( version_compare(BP_VERSION, '1.5.5') < 0 )$str = addslashes($str);
		return $str;
	} else return $str;
}
//*********** BP1.1+ ***********
//*********** WP REGULAR ***********
/**
 * Adds a security question if any exists
 * 
 * @global type $wpdb 
 */
function wangguard_register_add_question(){
	global $wpdb;
	$table_name = $wpdb->base_prefix . "wangguardquestions";
	//Get one random question from the question table
	$qrs = $wpdb->get_row("select * from $table_name order by RAND() LIMIT 1");
	
	if (!is_null($qrs)) {
		$question = $qrs->Question;
		$questionID = $qrs->id;
		
		if ( ! defined( 'APP_FRAMEWORK_DIR' ) ){
			$html = '
			<p>
				<label>' . $question . '<br />
				<input type="text" name="wangguardquestansw" id="wangguardquestansw" class="input wpreg-wangguardquestansw" value="" tabindex="26" />
				<input type="hidden" name="wangguardquest" value="'.$questionID.'" />
			</p>';
			echo $html;
		} else {
			$AppthemeName = get_theme_data( get_template_directory() . '/style.css' );
			
			if ('JobRoller' == $AppthemeName['Title']) {
				$html = '
			<p>
				<label>' . $question . '</label><br />
				<input type="text" name="wangguardquestansw" id="wangguardquestansw" class="input wpreg-wangguardquestansw text" value="" tabindex="26" />
				<input type="hidden" name="wangguardquest" value="'.$questionID.'" />
			</p>';
			}

			elseif (('ClassiPress' == $AppthemeName['Title']) || ('Clipper' == $AppthemeName['Title'])) {
				$html = '
			<p>
				<label>' . $question . ': </label>
				<input type="text" name="wangguardquestansw" id="wangguardquestansw" class="input wpreg-wangguardquestansw text" value="" tabindex="26" />
				<input type="hidden" name="wangguardquest" value="'.$questionID.'" />
			</p>';
			}

			elseif (('Vantage' == $AppthemeName['Title']) || ('Quality Control' == $AppthemeName['Title'])) {
				$html = '
					<div class="form-field">
					<label>
						' . $question . ' <input tabindex="1" type="text" class="text required wpreg-wangguardquestansw" name="wangguardquestansw" id="wangguardquestansw" value="">
						<input type="hidden" name="wangguardquest" value="'.$questionID.'" />
					</label>
				</div>';
			}

			elseif ('Ideas' == $AppthemeName['Title']) {
				$html = '
					<p>
							<label>' . $question . '</label>
							<input tabindex="3" type="text" name="wangguardquestansw" id="wangguardquestansw" value="" class="required">
							<input type="hidden" name="wangguardquest" value="'.$questionID.'" />
					</p>';
			}

			echo $html;
		}

	}

}
/**
 * Validates security question
 * 
 * @param type $user_name
 * @param type $user_email
 * @param type $errors
 */
 
	function wangguard_signup_validate($user_name, $user_email, $errors){
	
		//if ($_POST['user_email']){ $user_email = $_POST['user_email']; }else{ $user_email = $user_email; }
		
		if (!wangguard_validate_hfields($user_email)) {
			$errors->add('user_login',__('<strong>ERROR</strong>: Banned by WangGuard <a href="http://www.wangguard.com/faq" target="_new">Is it an error?</a> Perhaps you tried to register many times.', 'wangguard'));
			return;
		}

		$answerOK = wangguard_question_repliedOK();
		//If at least a question exists on the questions table, then check the provided answer
		
		if (!$answerOK)$errors->add('wangguard_error',__('<strong>ERROR</strong>: The answer to the security question is invalid.', 'wangguard')); else {
			//check domain against the list of selected blocked domains
			$blocked = wangguard_is_domain_blocked($user_email);
			
			if ($blocked) {
				$errors->add('wangguard_error',__('<strong>ERROR</strong>: Domain not allowed.', 'wangguard'));
			} else {
				$reported = wangguard_is_email_reported_as_sp($user_email, wangguard_getRemoteIP() , wangguard_getRemoteProxyIP() , true);
				if ($reported)$errors->add('wangguard_error',__('<strong>ERROR</strong>: Banned by WangGuard <a href="http://www.wangguard.com/faq" target="_new">Is it an error?</a> Perhaps you tried to register many times.', 'wangguard')); else
				if (wangguard_email_aliases_exists($user_email))$errors->add('wangguard_error',   __('<strong>ERROR</strong>: Duplicate alias email found by WangGuard.', 'wangguard')); else
				if (!wangguard_mx_record_is_ok($user_email))$errors->add('wangguard_error',   __("<strong>ERROR</strong>: WangGuard couldn't find an MX record associated with your email domain.", 'wangguard'));
			}

		}
	}

//*********** WP REGULAR ***********
/**
 * Checks if a domain for an email address is selected to be blocked on the "Blocked domains" configuration screen
 * 
 * @param type $email 
 */
function wangguard_is_domain_blocked($email) {
	$parts = explode("@", $email);
	//if email is not well formed, return TRUE, this should never happens as WP already checks for a valid email format
	
	if (count($parts) != 2)return true;
	$domain = strtolower($parts[1]);
	$selectedDomains = maybe_unserialize( get_site_option('blocked-list-domains') );
	
	if (!is_array($selectedDomains)) $selectedDomains = array();
	//matches exact domain?
	
	if (isset($selectedDomains[$domain]))return true;
	$domainParts = explode(".", $domain);
	
	if (count($domainParts) > 1) {
		$subdomcheck = $domainParts[count($domainParts)-1];
		//check for the top level domain
		
		if (isset($selectedDomains["*." . $subdomcheck]))return true;
		//n-level domains
		$from = count($domainParts)-2;
		for ($i = $from ; $i>=0 ; $i-- ) {
			$subdomcheck = $domainParts[$i] . "." . $subdomcheck;
			
			if (isset($selectedDomains["*." . $subdomcheck]))return true;
		}

	} else //malformed domain
	return true;
	return false;
}

/**
 * Verifies the email against WangGuard service
 * 
 * @global type $wpdb
 * @global type $wangguard_api_key
 * @global type $wangguard_user_check_status
 * @param type $email
 * @param type $clientIP
 * @param type $callingFromRegularWPHook regular WP hook sends true on this param
 * @return boolean 
 */
function wangguard_is_email_reported_as_sp($email , $clientIP , $ProxyIP , $callingFromRegularWPHook = false) {
	global $wpdb;
	global $wangguard_api_key;
	global $wangguard_user_check_status;
	
	if (empty ($wangguard_api_key))return false;
	$wangguard_user_check_status = "not-checked";
	
	if ( get_site_option("wangguard-do-not-check-client-ip")=='1') {
		$clientIP = '';
		$ProxyIP = '';
	}

	$response = wangguard_http_post("wg=<in><apikey>$wangguard_api_key</apikey><email>".$email."</email><ip>".$clientIP."</ip><proxyip>".$ProxyIP."</proxyip></in>", 'query-email.php');
	$responseArr = XML_unserialize($response);
	wangguard_stats_update("check");
	
	if ( is_array($responseArr)) {
		
		if (($responseArr['out']['cod'] == '10') || ($responseArr['out']['cod'] == '11')) {
			wangguard_stats_update("detected");
			return true;
		} else {
			
			if ($responseArr['out']['cod'] == '20') {
				$wangguard_user_check_status = 'checked';
			}

			elseif ($responseArr['out']['cod'] == '100')$wangguard_user_check_status = 'error:' . __('Your WangGuard API KEY is invalid.', 'wangguard'); else $wangguard_user_check_status = 'error:'.$responseArr['out']['cod'];
		}

	}

	return false;
}

/**
 *	Verifies the security question, used from the WP, WPMU and BP validation functions
 * @global type $wpdb
 * @return boolean 
 */
function wangguard_question_repliedOK() {
	//WP 3.2.1 multisite introduces a new two step registration, on step 2 we don't have to check the security question as it was checked in the step 1
	
	if (@$_POST['stage'] == 'validate-blog-signup') {
		
		if (!wp_verify_nonce($_POST['_signup_form'] , 'signup_form_' . $_POST['signup_form_id']))return false; else return true;
	}

	global $wpdb;
	$table_name = $wpdb->base_prefix . "wangguardquestions";
	//How many questions are created?
	$questionCount = $wpdb->get_col("select count(*) as q from $table_name");
	$answerOK = true;
	//If at least a question exists on the questions table, then check the provided answer
	
	if ($questionCount[0]) {
		$questionID = intval($_REQUEST['wangguardquest']);
		$answer = $_REQUEST['wangguardquestansw'];
		$qrs = $wpdb->get_row( $wpdb->prepare("select * from $table_name where id = %d" , $questionID));
		
		if (!is_null($qrs)) {
			
			if (mb_strtolower( $_REQUEST['wangguardquestansw'] ) == mb_strtolower( $qrs->Answer ) ) {
				$wpdb->query( $wpdb->prepare("update $table_name set RepliedOK = RepliedOK + 1 where id = %d" , $questionID ) );
			} else {
				$answerOK = false;
				$wpdb->query( $wpdb->prepare("update $table_name set RepliedWRONG = RepliedWRONG + 1 where id = %d" , $questionID ) );
			}

		} else {
			$answerOK = false;
			$wpdb->query( $wpdb->prepare("update $table_name set RepliedWRONG = RepliedWRONG + 1 where id = %d" , $questionID ) );
		}

	}

	return $answerOK;
}

/********************************************************************/
/*** ADD & VALIDATE SECURITY QUESTIONS ON REGISTER ENDS ***/
/********************************************************************/

/********************************************************************/
/*** USER REGISTATION & DELETE FILTERS BEGINS ***/
/********************************************************************/
// user register and delete actions
add_action('user_register','wangguard_plugin_user_register');
add_action('bp_complete_signup','wangguard_plugin_bp_complete_signup');
add_action('bp_core_activated_user','wangguard_bp_core_activated_user' , 10 , 3);
add_action('wpmu_activate_user','wangguard_wpmu_activate_user' , 10 , 3);
add_action('delete_user','wangguard_plugin_user_delete');
add_action('wpmu_delete_user','wangguard_plugin_user_delete');
add_action('make_spam_user','wangguard_make_spam_user');
add_action('make_ham_user','wangguard_make_ham_user');
add_action('bp_core_action_set_spammer_status','wangguard_bp_core_action_set_spammer_status' , 10 , 2);
/**
 * Save the status of the verification upon BP signups
 * 
 * @global type $wpdb
 * @global type $wangguard_user_check_status 
 */
function wangguard_plugin_bp_complete_signup() {
	global $wpdb;
	global $wangguard_user_check_status;
	$table_name = $wpdb->base_prefix . "wangguardsignupsstatus";
	//delete just in case a previous record from a user which didn't activate the account is there
	$wpdb->query( $wpdb->prepare("delete from $table_name where signup_username = '%s'" , $_POST['signup_username']));
	//Insert the new signup record
	$wpdb->query( $wpdb->prepare("insert into $table_name(signup_username , user_status , user_ip , user_proxy_ip) values ('%s' , '%s' , '%s' , '%s')" , $_POST['signup_username'] , $wangguard_user_check_status , wangguard_getRemoteIP() , wangguard_getRemoteProxyIP() ) );
}

/**
WooCommerce
*/
if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
	function wangguard_plugin_woocommerce_checkout_signup() {
		global $wpdb, $current_user;
		global $wangguard_user_check_status;
		global $woocommerce;
		
		if ((isset( $_POST['createaccount'] ) && ($_POST['createaccount'] == 1)) && (isset( $_POST['payment_method'] ) )){
			$table_name = $wpdb->base_prefix . "wangguardsignupsstatus";
			//delete just in case a previous record from a user which didn't activate the account is there
			$wpdb->query( $wpdb->prepare("delete from $table_name where signup_username = '%s'" , $_POST['account_username']));
			//Insert the new signup record
			$wangguard_user_check_status = 'buyer';
			$wpdb->query( $wpdb->prepare("insert into $table_name(signup_username , user_status , user_ip , user_proxy_ip) values ('%s' , '%s' , '%s' , '%s')" , $_POST['account_username'] , $wangguard_user_check_status , wangguard_getRemoteIP() , wangguard_getRemoteProxyIP() ) );
		}

		elseif (isset( $_POST['payment_method'] ) ) {
			get_currentuserinfo();
			$table_name = $wpdb->base_prefix . "wangguardsignupsstatus";
			$WangUser_login = $current_user->user_login;
			$WangUser_ID = $current_user->ID;
			$wangguard_user_check_status = 'buyer';
			//delete just in case a previous record from a user which didn't activate the account is there
			$wpdb->query( $wpdb->prepare("delete from $table_name where signup_username = '%s'" , $WangUser_login));
			$wpdb->query( $wpdb->prepare("insert into $table_name(signup_username , user_status , user_ip , user_proxy_ip) values ('%s' , '%s' , '%s' , '%s')" , $WangUser_login , $wangguard_user_check_status , wangguard_getRemoteIP() ,wangguard_getRemoteProxyIP() ) );
			wangguard_plugin_user_register($WangUser_ID);
		}

	}

}

/**
 * Account activated on BP hook
 * 
 * @global type $wpdb
 * @global type $wangguard_api_key
 * @global type $wangguard_user_check_status
 * @param type $userid
 * @param type $key
 * @param type $user 
 */
function wangguard_bp_core_activated_user($userid, $key, $user) {
	global $wpdb;
	global $wangguard_api_key;
	global $wangguard_user_check_status;
	wangguard_plugin_user_register($userid);
}

/**
 * Account activated on WPMU hook
 * 
 * @global type $wpdb
 * @global type $wangguard_api_key
 * @global type $wangguard_user_check_status
 * @param type $userid
 * @param type $password
 * @param type $meta 
 */
function wangguard_wpmu_activate_user($userid, $password, $meta) {
	global $wpdb;
	global $wangguard_api_key;
	global $wangguard_user_check_status;
	wangguard_plugin_user_register($userid);
}

/**
 * Saves the status of the verification against WangGuard service upon user registration
 * 
 * @global type $wpdb
 * @global type $wangguard_user_check_status
 * @param type $userid 
 */
function wangguard_plugin_user_register($userid) {
	global $wpdb;
	global $wangguard_user_check_status;
	
	if (empty ($wangguard_user_check_status)) {
		$user = new WP_User($userid);
		$table_name = $wpdb->base_prefix . "wangguardsignupsstatus";
		//if there a status on the signups table?
		$user_status = $wpdb->get_var( $wpdb->prepare("select user_status from $table_name where signup_username = '%s'" , $user->user_login));
		//delete the signup status
		$wpdb->query( $wpdb->prepare("delete from $table_name where signup_username = '%s'" , $user->user_login));
		//If not empty, overrides the status with the signup status
		
		if (!empty ($user_status))$wangguard_user_check_status = $user_status;
	}

	$table_name = $wpdb->base_prefix . "wangguarduserstatus";
	$user_status = $wpdb->get_var( $wpdb->prepare("select ID from $table_name where ID = %d" , $userid));
	
	if (is_null($user_status))//insert the new status
	$wpdb->query( $wpdb->prepare("insert into $table_name(ID , user_status , user_ip , user_proxy_ip) values (%d , '%s' , '%s' , '%s')" , $userid , $wangguard_user_check_status , wangguard_getRemoteIP() , wangguard_getRemoteProxyIP() ) ); else //update the new status
	$wpdb->query( $wpdb->prepare("update $table_name set user_status = '%s' where ID = %d" , $wangguard_user_check_status , $userid  ) );
}

/**
 * Deletes the status of a user from the WangGuard status tracking table
 * 
 * @global type $wpdb
 * @param type $userid 
 */
function wangguard_plugin_user_delete($userid) {
	global $wpdb;
	$user = new WP_User($userid);
	//delete the signup status
	$table_name = $wpdb->base_prefix . "wangguardsignupsstatus";
	$wpdb->query( $wpdb->prepare("delete from $table_name where signup_username = '%s'" , $user->user_login));
	//delete the user status
	$table_name = $wpdb->base_prefix . "wangguarduserstatus";
	$wpdb->query( $wpdb->prepare("delete from $table_name where ID = %d" , $userid ) );
	//delete the user from the moderation queue
	$table_name = $wpdb->base_prefix . "wangguardreportqueue";
	$wpdb->query( $wpdb->prepare("delete from $table_name where ID = %d" , $userid ) );
	//delete the user reports from the moderation queue
	$table_name = $wpdb->base_prefix . "wangguardreportqueue";
	$wpdb->query( $wpdb->prepare("delete from $table_name where reported_by_ID = %d" , $userid ) );
}

/**
 * User has been reported as spam, send to WangGuard
 * @global type $wpdb
 * @param type $userid 
 */
function wangguard_make_spam_user($userid) {
	global $wpdb;
	
		do_action('wangguard_pre_make_spam_user');
		//flag a user
		//get the recordset of the user to flag
		$wpusersRs = $wpdb->get_col( $wpdb->prepare("select ID from $wpdb->users where ID = %d" , $userid ) );
		wangguard_report_users($wpusersRs , "email" , false);
		
		do_action('wangguard_make_spam_user');

}

/**
 * User has been reported as safe, rollback on WangGuard
 * @global type $wpdb
 * @param type $userid 
 */
function wangguard_make_ham_user($userid) {
	global $wpdb;
	//flag a user
	//get the recordset of the user to make as safe
	$wpusersRs = $wpdb->get_col( $wpdb->prepare("select ID from $wpdb->users where ID = %d" , $userid ) );
	wangguard_rollback_report($wpusersRs);
}

/**
 * Updates WangGuard user staus when a user is flagged as spam or ham 
 * @param type $userid
 * @param type $is_spam 
 */
function wangguard_bp_core_action_set_spammer_status($userid , $is_spam) {
	
	if ($is_spam)wangguard_make_spam_user ($userid); else wangguard_make_ham_user ($userid);
}

/********************************************************************/
/*** USER REGISTATION & DELETE FILTERS ENDS ***/
/********************************************************************/

/********************************************************************/
/*** AJAX FRONT HANDLERS BEGINS ***/
/********************************************************************/

if ( ( (get_site_option ("wangguard-enable-bp-report-btn")==1) && ( defined('BP_VERSION') ) )  || ( get_site_option ("wangguard-enable-bp-report-blog")==1) ) {
	add_action('wp_head', 'wangguard_ajax_front_setup');
	add_action('wp_ajax_wangguard_ajax_front_handler', 'wangguard_ajax_front_callback');
}

/**
 * Front end ajax functions
 * 
 * @global type $wuangguard_parent
 */
function wangguard_ajax_front_setup() {
	global $wuangguard_parent;
	
	if ( !is_user_logged_in() )return;
	?>
<script type="text/javascript" >
function wangguard_isjQuery17()	 {
	var jQueryVersion = jQuery.fn.jquery.split('.');
	var ret = ( (parseInt(jQueryVersion[0])==1) && (parseInt(jQueryVersion[1])>=7) ) || ( parseInt(jQueryVersion[0])>1 );
	return ret;
}
if (typeof ajaxurl == 'undefined')
	ajaxurl = "<?php  echo admin_url( 'admin-ajax.php' ); ?>";
else if (ajaxurl == undefined)
	ajaxurl = "<?php  echo admin_url( 'admin-ajax.php' ); ?>";
jQuery(document).ready(function() {
	if (wangguard_isjQuery17() == true) {
		jQuery(document).on("click", ".wangguard-user-report", function(){
			wangguardUserReport_handler(this);
		});  
	}
	else {
		jQuery('.wangguard-user-report').live('click' , function () {
			wangguardUserReport_handler(this);
		});
	}
	function wangguardUserReport_handler(sender) {
		if (!confirm('<?php  echo addslashes(__("Do you confirm to report the user?" , "wangguard")) ?>')) 
			return;
		var userID = jQuery(sender).attr("rel");
		if ((userID == undefined) || (userID == '')) {
			userID = 0;
			//BP profile button doesn't allow to add a rel attr to the button so we store it in tne class field
			var tmpClass = jQuery(sender).attr("class");
			var matches = tmpClass.match(/wangguard-user-report-id-(\d+)/);
			if (matches != null)
				userID = matches[1];
		}
		data = {
			action	: 'wangguard_ajax_front_handler',
			object	: 'user',
			wpnonce	: '<?php  echo wp_create_nonce("wangguardreport") ?>',
			userid	: userID
		};
		jQuery.post(ajaxurl, data, function(response) {
			if (response=='0') {
				alert('<?php  echo addslashes(__('The user was reported.', 'wangguard')) ?>');
				jQuery(".wangguard-user-report[rel='"+userID+"']").fadeOut();
				jQuery(".wangguard-user-report-id-"+userID).fadeOut();
			}
		});
	};
	if (wangguard_isjQuery17() == true) {
		jQuery(document).on("click", ".wangguard-blog-report", function(){
			wangguardBlogReport_handler(this);
		});  
	}
	else {
		jQuery('.wangguard-blog-report').live('click' , function () {
			wangguardBlogReport_handler(this);
		});
	}
	function wangguardBlogReport_handler(sender) {
		if (!confirm('<?php  echo addslashes(__("Do you confirm to report the blog and authors?" , "wangguard")) ?>')) 
			return;
		var blogID = jQuery(sender).attr("rel");
		if ((blogID == undefined) || (blogID == '')) {
			blogID = 0;
			//BP profile button doesn't allow to add a rel attr to the button so we store it in tne class field
			var tmpClass = jQuery(sender).attr("class");
			var matches = tmpClass.match(/wangguard-blog-report-id-(\d+)/);
			if (matches != null)
				blogID = matches[1];
		}
		data = {
			action	: 'wangguard_ajax_front_handler',
			object	: 'blog',
			wpnonce	: '<?php  echo wp_create_nonce("wangguardreport") ?>',
			blogid	: blogID
		};
		jQuery.post(ajaxurl, data, function(response) {
			if (response=='0') {
				alert('<?php  echo addslashes(__('The blog was reported.', 'wangguard')) ?>');
				jQuery(".wangguard-blog-report").fadeOut();
			}
		});
	};
});</script>
<?php
}

/**
 * Checks whether a user is reported on queue
 * 
 * @global type $wpdb
 * @param type $userid
 * @return boolean 
 */
function wangguard_is_user_reported($userid) {
	global $wpdb;
	$table_name = $wpdb->base_prefix . "wangguardreportqueue";
	$Count = $wpdb->get_col( $wpdb->prepare("select count(*) as q from $table_name where ID = %d" , $userid) );
	return $Count[0] > 0;
}

/**
 * Checks whether a blog is reported on queue
 * 
 * @global type $wpdb
 * @param type $blogid
 * @return boolean
 */
function wangguard_is_blog_reported($blogid) {
	global $wpdb;
	$table_name = $wpdb->base_prefix . "wangguardreportqueue";
	$Count = $wpdb->get_col( $wpdb->prepare("select count(*) as q from $table_name where blog_id = %d" , $blogid) );
	return $Count[0] > 0;
}

/**
 * Front end AJAX handler
 * 
 * @global type $wpdb
 */
function wangguard_ajax_front_callback() {
	global $wpdb;
	
	if (!is_user_logged_in()) return;
	//add user ID or blog ID to the 
	$object = $_REQUEST['object'];
	$nonce = $_REQUEST['wpnonce'];
	
	if ( !wp_verify_nonce( $nonce, 'wangguardreport' ) )die();
	$thisUserID = get_current_user_id();
	
	if ($object == "user") {
		$userid = (int)$_REQUEST['userid'];
		
		if (empty ($userid)) die();
		
		if (wangguard_is_user_reported($userid)) die("0");
		$user_object = new WP_User($userid);
		//do not add admins as reported
		
		if ( wangguard_is_admin($user_object) ) die("0");
		$table_name = $wpdb->base_prefix . "wangguardreportqueue";
		$wpdb->query( $wpdb->prepare("insert into $table_name(ID , blog_id , reported_by_ID) values (%d , NULL , %d)" , $userid , $thisUserID ) );
		echo "0";
	}

	elseif ($object == "blog") {
		$blogid = (int)$_REQUEST['blogid'];
		
		if (empty ($blogid)) die();
		
		if (wangguard_is_blog_reported($blogid)) die("0");
		$isMainBlog = false;
		
		if (isset ($current_site)) {
			$isMainBlog = ($blogid != $current_site->blog_id);
			// main blog not a spam !
		}

		elseif (defined("BP_ROOT_BLOG")) {
			$isMainBlog = ( 1 == $blogid || BP_ROOT_BLOG == $blogid );
		} else $isMainBlog = ($blogid == 1);
		//do not report main blog
		
		if ($isMainBlog) die("0");
		$table_name = $wpdb->base_prefix . "wangguardreportqueue";
		$wpdb->query( $wpdb->prepare("insert into $table_name(ID , blog_id , reported_by_ID) values (NULL , %d , %d)" , $blogid , $thisUserID ) );
		echo "0";
	}

	die();
}

/********************************************************************/
/*** AJAX FRONT HANDLERS ENDS ***/
/********************************************************************/

/********************************************************************/
/*** AJAX ADMIN HANDLERS BEGINS ***/
/********************************************************************/
add_action('admin_head', 'wangguard_ajax_setup');
add_action('wp_ajax_wangguard_ajax_handler', 'wangguard_ajax_callback');
add_action('wp_ajax_wangguard_ajax_recheck', 'wangguard_ajax_recheck_callback');
add_action('wp_ajax_wangguard_ajax_questionadd', 'wangguard_ajax_questionadd');
add_action('wp_ajax_wangguard_ajax_questiondelete', 'wangguard_ajax_questiondelete');
add_action('wp_ajax_wangguard_ajax_cronjobadd', 'wangguard_ajax_cronjobadd');
add_action('wp_ajax_wangguard_ajax_cronjobdelete', 'wangguard_ajax_cronjobdelete');
add_action('wp_ajax_wangguard_ajax_ip_info', 'wangguard_ajax_ip_info');
/**
 * Admin side AJAX functions
 * 
 * @global type $wuangguard_parent
 * @global type $wuangguard_parent
 * @global type $wuangguard_parent
 */
function wangguard_ajax_setup() {
	global $wuangguard_parent;
	
	if (!current_user_can('level_10')) return;
	?>
<script type="text/javascript" >
var wangguardBulkOpError = false;
var wangguard_JSadminurl = "<?php  echo admin_url(); ?>";
function wangguard_isjQuery17()	 {
	var jQueryVersion = jQuery.fn.jquery.split('.');
	var ret = ( (parseInt(jQueryVersion[0])==1) && (parseInt(jQueryVersion[1])>=7) ) || ( parseInt(jQueryVersion[0])>1 );
	return ret;
}
jQuery(document).ready(function($) {
	jQuery("a.wangguard-splogger").click(function() {
		var userid = jQuery(this).attr("rel");
		wangguard_report(userid , false);
	});
	jQuery("a.wangguard-rollback").click(function() {
		var userid = jQuery(this).attr("rel");
		wangguard_rollback(userid);
	});
	jQuery("a.wangguard-splogger-blog").click(function() {
		var blogid = jQuery(this).attr("rel");
		wangguard_report_blog(blogid , false);
	});
	function wangguard_report(userid , frombulk) {
		var confirmed = true;
		<?php  if (get_site_option ("wangguard-expertmode")!='1') { ?>
			if (!frombulk) {
			<?php  if (get_site_option ("wangguard-delete-users-on-report")=='1') { ?>
				confirmed = confirm('<?php  echo addslashes(__('Do you confirm to flag this user as Splogger? This operation is IRREVERSIBLE and will DELETE the user.', 'wangguard')) ?>');
			<?php  } else { ?>
				confirmed = confirm('<?php  echo addslashes(__('Do you confirm to flag this user as Splogger?', 'wangguard')) ?>');
			<?php  } ?>
			}
		<?php  } ?>
		if (confirmed) {
			data = {
				action	: 'wangguard_ajax_handler',
				scope	: 'email',
				userid	: userid
			};
			jQuery.post(ajaxurl, data, function(response) {
				if (response=='0') {
					alert('<?php  echo addslashes(__('The selected user couldn\'t be found on the users table.', 'wangguard')) ?>');
				}
				else if (response=='-1') {
					wangguardBulkOpError = true;
					alert('<?php  echo addslashes(__('Your WangGuard API KEY is invalid.', 'wangguard')) ?>');
				}
				else if (response=='-2') {
					wangguardBulkOpError = true;
					alert('<?php  echo addslashes(__('There was a problem connecting to the WangGuard server. Please check your server configuration.', 'wangguard')) ?>');
				}
				else {
					<?php  if ($wuangguard_parent == 'edit.php') { ?>
					document.location = document.location;
					<?php  } else { ?>
						<?php  if (get_site_option ("wangguard-delete-users-on-report")=='1') { ?>
							jQuery('td span.wangguardstatus-'+response).parent().parent().fadeOut();
						<?php  } else { ?>
							jQuery('td span.wangguardstatus-'+response).removeClass('wangguard-status-checked');
							jQuery('td span.wangguardstatus-'+response).addClass('wangguard-status-splogguer');
							jQuery('td span.wangguardstatus-'+response).html('<?php  echo __('Reported as Splogger' , 'wangguard') ?>');
							jQuery('a.wangguard-splogger[rel=\''+response+'\']').hide();
							jQuery('a.wangguard-rollback[rel=\''+response+'\']').show();
						<?php  } ?>
					<?php  } ?>
				}
			});
		}
	}
	function wangguard_rollback(userid) {
		var confirmed = true;
		<?php  if (get_site_option ("wangguard-expertmode")!='1') { ?>
			confirmed = confirm('<?php  echo addslashes(__('Do you confirm to flag this user as safe?', 'wangguard')) ?>');
		<?php  } ?>
		if (confirmed) {
			data = {
				action	: 'wangguard_ajax_handler',
				scope	: 'rollback-email',
				userid	: userid
			};
			jQuery.post(ajaxurl, data, function(response) {
				if (response=='0') {
					alert('<?php  echo addslashes(__('The selected user couldn\'t be found on the users table.', 'wangguard')) ?>');
				}
				else if (response=='-1') {
					wangguardBulkOpError = true;
					alert('<?php  echo addslashes(__('Your WangGuard API KEY is invalid.', 'wangguard')) ?>');
				}
				else if (response=='-2') {
					wangguardBulkOpError = true;
					alert('<?php  echo addslashes(__('There was a problem connecting to the WangGuard server. Please check your server configuration.', 'wangguard')) ?>');
				}
				else {
					<?php  if ($wuangguard_parent == 'edit.php') { ?>
					document.location = document.location;
					<?php  } else { ?>
						jQuery('td span.wangguardstatus-'+response).removeClass('wangguard-status-splogguer');
						jQuery('td span.wangguardstatus-'+response).addClass('wangguard-status-checked');
						jQuery('td span.wangguardstatus-'+response).html('<?php  echo __('Checked (forced)' , 'wangguard') ?>');
						jQuery('a.wangguard-rollback[rel=\''+response+'\']').hide();
						jQuery('a.wangguard-splogger[rel=\''+response+'\']').show();
					<?php  } ?>
				}
			});
		}
	}
	function wangguard_report_blog(blogid) {
		var confirmed = true;
		<?php  if (get_site_option ("wangguard-expertmode")!='1') { ?>
			<?php  if (get_site_option ("wangguard-delete-users-on-report")=='1') { ?>
				confirmed = confirm('<?php  echo addslashes(__('Do you confirm to flag this blog\'s author(s) as Splogger(s)? This operation is IRREVERSIBLE and will DELETE the user(s).', 'wangguard')) ?>');
			<?php  } else { ?>
				confirmed = confirm('<?php  echo addslashes(__('Do you confirm to flag this blog\'s author(s) as Splogger(s)?', 'wangguard')) ?>');
			<?php  } ?>
		<?php  } ?>
		if (confirmed) {
			data = {
				action	: 'wangguard_ajax_handler',
				scope	: 'blog',
				blogid	: blogid
			};
			jQuery.post(ajaxurl, data, function(response) {
				if (response=='0') {
					alert('<?php  echo addslashes(__('The selected blog couldn\'t be found.', 'wangguard')) ?>');
				}
				else if (response=='-1') {
					wangguardBulkOpError = true;
					alert('<?php  echo addslashes(__('Your WangGuard API KEY is invalid.', 'wangguard')) ?>');
				}
				else if (response=='-2') {
					wangguardBulkOpError = true;
					alert('<?php  echo addslashes(__('There was a problem connecting to the WangGuard server. Please check your server configuration.', 'wangguard')) ?>');
				}
				else {
					jQuery('tr#blog-'+blogid).fadeOut();
					var users = response.split(",");
					for (i=0;i<=users.length;i++)
						jQuery('td span.wangguardstatus-'+users[i]).parent().parent().fadeOut();
				}
			});
		}
	}
	jQuery(".wangguard-queue-remove-blog").click(function() {
		if (!confirm('<?php  echo addslashes(__("Do you confirm to remove the blog from the Moderation Queue?" , "wangguard")) ?>')) 
			return;
		var blogID = jQuery(this).attr("rel");
		data = {
			action	: 'wangguard_ajax_handler',
			scope	: 'queue_blog_remove',
			wpnonce	: '<?php  echo wp_create_nonce("wangguardreport") ?>',
			blogid	: blogID
		};
		jQuery.post(ajaxurl, data, function(response) {
			if (response=='0') {
				jQuery("tr#blog-"+blogID).fadeOut();
			}
		});
	});
	jQuery(".wangguard-queue-remove-user").click(function() {
		if (!confirm('<?php  echo addslashes(__("Do you confirm to remove the user from the Moderation Queue?" , "wangguard")) ?>')) 
			return;
		var userID = jQuery(this).attr("rel");
		data = {
			action	: 'wangguard_ajax_handler',
			scope	: 'queue_user_remove',
			wpnonce	: '<?php  echo wp_create_nonce("wangguardreport") ?>',
			userid	: userID
		};
		jQuery.post(ajaxurl, data, function(response) {
			if (response=='0') {
				jQuery("tr#user-"+userID).fadeOut();
			}
		});
	});
	jQuery("a.wangguard-domain").click(function() {
		var confirmed = true;
		<?php  if (get_site_option ("wangguard-expertmode")!='1') { ?>
			<?php  if (get_site_option ("wangguard-delete-users-on-report")=='1') { ?>
				confirmed = confirm('<?php  echo addslashes(__('Do you confirm to flag this user domain as Splogger? This operation is IRREVERSIBLE and will DELETE the users that shares this domain.', 'wangguard')) ?>');
			<?php  } else { ?>
				confirmed = confirm('<?php  echo addslashes(__('Do you confirm to flag this user domain as Splogger?', 'wangguard')) ?>');
			<?php  } ?>
		<?php  } ?>
		if (confirmed) {
			data = {
				action	: 'wangguard_ajax_handler',
				scope	: 'domain',
				userid	: jQuery(this).attr("rel")
			};
			jQuery.post(ajaxurl, data, function(response) {
				if (response=='0') {
					alert('<?php  echo addslashes(__('The selected user couldn\'t be found on the users table.', 'wangguard')) ?>');
				}
				else if (response=='-1') {
					alert('<?php  echo addslashes(__('Your WangGuard API KEY is invalid.', 'wangguard')) ?>');
				}
				else if (response=='-2') {
					alert('<?php  echo addslashes(__('There was a problem connecting to the WangGuard server. Please check your server configuration.', 'wangguard')) ?>');
				}
				else {
					var users = response.split(",");
					for (i=0;i<=users.length;i++)
						jQuery('td span.wangguardstatus-'+users[i]).parent().parent().fadeOut();
				}
			});
		}
	});
	<?php 
	global $wuangguard_parent;
	
	if (($wuangguard_parent == 'ms-users.php') || ($wuangguard_parent == 'wpmu-users.php') || ($wuangguard_parent == 'users.php')) {
		?>
	jQuery(document).ajaxError(function(e, xhr, settings, exception) {
		alert('<?php  echo addslashes(__('There was a problem connecting to your WordPress server.', 'wangguard')) ?>');
	});
	<?php  } ?>
	jQuery("a.wangguard-recheck").click(function() {
		var userid = jQuery(this).attr("rel");
		wangguard_recheck(userid);
	});
	function wangguard_recheck(userid) {
		data = {
			action	: 'wangguard_ajax_recheck',
			userid	: userid
		};
		jQuery.post(ajaxurl, data, function(response) {
			if (response=='0') {
				alert('<?php  echo addslashes(__('The selected user couldn\'t be found on the users table.', 'wangguard')) ?>');
			}
			else if (response=='-1') {
				wangguardBulkOpError = true;
				alert('<?php  echo addslashes(__('Your WangGuard API KEY is invalid.', 'wangguard')) ?>');
			}
			else if (response=='-2') {
				wangguardBulkOpError = true;
				alert('<?php  echo addslashes(__('There was a problem connecting to the WangGuard server. Please check your server configuration.', 'wangguard')) ?>');
			}
			else {
				jQuery('td span.wangguardstatus-'+userid).fadeOut(500, function() {
					jQuery(this).html(response);
					jQuery(this).fadeIn(500);
				})
			}
		});
	}
	if (wangguard_isjQuery17() == true) {
		jQuery(document).on("click", "a.wangguard-delete-question", function(){
			wangguardDeleteQuestion(this);
		});  
	}
	else {
		jQuery('a.wangguard-delete-question').live('click' , function () {
			wangguardDeleteQuestion(this);
		});
	}
	function wangguardDeleteQuestion(sender) {
		<?php  if (get_site_option ("wangguard-expertmode")=='1') { ?>
			var confirmed = true;
		<?php  } else { ?>
			var confirmed = confirm('<?php  echo addslashes(__('Do you confirm to delete this question?.', 'wangguard')) ?>');
		<?php  } ?>
		if (confirmed) {
			var questid	= jQuery(sender).attr("rel");
			data = {
				action	: 'wangguard_ajax_questiondelete',
				questid	: questid
			};
			jQuery.post(ajaxurl, data, function(response) {
				if (response!='0') {
					jQuery("#wangguard-question-"+questid).slideUp("fast");
				}
			});
		}
	};
	jQuery("#wangguardnewquestionbutton").click(function() {
		jQuery("#wangguardnewquestionerror").hide();
		var wgq = jQuery("#wangguardnewquestion").val();
		var wga = jQuery("#wangguardnewquestionanswer").val();
		if ((wgq=='') || (wga=='')) {
			jQuery("#wangguardnewquestionerror").slideDown();
			return;
		}
		data = {
			action	: 'wangguard_ajax_questionadd',
			q		: wgq,
			a		: wga
		};
		jQuery.post(ajaxurl, data, function(response) {
			if (response!='0') {
				jQuery("#wangguard-question-noquestion").remove();
				var newquest = '<div class="wangguard-question" id="wangguard-question-'+response+'">';
				newquest += '<?php  echo addslashes(__("Question", 'wangguard')) ?>: <strong>'+wgq+'</strong><br/>';
				newquest += '<?php  echo addslashes(__("Answer", 'wangguard')) ?>: <strong>'+wga+'</strong><br/>';
				newquest += '<a href="javascript:void(0)" rel="'+response+'" class="wangguard-delete-question"><?php  echo addslashes(__('delete question', 'wangguard')) ?></a></div>';
				jQuery("#wangguard-new-question-container").append(newquest);
				jQuery("#wangguardnewquestion").val("");
				jQuery("#wangguardnewquestionanswer").val("");
			}
			else if (response=='0') {
				jQuery("#wangguardnewquestionerror").slideDown();
			}
		});
	});
	if (wangguard_isjQuery17() == true) {
		jQuery(document).on("click", "a.wangguard-delete-cronjob", function(){
			wangguardDeleteCronJob(this);
		});  
	}
	else {
		jQuery('a.wangguard-delete-cronjob').live('click' , function () {
			wangguardDeleteCronJob(this);
		});
	}
	function wangguardDeleteCronJob(sender) {
		<?php  if (get_site_option ("wangguard-expertmode")=='1') { ?>
			var confirmed = true;
		<?php  } else { ?>
			var confirmed = confirm('<?php  echo addslashes(__('Do you confirm to delete this cron job?.', 'wangguard')) ?>');
		<?php  } ?>
		if (confirmed) {
			var cronid = jQuery(sender).attr("rel");
			data = {
				action	: 'wangguard_ajax_cronjobdelete',
				cronid	: cronid
			};
			jQuery.post(ajaxurl, data, function(response) {
				if (response!='0') {
					jQuery("#wangguard-cronjob-"+cronid).slideUp("fast");
				}
			});
		}
	};
	jQuery("#wangguardnewcronjobbutton").click(function() {
		jQuery("#wangguardnewconjoberror").hide();
		var wgr = jQuery("#wangguardnewcronjob").val();
		var wga = jQuery("#wangguardnewcronjobaction").val();
		var wgw = jQuery("#wangguardnewcronjoblookup").val();
		var wgt1 = jQuery("#wangguardnewcronjobtimeh").val();
		var wgt2 = jQuery("#wangguardnewcronjobtimem").val();
		if ((wgr=='') || (wgw=='') || (wga=='')) {
			return;
		}
		data = {
			action	: 'wangguard_ajax_cronjobadd',
			r		: wgr,
			w		: wgw,
			a		: wga,
			t1		: wgt1,
			t2		: wgt2
		};
		jQuery.post(ajaxurl, data, function(response) {
			if (response!='0') {
				jQuery("#wangguard-cron-nocron").remove();
				jQuery("#wangguard-new-cronjob-container").append(response);
			}
			else if (response=='0') {
				jQuery("#wangguardnewconjoberror").slideDown();
			}
		});
	});
	<?php
 global $wuangguard_parent;if (($wuangguard_parent == 'ms-users.php') || ($wuangguard_parent == 'wpmu-users.php') || ($wuangguard_parent == 'users.php')) { ?>
		var wangguard_bulk = '';
		wangguard_bulk += '<input style="margin-right:15px" type="button" class="button-secondary action wangguardbulkcheckbutton" name="wangguardbulkcheckbutton" value="<?php  echo addslashes(__('Bulk check Sploggers' , 'wangguard'))  ?>">';
		wangguard_bulk += '<input type="button" class="button-secondary action wangguardbulkreportbutton" name="wangguardbulkreportbutton" value="<?php  echo addslashes(__('Bulk report Sploggers' , 'wangguard'))  ?>">';
		jQuery("div.tablenav div.alignleft:first").append(wangguard_bulk);
		jQuery("div.tablenav div.alignleft:last").append(wangguard_bulk);
		if (wangguard_isjQuery17() == true) {
			jQuery(document).on("click", "input.wangguardbulkcheckbutton", function(){
				wangguardbulkcheck_handler();
			});  
		}
		else {
			jQuery('input.wangguardbulkcheckbutton').live('click' , function () {
				wangguardbulkcheck_handler();
			});
		}
		function wangguardbulkcheck_handler() {
			var userscheck;
			userscheck = jQuery('input[name="users[]"]:checked');
			//Checkboxes name varies thru WP screens (users.php / ms-users.php / wpmu-users.php) and versions
			if (userscheck.length == 0)
				userscheck = jQuery('input[name="allusers[]"]:checked');
			//Checkboxes name varies thru WP screens (users.php / ms-users.php / wpmu-users.php) and versions
			if (userscheck.length == 0)
				userscheck = jQuery('th.check-column input[type="checkbox"]:checked');
			wangguardBulkOpError = false;
			userscheck.each(function() {
					if (wangguardBulkOpError) {
						return;
					}
					wangguard_recheck(jQuery(this).val());
			});
		};
		if (wangguard_isjQuery17() == true) {
			jQuery(document).on("click", "input.wangguardbulkreportbutton", function(){
				wangguardbulkreportbutton_handler();
			});  
		}
		else {
			jQuery('input.wangguardbulkreportbutton').live('click' , function () {
				wangguardbulkreportbutton_handler();
			});
		}
		function wangguardbulkreportbutton_handler() {
			<?php  if (get_site_option ("wangguard-delete-users-on-report")=='1') { ?>
				if (!confirm('<?php  _e('Do you confirm to flag the selected users as Sploggers? This operation is IRREVERSIBLE and will DELETE the users.' , 'wangguard') ?>'))
					return;
			<?php  } else { ?>
				if (!confirm('<?php  _e('Do you confirm to flag the selected users as Sploggers?' , 'wangguard') ?>'))
					return;
			<?php  } ?>
			var userscheck;
			userscheck = jQuery('input[name="users[]"]:checked');
			//Checkboxes name varies thru WP screens (users.php / ms-users.php / wpmu-users.php) and versions
			if (userscheck.length == 0)
				userscheck = jQuery('input[name="allusers[]"]:checked');
			//Checkboxes name varies thru WP screens (users.php / ms-users.php / wpmu-users.php) and versions
			if (userscheck.length == 0)
				userscheck = jQuery('th.check-column input[type="checkbox"]:checked');
			wangguardBulkOpError = false;
			userscheck.each(function() {
					if (wangguardBulkOpError) {
						return;
					}
					wangguard_report(jQuery(this).val() , true);
			});
			//document.location = document.location;
		};
	<?php  } ?>
});
</script>
<?php
}

/**
 * Admin side AJAX handler
 * 
 * @global type $wpdb 
 */
function wangguard_ajax_callback() {
	global $wpdb;
	
	if (!current_user_can('level_10')) die();
	$userid = intval($_POST['userid']);
	$scope = $_POST['scope'];
	switch ($scope) {
		case "queue_blog_remove":
			//remove blog from queue
			$blogid = intval($_POST['blogid']);
			$table_name = $wpdb->base_prefix . "wangguardreportqueue";
			$wpdb->query( $wpdb->prepare("delete from $table_name where blog_id = '%d'" , $blogid ) );
			echo "0";
			break;
		case "queue_user_remove":
			//remove user from queue
			$table_name = $wpdb->base_prefix . "wangguardreportqueue";
			$wpdb->query( $wpdb->prepare("delete from $table_name where ID = '%d'" , $userid ) );
			echo "0";
			break;
		case "domain":
			//flag domain
			$userDomain = new WP_User($userid);
			$domain = wangguard_extract_domain($userDomain->user_email);
			$domain = '%@' . str_replace(array("%" , "_"), array("\\%" , "\\_"), $domain);
			//get the recordset of the users to flag
			$wpusersRs = $wpdb->get_col( $wpdb->prepare("select ID from $wpdb->users where user_email LIKE '%s'" , $domain ) );
			echo wangguard_report_users($wpusersRs , $scope);
			break;
		case "blog":
			//flag domain
			$blogid = intval($_POST['blogid']);
			$blog_prefix = $wpdb->get_blog_prefix( $blogid );
			$authors = $wpdb->get_results( "SELECT user_id, meta_value as caps FROM $wpdb->users u, $wpdb->usermeta um WHERE u.ID = um.user_id AND meta_key = '{$blog_prefix}

	capabilities'" );
	$authorsArray = array();
	foreach( (array)$authors as $author ) {
		$caps = maybe_unserialize( $author->caps );
		
		if ( !isset( $caps['administrator'] ) ) continue;
		$authorsArray[] = $author->user_id;
	}

	echo wangguard_report_users($authorsArray , "email");
	break;
	case "rollback-email":
		$wpusersRs = $wpdb->get_col( $wpdb->prepare("select ID from $wpdb->users where ID = %d" , $userid ) );
		echo wangguard_rollback_report($wpusersRs);
		break;
	default:
		//flag a user
		//get the recordset of the user to flag
		
		if (wangguard_is_multisite()) {
			$spamFieldName = "spam";
		} else {
			$spamFieldName = "user_status";
		}
		
		if (function_exists("update_user_status")) {
			update_user_status($userid, $spamFieldName, 1);
			//when flagging the user as spam, the wangguard hook is called to report the user
		} else {
			$wpdb->query( $wpdb->prepare("update $wpdb->users set $spamFieldName = 1 where ID = %d" , $userid ) );
		}

		$wpusersRs = $wpdb->get_col( $wpdb->prepare("select ID from $wpdb->users where ID = %d" , $userid ) );
		wangguard_make_spam_user($userid);
		echo wangguard_report_users($wpusersRs , $scope);
		break;
}

die();
}

/**
 * Add question handler
 * 
 * @global type $wpdb 
 */
function wangguard_ajax_questionadd() {
	global $wpdb;
	
	if (!current_user_can('level_10')) die();
	$q = trim($_POST['q']);
	$a = trim($_POST['a']);
	
	if (get_magic_quotes_gpc()) {
		$q = stripslashes($q);
		$a = stripslashes($a);
	}

	
	if (empty ($q) || empty ($a)) {
		echo "0";
		die();
	}

	$table_name = $wpdb->base_prefix . "wangguardquestions";
	$wpdb->insert( $table_name , array( 'Question'=>$q  , "Answer"=>$a) , array('%s','%s') );
	echo $wpdb->insert_id;
	die();
}

/**
 * Delete question handler
 * 
 * @global type $wpdb 
 */
function wangguard_ajax_questiondelete() {
	global $wpdb;
	
	if (!current_user_can('level_10')) die();
	$questid = intval($_POST['questid']);
	$table_name = $wpdb->base_prefix . "wangguardquestions";
	$wpdb->query( $wpdb->prepare("delete from $table_name where id = %d" , $questid) );
	echo $questid;
	die();
}

/**
 * Executes an scheduled job
 * @param int $cronid
 */
function wangguard_cronjob_runner($cronid) {
	global $wpdb , $wangguard_api_key , $wangguard_cronjob_actions_options, $wangguard_is_network_admin;
	
	if (wangguard_is_multisite()) {
		$spamFieldName = "spam";
	} else {
		$spamFieldName = "user_status";
	}

	//get job ID
	$cronid = (int)$cronid;
	$cronjobs_table_name = $wpdb->base_prefix . "wangguardcronjobs";
	$wgcron = $wpdb->get_results("select * from $cronjobs_table_name where id = $cronid");
	
	if (!isset($wgcron[0]))return;
	//init vars
	$cronjob = $wgcron[0];
	$checkedUsers = $detectedSploggers = 0;
	$cleanUsers = array();
	$sploggersUsers = array();
	$message = 'WangGuard Cron Job # '.$cronid . "\n\n";
	//setup cron args
	$args = array((int)$cronjob->id);
	//delete the job, prevents being locked and runned again, WP should re schedule it
	$timestamp = wp_next_scheduled( 'wangguard_cronjob_runner' , $args );
	wp_unschedule_event($timestamp, 'wangguard_cronjob_runner' , $args );
	//store last run time
	$wpdb->query("update $cronjobs_table_name set LastRun = CURRENT_TIMESTAMP where id = $cronid");
	//re schedule the job at the configured time
	$timestampNextRun = wangguard_get_next_schedule($cronjob->RunOn , $cronjob->RunAt );
	wp_schedule_single_event( $timestampNextRun, 'wangguard_cronjob_runner' , $args);
	$humanizedNextRun = date(get_option('date_format') . ' ' . get_option('time_format'), $timestampNextRun);
	//api key is valid?
	$valid = wangguard_verify_key($wangguard_api_key);
	
	if (($valid == 'failed') || ($valid == 'invalid')) {
		$message .= __('Your WangGuard API KEY is invalid.', 'wangguard');
	} else {
		$userStatusTable = $wpdb->base_prefix . "wangguarduserstatus";
		$message .= __("Action", 'wangguard') . ": " . $wangguard_cronjob_actions_options[$cronjob->Action] . "\n\n";
		$timeFrom = mktime(0,0,0,date('n'),date('j'),date('Y')) - ($cronjob->UsersTF * 86400);
		set_time_limit(300);
		$goodUsers = $wpdb->get_col("select ID from $wpdb->users where user_registered >= FROM_UNIXTIME( $timeFrom )");
		
		if (count($goodUsers)) {
			$message .= sprintf(__("Verifying %d new users since",'wangguard') , count($goodUsers)) . ' ' . date(get_option('date_format') , $timeFrom) . "\n\n";
			foreach ($goodUsers as $userid) {
				$user_check_status = "-";
				set_time_limit(120);
				$user_object = new WP_User($userid);
				//get the WangGuard user status, if status is force-checked then ignore the user
				$user_status = $wpdb->get_var( $wpdb->prepare("select user_status from $userStatusTable where ID = %d" , $userid));
				
				if (($user_status == 'force-checked') || ($user_status == 'buyer') ) {
					$user_check_status = "force-checked";
				} else {
					//verify the user only if it's not already flagged
					$user_check_status = (($user_status != "reported") ? wangguard_verify_user($user_object) :
					"reported");
				}

				$checkedUsers++;
				
				if ($user_check_status == "reported") {
					//user was detected as splogger
					$detectedSploggers++;
					$sploggersUsers[] = $user_object->display_name . " (" . $user_object->user_email . ")";
					//what to do with this user
					switch ($cronjob->Action) {
						case "f":							
							// Now we mark a user as spam, there is a problem related to BuddyPress permissions, so the splogger activity will not removed. http://buddypress.trac.wordpress.org/ticket/5233
							if (function_exists('update_user_status')){
									update_user_status( $userid, 'spam', '1' );
									} else {
							$wpdb->query( $wpdb->prepare("update $wpdb->users set $spamFieldName = 1 where ID = %d" , $userid ) );
							}
							
							break;

							
						case "d":
							//Delete detected Sploggers----------------------------------------------------------------------------------------------------------
							wangguard_delete_user_and_blogs($userid);
							break;
				}

			} else {
				$cleanUsers[] = $user_object->display_name . " (" . $user_object->user_email . ")";
			}

		}

		
		if (count($cleanUsers))$message .= __("--- Verified Users ---",'wangguard') . "\n" . implode("\n", $cleanUsers) . "\n\n";
		
		if (count($sploggersUsers))$message .= __("--- Detected Sploggers ---",'wangguard') . "\n" . implode("\n", $sploggersUsers) . "\n\n";
	} else {
		$message .= __("No new users to verify since ",'wangguard') . date(get_option('date_format') , $timeFrom);
	}

}

//bottom link
$urlFunc = "admin_url";

if ($wangguard_is_network_admin && function_exists("network_admin_url"))$urlFunc = "network_admin_url";
$site_url = $urlFunc( "admin.php?page=wangguard_users" );

$message .= "\n\n" . __("Next run ","wangguard") . $humanizedNextRun;
$message .= "\n\n" . __("Click here to manage users: ","wangguard") . "\n" . $site_url;
$message .= "\n\nWangGuard - www.wangguard.com";
//Notify admin
$admin_email = get_site_option( 'admin_email' );

if ( $admin_email == '' )$admin_email = 'support@' . $_SERVER['SERVER_NAME'];
$from_name = get_site_option( 'site_name' ) == '' ? 'WordPress' : esc_html( get_site_option( 'site_name' ) );
$message_headers = "From: \"{$from_name}\" <{$admin_email}>\n" . "Content-Type: text/plain; charset=\"" . get_option('blog_charset') . "\"\n";

if (is_multisite()){
$current_site = new stdClass();
$current_site = get_current_site();
} else {
	$current_site = new stdClass();
}
if ( empty( $current_site->site_name ) ) {
	$current_site->site_name = 'WordPress';
}
$subject = sprintf('WangGuard Cron Job # '.$cronid . ' - '.__('Verified: %d - Sploggers: %d'), $checkedUsers, $detectedSploggers);
@wp_mail($admin_email, $subject, $message, $message_headers);
}

add_action('wangguard_cronjob_runner', 'wangguard_cronjob_runner');
function wangguard_delete_user_and_blogs($userid) {
	global $wpdb;
	
	if (function_exists("get_blogs_of_user") && function_exists("update_blog_status") && (method_exists ($wpdb , 'get_blog_prefix'))) {
		$blogs = get_blogs_of_user( $userid, true );
		
		if (is_array($blogs))foreach ( (array) $blogs as $key => $details ) {
			$isMainBlog = false;
			
			if (isset ($current_site)) {
				$isMainBlog = ($details->userblog_id != $current_site->blog_id);
				// main blog not a spam !
			}

			elseif (defined("BP_ROOT_BLOG")) {
				$isMainBlog = ( 1 == $details->userblog_id || BP_ROOT_BLOG == $details->userblog_id );
			} else $isMainBlog = ($details->userblog_id == 1);
			$userIsAuthor = false;
			
			if (!$isMainBlog) {
				//Only works on WP 3+
				$blog_prefix = $wpdb->get_blog_prefix( $details->userblog_id );
				$authorcaps = $wpdb->get_var( sprintf("SELECT meta_value as caps FROM $wpdb->users u, $wpdb->usermeta um WHERE u.ID = %d and u.ID = um.user_id AND meta_key = '{$blog_prefix}capabilities'" , $userid ));
			$caps = maybe_unserialize( $authorcaps );
			$userIsAuthor = ( isset( $caps['administrator'] ) );
		}

		//Update blog to spam if the user is the author and its not the main blog
		
		if ((!$isMainBlog) && $userIsAuthor) {
			@update_blog_status( $details->userblog_id, 'spam', '1' );
			//remove blog from queue
			$table_name = $wpdb->base_prefix . "wangguardreportqueue";
			$wpdb->query( $wpdb->prepare("delete from $table_name where blog_id = '%d'" , $details->userblog_id ) );
		}

	}

}

if (  wangguard_is_multisite() ) {
	if (function_exists('bp_core_mark_user_spam_admin')){
		@include_once( ABSPATH . 'wp-admin/includes/ms.php' );
		bp_core_mark_user_spam_admin($userid);
		wpmu_delete_user($userid);
	} else {
		@include_once( ABSPATH . 'wp-admin/includes/ms.php' );
		wpmu_delete_user($userid);
	}

}  else {
	
	if ( function_exists( 'wp_delete_user' ) && function_exists('bp_core_mark_user_spam_admin') ) {
		@include_once( ABSPATH . 'wp-admin/includes/user.php' );
		bp_core_mark_user_spam_admin($userid);
		wp_delete_user($userid);
	} else {
		@include_once( ABSPATH . 'wp-admin/includes/user.php' );
		wp_delete_user($userid);
	}

}

}


function wangguard_cron_add_schedules( $schedules ) {
	// Adds once weekly to the existing schedules.
	$schedules['wangguard_3days'] = array( 'interval' => 259200, 'display' => __( 'Every 3 days' , "wangguard" ) );
	$schedules['wangguard_5days'] = array( 'interval' => 432000, 'display' => __( 'Every 5 days' , "wangguard" ) );
	$schedules['wangguard_weekly'] = array( 'interval' => 604800, 'display' => __( 'Weekly' , "wangguard" ) );
	$schedules['wangguard_2weeks'] = array( 'interval' => 1209600, 'display' => __( 'Two Weeks' , "wangguard" ) );
	return $schedules;
}

add_filter( 'cron_schedules', 'wangguard_cron_add_schedules' );
/**
 * Add cron job handler
 * 
 * @global type $wpdb 
 */
function wangguard_ajax_cronjobadd() {
	global $wpdb;
	global $wangguard_cronjob_run_options , $wangguard_cronjob_actions_options , $wangguard_cronjob_lookup_options;
	
	if (!current_user_can('level_10')) die();
	$r = trim($_POST['r']);
	$a = trim($_POST['a']);
	$w = trim($_POST['w']);
	$t1 = (int)trim($_POST['t1']);
	$t2 = (int)trim($_POST['t2']);
	
	if (get_magic_quotes_gpc()) {
		$r = stripslashes($r);
		$a = stripslashes($a);
		$w = stripslashes($w);
	}

	
	if (!isset($wangguard_cronjob_run_options[$r]) || !isset($wangguard_cronjob_actions_options[$a]) || !isset($wangguard_cronjob_lookup_options[$w])) {
		echo "0";
		die();
	}

	$runAtTime = str_pad($t1,2,"0",STR_PAD_LEFT) . ":" . str_pad($t2,2,"0",STR_PAD_LEFT);
	$table_name = $wpdb->base_prefix . "wangguardcronjobs";
	$wpdb->insert( $table_name , array( 'RunOn'=>$r , "RunAt"=>$runAtTime  , "Action"=>$a  , "UsersTF"=>$w) , array('%s','%s','%s') );
	$args = array((int)$wpdb->insert_id);
	$ret = wp_schedule_single_event( wangguard_get_next_schedule('now' , $runAtTime ), 'wangguard_cronjob_runner' , $args);
	
	if ($ret === FALSE) {
		//if cron job couldn't be added, remove it from DB
		$wpdb->query( $wpdb->prepare("delete from $table_name where id = %d" , $wpdb->insert_id) );
		echo 0;
	} else {
		$timestamp = wp_next_scheduled( 'wangguard_cronjob_runner' , $args );
		$date = date(get_option('date_format') . ' ' . get_option('time_format'), $timestamp);
		?>
		<div class="wangguard-cronjob" id="wangguard-cronjob-<?php  echo $wpdb->insert_id ?>">
		<?php  _e("Cron Job Code", 'wangguard') ?>: <strong><?php  echo $wpdb->insert_id ?></strong><br/>
		<?php  _e("Run", 'wangguard') ?>: <strong><?php  echo $wangguard_cronjob_run_options[$r] ?> @ <?php  echo $runAtTime  ?> </strong><br/>
		<?php  _e("Action", 'wangguard') ?>: <strong><?php  echo $wangguard_cronjob_actions_options[$a] ?></strong><br/>
		<?php  _e("Check users registered in the last", 'wangguard') ?>: <strong><?php  echo $wangguard_cronjob_lookup_options[$w] ?></strong><br/>
		<?php  _e("Last run", 'wangguard') ?>: <strong>-</strong><br/>
		<?php  _e("Next run", 'wangguard') ?>: <strong><?php  echo $date  ?></strong><br/>
		<a href="javascript:void(0)" rel="<?php  echo $wpdb->insert_id ?>" class="wangguard-delete-cronjob"><?php  _e('delete cron job', 'wangguard') ?></a>
		</div>
		<?php
	}

	die();
}

/**
 * Returns the unix time for the next schedule
 * @param type $recurrence
 * @param type $time
 */
function wangguard_get_next_schedule($recurrence , $time) {
	$currTime = time();
	$time = explode(":", $time);
	$hour = (int)@$time[0];
	$minute = (int)@$time[1];
	$scheduledTime = mktime($hour, $minute, 0, date("n",$currTime),  date("j",$currTime),  date("Y",$currTime));
	
	if ($recurrence == 'now') {
		//try to schedule it for today, used when the cron job is created
		
		if ($currTime > $scheduledTime) {
			//if the scheduled time for today has passed, schedule it for tomorrow
			$scheduledTime = strtotime("+1 day" , $scheduledTime);
		}

	} else {
		$schedules = wp_get_schedules();
		
		if (isset($schedules[$recurrence])) {
			$interval = $schedules[$recurrence]['interval'];
			echo "$interval";
			$scheduledTime = strtotime("+{$interval} seconds" , $scheduledTime);
	}

}

return $scheduledTime;
}

/**
 * Delete cron job handler
 * 
 * @global type $wpdb 
 */
function wangguard_ajax_cronjobdelete() {
	global $wpdb;
	
	if (!current_user_can('level_10')) die();
	$cronid = intval($_POST['cronid']);
	$table_name = $wpdb->base_prefix . "wangguardcronjobs";
	$wpdb->query( $wpdb->prepare("delete from $table_name where id = %d" , $cronid) );
	$args = array((int)$cronid);
	$timestamp = wp_next_scheduled( 'wangguard_cronjob_runner' , $args );
	wp_unschedule_event($timestamp, 'wangguard_cronjob_runner' , $args );
	echo $cronid;
	die();
}

/**
 * Recheck user on WangGuard handler
 * 
 * @global type $wpdb
 * @global type $wangguard_api_key
 */
function wangguard_ajax_recheck_callback() {
	global $wpdb;
	global $wangguard_api_key;
	
	if (!current_user_can('level_10')) die();
	$userid = intval($_POST['userid']);
	$valid = wangguard_verify_key($wangguard_api_key);
	
	if ($valid == 'failed') {
		echo "-2";
		die();
	} else
	if ($valid == 'invalid') {
		echo "-1";
		die();
	}

	$user_object = new WP_User($userid);
	
	if (empty ($user_object->user_email)) {
		echo "0";
		die();
	}

	
	if ( wangguard_is_admin($user_object) ) {
		echo '<span class="wangguard-status-no-status wangguardstatus-'.$userid.'">'. __('No status', 'wangguard') .'</span>';
		die();
	}

	$user_check_status = wangguard_verify_user($user_object);
	
	if ($user_check_status == "reported") {
		echo '<span class="wangguard-status-splogguer">'. __('Reported as Splogger', 'wangguard') .'</span>';
	}

	elseif ($user_check_status == "checked") {
		echo '<span class="wangguard-status-checked">'. __('Checked', 'wangguard') .'</span>';
	}

	elseif (substr($user_check_status,0,5) == "error") {
		echo '<span class="wangguard-status-error">'. __('Error', 'wangguard') . " - " . substr($user_check_status,6) . '</span>';
	} else return '<span class="wangguard-status-not-checked">'. __('Not checked', 'wangguard') .'</span>';
	die();
}

/**
 * Get an IP information from WG server
 * @global type $wangguard_api_key 
 */
function wangguard_ajax_ip_info() {
	global $wangguard_api_key;
	
	if (!current_user_can('level_10')) die();
	$ip = $_POST['ip'];
	$lang = substr(WPLANG, 0,2);
	$response = wangguard_http_post("wg=<in><apikey>$wangguard_api_key</apikey><ip>".$ip."</ip><lang>".$lang."</lang></in>", 'get-ip-info.php');
	echo $response;
	die();
}

/********************************************************************/
/*** AJAX ADMIN HANDLERS ENDS ***/
/********************************************************************/

/********************************************************************/
/*** BP FRONTEND REPORT BUTTONS BEGINS ***/
/********************************************************************/

/**
 * Hook to insert the report user on BP comment
 * 
 * @global type $bp
 * @global type $user_ID
 * @param string $link
 * @param type $args
 * @param type $comment
 * @param type $post
 * @return string 
 */
function wangguard_bp_comment_reply_link($link , $args, $comment, $post='') {
	global $bp , $user_ID;
	$userid = $comment->user_id;
	
	if (!$bp) return $link;
	$user_object = new WP_User($userid);
	
	if (empty ($user_object->ID)) return $link;
	
	if ($user_ID == $user_object->ID) return $link;
	
	if (wangguard_is_admin($user_object)) return $link;
	$link .= '<a href="javascript:void(0)" style="margin-left:10px" class="comment-reply-link wangguard-user-report" rel="'.$userid.'" title="'.__('Report user', 'wangguard').'">'.__('Report user', 'wangguard').'</a>';
	return $link;
}

/**
 * Hook to insert the report user on BP blog post and activity
 * 
 * @global type $l10n
 * @global type $post
 * @param type $id
 * @param type $type
 */
function wangguard_bp_report_button($id = '', $type = '') {
	
	if (!is_user_logged_in())return;
	
	if ( !$type && !is_single() )$type = 'activity';
	elseif ( !$type && is_single() )$type = 'blogpost';
	
	if (function_exists("is_textdomain_loaded")) {
		
		if (!is_textdomain_loaded("wangguard"))load_textdomain ("wangguard", PLUGINDIR . "/wangguard/languages/wangguard-".WPLANG.".mo");
	} else {
		global $l10n;
		
		if (!isset( $l10n['wangguard']))load_textdomain ("wangguard", PLUGINDIR . " /wangguard/languages/wangguard-".WPLANG.".mo");
	}

	
	if ( $type == 'activity' ) :
	$activity = bp_activity_get_specific( array( 'activity_ids' => bp_get_activity_id() ) );
	
	if ( !empty( $activity['activities'][0] ) ) :
	$user_id = $activity['activities'][0]->user_id;
	$user_object = new WP_User($user_id);
	
	if (empty ($user_object->ID)) return;
	
	if (!wangguard_is_admin($user_object)) :
	
	if ( true || !bp_like_is_liked( bp_get_activity_id(), 'activity' ) ) :
	?>
				<a href="javascript:void(0)" class="button wangguard-user-report" rel="<?php  echo $user_object->ID; ?>" title="<?php  echo __('Report user', 'wangguard'); ?>"><?php  echo  __('Report user', 'wangguard'); ?></a>
				<?php 
	endif;
	endif;
	endif;
	elseif ( $type == 'blogpost' ) :
	global $post;
	
	if (empty ($post->post_author)) return;
	$user_id = $post->post_author;
	$user_object = new WP_User($user_id);
	
	if (empty ($user_object->ID)) return;
	
	if (!wangguard_is_admin($user_object)) :
	
	if (true || !bp_like_is_liked( $id, 'blogpost' ) ) :
	?>
				<div class="activity-list"><div class="activity-meta"><a href="javascript:void(0)" class="button wangguard-user-report" rel="<?php  echo $user_object->ID; ?>" title="<?php  echo __('Report user', 'wangguard'); ?>"><?php  echo  __('Report user', 'wangguard'); ?></a></div></div>
			<?php 
	endif;
	endif;
	endif;
}


if ( get_site_option ("wangguard-enable-bp-report-btn")==1) {
	add_filter( 'bp_activity_entry_meta', 'wangguard_bp_report_button' );
	add_action( 'bp_before_blog_single_post', 'wangguard_bp_report_button' );
	add_filter( 'comment_reply_link', 'wangguard_bp_comment_reply_link' , 10 , 4);
}

/**
 * Hook to insert the report user on user's profile
 * 
 * @global type $bp
 */
function wangguard_bp_report_button_header() {
	global $bp;
	
	if (!$bp) return;
	$user_object = new WP_User($bp->displayed_user->id);
	
	if (empty ($user_object->ID)) return;
	
	if (wangguard_is_admin($user_object)) return;
	echo bp_get_button( array(	'id' => 'wangguard_report_user',
								'component' => 'members',
								'must_be_logged_in' => true,
								'block_self' => true,
								'wrapper_id' => 'wangguard_report_user-button',
								'link_href' => "javascript:void(0)",
								'link_class' =>'wangguard-user-report wangguard-user-report-id-' . $user_object->ID,
								'link_title' => __('Report user', 'wangguard'),
								'link_text' => __('Report user', 'wangguard')) );
}


if (get_site_option ("wangguard-enable-bp-report-btn")==1) {
	add_action( 'bp_member_header_actions',    'wangguard_bp_report_button_header' , 20 );
}

/********************************************************************/
/*** BP FRONTEND REPORT BUTTONS ENDS ***/
/********************************************************************/

/********************************************************************/
/*** ADMIN BAR REPORT BEGIN ***/
/********************************************************************/

/**
 * Add WangGuard to BP admin bar
 * 
 * @global type $current_blog
 * @global type $wangguard_is_network_admin
 * @global type $wp_version
 */
function wangguard_add_bp_admin_bar_menus() {
	global $current_blog , $wangguard_is_network_admin;
	
	if (!is_user_logged_in())return;
	$urlFunc = "admin_url";
	
	if ($wangguard_is_network_admin && function_exists("network_admin_url"))$urlFunc = "network_admin_url";
	
	if (function_exists("is_super_admin"))$showAdmin = is_super_admin(); else $showAdmin = current_user_can('level_10');
	global $wp_version;
	$cur_wp_version = preg_replace('/-.*$/', '', $wp_version);
	$WP_List_TableClassSupported = version_compare($cur_wp_version , '3.1.0' , ">=");
	$queueEnabled = ((get_site_option("wangguard-enable-bp-report-blog") == 1) || (get_site_option ("wangguard-enable-bp-report-btn")==1))  &&   $WP_List_TableClassSupported;
	// This is a blog, render a menu with links to all authors
	
	if ($showAdmin) {
		echo '<li id="wangguard-report-menu"><a href="'. $urlFunc( "admin.php?page=" . ($queueEnabled ? "wangguard_queue" :
		"wangguard_conf") ).'">';
		_e('WangGuard', 'wangguard');
		echo '</a>';
		echo '<ul class="wangguard-report-menu-list">';
		
		if ( $current_blog && (get_site_option("wangguard-enable-bp-report-blog") == 1) ) {
			
			if (BP_ROOT_BLOG != $current_blog->blog_id) {
				echo '<li>';
				echo '<a href="javascript:void(0)" class="wangguard-blog-report" rel="'.$current_blog->blog_id.'">';
				echo __('Report blog and author', 'wangguard') . '</a>';
				echo '</li>';
			}

		}

		echo '<li>';
		echo '<a href="'.$urlFunc( "admin.php?page=wangguard_users" ).'">';
		echo __('Users', 'wangguard') . '</a>';
		echo '<div class="admin-bar-clear"></div>';
		echo '</li>';
		
		if ($queueEnabled) {
			echo '<li>';
			echo '<a href="'.$urlFunc( "admin.php?page=wangguard_queue" ).'">';
			echo __('Moderation Queue', 'wangguard') . '</a>';
			echo '<div class="admin-bar-clear"></div>';
			echo '</li>';
		}

		echo '<li>';
		echo '<a href="'.$urlFunc( "admin.php?page=wangguard_wizard" ).'">';
		echo __('Wizard', 'wangguard') . '</a>';
		echo '<div class="admin-bar-clear"></div>';
		echo '</li>';
		echo '<li>';
		echo '<a href="'.$urlFunc( "admin.php?page=wangguard_cronjobs" ).'">';
		echo __('Cron Jobs', 'wangguard') . '</a>';
		echo '<div class="admin-bar-clear"></div>';
		echo '</li>';
		echo '<li>';
		echo '<a href="'.$urlFunc( "admin.php?page=wangguard_stats" ).'">';
		echo __('Stats', 'wangguard') . '</a>';
		echo '<div class="admin-bar-clear"></div>';
		echo '</li>';
		echo '<li>';
		echo '<a href="'.$urlFunc( "admin.php?page=wangguard_conf" ).'">';
		echo __('Configuration', 'wangguard') . '</a>';
		echo '<div class="admin-bar-clear"></div>';
		echo '</li>';
		echo '</ul>';
		echo '</li>';
	} else {
		
		if ( $current_blog && (get_site_option("wangguard-enable-bp-report-blog") == 1) ) {
			
			if (BP_ROOT_BLOG != $current_blog->blog_id) {
				echo '<li id="wangguard-report-menu-noop" class="no-arrow">';
				echo '<a href="javascript:void(0)" class="wangguard-blog-report" rel="'.$current_blog->blog_id.'">';
				echo __('Report blog and author', 'wangguard') . '</a>';
				echo '</a>';
				echo '</li>';
			}

		}

	}

}

add_action('bp_adminbar_menus', 'wangguard_add_bp_admin_bar_menus' , 10 );
/**
 * Add WangGuard to WP admin bar
 * @global type $wp_admin_bar
 * @global type $current_blog
 * @global type $current_site
 * @global type $wangguard_is_network_admin
 * @global type $wp_version
 */
function wangguard_add_wp_admin_bar_menus() {
	global $wp_admin_bar , $current_blog , $current_site , $wangguard_is_network_admin;
	
	if (!is_user_logged_in())return;
	$urlFunc = "admin_url";
	
	if ($wangguard_is_network_admin && function_exists("network_admin_url"))$urlFunc = "network_admin_url";
	$isMainBlog = false;
	$wggcurrentblog = get_current_blog_id();
	
	if (defined("BP_ROOT_BLOG")) {
		$isMainBlog = ( 1 == $wggcurrentblog || BP_ROOT_BLOG == $wggcurrentblog );
	} else $isMainBlog = (@$current_blog->blog_id == 1);
	$showReport = !$isMainBlog && (get_site_option ("wangguard-enable-bp-report-blog")==1);
	global $wp_version;
	$cur_wp_version = preg_replace('/-.*$/', '', $wp_version);
	$WP_List_TableClassSupported = version_compare($cur_wp_version , '3.1.0' , ">=");
	$queueEnabled = ((get_site_option("wangguard-enable-bp-report-blog") == 1) || (get_site_option ("wangguard-enable-bp-report-btn")==1))  &&   $WP_List_TableClassSupported;
	
	if (function_exists("is_super_admin"))$showAdmin = is_super_admin(); else $showAdmin = current_user_can('level_10');
	
	if ($showAdmin) {
		$wp_admin_bar->add_menu( array( 'id' => 'wangguard-admbar-splog', 'title' => __( 'WangGuard', 'wangguard' ), 'href' => $urlFunc( "admin.php?page=" . ($queueEnabled ? "wangguard_queue" : "wangguard_conf") ) ) );
		
		if ($showReport)$wp_admin_bar->add_menu( array( 'parent' => 'wangguard-admbar-splog', 'id' => "wangguard-admbar-report-blog", 'meta'=>array("class"=>"wangguard-blog-report wangguard-blog-report-id-".$current_blog->blog_id ), 'title' => __('Report blog and author', 'wangguard'), 'href' => '#' ) );
		$wp_admin_bar->add_menu( array( 'parent' => 'wangguard-admbar-splog', 'id' => "wangguard-admbar-users", 'title' => __('Users', 'wangguard'), 'href' => $urlFunc( "admin.php?page=wangguard_users" ) ) );
		
		if ($queueEnabled)$wp_admin_bar->add_menu( array( 'parent' => 'wangguard-admbar-splog', 'id' => "wangguard-admbar-queue", 'title' => __('Moderation Queue', 'wangguard'), 'href' => $urlFunc( "admin.php?page=wangguard_queue" ) ) );
		$wp_admin_bar->add_menu( array( 'parent' => 'wangguard-admbar-splog', 'id' => "wangguard-admbar-wizard", 'title' => __('Wizard', 'wangguard'), 'href' => $urlFunc( "admin.php?page=wangguard_wizard" ) ) );
		$wp_admin_bar->add_menu( array( 'parent' => 'wangguard-admbar-splog', 'id' => "wangguard-admbar-cronjobs", 'title' => __('Cron Jobs', 'wangguard'), 'href' => $urlFunc( "admin.php?page=wangguard_cronjobs" ) ) );
		$wp_admin_bar->add_menu( array( 'parent' => 'wangguard-admbar-splog', 'id' => "wangguard-admbar-stats", 'title' => __('Stats', 'wangguard'), 'href' => $urlFunc( "admin.php?page=wangguard_stats" ) ) );
		$wp_admin_bar->add_menu( array( 'parent' => 'wangguard-admbar-splog', 'id' => "wangguard-admbar-settings", 'title' => __('Configuration', 'wangguard'), 'href' => $urlFunc( "admin.php?page=wangguard_conf" ) ) );
	}

	elseif ($showReport) {
		$wp_admin_bar->add_menu( array( 'id' => "wangguard-admbar-report-blog", 'meta'=>array("class"=>"wangguard-blog-report wangguard-blog-report-id-".$current_blog->blog_id ), 'title' => __('Report blog and author', 'wangguard'), 'href' => '#' ) );
	}

}

add_action('admin_bar_menu', 'wangguard_add_wp_admin_bar_menus', 100 );
/********************************************************************/
/*** ADMIN BAR REPORT BEGIN ***/
/********************************************************************/

/********************************************************************/
/*** ADMIN GROUP MENU BEGINS ***/
/********************************************************************/

/**
 * Add WangGuard to WP menu
 * 
 * @global type $menu
 * @global array $admin_page_hooks
 * @global array $_registered_pages
 * @global type $wpdb
 * @return boolean 
 */
function wangguard_add_admin_menu() {
	
	if ( !is_super_admin() )return false;
	global $menu, $admin_page_hooks, $_registered_pages , $wpdb , $wangguard_api_key, $users_Info, $WGDevelopmentPage, $WGContactPage, $WGAboutPage, $WGPluginPage, $WGHelpPage, $WGHelpUsPage, $WGCreditsPage, $WGAddonPage;
	$params = array('page_title' => __( 'WangGuard', 'wangguard' ),'menu_title' => __( 'WangGuard', 'wangguard' ),'access_level' => 10,'file' => 'wangguard_conf','function' => 'wangguard_conf','position' => 20.4);
	extract( $params, EXTR_SKIP );
	$file = plugin_basename( $file );
	$admin_page_hooks[$file] = sanitize_title( $menu_title );
	$hookname = get_plugin_page_hookname( $file, '' );
	
	if (!empty ( $function ) && !empty ( $hookname ))add_action( $hookname, $function );
	$position = '1523426.4532';
	do {
		$position++;
	}
	//add_menu_page('WangGuard','WangGuard','manage_options','wangguard_conf','wangguard_conf',,)
	while ( !empty( $menu[$position] ) );
	
	if ( empty( $icon_url ) )$icon_url = '';
	$menu[$position] = array ( $menu_title, "level_10", "wangguard_conf", $page_title, 'menu-top ' . $hookname, $hookname, $icon_url );
	$_registered_pages[$hookname] = true;
	$countSpan = "";
	$table_name = $wpdb->base_prefix . "wangguardreportqueue";
	$doCount = true;
	
	if (empty($wangguard_api_key))$doCount = $wpdb->get_var("show tables like '$table_name'") == $table_name;
	
	if ($doCount) {
		$Count = $wpdb->get_col( "select count(*) as q from $table_name" );
		
		if ($Count[0] > 0)$countSpan = '<span class="update-plugins" ><span class="pending-count">'.$Count[0].'</span></span>';
	}

	@include_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
	$queueEnabled = ((get_site_option("wangguard-enable-bp-report-blog") == 1) || (get_site_option ("wangguard-enable-bp-report-btn")==1))  &&   class_exists('WP_List_Table');
	$confHook = add_submenu_page( 'wangguard_conf', __( 'Configuration', 'wangguard'), __( 'Configuration', 'wangguard' ), 'manage_options', 'wangguard_conf', 'wangguard_conf' );
	add_action("admin_print_scripts-$confHook", 'wangguard_add_jQueryJS');
	$usersHook = add_submenu_page( 'wangguard_conf', __( 'Users', 'wangguard'), __( 'Users', 'wangguard' ), 'manage_options', 'wangguard_users', 'wangguard_users' );
	add_action("load-$usersHook", 'wangguard_users_screen_options');
	add_action("admin_print_scripts-$usersHook", 'wangguard_add_UsersJS');
	
	if ($queueEnabled) {
		$queueHook = add_submenu_page( 'wangguard_conf', __( 'Moderation Queue', 'wangguard'), __( 'Moderation Queue', 'wangguard' ) . $countSpan, 'manage_options', 'wangguard_queue', 'wangguard_queue' );
		add_action("load-$queueHook", 'wangguard_users_screen_options');
		add_action("admin_print_scripts-$queueHook", 'wangguard_add_UsersJS');
	}

	$wizardHook = add_submenu_page( 'wangguard_conf', __( 'Wizard', 'wangguard'), __( 'Wizard', 'wangguard' ), 'manage_options', 'wangguard_wizard', 'wangguard_wizard' );
	add_action("admin_print_scripts-$wizardHook", 'wangguard_add_jQueryJS');
	$cronHook = add_submenu_page( 'wangguard_conf', __( 'Cron Jobs', 'wangguard'), __( 'Cron Jobs', 'wangguard' ), 'manage_options', 'wangguard_cronjobs', 'wangguard_cronjobs' );
	add_action("admin_print_scripts-$cronHook", 'wangguard_add_jQueryJS');
	$statsPage = add_submenu_page( 'wangguard_conf', __( 'Stats', 'wangguard'), __( 'Stats', 'wangguard' ), 'manage_options', 'wangguard_stats', 'wangguard_stats' );
	add_action("admin_print_scripts-$statsPage", 'wangguard_add_StatsJS');
	$WGAddonPage = add_submenu_page( 'wangguard_conf', __( 'Add-Ons', 'wangguard'), __( 'Add-Ons', 'wangguard' ), 'manage_options', 'wangguard_addons', 'wangguard_addons' );
	$WGPluginPage = add_submenu_page( 'wangguard_conf', __( 'Third party plugins', 'wangguard'), __( 'Third party plugins', 'wangguard' ), 'manage_options', 'wangguard_compatible_plugins', 'wangguard_compatible_plugins' );
	$WGAboutPage = add_submenu_page( 'wangguard_conf', __( 'About', 'wangguard'), __( 'About', 'wangguard' ), 'manage_options', 'wangguard_about', 'wangguard_about' );
	$WGHelpPage = add_submenu_page( 'wangguard_conf', __( 'Help', 'wangguard'), __( 'Help', 'wangguard' ), 'manage_options', 'wangguard_help', 'wangguard_help' );
	$users_Info = add_submenu_page( '', __( 'Users Info', 'wangguard'), __( 'Users Info', 'wangguard' ), 'manage_options', 'wangguard_users_info', 'wangguard_users_info' );
	add_action("admin_print_scripts-$users_Info", 'wangguard_add_jQueryJS');
	$WGDevelopmentPage = add_submenu_page( '', __( 'Development', 'wangguard'), __( 'Development', 'wangguard' ), 'manage_options', 'wangguard_development', 'wangguard_development' );
	$WGContactPage = add_submenu_page( '', __( 'Contact', 'wangguard'), __( 'Contact', 'wangguard' ), 'manage_options', 'wangguard_contact', 'wangguard_contact' );
	$WGHelpUsPage = add_submenu_page( '', __( 'Help Us', 'wangguard'), __( 'Help Us', 'wangguard' ), 'manage_options', 'wangguard_help_us', 'wangguard_help_us' );
	$WGCreditsPage = add_submenu_page( '', __( 'Credits', 'wangguard'), __( 'Credits', 'wangguard' ), 'manage_options', 'wangguard_credits', 'wangguard_credits' );
}

function wangguard_add_StatsJS() {
	wangguard_add_jQueryJS();
	wp_enqueue_script("jquery-ui-core");
	wp_enqueue_script("raphael" , "/" . PLUGINDIR . '/wangguard/js/raphael-min.js' , array('jquery-ui-widget'),'1.5.6');
	wp_enqueue_script("globalize" , "/" . PLUGINDIR . '/wangguard/js/globalize.min.js' , array('jquery-ui-widget' , 'raphael'),'1.5.6');
	wp_enqueue_script("wijmo-wijraphael" , "/" . PLUGINDIR . '/wangguard/js/jquery.wijmo.raphael.min.js' , array('raphael' , 'jquery' , 'jquery-ui-core'),'1.5.6');
	wp_enqueue_script("wijmo-wijchartcore" , "/" . PLUGINDIR . '/wangguard/js/jquery.wijmo.wijchartcore.min.js' , array('raphael' , 'wijmo-wijraphael'),'1.5.6');
	wp_enqueue_script("wijmo.wijbarchart" , "/" . PLUGINDIR . '/wangguard/js/jquery.wijmo.wijbarchart.min.js' , array('wijmo-wijchartcore'),'1.5.6');
	wp_enqueue_script("wangguard-admin" , "/" . PLUGINDIR . '/wangguard/js/wangguard-admin.js','1.5.6');
}


function wangguard_add_UsersJS() {
	wangguard_add_jQueryJS();
	wp_enqueue_script("wangguard-admin" , "/" . PLUGINDIR . '/wangguard/js/wangguard-admin.js','1.5.6');
}


function wangguard_add_jQueryJS() {
	wp_enqueue_script("jquery");
	wp_enqueue_script("jquery-ui-widget");
}

function wangguard_add_formsJS() {
	
	wp_enqueue_script( 'jquery-ui-core'      );
	wp_enqueue_script( 'jquery-ui-tabs'      );
	wp_enqueue_script( 'jquery-ui-mouse'     );
	wp_enqueue_script( 'jquery-ui-draggable' );
	wp_enqueue_script( 'jquery-ui-droppable' );
	wp_enqueue_script( 'jquery-ui-sortable'  );
	wp_enqueue_script("wangguard_forms" , "/" . PLUGINDIR . '/wangguard/js/wangguard-forms.js','1.5.11');
}

/**
 * Adds the users per page options to users and queue screens
 */
function wangguard_users_screen_options() {
	add_screen_option( 'per_page', array('label' => _x( 'Users', 'users per page (screen options)' )) );
}

/**
 * Stores the users per page value
 * @global type $wangguard_users_per_page
 * @param type $status
 * @param type $option
 * @param type $value
 * @return type 
 */
function wangguard_set_users_screen_option($status, $option, $value) {
	
	if ( ($option == 'wangguard_page_wangguard_users_network_per_page') || ($option == 'wangguard_page_wangguard_queue_network_per_page') ) {
		return $value;
	}

}

add_filter('set-screen-option', 'wangguard_set_users_screen_option', 10, 3);

if (!$wangguard_is_network_admin)add_action( 'admin_menu', 'wangguard_add_admin_menu' ); else add_action( 'network_admin_menu', 'wangguard_add_admin_menu' );
/********************************************************************/
/*** ADMIN GROUP MENU ENDS ***/

/********************************************************************//********************************************************************/
/*** DASHBOARD BEGINS ***/
/********************************************************************/

/**
 * Show stats box on dashboard
 */
function wangguard_dashboard_stats() {
	
	if ( !is_super_admin() )return false;
	wp_enqueue_script("jquery");
	wp_enqueue_script("jquery-ui-widget");
	wp_enqueue_script("raphael" , "/" . PLUGINDIR . '/wangguard/js/raphael-min.js' , array('jquery-ui-widget'),'1.5.6' );
	wp_enqueue_script("globalize" , "/" . PLUGINDIR . '/wangguard/js/globalize.min.js' , array('jquery-ui-widget' , 'raphael'),'1.5.6' );
	wp_enqueue_script("wijmo-wijraphael" , "/" . PLUGINDIR . '/wangguard/js/jquery.wijmo.raphael.min.js?' , array('raphael' , 'jquery'),'1.5.6' );
	wp_enqueue_script("wijmo-wijchartcore" , "/" . PLUGINDIR . '/wangguard/js/jquery.wijmo.wijchartcore.min.js' , array('raphael' , 'wijmo-wijraphael'),'1.5.6' );
	wp_enqueue_script("wijmo.wijbarchart" , "/" . PLUGINDIR . '/wangguard/js/jquery.wijmo.wijbarchart.min.js' , array('wijmo-wijchartcore'),'1.5.6' );
	wp_enqueue_script("wangguard-admin" , "/" . PLUGINDIR . '/wangguard/js/wangguard-admin.js','1.5.6' );
	wp_add_dashboard_widget("wangguard_dashboard_stats", __( 'WangGuard Stats' , 'wangguard' ) . " - " . __( 'Last 7 days' , 'wangguard' ) , "wangguard_dashboard_stats_render");
	global $wp_meta_boxes;
	
	if (is_array($wp_meta_boxes['dashboard']['normal']['core'])) {
		$normal_dashboard = $wp_meta_boxes['dashboard']['normal']['core'];
		$wangguard_stats_backup = $normal_dashboard['wangguard_dashboard_stats'];
		unset($wp_meta_boxes['dashboard']['normal']['core']['wangguard_dashboard_stats']);
		$wp_meta_boxes['dashboard']['side']['core']['wangguard_dashboard_stats'] = $wangguard_stats_backup;
	} else
	if (is_array($wp_meta_boxes['dashboard-network']['normal']['core'])) {
		$normal_dashboard = $wp_meta_boxes['dashboard-network']['normal']['core'];
		$wangguard_stats_backup = $normal_dashboard['wangguard_dashboard_stats'];
		unset($wp_meta_boxes['dashboard-network']['normal']['core']['wangguard_dashboard_stats']);
		$wp_meta_boxes['dashboard-network']['side']['core']['wangguard_dashboard_stats'] = $wangguard_stats_backup;
	}

}

/**
 * Renders the stats box content on dashboard
 * 
 * @global type $wangguard_api_key
 * @global type $wangguard_is_network_admin
 */
function wangguard_dashboard_stats_render() {
	global $wangguard_api_key , $wangguard_is_network_admin;
	
	if ( defined('WANGGUARD_API_HOST') ) {$wangguard_api_host = WANGGUARD_API_HOST;}
	if ( defined('WANGGUARD_REST_PATH') ) {$wangguard_rest_path = WANGGUARD_REST_PATH;}
	
	if ( !current_user_can('level_10') )return;
	$lang = substr(WPLANG, 0,2);
	?>
	<script type="text/javascript">
		var wangguardResizeTimer;
		jQuery(document).ready(function () {
           var WGstatsURL = "http://<?php  echo $wangguard_api_host . $wangguard_rest_path ?>get-stat.php?wg="+ encodeURIComponent('<in><apikey><?php  echo $wangguard_api_key ?></apikey><last7>1</last7><lang><?php  echo $lang ?></lang></in>');
           jQuery.ajax({
                dataType: "jsonp",
                url: WGstatsURL,
                jsonpCallback: "callback",
                success: createChart
            });
			function createChart(data) {
				jQuery("#wangguard-stats-container").wijbarchart(data);
			}
		});
	</script>
	<div id="wangguard-stats-container" class="ui-widget ui-widget-content ui-corner-all" style="width: 98%; height: 300px; margin:0 auto;"></div>
	<?php
	$urlFunc = "admin_url";
	
	if ($wangguard_is_network_admin && function_exists("network_admin_url"))$urlFunc = "network_admin_url";
	echo '<div style="text-align:center"><a href="'.$urlFunc( "admin.php?page=wangguard_stats" ).'">'.__( 'Click here to access the WangGuard stats' , 'wangguard' ).'</a></div>';
}

$wpversion = get_bloginfo('version');

if ($wpversion >= '3.6') {
	return;
} else {
	
	if ( $wangguard_is_network_admin )add_action( 'wp_network_dashboard_setup', 'wangguard_dashboard_stats' ); else add_action( 'wp_dashboard_setup', 'wangguard_dashboard_stats' );
}

/********************************************************************/
/*** DASHBOARD ENDS ***/
/********************************************************************/

/********************************************************************/
/****** ALLOW PLUGINS-ADD-ONS TO DO THINGS BEGINS *******************/
/********************************************************************/

do_action( 'wangguard_include');

/********************************************************************/
/****** ALLOW PLUGINS-ADD-ONS TO DO THINGS ENDS**********************/
/********************************************************************/
?>