<?php

/***************************************************/
/*								     			   */
/* Fonction de mise à jour d'un profil utilisateur */
/*									    		   */
/***************************************************/

function wats_admin_save_user_profile()
{
	global $current_user, $wpdb, $wats_settings;

	if ($_POST['submit'])
	{	
		get_currentuserinfo();
		$old_user = $current_user;

		if (!current_user_can('administrator'))
			return;

		if ($_POST['user_id'])
			wp_set_current_user($_POST['user_id']);

		$wats_capabilities_table = wats_init_capabilities_table();
		$wats_notifications_table = wats_init_notification_table();
		
		foreach ($wats_capabilities_table as $key => $value)
		{
			$result = $_POST[$key];
			if (($result == "yes") && (current_user_can($key) == 0))
				$current_user->add_cap($key,1);
			if (($result == "no") && (current_user_can($key) == 1))
				$current_user->remove_cap($key);
		}
		
		if ($wats_settings['ticket_notification_bypass_mode'] == 1)
		{
			$notifications = get_user_meta($current_user->ID,'wats_notifications',true);
			foreach ($wats_notifications_table as $key => $value)
			{
				if ($wats_settings[$key] != 0)
				{
					$result = $_POST[$key];
					if ($result == "yes")
						$notifications[$key] = 1;
					else
						$notifications[$key] = 0;
				}
			}
			update_user_meta($current_user->ID,'wats_notifications',$notifications);
		}
		
		if ($wats_settings['user_expiration_date_enabled'] == 1)
		{
			$expiration_date = isset($_POST['expirationdate']) ? $_POST['expirationdate'] : 0;
			if (wats_is_date($expiration_date))
				update_user_meta($current_user->ID,'wats_expiration_date',$expiration_date);
			else
				update_user_meta($current_user->ID,'wats_expiration_date',null);
		}
		
		if ($wats_settings['profile_country_enabled'] == 1)
		{
			$country = isset($_POST['wats_country_list']) ? stripslashes_deep($_POST['wats_country_list']) : '0';
			if ($country != '0')
				update_user_meta($current_user->ID,$wats_settings['country_meta_key_profile'],$country);
			else
				update_user_meta($current_user->ID,$wats_settings['country_meta_key_profile'],null);
		}
		
		if ($wats_settings['profile_company_enabled'] == 1)
		{
			$company = isset($_POST['wats_company_list']) ? stripslashes_deep($_POST['wats_company_list']) : '0';
			if ($company != '0')
				update_user_meta($current_user->ID,$wats_settings['company_meta_key_profile'],$company);
			else
				delete_user_meta($current_user->ID,$wats_settings['company_meta_key_profile']);
			do_action('wats_user_to_company_mapping_add',$current_user->ID,$company);
		}
		
		if ($wats_settings['profile_sla_enabled'] == 1)
		{
			$sla = isset($_POST['wats_sla_list']) ? stripslashes_deep($_POST['wats_sla_list']) : '0';
			if ($sla != '0')
				update_user_meta($current_user->ID,'wats_sla',$sla);
			else
				delete_user_meta($current_user->ID,'wats_sla');
		}
		
		wp_set_current_user($old_user->ID);
	}
		
	return;
}

/**************************************************************/
/*								     						  */
/* Fonction d'édition du profil utilisateur (privilège admin) */
/*									    					  */
/**************************************************************/

function wats_admin_edit_user_profile()
{
    global $wpdb,$user_id,$current_user,$wats_settings;

	if (!current_user_can('administrator'))
		return;

    $old_user = $current_user;
	
    wp_set_current_user($user_id);

	$wats_capabilities_table = wats_init_capabilities_table();
	$wats_notifications_table = wats_init_notification_table();
		
	$notifications = get_user_meta($current_user->ID,'wats_notifications',true);
	
	echo '<h3>'.__('Ticket system capabilities','WATS').'</h3><table class="form-table"><tbody>';
	foreach ($wats_capabilities_table as $key => $value)
	{
		$right = current_user_can($key) ? 1 : 0;
		echo '<tr><th><label>'.$value.'</label></th><td><select name="'.$key.'" id="'.$key.'" size=1>';
		echo '<option value="yes"';
		if ($right == 1) echo ' selected';
		echo '>'.__('Yes','WATS').'</option><option value="no"';
		if ($right == 0) echo ' selected';
		echo '>'.__('No','WATS').'</option></td></tr>';
	}
	echo '</tbody></table><br />';
	
	if ($wats_settings['ticket_notification_bypass_mode'] == 1)
	{
		echo '<h3>'.__('Ticket system notifications','WATS').'</h3><table class="form-table"><tbody>';
		foreach ($wats_notifications_table as $key => $value)
		{
			echo '<tr><th><label>'.$value.'</label></th><td><select name="'.$key.'" id="'.$key.'" size=1 ';
			if ($wats_settings[$key] == 0)
				echo 'disabled=disabled ';
			echo '>';
			echo '<option value="yes"';
			if ($notifications[$key] == 1) echo ' selected';
			echo '>'.__('Yes','WATS').'</option><option value="no"';
			if ($notifications[$key] == 0) echo ' selected';
			echo '>'.__('No','WATS').'</option></td></tr>';
		}
		echo '</tbody></table><br /><br /><div class="wats_tip_visible">';
		echo __('Note : you can\'t set an option if it has been disabled globally by the admin.','WATS').'</div><br /><br />';
	}
	
	if ($wats_settings['user_expiration_date_enabled'] == 1 || $wats_settings['profile_country_enabled'] == 1 || $wats_settings['profile_company_enabled'] == 1 || $wats_settings['profile_sla_enabled'] == 1)
		echo '<h3>'.__('Account options','WATS').'</h3><table class="form-table"><tbody>';
	
	if ($wats_settings['user_expiration_date_enabled'] == 1)
	{
		echo '<tr><th><label>'.__('Expiration date (yyyy-mm-dd)','WATS').'</label></th>';
		echo '<td><input type="text" name="expirationdate" id="expirationdate" size="12" value="'.esc_html(get_user_meta($current_user->ID,'wats_expiration_date',true)).'" /></td>';
	}
	
	if ($wats_settings['profile_country_enabled'] == 1)
	{
		$my_country = get_user_meta($current_user->ID,$wats_settings['country_meta_key_profile'],true);
		$country_list = wats_build_country_list();
		echo '<tr><th><label>'.__('Country','WATS').'</label></th>';
		echo '<td><select name="wats_country_list" id="wats_country_list">';
		echo '<option value="0">'.__('None','WATS').'</option>';
		foreach ($country_list as $key => $value)
		{
			echo '<option value="'.esc_attr($key).'"';
			if ($my_country == $key)
				echo " selected";
			echo '>'.esc_html($key).'</option>';
		}
		echo '</select></td>';
	}
	
	if ($wats_settings['profile_company_enabled'] == 1)
	{
		$my_company = get_user_meta($current_user->ID,$wats_settings['company_meta_key_profile'],true);
		if (function_exists('wats_build_company_list'))
		{
			$company_list = wats_build_company_list(1);
			echo '<tr><th><label>'.__('Company','WATS').'</label></th>';
			echo '<td><select name="wats_company_list" id="wats_company_list">';
			foreach ($company_list AS $key => $value)
			{
				echo '<option value="'.esc_attr($key).'"';
				if ($my_company == $key)
					echo " selected";
				if ($key == '0')
					echo '>'.esc_html($value).'</option>';
				else
					echo '>'.esc_html($key).'</option>';
			}
			echo '</select></td>';
		}
	}
	
	if ($wats_settings['profile_sla_enabled'] == 1)
	{
		$my_sla = get_user_meta($current_user->ID,'wats_sla',true);
		$wats_slas = $wats_settings['wats_slas'];
		echo '<tr><th><label>'.__('Service level agreement','WATS').'</label></th>';
		echo '<td><select name="wats_sla_list" id="wats_sla_list">';
		echo '<option value="0">'.__('None','WATS').'</option>';
		foreach ($wats_slas AS $key => $value)
		{
			echo '<option value="'.esc_attr($key).'"';
			if ($my_sla == $key)
				echo " selected";
			echo '>'.esc_html($value).'</option>';
		}
		echo '</select></td>';
	}
	
	echo '</tbody></table><br />';
	
	echo '<br /><br />';
	
	wp_set_current_user($old_user->ID);
	
	return;
}

/*************************************************************/
/*								     						 */
/* Fonction de création des metas pour un nouvel utilisateur */
/*									    					 */
/*************************************************************/

function wats_user_register($id)
{
	$wats_notifications = array();
	$wats_notifications['new_ticket_notification_admin'] = 0;
	$wats_notifications['ticket_update_notification_all_tickets'] = 0;
	$wats_notifications['ticket_update_notification_my_tickets'] = 0;
	update_user_meta($id,'wats_notifications',$wats_notifications);
	
	return;
}

/***********************************************************************/
/*								     						           */
/* Fonction pour empêcher un utilisateur de modifier l'email du profil */
/*									    					           */
/***********************************************************************/

function wats_edit_user_email($value)
{
	global $current_user, $wats_settings;
	
	if ($wats_settings['prevent_user_profile_mail_modification'] == 1 && !current_user_can('administrator') && is_email($current_user->user_email))
	{
		$value = $current_user->user_email;
	}
	
	return($value);
}

?>