<?php

/********************************************/
/*                                          */
/* Fonction de rcupration du ticket owner */
/*                                          */
/********************************************/

function wats_ticket_get_owner($post)
{
	global $wats_settings;
	
	$output = '';
	if ($wats_settings['ticket_assign'] != 0)
	{
		$ticket_owner = get_post_meta($post->ID,'wats_ticket_owner',true);
		if ($ticket_owner)
			$output = $ticket_owner;
	}

	return($output);
}


/*******************************************************/
/*                                                     */
/* Fonction de rcupration de la priorit d'un ticket */
/*                                                     */
/*******************************************************/

function wats_ticket_get_priority($post)
{
	global $wats_settings;
	
	$wats_ticket_priority = isset($wats_settings['wats_priorities']) ? $wats_settings['wats_priorities'] : 0;
	
	$priority = get_post_meta($post->ID,'wats_ticket_priority',true);
	
	if (wats_is_numeric($priority) && isset($wats_ticket_priority[$priority]))
		$output = esc_html__($wats_ticket_priority[$priority],'WATS');
	else
		$output = '';
	
	return($output);
}

/************************************************/
/*                                              */
/* Fonction de rcupration du type d'un ticket */
/*                                              */
/************************************************/

function wats_ticket_get_type($post)
{
	global $wats_settings;
	
	$wats_ticket_type = isset($wats_settings['wats_types']) ? $wats_settings['wats_types'] : 0;

	$type = get_post_meta($post->ID,'wats_ticket_type',true);
	
	if (wats_is_numeric($type) && isset($wats_ticket_type[$type]))
		$output = esc_html__($wats_ticket_type[$type],'WATS');
	else
		$output = '';
	
	return($output);
}

/**************************************************/
/*                                                */
/* Fonction de rcupration du status d'un ticket */
/*                                                */
/**************************************************/

function wats_ticket_get_status($post)
{
	global $wats_settings;
	
	$wats_ticket_status = isset($wats_settings['wats_statuses']) ? $wats_settings['wats_statuses'] : 0;
	
	$status = get_post_meta($post->ID,'wats_ticket_status',true);
	
	if (wats_is_numeric($status) && isset($wats_ticket_status[$status]))
		$output = esc_html__($wats_ticket_status[$status],'WATS');
	else
		$output = '';
	
	return($output);
}

/***************************************************/
/*                                                 */
/* Fonction de rcupration du produit d'un ticket */
/*                                                 */
/***************************************************/

function wats_ticket_get_product($post)
{
	global $wats_settings;
	
	$wats_ticket_product = isset($wats_settings['wats_products']) ? $wats_settings['wats_products'] : 0;
	
	$product = get_post_meta($post->ID,'wats_ticket_product',true);
	
	if (wats_is_numeric($product) && isset($wats_ticket_product[$product]))
		$output = esc_html__($wats_ticket_product[$product],'WATS');
	else
		$output = '';
	
	return($output);
}

/***************************************************/
/*                                                 */
/* Fonction de rcupration des custom fields lis aux tickets */
/*                                                 */
/***************************************************/

function wats_ticket_get_custom_fields_frontend_ticket_template($post)
{
	global $wats_settings;
	
	$output = '';
	$wats_ticket_custom_field_values = $wats_settings['wats_ticket_custom_fields'];
	if (is_array($wats_ticket_custom_field_values))
	foreach ($wats_ticket_custom_field_values as $key => $table)
	{
		if ($table['ftdt'] == 1 || ($table['ftdt'] == 2 && current_user_can('administrator')))
			$output .= '<div class="wats_single_ticket_custom_field" id="wats_cf_'.$table['meta_key'].'"><label class="wats_label">'.esc_html($table['name'])." : </label>".esc_html(get_post_meta($post->ID,$table['meta_key'],true)).'</div>';
	}

	return($output);
}

/*************************************************/
/*                                               */
/* Fonction de mise  jour des metas d'un ticket */
/*                                               */
/*************************************************/

function wats_comment_update_meta($comment_id)
{
	global $wats_settings;
	
	wats_load_settings();
	
	$comment = get_comment($comment_id); 
	$status = $comment->comment_approved; 
	$post_id =  $comment->comment_post_ID;
	if ($status !== "spam" && wats_is_ticket($post_id))
	{
		wats_ticket_save_meta($post_id,get_post($post_id));
		
		if (current_user_can('administrator') && $wats_settings['internal_comment_visibility'] == 1 && isset($_POST['wats_internal_update']))
			update_comment_meta($comment_id,'wats_internal_update',1);
	}

	return;
}

/******************************************************/
/*                                                    */
/* Fonction de preprocessing d'un nouveau commentaire */
/*                                                    */
/******************************************************/

function wats_pre_comment_on_post($comment_post_id)
{
	global $wats_settings, $current_user;
	
	$post = get_post($comment_post_id);
	if ($post->post_type == 'ticket')
	{
		if ($wats_settings['ticket_status_key_enabled'] == 1 && get_post_meta($comment_post_id,'wats_ticket_status',true) == wats_get_closed_status_id() && !current_user_can('administrator'))
			wp_die(__('Sorry, you can\'t update this ticket.','WATS'));
		else if ($wats_settings['visibility'] == 1 && !is_user_logged_in())
			wp_die(__('Sorry, you must be logged in to update this ticket.','WATS'));
		else if ($wats_settings['visibility'] == 2 && (!is_user_logged_in() || (is_user_logged_in() && !current_user_can('administrator') && $current_user->ID != $post->post_author && ($wats_settings['ticket_visibility_same_company'] == 0 || wats_check_user_same_company($current_user->ID,$post->post_author) == false))))
			wp_die(__('Sorry, you don\'t have the rights to update this ticket.','WATS'));
	}
		
	return;
}

/************************************************/
/*                                              */
/* Fonction de sauvegarde des metas d'un ticket */
/*                                              */
/************************************************/

function wats_ticket_save_meta($postID,$post)
{
	global $wats_settings, $wpdb;

	wats_load_settings();
	
	if ($post->post_type == 'ticket')
	{

		$newticket = 0;

		if ((defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) || $post->post_status == 'auto-draft' || $post->post_status == 'trash')
		{
			return $postID;
		}
		
		
		$newstatus = -1;
		if ($wats_settings['ticket_status_key_enabled'] == 1 && isset($_POST['wats_select_ticket_status']))
		{
			$status = get_post_meta($postID,'wats_ticket_status',true);
						
			if (get_post_meta($postID,'wats_ticket_status',true) != wats_get_closed_status_id() || current_user_can('administrator'))
			{
				if ($status != $_POST['wats_select_ticket_status'])
					$newstatus = $_POST['wats_select_ticket_status'];

				if ($_POST['wats_select_ticket_status'] > 0)
					update_post_meta($postID,'wats_ticket_status',$_POST['wats_select_ticket_status']);
			}
		}

		$newtype = -1;
		if ($wats_settings['ticket_type_key_enabled'] == 1 && isset($_POST['wats_select_ticket_type']))
		{
			$type = get_post_meta($postID,'wats_ticket_type',true);
			if ($type != $_POST['wats_select_ticket_type'])
				$newtype = $_POST['wats_select_ticket_type'];
			
			if ($_POST['wats_select_ticket_type'] > 0)
				update_post_meta($postID,'wats_ticket_type',$_POST['wats_select_ticket_type']);
		}
			
		$newpriority = -1;
		if ($wats_settings['ticket_priority_key_enabled'] == 1 && isset($_POST['wats_select_ticket_priority']))
		{
			$priority = get_post_meta($postID,'wats_ticket_priority',true);
			if ($priority != $_POST['wats_select_ticket_priority'])
				$newpriority = $_POST['wats_select_ticket_priority'];
			
			if ($_POST['wats_select_ticket_priority'] > 0)
				update_post_meta($postID,'wats_ticket_priority',$_POST['wats_select_ticket_priority']);
		}
		
		$newproduct = -1;
		if ($wats_settings['ticket_product_key_enabled'] == 1 && isset($_POST['wats_select_ticket_product']))
		{
			$product = get_post_meta($postID,'wats_ticket_product',true);
			if ($product != $_POST['wats_select_ticket_product'])
				$newproduct = $_POST['wats_select_ticket_product'];
			
			if ($_POST['wats_select_ticket_product'] > 0)
				update_post_meta($postID,'wats_ticket_product',$_POST['wats_select_ticket_product']);
		}
		
		$newowner = -1;
		if (isset($_POST['wats_select_ticket_owner']))
		{
			$owner = get_post_meta($postID,'wats_ticket_owner',true);
			if ($owner != $_POST['wats_select_ticket_owner'])
				$newowner = $_POST['wats_select_ticket_owner'];
			
			update_post_meta($postID,'wats_ticket_owner',$_POST['wats_select_ticket_owner']);
		}
		
		if (is_admin() && ($wats_settings['ticket_notification_custom_list'] == 1) && current_user_can('administrator') && isset($_POST['wats_update_notification_mailing_list']))
		{
			$mailing_list = str_replace(";",",",$_POST['wats_update_notification_mailing_list']);
			if (strlen($mailing_list) == 0)
				delete_post_meta($postID,'wats_update_notification_mailing_list');
			else
				update_post_meta($postID,'wats_update_notification_mailing_list',$mailing_list);
		}
		
		$wats_ticket_custom_field_values = $wats_settings['wats_ticket_custom_fields'];
		if (is_array($wats_ticket_custom_field_values))
		foreach ($wats_ticket_custom_field_values as $key => $table)
		{
			if ((is_admin() && (($table['atef'] == 3 && current_user_can('administrator')) || $table['atef'] == 4 || ($table['atef'] == 5 && current_user_can('administrator'))))
			|| (!is_admin() && ($table['ftuf'] == 4 || ($table['ftuf'] == 5 && current_user_can('administrator')))))
			{
				if (isset($_POST['wats_cf_'.$table['meta_key']]))
					update_post_meta($postID,$table['meta_key'],$_POST['wats_cf_'.$table['meta_key']]);
			}
		}
		
		if (!get_post_meta($postID,'wats_ticket_number',true))
		{
			add_post_meta($postID,'wats_ticket_number',wats_get_latest_ticket_number()+1);
			$newticket = 1;
		}
		
		if ($newticket == 1)
		{
			if ($_POST['view'] != 1)
				wats_fire_admin_notification($postID);
		}
		else
		{
			if (!isset($_POST['wats_update_no_notification']) || !current_user_can('administrator'))
				wats_fire_ticket_update_notification($postID,$newstatus,$newtype,$newpriority,$newproduct,$newowner);
		}
		
		do_action('wats_ticket_saved_meta',$postID);
	}
	
	return;
}

/*****************************************************/
/*                                                   */
/* Fonction de hook durant la sauvegarde d'un ticket */
/*                                                   */
/*****************************************************/

function wats_insert_post_data($data)
{
	global $wats_settings, $current_user;

	if (current_user_can('administrator') && $wats_settings['call_center_ticket_creation'] == 1 && isset($_POST['wats_select_ticket_originator']) && $data['post_type'] == "ticket")
		$data['post_author'] = wats_get_user_ID_from_user_login($_POST['wats_select_ticket_originator']);

	if ($data['post_type'] == "ticket")
		$data['comment_status'] = 'open';
	
	return $data;
}

/************************************************************************/
/*                                                                      */
/* Fonction de filtrage du mail de l'expditeur du mail de notification */
/*                                                                      */
/************************************************************************/

function wats_mail_from()
{
	global $wats_settings, $current_user, $wats_current_post_author;
	
	wats_load_settings();
	
	if ($wats_settings['source_email_address'] == 0)
		$mail = get_option('admin_email');
	else if ($wats_current_post_author > 0)
	{
		$user_info = get_userdata($wats_current_post_author);
		$mail = $user_info->user_email;
	}
	else
		$mail = $current_user->user_email;
		
	if (!is_email($mail))
	{
		$sitename = strtolower($_SERVER['SERVER_NAME']);
		if (substr($sitename,0,4) == 'www.')
			$sitename = substr($sitename,4);
		$mail = 'wordpress@'.$sitename;
	}
	
	return $mail;
}

/***********************************************************************/
/*                                                                     */
/* Fonction de filtrage du nom de l'expditeur du mail de notification */
/*                                                                     */
/***********************************************************************/

function wats_mail_from_name()
{
	return get_option('blogname') + "1";
}

/*******************************************************/
/*                                                     */
/* Fonction de notification de mise  jour d'un ticket */
/*                                                     */
/*******************************************************/

function wats_fire_ticket_update_notification($postID,$newstatus,$newtype,$newpriority,$newproduct,$newowner)
{
	global $wats_settings, $wpdb, $wats_current_post_author;

	wats_load_settings();

	$updates = '';
	if ($newstatus != -1)
	{
		$wats_ticket_status = $wats_settings['wats_statuses'];
		$updates .= __('Ticket status has been changed to : ','WATS').esc_html__($wats_ticket_status[$newstatus],'WATS').".\r\n";
	}
	if ($newtype != -1)
	{
		$wats_ticket_types = $wats_settings['wats_types'];
		$updates .= __('Ticket type has been changed to : ','WATS').esc_html__($wats_ticket_types[$newtype],'WATS').".\r\n";
	}
	if ($newpriority != -1)
	{
		$wats_ticket_priority = $wats_settings['wats_priorities'];
		$updates .= __('Ticket priority has been changed to : ','WATS').esc_html__($wats_ticket_priority[$newpriority],'WATS').".\r\n";
	}
	if ($newproduct != -1)
	{
		$wats_ticket_product = $wats_settings['wats_products'];
		$updates .= __('Ticket product has been changed to : ','WATS').esc_html__($wats_ticket_product[$newproduct],'WATS').".\r\n";
	}	
	if ($newowner != -1)
	{
		if ($newowner == "0")
			$updates .= __('Ticket owner has been removed','WATS').".\r\n";
		else
			$updates .= __('Ticket owner has been assigned to : ','WATS').esc_html__($newowner,'WATS').".\r\n";
	}
	
	$ticket_author_id = 0;
	$post = get_post($postID);
	$userid = $post->post_author;
	$wats_current_post_author = 0;
	add_filter('wp_mail_from', 'wats_mail_from');
	add_filter('wp_mail_from_name', 'wats_mail_from_name');
	
	if ($wats_settings['ticket_update_notification_my_tickets'] == 1)
	{
		$ticketnumber = get_post_meta($postID,'wats_ticket_number',true);

		// Registered author notification
		$user = new WP_user($userid);
		$notifications = get_user_meta($user->ID,'wats_notifications',true);
		if ($wats_settings['ticket_notification_bypass_mode'] == 0 || !isset($notifications['ticket_update_notification_my_tickets']) || $notifications['ticket_update_notification_my_tickets'] != 0)
		{
			$ticket_author_id = $userid;
			$subject = __('Ticket ','WATS').$ticketnumber.__(' has been updated','WATS');
			$output = __('Hello ','WATS').get_user_meta($user->ID, 'first_name',true).",\r\n\r\n";
			$output .= __('Ticket ','WATS').$ticketnumber.__(' has been updated.','WATS');
			$output .= __('You can view it here :','WATS')."\r\n";
			if (!$user->has_cap('subscriber'))
			{
				$output .= __('+ Frontend side : ','WATS').get_permalink($postID)."\r\n\r\n";
				$output .= __('+ Admin side : ','WATS').wats_get_edit_ticket_link($postID, 'mail')."\r\n\r\n";
			}
			else
				$output .= get_permalink($postID)."\r\n\r\n";
			$output .= $updates."\r\n";
			$output = apply_filters('wats_fire_ticket_update_notification_filter',$output,$postID);
			$output .= wats_get_mail_notification_signature();
			$subject = apply_filters('wats_fire_ticket_update_notification_title_filter',$subject,$postID);
			wp_mail($user->user_email,$subject,$output);
		}
		
		// Non registered author notification
		if ($ticket_author_email = get_post_meta($post->ID,'wats_ticket_author_email',true))
		{
			$subject = __('Ticket ','WATS').$ticketnumber.__(' has been updated','WATS');
			$output = __('Hello ','WATS').get_post_meta($post->ID,'wats_ticket_author_name',true).",\r\n\r\n";
			$output .= __('Ticket ','WATS').$ticketnumber.__(' has been updated.','WATS');
			$output .= __('You can view it here :','WATS')."\r\n";
				$output .= get_permalink($postID)."\r\n\r\n";
			$output .= $updates."\r\n";
			$output = apply_filters('wats_fire_ticket_update_notification_filter',$output,$postID);
			$output .= wats_get_mail_notification_signature();
			$subject = apply_filters('wats_fire_ticket_update_notification_title_filter',$subject,$postID);
			wp_mail($ticket_author_email,$subject,$output);
		}
		
		// Registered updaters notification
		$users = $wpdb->get_results($wpdb->prepare("SELECT DISTINCT user_id FROM $wpdb->comments WHERE comment_post_ID = %d",$postID));
		foreach ($users AS $user_entry)
		{
			if ($user_entry->user_id != $ticket_author_id)
			{
				$user = new WP_user($user_entry->user_id);
				$notifications = get_user_meta($user->ID,'wats_notifications',true);
				if ($wats_settings['ticket_notification_bypass_mode'] == 0 || !isset($notifications['ticket_update_notification_my_tickets']) || $notifications['ticket_update_notification_my_tickets'] != 0)
				{
					$subject = __('Ticket ','WATS').$ticketnumber.__(' has been updated','WATS');
					$output = __('Hello ','WATS').get_user_meta($user->ID, 'first_name',true).",\r\n\r\n";
					$output .= __('Ticket ','WATS').$ticketnumber.__(' has been updated.','WATS');
					$output .= __('You can view it here :','WATS')."\r\n";
					if (!$user->has_cap('subscriber'))
					{
						$output .= __('+ Frontend side : ','WATS').get_permalink($postID)."\r\n\r\n";
						$output .= __('+ Admin side : ','WATS').wats_get_edit_ticket_link($postID, 'mail')."\r\n\r\n";
					}
					else
						$output .= get_permalink($postID)."\r\n\r\n";
					$output .= $updates."\r\n";
					$output = apply_filters('wats_fire_ticket_update_notification_filter',$output,$postID);
					$output .= wats_get_mail_notification_signature();
					$subject = apply_filters('wats_fire_ticket_update_notification_title_filter',$subject,$postID);
					wp_mail($user->user_email,$subject,$output);
				}
			}
		}
	}
	
	if ($wats_settings['ticket_update_notification_all_tickets'] == 1)
	{

		/*$users = $wpdb->get_results($wpdb->prepare("SELECT ID FROM $wpdb->users WHERE user_login NOT LIKE %s",'%unverified__%'));*/
		if (class_exists('WP_User_Query'))
		{
			$wp_user_search = new WP_User_Query(array('role'=>'administrator'));
			$users = $wp_user_search->get_results();
		}
		else
		{
			$users = $wpdb->get_results($wpdb->prepare("SELECT ID FROM $wpdb->users"));
		}
		
		$ticketnumber = get_post_meta($postID,'wats_ticket_number',true);
		foreach ($users AS $user_entry)
		{
			if ($user_entry->ID != $ticket_author_id)
			{
				$user = new WP_User($user_entry->ID);
				$notifications = get_user_meta($user->ID,'wats_notifications',true);
				if ($user->has_cap('administrator') && ($wats_settings['ticket_notification_bypass_mode'] == 0 || !isset($notifications['ticket_update_notification_all_tickets']) || $notifications['ticket_update_notification_all_tickets'] != 0))
				{
					$subject = __('Ticket ','WATS').$ticketnumber.__(' has been updated','WATS');
					$output = __('Hello ','WATS').get_user_meta($user->ID, 'first_name',true).",\r\n\r\n";
					$output .= __('Ticket ','WATS').$ticketnumber.__(' has been updated.','WATS');
					$output .= __('You can view it here :','WATS')."\r\n";
					if (!$user->has_cap('subscriber'))
					{
						$output .= __('+ Frontend side : ','WATS').get_permalink($postID)."\r\n\r\n";
						$output .= __('+ Admin side : ','WATS').wats_get_edit_ticket_link($postID, 'mail')."\r\n\r\n";
					}
					else
						$output .= get_permalink($postID)."\r\n\r\n";
					$output .= $updates."\r\n";
					$output = apply_filters('wats_fire_ticket_update_notification_filter',$output,$postID);
					$output .= wats_get_mail_notification_signature();
					$subject = apply_filters('wats_fire_ticket_update_notification_title_filter',$subject,$postID);
					wp_mail($user->user_email,$subject,$output);
				}
			}
		}
	}
	
	if ($wats_settings['ticket_notification_custom_list'] == 1)
	{
		$ticket_update_mailing_list = get_post_meta($postID,'wats_update_notification_mailing_list',true);

		if (strlen($ticket_update_mailing_list) > 0)
		{
			$subject = __('Ticket ','WATS').$ticketnumber.__(' has been updated','WATS');
			$output = __('Hello ','WATS')."\r\n\r\n";
			$output .= __('Ticket ','WATS').$ticketnumber.__(' has been updated.','WATS');
			$output .= __('You can view it here :','WATS')."\r\n";
			$output .= get_permalink($postID)."\r\n\r\n";
			$output .= $updates."\r\n";
			$output = apply_filters('wats_fire_ticket_update_notification_filter',$output,$postID);
			$output .= wats_get_mail_notification_signature();
			$subject = apply_filters('wats_fire_ticket_update_notification_title_filter',$subject,$postID);
			wp_mail($ticket_update_mailing_list,$subject,$output);
		}
	}

	return;
}

/************************************************************************/
/*                                                                      */
/* Fonction d'envoi des notifications bases sur les rgles spcifiques */
/*                                                                      */
/************************************************************************/

function wats_fire_rules_notification($postID, $details)
{
	global $wats_settings, $wpdb;
	
	$wats_notification_rules = get_option('wats_notification_rules');
	if (is_array($wats_notification_rules))
	{
		$status = get_post_meta($postID,'wats_ticket_status',true);
		$priority = get_post_meta($postID,'wats_ticket_priority',true);
		$type = get_post_meta($postID,'wats_ticket_type',true);
		$product = get_post_meta($postID,'wats_ticket_product',true);
		$post = get_post($postID);
		$country = get_user_meta($post->post_author,$wats_settings['country_meta_key_profile'],true);
		$company = get_user_meta($post->post_author,$wats_settings['company_meta_key_profile'],true);
						
		foreach (array_keys($wats_notification_rules) AS $key)
		{
			foreach ($wats_notification_rules[$key] AS $rule => $list)
			{
				$rule = wats_admin_build_notification_rule($rule);
				$result = 1;
				
				foreach ($rule AS $key => $value)
				{
					if ($key == 'priority' && $value != $priority && $value != "0")
						$result = 0;
					if ($key == 'status' && $value != $status && $value != "0")
						$result = 0;
					if ($key == 'type' && $value != $type && $value != "0")
						$result = 0;
					if ($key == 'product' && $value != $product && $value != "0")
						$result = 0;
					if ($key == 'country' && $value != $country && $value != "0")
						$result = 0;
					if ($key == 'company' && $value != $company && $value != "0")
						$result = 0;
				}
				
				if ($result == 1)
				{
					$subject = __('New ticket submitted','WATS');
					$output = __('Hello','WATS').",\r\n\r\n";
					$output .= __('A new ticket has been submitted into the system.','WATS')."\r\n\r\n";
					$output .= $details;
					$output .= __('You can view it here :','WATS')."\r\n";
					$output .= __('+ Frontend side : ','WATS').get_permalink($postID)."\r\n\r\n";
					$output .= __('+ Admin side : ','WATS').wats_get_edit_ticket_link($postID, 'mail')."\r\n\r\n";
					$output = apply_filters('wats_fire_rules_notification_filter',$output,$postID);
					$output .= wats_get_mail_notification_signature();
					$subject = apply_filters('wats_fire_rules_notification_title_filter',$subject,$postID);
					wp_mail($list,$subject,$output);
				}
			}
		}
	}
	
	return;
}

/****************************************************/
/*                                                  */
/* Fonction de notification de cration d'un ticket */
/*                                                  */
/****************************************************/

function wats_fire_admin_notification($postID)
{
	global $wats_settings, $wpdb, $wats_current_post_author;

	wats_load_settings();
	
	$wats_ticket_priority = isset($wats_settings['wats_priorities']) ? $wats_settings['wats_priorities'] : 0;
	$wats_ticket_type = isset($wats_settings['wats_types']) ? $wats_settings['wats_types'] : 0;
	$wats_ticket_status = isset($wats_settings['wats_statuses']) ? $wats_settings['wats_statuses'] : 0;
	$wats_ticket_product = isset($wats_settings['wats_products']) ? $wats_settings['wats_products'] : 0;
	$post = get_post($postID);
	$wats_current_post_author = $post->post_author;
	
	$details = __('Here are the ticket details :','WATS')."\r\n";
	if ($wats_settings['ticket_type_key_enabled'] == 1)
		$details .= __('+ Ticket type : ','WATS').$wats_ticket_type[get_post_meta($postID,'wats_ticket_type',true)]."\r\n";
	if ($wats_settings['ticket_priority_key_enabled'] == 1)
		$details .= __('+ Ticket priority : ','WATS').$wats_ticket_priority[get_post_meta($postID,'wats_ticket_priority',true)]."\r\n";
	if ($wats_settings['ticket_status_key_enabled'] == 1)
		$details .= __('+ Ticket status : ','WATS').$wats_ticket_status[get_post_meta($postID,'wats_ticket_status',true)]."\r\n";
	if ($wats_settings['ticket_product_key_enabled'] == 1)
		$details .= __('+ Ticket product : ','WATS').$wats_ticket_product[get_post_meta($postID,'wats_ticket_product',true)]."\r\n";
	$details .= __('+ Ticket number : ','WATS').wats_get_ticket_number($postID)."\r\n";
	$details .= __('+ Ticket title : ','WATS').get_the_title($postID)."\r\n\r\n";

	add_filter('wp_mail_from','wats_mail_from');
	add_filter('wp_mail_from_name', 'wats_mail_from_name');
	
	wats_fire_rules_notification($postID, $details);
	
	if ($wats_settings['new_ticket_notification_admin'] == 1)
	{
		if (class_exists('WP_User_Query'))
		{
			$wp_user_search = new WP_User_Query(array('role'=>'administrator'));
			$users = $wp_user_search->get_results();
		}
		else
		{
			$users = $wpdb->get_results($wpdb->prepare("SELECT ID FROM $wpdb->users"));
		}
				
		foreach ($users AS $user_entry)
		{
			$user = new WP_user($user_entry->ID);
			
			if ($user->has_cap('administrator'))
			{
				$notifications = get_user_meta($user->ID,'wats_notifications',true);
				if ($wats_settings['ticket_notification_bypass_mode'] == 0 || !isset($notifications['new_ticket_notification_admin']) || $notifications['new_ticket_notification_admin'] != 0)
				{
					$subject = __('New ticket submitted','WATS');
					$output = __('Hello ','WATS').get_user_meta($user->ID, 'first_name',true).",\r\n\r\n";
					$output .= __('A new ticket has been submitted into the system.','WATS')."\r\n\r\n";
					$output .= $details;
					$output .= __('You can view it here :','WATS')."\r\n";
					$output .= __('+ Frontend side : ','WATS').get_permalink($postID)."\r\n\r\n";
					$output .= __('+ Admin side : ','WATS').wats_get_edit_ticket_link($postID, 'mail')."\r\n\r\n";
					$output = apply_filters('wats_fire_admin_notification_filter',$output,$postID);
					$output .= wats_get_mail_notification_signature();
					$subject = apply_filters('wats_fire_admin_notification_title_filter',$subject,$postID);
					wp_mail($user->user_email,$subject,$output);
				}
			}
		}
	}
	
	return;
}

/************************************************/
/*                                              */
/* Fonction d'ajout des meta boxes dans l'admin */
/*                                              */
/************************************************/

function wats_ticket_meta_boxes()
{
	global $wp_meta_boxes, $wats_settings;

	remove_meta_box('commentsdiv', 'ticket', 'normal');
	remove_meta_box('commentstatusdiv', 'ticket', 'normal');
	add_meta_box('ticketdetailsdiv',__('Ticket details','WATS'),'wats_ticket_details_meta_box','ticket','normal','default',array('view' => 0));
	add_meta_box('categorydiv', __('Categories'), 'post_categories_meta_box', 'ticket', 'side', 'core');
	if ($wats_settings['tickets_custom_fields'] == 1)
		add_meta_box('postcustom', __('Custom Fields'), 'post_custom_meta_box', 'ticket', 'normal', 'core');
	if ($wats_settings['tickets_tagging'] == 1)
		add_meta_box('tagsdiv-post_tag', __('Tags'), 'post_tags_meta_box', 'ticket', 'side', 'core');
	
	return;
}

/***************************************************************/
/*                                                             */
/* Fonction d'affichage de l'historique d'un ticket (meta box) */
/*                                                             */
/***************************************************************/

function wats_ticket_history_meta_box($post)
{

	echo __('Here is the ticket history','WATS');

	return;
}

/***************************************************************/
/*                                                             */
/* Fonction de filtrage des messages dans la page d'dition des tickets */
/*                                                             */
/***************************************************************/

function wats_post_updated_messages($messages)
{

	if ((isset($_GET['post_type']) && $_GET['post_type'] == 'ticket') || (isset($_GET['post']) && get_post_type($_GET['post']) == 'ticket'))
	{
		if (isset($_GET['post']))
		{
			$messages['post'][10] = sprintf(__('Ticket draft updated. Please don\'t forget to submit it when edition is complete! <a target="_blank" href="%s">Preview ticket</a>','WATS'), esc_url(add_query_arg('preview','true',get_permalink($_GET['post']))));
		}
	}
	
	return $messages;
}

/***********************************************************/
/*                                                         */
/* Fonction d'affichage des dtails d'un ticket (meta box) */
/* view : 0 (comment form et ticket edit/creation admin)    */
/* view : 1 (ticket creation frontend) 					   */
/*                                                         */
/***********************************************************/

function wats_ticket_details_meta_box($post,$view=0)
{
	global $wats_settings, $current_user, $pagenow;

	if (is_array($view))
		$view = $view['args']['view'];

	$wats_ticket_priority = isset($wats_settings['wats_priorities']) ? $wats_settings['wats_priorities'] : 0;
	$wats_ticket_type = isset($wats_settings['wats_types']) ? $wats_settings['wats_types'] : 0;
	$wats_ticket_status = isset($wats_settings['wats_statuses']) ? $wats_settings['wats_statuses'] : 0;
	$wats_ticket_product = isset($wats_settings['wats_products']) ? $wats_settings['wats_products'] : 0;
	$wats_ticket_assign = $wats_settings['ticket_assign'];
	
	$role = array_shift($current_user->roles);
	$user_can_assign = 0;
	if (isset($role) && $wats_settings['ticket_assignment_'.$role] == 1)
		$user_can_assign = 1;
	
	if (is_object($post))
	{
		$ticket_priority = get_post_meta($post->ID,'wats_ticket_priority',true);
		$ticket_status = get_post_meta($post->ID,'wats_ticket_status',true);
		$ticket_type = get_post_meta($post->ID,'wats_ticket_type',true);
		$ticket_owner = get_post_meta($post->ID,'wats_ticket_owner',true);
		$ticket_product = get_post_meta($post->ID,'wats_ticket_product',true);
	}
	else
	{
		$ticket_priority = 0;
		$ticket_status = 0;
		$ticket_type = 0;
		$ticket_owner = 0;
		$ticket_product = 0;
	}
	
	$output = '';
	
	if ($wats_settings['ticket_type_key_enabled'] == 1)
	{
		if ($view == 1)
			$output .= '<div class="wats_select_ticket_type_frontend">';
			
		if ($view == 0 && !is_admin())
			$output .= '<div class="wats_select_ticket_type_frontend_update_form">';
			
		if (is_admin())
			$output.= '<br />';
		$output .= '<label class="wats_label">'.__('Ticket type','WATS').' : </label>';
		$output .= '<select name="wats_select_ticket_type" id="wats_select_ticket_type" class="wats_select">';
		if (is_array($wats_ticket_type))
		foreach ($wats_ticket_type as $key => $value)
		{
			$output .= '<option value='.$key;
			if ($key == $ticket_type || (!$ticket_type && $key == $wats_settings['default_ticket_type']))
				$output .= ' selected';
			$output .= '>'.esc_html__($value,'WATS').'</option>';
		}
		$output .= '</select><br /><br />';
		if ($view == 1 || ($view == 0 && !is_admin()))
			$output .= '</div>';
	}
	
	if ($wats_settings['ticket_priority_key_enabled'] == 1)
	{
		if ($view == 1)
			$output .= '<div class="wats_select_ticket_priority_frontend">';
		
		if ($view == 0 && !is_admin())
			$output .= '<div class="wats_select_ticket_priority_frontend_update_form">';
		
		$output .= '<label class="wats_label">'.__('Ticket priority','WATS').' : </label>';
		$output .= '<select name="wats_select_ticket_priority" id="wats_select_ticket_priority" class="wats_select">';
		if (is_array($wats_ticket_priority))
		foreach ($wats_ticket_priority as $key => $value)
		{
			$output .= '<option value='.$key;
			if ($key == $ticket_priority || (!$ticket_priority && $key == $wats_settings['default_ticket_priority']))
				$output .= ' selected';
			$output .= '>'.esc_html__($value,'WATS').'</option>';
		}
		$output .= '</select><br /><br />';
		
		if ($view == 1 || ($view == 0 && !is_admin()))
			$output .= '</div>';
	}
	
	if ($wats_settings['ticket_status_key_enabled'] == 1)
	{
		if ($view == 1)
			$output .= '<div class="wats_select_ticket_status_frontend">';
		
		if ($view == 0 && !is_admin())
			$output .= '<div class="wats_select_ticket_status_frontend_update_form">';
		
		if (is_admin() && is_object($post) && get_post_meta($post->ID,'wats_ticket_status',true) == wats_get_closed_status_id() && !current_user_can('administrator'))
		{
			$output .= __('Ticket status','WATS').' : '.$wats_ticket_status[wats_get_closed_status_id()].'<br /><br />';
		}
		else
		{
			$output .= '<label class="wats_label">'.__('Ticket status','WATS').' : </label>';
			$output .= '<select name="wats_select_ticket_status" id="wats_select_ticket_status" class="wats_select">';
			if (is_array($wats_ticket_status))
			foreach ($wats_ticket_status as $key => $value)
			{
				$output .= '<option value='.$key;
				if ($key == $ticket_status || (!$ticket_status && $key == $wats_settings['default_ticket_status']))
					$output .= ' selected';
				$output .= '>'.esc_html__($value,'WATS').'</option>';
			}
			$output .= '</select><br /><br />';
		}
		
		if ($view == 1 || ($view == 0 && !is_admin()))
			$output .= '</div>';
	}
	
	if ($wats_settings['ticket_product_key_enabled'] == 1)
	{
		if ($view == 1)
			$output .= '<div class="wats_select_ticket_product_frontend">';
		
		if ($view == 0 && !is_admin())
			$output .= '<div class="wats_select_ticket_product_frontend_update_form">';
		
		$output .= '<label class="wats_label">'.__('Ticket product','WATS').' : </label>';
		$output .= '<select name="wats_select_ticket_product" id="wats_select_ticket_product" class="wats_select">';
		if (is_array($wats_ticket_product))
		foreach ($wats_ticket_product as $key => $value)
		{
			$output .= '<option value='.$key;
			if ($key == $ticket_product || (!$ticket_product && $key == $wats_settings['default_ticket_product']))
				$output .= ' selected';
			$output .= '>'.esc_html__($value,'WATS').'</option>';
		}
		$output .= '</select><br /><br />';
		
		if ($view == 1 || ($view == 0 && !is_admin()))
			$output .= '</div>';
	}
	
	$wats_ticket_custom_field_values = $wats_settings['wats_ticket_custom_fields'];
	if (is_array($wats_ticket_custom_field_values))
	foreach ($wats_ticket_custom_field_values as $key => $table)
	{
		if (is_admin())
		{
			if ($table['atef'] == 1 || ($table['atef'] == 2 && current_user_can('administrator')) || ($table['atef'] == 3 && !current_user_can('administrator')))
				$output .= '<label class="wats_label">'.esc_html($table['name'])." : </label>".esc_html(get_post_meta($post->ID,$table['meta_key'],true)).'<br /><br />';
			else if (($table['atef'] == 3 && current_user_can('administrator')) || $table['atef'] == 4 || ($table['atef'] == 5 && current_user_can('administrator')))
			{
				$custom_value = esc_attr(get_post_meta($post->ID,$table['meta_key'],true));
				$output .= '<label class="wats_label">'.esc_html($table['name']).' : </label><input type="text" name="wats_cf_'.$table['meta_key'].'" id="wats_cf_'.$table['meta_key'].'" value="'.$custom_value.'" /><br /><br />';
			}
		}
		else
		{
			if (($view == 1 && ($table['fsf'] == 4 || ($table['fsf'] == 5 && current_user_can('administrator'))))
			|| ($view == 0 && ($table['ftuf'] == 4 || ($table['ftuf'] == 5 && current_user_can('administrator')))))
			{
				$custom_value = is_object($post) ? esc_attr(get_post_meta($post->ID,$table['meta_key'],true)) : '';
				$output .= '<div class="wats_frontend_ticket_custom_field" id="wats_cf_'.$table['meta_key'].'">';
				$output .= '<label class="wats_label">'.esc_html($table['name']).' : </label><input type="text" name="wats_cf_'.$table['meta_key'].'" id="wats_cf_'.$table['meta_key'].'" value="'.$custom_value.'" /></div><br />';
			}
		}
	}
	
	if ($wats_ticket_assign == 1 || ($wats_ticket_assign == 2 && $user_can_assign == 1))
	{
		if ($view == 1)
			$output .= '<div class="wats_select_ticket_owner_frontend">';
		
		if ($view == 0 && !is_admin())
			$output .= '<div class="wats_select_ticket_owner_frontend_update_form">';
			
		$output .= '<label class="wats_label">'.__('Ticket owner','WATS').' : </label>';
		if ($wats_settings['ticket_assign_user_list'] == 0)
		{
			$userlist = wats_build_user_list(__("None",'WATS'),0);
		}
		else if ($wats_settings['ticket_assign_user_list'] == 1)
		{
			$userlist = wats_build_user_list(__("None",'WATS'),'administrator');
			if ($post->ID && !in_array(get_the_author(),$userlist))
			{
				$namelist = wats_build_formatted_name(get_the_author_meta('ID'));
				foreach ($namelist AS $login => $name)
					$userlist[$login] = $name;
			}
		}
		else if ($wats_settings['ticket_assign_user_list'] == 2)
		{
			$userlist = wats_build_user_list(__("None",'WATS'),'wats_ticket_ownership');
			if ($post->ID && !in_array(get_the_author(),$userlist))
			{
				$namelist = wats_build_formatted_name(get_the_author_meta('ID'));
				foreach ($namelist AS $login => $name)
					$userlist[$login] = $name;
			}
		}
				
		$output .= '<select name="wats_select_ticket_owner" id="wats_select_ticket_owner" class="wats_select">';
		foreach ($userlist AS $userlogin => $username)
		{
			$output .= '<option value="'.$userlogin.'" ';
			if ($userlogin == $ticket_owner) $output .= 'selected';
				$output .= '>'.$username.'</option>';
		}
		$output .= '</select><br /><br />';
		
		if ($view == 1 || ($view == 0 && !is_admin()))
			$output .= '</div>';
	}
	
	if (is_object($post))
		setup_postdata($post);


	if ((is_admin() || $view == 1) && current_user_can('administrator') && $wats_settings['call_center_ticket_creation'] == 1)
	{
		if (is_object($post))
			$selected_login = get_the_author_meta('user_login');
		else
			$selected_login = $current_user->user_login;
	
		$output .= '<div id="wats_div_ticket_originator"><label class="wats_label">'.__('Ticket originator : ','WATS').'</label>';
		
		if ($wats_settings['profile_company_enabled'] == 1 && function_exists('wats_build_company_list'))
		{
			$company_list = wats_build_company_list(2);
			$my_company = get_user_meta(wats_get_user_ID_from_user_login($selected_login),$wats_settings['company_meta_key_profile'],true);
			if ($my_company == '')
				$my_company = 0;
			$output .= wp_nonce_field('wats-edit-ticket','_wpnonce_wats_edit_ticket',true,false)."\n";
			$output .= '<br /><br /><label class="wats_label">+ '.__('Company','WATS').' : </label>';
			$output .= '<select name="wats_company_list" id="wats_company_list">';
			foreach ($company_list AS $key => $value)
			{
				$output .= '<option value="'.esc_attr($key).'"';
				if ($my_company === $key) 
					$output .= " selected";
				if ($key == '0')
					$output .= '>'.esc_html($value).'</option>';
				else
					$output .= '>'.esc_html($key).'</option>';
			}
			$output .= '</select>';
			$output .= '<br /><br /><label class="wats_label">+ '.__('User','WATS').' : </label>';
			$userlist = wats_build_user_list_from_company(0,0,$my_company);
		}
		else
		{
			$userlist = wats_build_user_list(0,0);
		}
		
		$output .= '<select name="wats_select_ticket_originator" id="wats_select_ticket_originator" class="wats_select">';
		foreach ($userlist AS $userlogin => $username)
		{
			$output .= '<option value="'.$userlogin.'" ';
			if ($selected_login == $userlogin) $output .= " selected";
			$output .= '>'.$username.'</option>';
		}
		$output .=  '</select></div>';
	}
	else if (is_admin())
	{
		if ($post->ID)
		{
			$output .= '<label class="wats_label">'.__('Ticket originator : ','WATS').'</label>';
			$output .= get_the_author();
		}
		
	}
		
	if (is_admin())
	{
		$ticket_author_name = get_post_meta($post->ID,'wats_ticket_author_name',true);
		if ($ticket_author_name)
			$output .= '<br /><br /><label class="wats_label">'.__('Ticket author name : ','WATS').'</label>'.$ticket_author_name;
		
		$ticket_author_email = get_post_meta($post->ID,'wats_ticket_author_email',true);
		if ($ticket_author_email)
			$output .= '<br /><br /><label class="wats_label">'.__('Ticket author email : ','WATS').'</label>'.'<a href="mailto:'.$ticket_author_email.'">'.$ticket_author_email.'</a>';
		
		$ticket_author_url = get_post_meta($post->ID,'wats_ticket_author_url',true);
		if ($ticket_author_url)
			$output .= '<br /><br /><label class="wats_label">'.__('Ticket author url : ','WATS').'</label>'.'<a href="'.$ticket_author_url.'">'.$ticket_author_url.'</a>';
		$output .= '<br /><br />';
		
		if (current_user_can('administrator') && $wats_settings['ticket_notification_custom_list'] == 1)
		{
			$ticket_update_mailing_list = get_post_meta($post->ID,'wats_update_notification_mailing_list',true);
			$output .= '<label class="wats_label">'.__('Update notification mailing list : ','WATS').'</label><input type="text" name="wats_update_notification_mailing_list" id="wats_update_notification_mailing_list" value="'.$ticket_update_mailing_list.'" size="30" class="regular-text" /><br /><br />';
		}
	}
	
	if ($view == 0 && current_user_can('administrator'))
	{
		if (!is_admin() && $wats_settings['internal_comment_visibility'] == 1)
			$output .= 	'<input style="width:20px;" type="checkbox" id="wats_internal_update" name="wats_internal_update"> '.__('Only administrators can view this update','WATS').'<br /><br />';

		if ((!is_admin() || $pagenow != 'post-new.php') && ($wats_settings['ticket_update_notification_all_tickets'] == 1 || $wats_settings['ticket_update_notification_my_tickets'] == 1 || $wats_settings['ticket_notification_custom_list'] == 1))
			$output .= 	'<input style="width:20px;" type="checkbox" id="wats_update_no_notification" name="wats_update_no_notification"> '.__('Don\'t fire any notification for this update','WATS').'<br /><br />';
	}
	
	if ($view == 1)
		return ($output);
	else
		echo $output;
}

?>
