

// jQuery for page scrolling feature - requires jQuery Easing plugin
$(function() {
    $('a.page-scroll').bind('click', function(event) {
        var $anchor = $(this);
        $('html, body').stop().animate({
            scrollTop: $($anchor.attr('href')).offset().top
        }, 1500, 'easeInOutExpo');
        event.preventDefault();
    });
});

// Highlight the top nav as scrolling occurs
$('body').scrollspy({
    target: '.navbar-fixed-top'
})

// Closes the Responsive Menu on Menu Item Click
$('.navbar-collapse ul li a').click(function() {
    $('.navbar-toggle:visible').click();
});

$('#toggleButton').click(function() {
	// toggle the icon-bar
    $('#toggleButton .icon-bar').toggleClass("navbar-toggle-hide"); 
     
    // toggle the "remove/close" button
    $('#toggleButton i').toggleClass("navbar-toggle-hide");
    // remove the bg-tran class/ actually only need once
    $('#toggleButton').removeClass( "bg-init" )
    
    // in mobile screen
    $('.navbar').toggleClass("navbar-bg"); 
    $('.logo-white').toggleClass("logo-black"); 
    
});

// This is to make our #nav stick to the top when scrolling
$('#nav').affix({
    offset: $('#nav').position()
});

// show/hide some elements on nav when user scrolls the page
$('#nav').on('affix.bs.affix', function () {
    $("#logo1").hide();
    $("#logo2").removeClass("visible-xs-block");
    $("#logo2").hide();
    $("#desktopMenu").hide(); 
});
// Called when nav is restored
$('#nav').on('affix-top.bs.affix', function () {
	$("#logo1").show();
    $("#logo2").show();
    $("#desktopMenu").show();
});

var isMenuShowed = false;

//fix issue when user set Always show scrollbar
//store delta of body width before and after scroll appear
//alway set width of pc-nav-drop .nav-holder is body width with scroll
var deltaWidth = 0;

$(window).ready(function(){
    var windowHeight = $(window).height();
    $('#pc-navbar-drop-content').css('max-height', windowHeight);
    $('#pc-navbar-drop-content').css('min-height', windowHeight);

    $('#pc-navbar-drop').css('top', -$('#pc-navbar-drop').height());
    $('#pc-navbar-drop-content').css('top', -windowHeight);

    //toggle to test width of body before and after scroll appear
    var widthBodyWithScroll = $('body').width();
    $('body').toggleClass('no-scroll');
    var widthBodyWithoutScroll = $('body').width();
    $('body').toggleClass('no-scroll');

    deltaWidth = widthBodyWithoutScroll - widthBodyWithScroll;
    $('#pc-navbar-drop .nav-holder').css('width', widthBodyWithScroll + 'px');
    $('#pc-navbar-drop-content').css('width', widthBodyWithoutScroll + 'px');
});

$(window).resize(function() {
    var windowHeight = $(window).height();

    //addjust navbar top when it's not collapsed.
    if (!isMenuShowed)
        $('#pc-navbar-drop-content').css('top', -windowHeight);

    $('#pc-navbar-drop-content').css('max-height', windowHeight);
    $('#pc-navbar-drop-content').css('min-height', windowHeight);

    //toggle to test width of body before and after scroll appear
    var widthBody = $('body').width();
    if (isMenuShowed) {
        $('#pc-navbar-drop-content').css('width', widthBody + 'px');
        $('#pc-navbar-drop .nav-holder').css('width', widthBody-deltaWidth + 'px');
    }
    else {
        $('#pc-navbar-drop-content').css('width', widthBody+deltaWidth + 'px');
        $('#pc-navbar-drop .nav-holder').css('width', widthBody + 'px');
    }
});

function animateMenu() {
    $('.nav-holder').unbind( 'click', animateMenu );

    $('#pc-navbar-drop').stop();
    $('#pc-navbar-drop-content').stop();

    if (isMenuShowed) {
        $('body').toggleClass('no-scroll');

        $('#pc-navbar-drop').animate({opacity: 0}, 500, function(){});

        $('#pc-navbar-drop-content').css('overflow', 'hidden');
        $("#pc-navbar-drop-content").animate({top: -$('#pc-navbar-drop-content').height()}, 500, function() {
            isMenuShowed = false;
            $('#pc-navbar-drop').css('top', -$('#pc-navbar-drop').height());
            $('.nav-holder').bind('click', animateMenu);
        });
    }
    else {
        $('#pc-navbar-drop').css('top', 0);
        $('#pc-navbar-drop').animate({opacity: 1}, 500, function(){
            $('body').toggleClass('no-scroll');
        });  
        

        $('#pc-navbar-drop-content').css('overflow', 'auto'); 
        $("#pc-navbar-drop-content").animate({top: 0}, 500, function() {
            isMenuShowed = true;
            $('.nav-holder').bind('click', animateMenu);
        });
    }
}
$('.nav-holder').bind('click', animateMenu);
