<?php
/**
 * Template Name: Home Page Template
 *
 * @package WordPress
 * @subpackage Twenty_Fourteen
 * @since Twenty Fourteen 1.0
 */

get_header(); ?>
    <link href="<?php echo get_bloginfo('template_url'); ?>/css/home-page-template.css" rel="stylesheet">

    <!-- Header -->
    <header>
        <div class="container">
            <div class="intro-text">
                <div class="intro-lead-in"><i class="fa fa-quote-left"></i>Beautiful handwriting for <br /> effective note takers<i class="fa fa-quote-right"></i></div>
                <!-- <div class="cta-button"><a href="#services"><i class="fa fa-chevron-down"></i></a></div> -->
            </div>
        </div>
    </header>

    <section id="our-products">
        <div class="container">
            <div class="row products notes">
                <div class="col-md-offset-2 col-md-4 col-sm-6 col-xs-12">
                    <img class="pull-left logo" src="http://dev.gowriteon.com/wp-content/themes/WriteOn-Angular-Wordpress/img/logos/np_logo.png" alt="Notes Plus" width="150" />
                    <div class="heading">
                        <h5 class="visible-xs"><b>NOTES PLUS</b></h5>
                        <h4 class="hidden-xs">NOTES PLUS</h4>
                        <h5 class="subheading">Powerful note-taking tool.</h5>
                        <button class="button btn-lg hidden-xs">Learn more</button>
                    </div>
                </div>
                <div class="col-md-6 col-sm-6 hidden-xs"><img class="img-responsive" src="http://dev.gowriteon.com/wp-content/themes/WriteOn-Angular-Wordpress/img/np4_UseLessPaper.png" alt="" width="474" /></div>
            </div>

            <hr class="visible-xs" />

            <div class="row products ink">
                <div class="col-md-offset-2 col-md-4 col-sm-6 hidden-xs">
                    <img class="img-responsive" src="http://dev.gowriteon.com/wp-content/themes/WriteOn-Angular-Wordpress/img/ink_paperbutbetter.png" alt="Inkredible" width="380" />
                </div>
                <div class="col-md-6 col-sm-6 col-xs-12">
                    <img class="pull-right logo" src="http://dev.gowriteon.com/wp-content/themes/WriteOn-Angular-Wordpress/img/logos/ink_logo.png" alt="" width="160" />
                    <div class="heading" align="right">
                        <h5 class="visible-xs"><b>INKREDIBLE</b></h5>
                        <h4 class="hidden-xs">INKREDIBLE</h4>
                        <h5 class="subheading">Just like paper but better.</h5>
                        <button class="button btn-lg hidden-xs">Learn more</button>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div id="square-region" class="container-fluid">
        <div class="col-sm-12">
            <div class="square-region-header">
                <div class="header-text">Activities</div>
            </div>

            <!-- Start row with 2 squares -->
            <div class="row square-row">    
                <!-- Open Square  -->
                <div class="square-social col-sm-6">
                    <!-- Change min-height if you want to push long content -->
                    <div class="article" style="min-height:600px">
                        <div class="tile-header">
                            <time class="tile-timestamp">11:00 am</time>
                        </div>

                        <div class="social-wrapper">
                            <figure class="tile-content social-content" style="margin-top:18%">
                                <div class="social-source">
                                    <img class="social-source-image" src="https://pbs.twimg.com/profile_images/2782853520/5498f9c6981009e74a91f282a89c17b4_bigger.png" alt="">
                                    <a href="#"><h4>Notes Plus</h4></a>
                                </div>
                                <div style="text-align:center">
                                    Want to take a look at what I have to offer?
The QuickStart Guide itself was created using #NotesPlus
                                </div>
                                <div class="social-link">
                                    <a class="twitter-link" href="https://twitter.com/notesplusapp/status/263117003156516864"><i class="fa fa-twitter"></i></a>
                                </div>
                            </figure>
                        </div>

                        <div class="tile-footer hidden-xs">
                            <ul class="list-inline tile-share">
                                <li><a class="share" href="https://twitter.com/intent/tweet?in_reply_to=263117003156516864" target="_blank"><i class="fa fa-reply"></i></a></li>
                                <li><a class="share" href="https://twitter.com/intent/retweet?tweet_id=263117003156516864" target="_blank"><i class="fa fa-retweet"></i></a></li>
                                <li><a class="share" href="https://twitter.com/intent/favorite?tweet_id=263117003156516864" target="_blank"><i class="fa fa-star"></i></a></li>
                            </ul>
                        </div>

                        <div class="tile-footer-non-fixed visible-xs">
                            <ul class="list-inline tile-share">
                                <li><a class="share" href="https://twitter.com/intent/tweet?in_reply_to=263117003156516864" target="_blank"><i class="fa fa-reply"></i></a></li>
                                <li><a class="share" href="https://twitter.com/intent/retweet?tweet_id=263117003156516864" target="_blank"><i class="fa fa-retweet"></i></a></li>
                                <li><a class="share" href="https://twitter.com/intent/favorite?tweet_id=263117003156516864" target="_blank"><i class="fa fa-star"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- Close Square  -->

                <!-- Open Square  -->
                <div class="square-social col-sm-6">
                    <!-- Change min-height if you want to push long content -->
                    <div class="article" style="min-height:600px">
                        <div class="tile-header">
                            <time class="tile-timestamp">11:00 am</time>
                        </div>

                        <div class="social-wrapper">
                            <figure class="tile-content social-content" style="margin-top:15%">
                                <div class="social-source">
                                    <img class="social-source-image" src="https://pbs.twimg.com/profile_images/2782853520/5498f9c6981009e74a91f282a89c17b4_bigger.png" alt="">
                                    <a href="#"><h4>Notes Plus</h4></a>
                                </div>
                                <div style="text-align:center">
                                    Tip of the day: You can select any pen strokes by circling it and then edit, change color and pen thickness, resize, rotate, duplicate etc..
                                </div>
                                <div class="social-link">
                                    <a class="twitter-link" href="https://twitter.com/notesplusapp/status/263192193571905536"><i class="fa fa-twitter"></i></a>
                                </div>
                            </figure>
                        </div>

                        <div class="tile-footer hidden-xs">
                            <ul class="list-inline tile-share">
                                <li><a class="share" href="https://twitter.com/intent/tweet?in_reply_to=263192193571905536" target="_blank"><i class="fa fa-reply"></i></a></li>
                                <li><a class="share" href="https://twitter.com/intent/retweet?tweet_id=263192193571905536" target="_blank"><i class="fa fa-retweet"></i></a></li>
                                <li><a class="share" href="https://twitter.com/intent/favorite?tweet_id=263192193571905536" target="_blank"><i class="fa fa-star"></i></a></li>
                            </ul>
                        </div>

                        <div class="tile-footer-non-fixed visible-xs">
                            <ul class="list-inline tile-share">
                                <li><a class="share" href="https://twitter.com/intent/tweet?in_reply_to=263192193571905536" target="_blank"><i class="fa fa-reply"></i></a></li>
                                <li><a class="share" href="https://twitter.com/intent/retweet?tweet_id=263192193571905536" target="_blank"><i class="fa fa-retweet"></i></a></li>
                                <li><a class="share" href="https://twitter.com/intent/favorite?tweet_id=263192193571905536" target="_blank"><i class="fa fa-star"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- Close Square  -->
            </div> 
            <!-- End row -->

            <!-- Start row with 2 squares -->
            <div class="row square-row">    
                <!-- Open Square  -->
                <div class="square col-sm-6">
                    <div class="article">
                        <div class="tile-header">
                            <time class="tile-timestamp">10:00 am</time>
                        </div>
                        <figure class="tile-content">
                            <div><img src="http://notesplusapp.com/wp-content/uploads/NP4_Share_800x557.png" alt="" width="100%"></div>
                            <div>
                                <h2>Collaborate and Share</h2>
                                <h4 class="feature-footnotes">with many import/export options.</h4>
                            </div>                          
                        </figure>

                        <div class="tile-footer hidden-xs">
                            <ul class="list-inline tile-share">
                                <li><a class="share" href="https://twitter.com/intent/tweet?text=Collaborate and Share with many import/export options." target="_blank"><i class="fa fa-twitter"></i></a></li>
                                <li><a class="share" href="https://www.facebook.com/sharer/sharer.php?u=http://dev.gowriteon.com/home-square-tile" target="_blank"><i class="fa fa-facebook"></i></a></li>
                            </ul>
                        </div>

                        <div class="tile-footer-non-fixed visible-xs">
                            <ul class="list-inline tile-share">
                                <li><a class="share" href="https://twitter.com/intent/tweet?text=Collaborate and Share with many import/export options." target="_blank"><i class="fa fa-twitter"></i></a></li>
                                <li><a class="share" href="https://www.facebook.com/sharer/sharer.php?u=http://dev.gowriteon.com/home-square-tile" target="_blank"><i class="fa fa-facebook"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- Close Square -->

                <!-- Open Square  -->
                <div class="square col-sm-6">
                    <div class="article">
                        <div class="tile-header">
                            <time class="tile-timestamp">11:00 am</time>
                        </div>
                        <figure class="tile-content">
                            <div><img src="http://notesplusapp.com/wp-content/uploads/NP4_Share_800x557.png" alt="" width="100%"></div>
                            <div>
                                <h2>Use Less Paper</h2>
                                <h4 class="feature-footnotes">and be more organized.</h4>
                            </div>
                        </figure>

                        <div class="tile-footer hidden-xs">
                            <ul class="list-inline tile-share">
                                <li><a class="share" href="https://twitter.com/intent/tweet?text=Use Less Paper and be more organized." target="_blank"><i class="fa fa-twitter"></i></a></li>
                                <li><a class="share" href="https://www.facebook.com/sharer/sharer.php?u=http://dev.gowriteon.com/home-square-tile" target="_blank"><i class="fa fa-facebook"></i></a></li>
                            </ul>
                        </div>

                        <div class="tile-footer-non-fixed visible-xs">
                            <ul class="list-inline tile-share">
                                <li><a class="share" href="https://twitter.com/intent/tweet?text=Use Less Paper and be more organized." target="_blank"><i class="fa fa-twitter"></i></a></li>
                                <li><a class="share" href="https://www.facebook.com/sharer/sharer.php?u=http://dev.gowriteon.com/home-square-tile" target="_blank"><i class="fa fa-facebook"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- Close Square  -->
            </div> 
            <!-- End row -->

            <!-- Start row with 2 squares -->
            <div class="row square-row">    
                <!-- Open Square  -->
                <div class="square col-sm-6">
                    <div class="article">
                        <div class="tile-header">
                            <time class="tile-timestamp">10:00 am</time>
                        </div>
                        <figure class="tile-content">
                            <div><img src="http://notesplusapp.com/wp-content/uploads/NP4_Visual_800x1025.png" alt="" width="100%"></div>
                            <div>
                                <h2>Be More Visual</h2>
                                <h4 class="feature-footnotes">with shapes and pictures.</h4>
                            </div>                            
                        </figure>

                        <div class="tile-footer hidden-xs">
                            <ul class="list-inline tile-share">
                                <li><a class="share" href="https://twitter.com/intent/tweet?text=Be More Visual with shapes and pictures." target="_blank"><i class="fa fa-twitter"></i></a></li>
                                <li><a class="share" href="https://www.facebook.com/sharer/sharer.php?u=http://dev.gowriteon.com/home-square-tile" target="_blank"><i class="fa fa-facebook"></i></a></li>
                            </ul>
                        </div>

                        <div class="tile-footer-non-fixed visible-xs">
                            <ul class="list-inline tile-share">
                                <li><a class="share" href="https://twitter.com/intent/tweet?text=Be More Visual with shapes and pictures." target="_blank"><i class="fa fa-twitter"></i></a></li>
                                <li><a class="share" href="https://www.facebook.com/sharer/sharer.php?u=http://dev.gowriteon.com/home-square-tile" target="_blank"><i class="fa fa-facebook"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- Close Square -->

                <!-- Open Square  -->
                <div class="square col-sm-6">
                    <div class="article">
                        <div class="tile-header">
                            <time class="tile-timestamp">11:00 am</time>
                        </div>
                        <figure class="tile-content">
                            <div><img src="http://notesplusapp.com/wp-content/uploads/NP4_Visual_800x1025.png" alt="" width="100%"></div>
                            <div>
                                <h2>Import (External) PDFs</h2>
                                <h4 class="feature-footnotes">and take notes on them.</h4>
                            </div>
                        </figure>

                        <div class="tile-footer hidden-xs">
                            <ul class="list-inline tile-share">
                                <li><a class="share" href="https://twitter.com/intent/tweet?text=Import (External) PDFs and take notes on them." target="_blank"><i class="fa fa-twitter"></i></a></li>
                                <li><a class="share" href="https://www.facebook.com/sharer/sharer.php?u=http://dev.gowriteon.com/home-square-tile" target="_blank"><i class="fa fa-facebook"></i></a></li>
                            </ul>
                        </div>

                        <div class="tile-footer-non-fixed visible-xs">
                            <ul class="list-inline tile-share">
                                <li><a class="share" href="https://twitter.com/intent/tweet?text=Import (External) PDFs and take notes on them." target="_blank"><i class="fa fa-twitter"></i></a></li>
                                <li><a class="share" href="https://www.facebook.com/sharer/sharer.php?u=http://dev.gowriteon.com/home-square-tile" target="_blank"><i class="fa fa-facebook"></i></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!-- Close Square  -->
            </div> 
            <!-- End row -->
        </div>
    </div>

	<?php
		// Start the Loop.
		while ( have_posts() ) : the_post();
			// Include the page content template.
			// echo the_content();
		endwhile;
		?>
		</div>
	</div>
<?php
get_footer();?>

<script>
    $('.share').click(function(){
        return windowpop(this.href, 545, 433);
    });

    function windowpop(url, width, height) {
        var leftPosition, topPosition;
        //Allow for borders.
        leftPosition = (window.screen.width / 2) - ((width / 2) + 10);
        //Allow for title and status bars.
        topPosition = (window.screen.height / 2) - ((height / 2) + 50);
        //Open the window.
        window.open(url, "Window2", "status=no,height=" + height + ",width=" + width + ",resizable=yes,left=" + leftPosition + ",top=" + topPosition + ",screenX=" + leftPosition + ",screenY=" + topPosition + ",toolbar=no,menubar=no,scrollbars=no,location=no,directories=no");
    }

    $(window).resize(function() {
        // if ($(window).width() < 768) return;

        // $('.square-row').each(function(index) {
        //     $articles = $(this).find('.square');
        //     $height = $(this).height();

        //     $articles.each(function(index){
        //         $(this).height($height);
        //     });
        // });
    });

    $(window).load(function(){
        if ($(window).width() < 768) return;

        $('.square-row').each(function(index) {
            $articles = $(this).find('.square');
            $height = $(this).height();

            $articles.each(function(index){
                $(this).height($height+20);
            });
        });
    });
</script>
