<?php
// Do not delete these lines
	if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('Please do not load this page directly. Thanks!');

	if ( post_password_required() ) { ?>
		<p class="nocomments">This post is password protected. Enter the password to view comments.</p>
	<?php
		return;
	}
?>

<!-- You can start editing here. -->

<?php if ( have_comments() ) : ?>
 <?php else : // this is displayed if there are no comments so far ?>
	<?php if ( comments_open() ) : ?>
		<!-- If comments are open, but there are no comments. -->
	 <?php else : // comments are closed ?>
		<!-- If comments are closed. -->
		<!--<p class="nocomments">Comments are closed.</p>-->
	<?php endif; ?>
<?php endif; ?>


<?php if ( comments_open() ) : ?>

<!-- CommentOpen -->
<div id="respond">
	<div>
		<h2 class="heading strike"><span>Leave A Comment</span></h2>
	</div>

	<?php if ( get_option('comment_registration') && !is_user_logged_in() ) : ?>
		<p>You must be <a href="<?php echo wp_login_url( get_permalink() ); ?>">logged in</a> to post a comment.</p>
	<?php else : ?>
		<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform" role="form" class="form-horizontal">
			<?php if (is_user_logged_in()) : ?>
			<div class="form-group">
				<div class="col-xs-12 col-sm-10 col-sm-offset-1 col-md-8 col-md-offset-2 input-padding">
					<p>Logged in as <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. 
					<a href="<?php echo wp_logout_url(get_permalink()); ?>" title="Log out of this account">Log out &raquo;</a></p>
					<input type="hidden" name="author" id="author" value="<?php echo esc_attr($comment_author); ?>" />
					<input type="hidden" name="email" id="email" value="<?php echo esc_attr($comment_author_email); ?>" />
				</div>
			</div>
			<?php else : ?>
			<div class="form-group">
				<div class="col-xs-12 col-sm-5 col-sm-offset-1 col-md-4 col-md-offset-2 input-padding">
					<label class="sr-only" for="exampleInputEmail2">Name</label>
					<input type="text" name="author" id="author" class="form-control input-lg" size="50" tabindex="1" value="" aria-required="true" placeholder="Name" />
				</div>
				<div class="col-xs-12 col-sm-5 col-md-4 input-padding">
					<label class="sr-only" for="exampleInputEmail2">Email</label>
					<input type="email" name="email" id="email" class="form-control input-lg" size="50" tabindex="2" value="" aria-required="true" placeholder="Email" />
				</div>
			</div>
			<?php endif; ?>
			<div class="form-group">
				<div class="col-xs-12 col-sm-10 col-sm-offset-1 col-md-8 col-md-offset-2">
					<textarea name="comment" id="comment" class="form-control" cols="58" rows="12" tabindex="4"></textarea>
				</div>
			</div>
			<div class="form-group">
				<div class="col-xs-12 col-sm-10 col-sm-offset-1 col-md-8 col-md-offset-2">
					<input name="submit" type="submit" id="submit" tabindex="5" value="Submit Comment" class="btn btn-default btn-lg active">
					<?php cancel_comment_reply_link('<input type="button" value="Cancel" tabindex="5" id="cancel" name="cancel" class="btn btn-default btn-lg active"/>'); ?>
					<?php comment_id_fields(); ?>
				</div>
			</div>
			<?php do_action('comment_form', $post->ID); ?>
		</form>
	<?php endif;  ?>
	
	<?php 
		$comment_array = get_approved_comments($post->ID);
		if ($comment_array != null && sizeof($comment_array) > 0) : ?>
	<?php endif;  ?>
</div>

<?php 

	$comment_array = get_approved_comments($post->ID);
	if ($comment_array != null && sizeof($comment_array) > 0) : ?>

<div><h2 class="heading strike"></h2></div>
<div class="row">		
<div class="col-xs-12 col-sm-10 col-sm-offset-1 col-md-8 col-md-offset-2">
<div id="real-pagging" class="comment-nav">
	<?php 
		paginate_comments_links("prev_text=Older ←&next_text=→ Newer");
	 ?>
</div>
</div>

</div>
<?php endif;  ?>

<div class="row">		
<div class="col-xs-12 col-sm-10 col-sm-offset-1 col-md-8 col-md-offset-2">
<ol class="commentlist">
	<?php
		//Gather comments for a specific page/post 
		$comments = get_approved_comments($post->ID);

		//Display the list of comments
		wp_list_comments(array(
			'reverse_top_level' => false, //Show the latest comments at the top of the list
			'callback' => 'writeon_comments'
		), $comments);
	?>
</ol>
</div>
</div>

<?php 
	$comment_array = get_approved_comments($post->ID);
	if ($comment_array != null && sizeof($comment_array) > 0) : ?>
<div class="row">		
<div class="col-xs-12 col-sm-10 col-sm-offset-1 col-md-8 col-md-offset-2"">
<div id="alt-pagging">
	<?php 
		paginate_comments_links("prev_text=Older ←&next_text=→ Newer");
	 ?>
</div>
</div>
</div>
<?php endif;  ?>

	<script>
		jQuery("#real-pagging").html(jQuery("#alt-pagging").html());
	</script>
<?php endif; // if you delete this the sky will fall on your head ?>
