var host_url = "http://dev.gowriteon.com/wp-content/themes/WriteOn-WP";

jQuery(window).ready(function(){
    
    var firstLoad = jQuery('#wp-content-editor-container textarea').val();
    
    if (firstLoad == '' || firstLoad == null) {
        firstLoad = loadDefaultContent(jQuery('#wpcf-group-card-options select[name="wpcf[card-type]"]').val());
        jQuery('#wp-content-editor-container textarea').val(firstLoad);
        jQuery('#wp-content-editor-container iframe').contents().find('html body').html(firstLoad);
    }

    jQuery('#wpcf-group-card-options select[name="wpcf[card-type]"]').change(function() {
        var content = loadDefaultContent(jQuery( this ).val());
        jQuery('#wp-content-editor-container textarea').val(content);
        jQuery('#wp-content-editor-container iframe').contents().find('html body').html(content);
    });
});

function loadDefaultContent(type) {
    var url = "";
    if (type == 1) {    //Twitter
        url = host_url + '/page-templates/default-card-content/tweet.html';
    }
    else if (type == 2) {   //Facebook
        url = host_url + '/page-templates/default-card-content/facebook.html';
    }
    else if (type == 3) {   //Tumlr
        url = host_url + '/page-templates/default-card-content/tumblr.html';
    }
    else if (type == 4) {   //Press
        url = host_url + '/page-templates/default-card-content/press.html';
    }
    else if (type == 5) {   //Annoucement
        url = host_url + '/page-templates/default-card-content/annoucement.html';
    }
    else if (type == 6) {   //Review
        url = host_url + '/page-templates/default-card-content/review.html';
    }
    
    
    if (url == "") {
        return "";
    }

    var content = loadHTMLFromFile(url);

    return content;
}

function htmlDecode(input){
  var e = document.createElement('div');
  e.innerHTML = input;
  return e.childNodes.length === 0 ? "" : e.childNodes[0].nodeValue;
}

function loadHTMLFromFile(href) {
    var xmlhttp = new XMLHttpRequest();
    xmlhttp.open("GET", href, false);
    xmlhttp.send();
    return xmlhttp.responseText;
}