var videoPlayerWrapper,
    browserViewer = jQuery(window),
    videoPlayer,
    iOS = navigator.userAgent.match(/(iPod|iPhone|iPad)/),
    isBindScrollInDesktop = false,
	isFirefox = navigator.userAgent.toLowerCase().indexOf('firefox') > -1;

hideControl();    
initVideo();
   
function initVideo() {
    if (iOS) {
        videoPlayerWrapper = jQuery('#video_player_ios');
        videoPlayer = jQuery("#video_player_ios");
		
		removeDesktopComponents();
        
        // Binding event
        videoPlayerWrapper
            .on('playing', function() {
                hideControl();
            })
			.on('pause', function() {
                showControl();
            })
            .on('waiting', function() {
                hideControl();
            })
            .on('ended', function() {
                showControl();
				initSwitchVideoToSlide();
            })
            .click(function(e) {
                e.preventDefault();
            });
    } else {
        videoPlayerWrapper = jQuery('#video_player_desktop');
        videoPlayer = jQuery("#video_player_desktop").get(0);

		removeIosComponents();
        hidePlayButtonDesktop();
		handleFirefoxRefesh();
		
        // Binding event
        videoPlayerWrapper
            .on('playing', function() {
                hideControl();
				if(isBindScrollInDesktop == false) {
                    initScrollEventDesktop();
                    isBindScrollInDesktop = true;
                }
            })
            .on('ended', function() {
                showControl();
                /*showPlayButtonDesktop();
				videoPlayerWrapper.css("display", "inline");*/
				initSwitchVideoToSlide();
            })
            .click(function(e) {
                e.preventDefault();
            });
        
		initDesktopClickOnVideo();
		
		jQuery("#landing-video-button-play").click(function() {
			unmuteVideo();
			hidePlayButtonDesktop();
			playVideoPlayerDesktop();
		});
    }
}

function initScrollEventDesktop() {
	if (iOS) {
        return;
    }
    
    var iScrollPos = jQuery(window).scrollTop();
    jQuery(window).scroll(function () {
        var iCurScrollPos = jQuery(this).scrollTop();
        if (iCurScrollPos > iScrollPos) {
            console.log('Down');
            stopVideoPlayerDesktop();
            showPlayButtonDesktop();
            showControl();
        } else {
           console.log('Up');
        }
        iScrollPos = iCurScrollPos;
    });
}

function initDesktopClickOnVideo() {
	videoPlayerWrapper.on('click', function(event) {
		toggleVideoPlay();
	});
}

function toggleVideoPlay()
{
	/*
	 * If Video is playing: stop it
	 * If video is stopped: play it
	 */

	if ( isVideoPlayed() ) {
		stopVideoPlayerDesktop();
		muteVideo();
		showPlayButtonDesktop();
		showControl();
	} else {
		playVideoPlayerDesktop();
		unmuteVideo();
		hidePlayButtonDesktop();
		hideControl();
	}
}

function handleFirefoxRefesh() {
	if(isFirefox) {		
		videoPlayerWrapper = jQuery('#video_player_desktop_firefox');
		videoPlayer = jQuery("#video_player_desktop_firefox").get(0);
		
		onlyShowFFVideo();
		hideControl();
		
		setTimeout(function() {
			if(isBindScrollInDesktop == false) {
				initScrollEventDesktop();
				isBindScrollInDesktop = true;
			}
		}, 3000);
	}
}

function isVideoPlayed() {
	return (videoPlayer.paused == false)
}

function removeIosComponents() {
    jQuery("#video_player_ios").remove();
}

function removeDesktopComponents() {
    jQuery("#video_player_desktop").remove();
	jQuery("#video_player_desktop_firefox").remove();
    jQuery("#landing-video-button-play").remove();
}

function onlyShowFFVideo() {
	jQuery("#video_player_desktop").remove();
	jQuery("#video_player_ios").remove();
}

function hideControl() {
    jQuery(".launchHeader").hide();
    jQuery(".launchFooter").hide();
	jQuery("nav#topNavigation").hide();
}

function showControl() {
    jQuery(".launchHeader").show();
	jQuery("nav#topNavigation").show();
}

function playVideoPlayerDesktop() {
    videoPlayer.play();
}

function stopVideoPlayerDesktop() {
    videoPlayer.pause();
}

function showPlayButtonDesktop() {
    jQuery("#landing-video-button-play").show();
}

function hidePlayButtonDesktop() {
    jQuery("#landing-video-button-play").hide();
}

function muteVideo() {
	videoPlayerWrapper.prop('muted', true);
}

function unmuteVideo() {
	videoPlayerWrapper.prop('muted', false);
}

function initSwitchVideoToSlide() {
	setTimeout(switchVideoToSlide, 5000);
}

function switchVideoToSlide() {
	if (typeof beginSlide == 'function') { 
		hidePlayButtonDesktop();
		jQuery(".launchFooter").show();
		jQuery("video").remove();
		
		if(typeof isShowVideo !== "undefined") {
			isShowVideo = false;
		}
		
		var imageContainer = jQuery('.slideImageContainer');
		imageContainer.animate({
			left: '-=100%'
		}, 500, function() {
			ResetLaunchSize();
			InitRatioLaunch();
			beginSlide();
			
			videoPlayerWrapper.animate({
				width: '0px'
			}, 500);
		});
		
		
		
		ResetLaunchSize();
		InitRatioLaunch();
		
	}
}



function hideVideoArea() {
	jQuery("#videoArea").css("display", "none");
}

function showSlideArea() {
	jQuery("#slider").css("display", "");
}