var slides,
	isSliding = false,
	noSlides = 0,
    slideTimer,
    hasSlideQueue = false,
	isHandledDevice = (/android|webos|iphone|ipad|ipod|blackberry|iemobile|opera mini/i.test(navigator.userAgent.toLowerCase()));

if(typeof delay === "undefined") {
        var delay = 15000;
}

if(typeof direction === "undefined") {
        var direction = "left";
}

function startSlide() {
	if(typeof slider === "undefined") {
		return;
	}	
	
	if(slider.length == 0) {
		return;
	}
	
	slides = slider.find(".launchSlide");
    noSlides = slides.length;
	if(noSlides < 2) {
		return;
	}
	
	positionSlides();
	initAnimateSlide();
	
	if(isHandledDevice) {
		initEventSwipe();
	}
}

function positionSlides() {
	var left = 0;
	for(index = 0; index < slides.length; index++) {
		slides.eq(index).css("left", left + "%");
		left += 100;
	}
}

function initAnimateSlide() {
	slideTimer = setInterval(animateSlide, delay);
}

function animateSlide() {

	if(isSwiping) {
		return;
	}

	// only animate when visible
	if(!isSwiping) {
		var windowTop = jQuery(document).scrollTop();
		var sliderTop = slider.offset().top;
		var delta = windowTop - sliderTop;
		if( (delta > 40) || (delta < -40) ) {
			return;
		}
	}

    
    
	if(isSliding == true || checkVideoPlaying() == true) {
        if(isSwiping && isVideoPausing()) {
            
        } else {
            return;
        }
	}
	
	isSliding = true;
	
	slides = slider.find(".launchSlide");
	slides.css("width", "100%");
	if(direction == "left") {
		swipeToLeft();
	} else {
        swipeToRight();
    }
}

function swipeToLeft() {
	/*slides.eq(0).animate({
		left: "-100%"
	}, 500, function() {
		slides.eq(0).css("left", (noSlides * 100) + "%");
		slider.append(slides.eq(0));
	});
	
	slides.eq(1).css("left", "100%");
	slides.eq(1).animate({
		left: "0%"
	}, 500, function() {
		isSliding = false;
	}); 
    
    for(i = 2; i < slides.length; i++) {
        slides.eq(i).css("left", ((i - 1) * 100) + "%");
    }*/
    
    var slideLeft = parseInt(slides.eq(slides.length - 1).css("left"), 10);
    if(slideLeft == 0) {
        slides.eq(0).css("left", "100%");
        slider.append(slides.eq(0));
    }
    
    for(i = 0; i < slides.length; i++) {
        slides.eq(i).animate({
            left: "-=100%"
        }, 500, function() {
            isSliding = false;
        });
    }
}

function swipeToRight() {
	/*var lastElement = slides.eq(noSlides - 1);
	slider.prepend(lastElement);
	lastElement.css("left", "-100%");

    for(i = 1; i < slides.length - 1; i++) {
        slides.eq(i).css("left", ((i + 1) * 100) + "%");
    }
    
	slides.eq(0).animate({
		left: "100%"
	}, 500, function() {
		
	});
	
	lastElement.animate({
		left: "0%"
	}, 500, function() {
		isSliding = false;
	});*/
    
    var slideLeft = parseInt(slides.eq(0).css("left"), 10);
    if(slideLeft == 0) {
        slides.eq(slides.length - 1).css("left", "-100%");
        slider.prepend(slides.eq(slides.length - 1));
    }
    
    for(i = 0; i < slides.length; i++) {
        slides.eq(i).animate({
            left: "+=100%"
        }, 500, function() {
            isSliding = false;
        });
    }
}

function initSwipeEvent() {
	if(jQuery(".launch").length <= 0) {
		return;
	}
	
	var eventHandler = new Hammer(jQuery(".launch").get(0));
	eventHandler.get('swipe').set({ velocity: 0.1, threshold: 30 });
	eventHandler
		.on("swipeleft swiperight", function(ev) {
			
			var deltaX = Math.abs(ev.deltaX);
			var deltaY = Math.abs(ev.deltaY);
			//alert("deltaX: " + deltaX + ", deltaY: " + deltaY + ", (deltaX / deltaY): " + (deltaX / deltaY));
			if((deltaX / deltaY) < 2) {
				return;
			}
			
			if(ev.type == "swipeleft") {
				console.log("swipe to left");
				direction = "left";
			} else {
				console.log("swipe to right");
				direction = "right";
			}
		
			isSwiping = true;
            clearInterval(slideTimer);
            swipeHandle();
			initAnimateSlide();
			isSwiping = false;
		});    
}

function swipeHandle() {
    if(!isSliding) {
        animateSlide();
    }
}

jQuery(document).ready(function() {
	startSlide();
});

function checkVideoPlaying() {
	if(typeof isVideoPlaying === "undefined") {
		return false;
	}
	
	return isVideoPlaying;
}


function isVideoPausing() {
    if(typeof isPausing === "undefined") {
		return false;
	}
	
	return isPausing;
}