var originTouch,
	currentTouch,
	isSwiping = false,
    currentLaunch,
    swipeDirection,
	isSwipingTimeOut,
    startTouchTimeStamp,
    endTouchTimeStamp,
	stackupTop;

var url = document.URL;
	
function initEventSwipe() {
	if(jQuery(".launch").length <= 0) {
		// Return if the launch area doesn't exist
		return;
	}

	stackupTop = parseInt(jQuery(".stackup-margin-top").css("margin-top"), 10);
	
	
	jQuery(".launch").get(0).addEventListener("touchstart", touchStartEvent, true);
	jQuery(".launch").get(0).addEventListener("touchmove", touchMoveEvent, true);
	jQuery(".launch").get(0).addEventListener("touchend", touchEndEvent, true);
	jQuery(".launch").get(0).addEventListener("touchcancel", touchCancelEvent, true);
    
    jQuery(window).on("orientationchange", handleOrientationChangeEvent);
}

function touchStartEvent(event) {
	console.log("touchStartEvent Begin");
	startTouchTimeStamp = new Date().getTime();
    
    stopSlideAnimate();
    
	var x = event.changedTouches[0].pageX;
	var y = event.changedTouches[0].pageY;
	originTouch = [x, y];
	currentTouch = [x, y];
	console.log("Touch point - x: " + x + ", y: " + y);

    checkLoopImage();
    
	console.log("touchStartEvent End");
}

function touchMoveEvent(event) {
	isSwiping = true;
	
	console.log("touchStartEvent Begin");
	
	var originX = currentTouch[0];
	var originY = currentTouch[1];
	
	var x = event.changedTouches[0].pageX;
	var y = event.changedTouches[0].pageY;
	currentTouch = [x, y];
	
	var deltaX = Math.abs(x - originX);
	var deltaY = Math.abs(y - originY);
	
	
	
	if((deltaX / deltaY) >= 1) {
		slides = slider.find(".launchSlide");
		
		slides.css("left", "+=" + (x - originX) + "px");
	
	
		event.preventDefault();
	} else {
		
	}
	
    checkLoopImage();
    
	console.log("touchMoveEvent End");
}

function touchEndEvent(event) {
	console.log("touchEndEvent Begin");
	endTouchTimeStamp = new Date().getTime();
    
    
    var currentX = currentTouch[0];
    var originX = originTouch[0];
    var distance = Math.abs(currentX - originX);
    
	detectDirection(currentX, originX);
    var velocity = calculateVelocity(distance, startTouchTimeStamp, endTouchTimeStamp);
    
    removeLoopImage();
    finishSlide(velocity);
    startSlideAnimate();
    
	console.log("touchEndEvent End");
}

function handleOrientationChangeEvent(event) {
	
	
	OrientationChangeEvent(event);
	setTimeout(function() { 
		OrientationChangeEvent(event);
		scrollTopAfterRotate();
	}, 600);
}

function scrollTopAfterRotate() {
	var scrollTop = jQuery(document).scrollTop();
	var launchTop = jQuery(".launch").offset().top;
	var windowHeight = jQuery(window).height();
	
	if(Math.abs(scrollTop - launchTop) <= windowHeight * 0.7) {
		jQuery("html, body").animate({scrollTop: launchTop }, {duration:400});
	}
}

function OrientationChangeEvent(event) {
	var slides = slider.find(".launchSlide");
	var noSlides = slides.length;
	var currentIndex = 0;
   
	for(index = 0; index < slides.length; index++) {
		var currentSlideLeft = parseInt(slides.eq(index).css("left"), 10);
		
		
		if(currentSlideLeft == 0) {
			currentIndex = index;
		}
	}
	
	for(index = 0; index < slides.length; index++) {
		var currentSlideWidth = parseInt(slides.eq(index).width(), 10);
		var currentLeft = (index - currentIndex) * currentSlideWidth;
		slides.eq(index).css("left", currentLeft + "px");
	}
}

function detectDirection(currentX, originX) {
    
    if(currentX - originX > 0) {
        swipeDirection = "right";
        direction = "right";
    } else {
        swipeDirection = "left";
        direction = "left";
    }
}

function touchCancelEvent(event) {
	console.log("touchCancelEvent Begin");
    startSlideAnimate();
	console.log("touchCancelEvent End");
}

function stopSlideAnimate() {
	clearTimeout(isSwipingTimeOut);
    isSwiping = true;
    var slides = slider.find(".launchSlide");
    slides.stop(false, false);
}

function startSlideAnimate() {
	clearTimeout(isSwipingTimeOut);
    isSliding = false;
    //initAnimateSlide();
    isSwipingTimeOut = setTimeout(function() {
        isSwiping = false;
    }, 8000);
}

function checkLoopImage() {
    var slides = slider.find(".launchSlide");
    var noSlides = slides.length;
    slides.stop(true, false);
   
   
    for(index = 0; index < slides.length; index++) {
        var currentSlideLeft = parseInt(slides.eq(index).css("left"), 10);
        var currentSlideWidth = parseInt(slides.eq(index).width(), 10);
        
        if(0 == index && 0 <= currentSlideLeft) {
            var lastElement = slides.eq(noSlides - 1);
            slider.prepend(lastElement);
            lastElement.css("left", "-" + (currentSlideWidth - currentSlideLeft) + "px");
            return;
        } else if((noSlides - 1) == index && currentSlideLeft <= 0) {
            var firstElement = slides.eq(0)
            slider.append(firstElement);
            firstElement.css("left", (currentSlideWidth + currentSlideLeft) + "px");
            return;
        }
    }
}

function removeLoopImage() {
    
}

function finishSlide(velocity) {
    var slides = slider.find(".launchSlide");
    var noSlides = slides.length;
    currentLaunch = getCurrentLaunch(swipeDirection);
    var currentSlideLeft = parseInt(currentLaunch.css("left"), 10);
    var currentSlideWidth = parseInt(currentLaunch.width(), 10);
    
    if(swipeDirection == "right") {
        if(currentSlideLeft > 10 && velocity > 0.13) {
            stopAutomationSlider();
            finishToRightWhenSwipeRight(currentLaunch);
        } else /*if(currentSlideLeft <= (currentSlideWidth * 0.1))*/ {
            finishToLeftWhenSwipeRight(currentLaunch);
        }
    } else if(swipeDirection == "left") {        
        if((currentSlideLeft + currentSlideWidth) < (currentSlideWidth -10)  && velocity > 0.13) {
            stopAutomationSlider();
            finishToLeftWhenSwipeLeft(currentLaunch);
        } else /*if((currentSlideLeft + currentSlideWidth) >= (currentSlideWidth * 0.9))*/ {
            finishToRightWhenSwipeLeft(currentLaunch);
        }
    }
}

function stopAutomationSlider() {
    clearInterval(slideTimer);
}

function getCurrentLaunch(swipeDirection) {
    var slides = slider.find(".launchSlide");
    var noSlides = slides.length;
    var tempCurrentSlide;
    
    for(index = 0; index < slides.length; index++) {
        var currentSlideLeft = parseInt(slides.eq(index).css("left"), 10);
        var currentSlideWidth = parseInt(slides.eq(index).width(), 10);
        
        if(currentSlideLeft == 0) {
            return slides.eq(index);
        }
        
        if(swipeDirection == "left" && -currentSlideWidth <= currentSlideLeft && currentSlideLeft <= 0) {
            tempCurrentSlide = slides.eq(index);
        } else if(swipeDirection == "right" && 0 <= currentSlideLeft && currentSlideLeft <= currentSlideWidth) {
            tempCurrentSlide = slides.eq(index);
        }
    }
    
    return tempCurrentSlide;
}

function finishToRightWhenSwipeRight(currentLaunch) {  
    slides = slider.find(".launchSlide");
    var slideWidth = parseInt(currentLaunch.width(), 10);
    var slideLeft = parseInt(currentLaunch.css("left"), 10);
    
    var deltaLeft = (slideWidth - slideLeft);
    var duration = calculateDurationSlide(deltaLeft, 500, slideWidth);
    
    for(i = 0; i < slides.length; i++) {
        slides.eq(i).stop(true).animate({
            left: "+=" + deltaLeft + "px"
        }, duration, 'linear', function() {
            
        });
    }
}

function finishToLeftWhenSwipeRight(currentLaunch) {
    slides = slider.find(".launchSlide");
    var slideWidth = parseInt(currentLaunch.width(), 10);
    var slideLeft = parseInt(currentLaunch.css("left"), 10);
    
    var deltaLeft = slideLeft;
    var duration = calculateDurationSlide(deltaLeft, 500, slideWidth);
    
    for(i = 0; i < slides.length; i++) {
        slides.eq(i).stop(true).animate({
            left: "-=" + deltaLeft + "px"
        }, duration, 'linear', function() {
            
        });
    }
}

function finishToRightWhenSwipeLeft(currentLaunch) { 
    slides = slider.find(".launchSlide");
    var slideWidth = parseInt(currentLaunch.width(), 10);
    var slideLeft = parseInt(currentLaunch.css("left"), 10);
    
    var deltaLeft = Math.abs(slideLeft);
    var duration = calculateDurationSlide(deltaLeft, 500, slideWidth);
    
    for(i = 0; i < slides.length; i++) {
        slides.eq(i).stop(true).animate({
            left: "+=" + deltaLeft + "px"
        }, duration, 'linear', function() {
            
        });
    }
}

function finishToLeftWhenSwipeLeft(currentLaunch) {
    slides = slider.find(".launchSlide");
    var slideWidth = parseInt(currentLaunch.width(), 10);
    var slideLeft = parseInt(currentLaunch.css("left"), 10);
    
    var deltaLeft = (slideLeft + slideWidth);
    var duration = calculateDurationSlide(deltaLeft, 500, slideWidth);
    
    for(i = 0; i < slides.length; i++) {
        slides.eq(i).stop(true).animate({
            left: "-=" + deltaLeft + "px"
        }, duration, 'linear', function() {
            
        });
    }
}

function calculateVelocity(distance, startTimeStamp, endTimeStamp) {
    var duration = endTimeStamp - startTimeStamp;
    return distance / duration;
}

function calculateDurationSlide(delta, fullDuration, fullDelta) {
    return fullDuration * delta / fullDelta;
} 