var videoPlayerWrapper,
    browserViewer = jQuery(window),
    videoPlayer,
    iOS = navigator.userAgent.match(/(iPod|iPhone|iPad)/),
    isBindScrollInDesktop = false,
	isFirefox = navigator.userAgent.toLowerCase().indexOf('firefox') > -1,
	isVideoPlaying,
    delaySlideWhenEndVideo = 5000,
    delaySlideWhenPauseVideo = 5000,
    delaySlideWhenEndVideoTimer,
    isPausing = false;

function generateVideo(mp4Url, webmUrl, ogvUrl) {
	var printedVideo = "";
	var autoPlayText = "";
	if(isAutoStart) {
		autoPlayText = 'autoplay="true"';
	}
	
	if (iOS) {
		printedVideo = '<img id="landing-video-button-play" src="wp-content/themes/WriteOn-WP/img/landing/PlayButton.png"/><video style="width: 1280px; height: 720px; opacity: 0" id="video_player_ios" class="videoLanding" src="' + mp4Url + '" controls="controls"></video>';
	} else if(isFirefox) {
		printedVideo = '<img id="landing-video-button-play" src="wp-content/themes/WriteOn-WP/img/landing/PlayButton.png"/><video style="width: 1280px; height: 720px;" id="video_player_desktop_firefox" class="videoLanding" muted="muted" ' + autoPlayText + '  preload="metadata" src="' + ogvUrl + '"></video>';
	} else {
		printedVideo = '<img id="landing-video-button-play" src="wp-content/themes/WriteOn-WP/img/landing/PlayButton.png"/><video style="width: 1280px; height: 720px;" id="video_player_desktop" class="videoLanding" ' + autoPlayText + ' muted="muted" preload="metadata"><source src="' + mp4Url + '" type="video/mp4" data-format="mp4"><source src="' + webmUrl + '" type="video/webm" data-format="webm"><source src="' + ogvUrl + '" type="video/ogv" data-format="ogv"></video>';
	}
	
	document.write(printedVideo);
	setupVideo();
}
   
function setupVideo() {	
    if (iOS) {
        videoPlayerWrapper = jQuery('#video_player_ios');
        videoPlayer = jQuery("#video_player_ios");
		
        videoPlayerWrapper.addClass("hideVideoIpad");
        
        // Binding event
        videoPlayerWrapper
			.on('play', function() {
                clearTimeout(delaySlideWhenEndVideoTimer);
				isVideoPlaying = true;
                isPausing = false;
				jQuery("video").css("opacity", "1");
                removeBackground();
                videoPlayerWrapper.removeClass("hideVideoIpad");
			})
            .on('playing', function() {
				isVideoPlaying = true;
                isPausing = false;
				jQuery("video").css("opacity", "1");
                hideControl();
                videoPlayerWrapper.removeClass("hideVideoIpad");
            })
			.on('pause', function() {
                isPausing = true;
            })
            .on('waiting', function() {
                hideControl();
            })
            .on('ended', function() {
                delaySlideWhenEndVideoTimer = setTimeout(function() {
                    isVideoPlaying = false;
                }, delaySlideWhenEndVideo);
                
                showControl();
				switchVideo();
                showPlayButtonDesktop();
                jQuery("video").css("opacity", "0");
                showBackground();
                videoPlayerWrapper.addClass("hideVideoIpad");
            })
            .click(function(e) {
                e.preventDefault();
            });
    } else {
		if(isAutoStart) {
			hideControl();
		} else {
            jQuery("video").css("opacity", "0");
        }
        videoPlayerWrapper = jQuery('#video_player_desktop');
        videoPlayer = jQuery("#video_player_desktop").get(0);
		handleFirefoxRefesh();
		
        // Binding event
        videoPlayerWrapper
			.on('play', function() {
                clearTimeout(delaySlideWhenEndVideoTimer);
				isVideoPlaying = true;
                jQuery("video").css("opacity", "1");
                removeBackground();
			})
            .on('playing', function() {
				isVideoPlaying = true;
                hideControl();
				setCookie("videoPlayer_status", "2", 1000 * 24 * 60 * 60);
				if(isBindScrollInDesktop == false) {
                    initScrollEvent();
                    isBindScrollInDesktop = true;
                }
            })
            .on('pause', function() {
                delaySlideWhenEndVideoTimer = setTimeout(function() {
                    isVideoPlaying = false;
                }, delaySlideWhenPauseVideo);
                
                showControl();
                jQuery(".video-top-question").hide();
                jQuery(".video-top-ustoo").hide();
            })
            .on('ended', function() {
                delaySlideWhenEndVideoTimer = setTimeout(function() {
                    isVideoPlaying = false;
                }, delaySlideWhenEndVideo);
                showControl();
                showPlayButtonDesktop();
				/*videoPlayerWrapper.css("display", "inline");*/
                jQuery("video").css("opacity", "0");
                showBackground();
            })
            .click(function(e) {
                e.preventDefault();
            });
        
		initDesktopClickOnVideo();
    }
	
	jQuery("#landing-video-button-play").click(function() {
		isVideoPlaying = true;
		if(iOS) {
			jQuery("video").css("opacity", "1");
		} else {
			unmuteVideo();
			hidePlayButtonDesktop();
			playVideoPlayerDesktop();
		}		
	});
}

function initScrollEvent() {
	if (iOS) {
        return;
    }
    
    jQuery(window).scroll(function () {
	
		var sliderHeight = 0;
		var sliderTop = 0;
		if(typeof slider === "undefined") {
			sliderTop = 0;
			sliderBottom = 0;
		} else {
			sliderHeight = slider.height();
			sliderTop = slider.offset().top;
		}
	
        var iCurScrollPos = jQuery(this).scrollTop();
        if (iCurScrollPos < sliderTop - (sliderHeight * 1 / 3) ||
			iCurScrollPos > sliderTop + (sliderHeight * 1 / 3)) {
            stopVideoPlayerDesktop();
            showPlayButtonDesktop();
            
            jQuery(".launchHeader").show();
            jQuery("nav#topNavigation").show();
        }
    });
}

function initDesktopClickOnVideo() {
	videoPlayerWrapper.on('click', function(event) {
		toggleVideoPlay();
	});
}

function toggleVideoPlay()
{
	/*
	 * If Video is playing: stop it
	 * If video is stopped: play it
	 */

	if ( isVideoPlayed() ) {
		isVideoPlaying = false;
		stopVideoPlayerDesktop();
		muteVideo();
		showPlayButtonDesktop();
		showControl();
	} else {
		isVideoPlaying = true;
		playVideoPlayerDesktop();
		unmuteVideo();
		hidePlayButtonDesktop();
		hideControl();
	}
}

function handleFirefoxRefesh() {
	if(isFirefox) {		
		videoPlayerWrapper = jQuery('#video_player_desktop_firefox');
		videoPlayer = jQuery("#video_player_desktop_firefox").get(0);
		
		setTimeout(function() {
			if(isBindScrollInDesktop == false) {
				initScrollEvent();
				isBindScrollInDesktop = true;
			}
		}, 3000);
	}
}

function isVideoPlayed() {
	return (videoPlayer.paused == false)
}

function removeDesktopComponents() {
    jQuery("#video_player_desktop").remove();
	jQuery("#video_player_desktop_firefox").remove();
    jQuery("#landing-video-button-play").remove();
}

function hideControl() {
    jQuery(".launchHeader").hide();
    jQuery(".launchFooter").hide();
	jQuery("nav#topNavigation").hide();
	jQuery("#landing-video-button-play").hide();
	
	jQuery(".video-top-question").hide();
	jQuery(".video-top-ustoo").hide();
}

function showControl() {
    jQuery(".launchHeader").show();
	jQuery("nav#topNavigation").show();
	jQuery(".video-top-question").show();
	jQuery(".video-top-ustoo").show();
}

function playVideoPlayerDesktop() {
    videoPlayer.play();
}

function stopVideoPlayerDesktop() {
    videoPlayer.pause();
}

function showPlayButtonDesktop() {
    jQuery("#landing-video-button-play").show();
}

function hidePlayButtonDesktop() {
    jQuery("#landing-video-button-play").hide();
}

function muteVideo() {
	videoPlayerWrapper.prop('muted', true);
}

function unmuteVideo() {
	videoPlayerWrapper.prop('muted', false);
}

function hideVideoArea() {
	jQuery("#videoArea").css("display", "none");
}

function showSlideArea() {
	jQuery("#slider").css("display", "");
}

function setCookie(cname, cvalue, secs) {
	var d = new Date();
	d.setTime(d.getTime() + (secs*1000));
	var expires = "expires="+d.toGMTString();
	document.cookie = cname + "=" + cvalue + "; " + expires + "; path=/";
}

function switchVideo() {
	var oldUrl = videoPlayerWrapper.attr("src");
	videoPlayerWrapper.attr("src", "");
	videoPlayerWrapper.attr("src", oldUrl);
}

function showBackground() {
    videoPlayerWrapper.parent().parent().css("background-size", "");
}

function removeBackground() {
    videoPlayerWrapper.parent().parent().css("background-size", "0px");
}