var originalVideoLandingRatio = 0;
ResetVideoSize();
ScaleVideo();

jQuery(window).resize(function() {
    ResetVideoSize();
    ScaleVideo();
});

function ResetVideoSize() {
    jQuery(".videoLanding").css("margin-top", "0px");
}

function ScaleVideo() {
    var launchWidth = jQuery(".launch").width();
	var launchHeight = jQuery(".launch").height();
    var launchRatio = launchWidth / launchHeight;
    
    if(originalVideoLandingRatio == 0) {
        var videoLandingWidth = jQuery(".videoLanding").width();
        var videoLandingHeight = jQuery(".videoLanding").height();
        originalVideoLandingRatio = videoLandingWidth / videoLandingHeight;
    }
    
    if(launchRatio == originalVideoLandingRatio) {
        SetVideoSize(launchWidth, launchHeight);
    } else {
        var newHeight = launchWidth / originalVideoLandingRatio;
        var newMarginTop = (launchHeight - newHeight) / 2;
        SetVideoSize(launchWidth, newHeight, newMarginTop);
    }
}


function SetVideoSize(width, height, marginTop) {

    jQuery(".videoLanding").css("width", width).css("height", height).css("margin-top", marginTop);

}
