<?php
/**
 * Template Name: Card Page Template
 *
 * @package WordPress
 * @subpackage 
 * @since 
 */

get_header(); ?>

<link href="<?php echo get_bloginfo('template_url'); ?>/css/card-page-template.css" rel="stylesheet">

    <div id="card-page" class="container-fluid page-content">

	<?php
		// Start the Loop.
    	while ( have_posts() ) : the_post();
            //$feat_image = wp_get_attachment_url( get_post_thumbnail_id($post->ID) );
            ?>
            <!-- <div id="card-page-header" style="background-image: url('<?php echo $feat_image; ?>');"></div> -->
            <?php 
    		// Include the page content template.
    		echo the_content();

            // $post_types = get_post_types( '', 'names' ); 
            // foreach ( $post_types as $post_type ) {
            //    echo '<p>' . $post_type . '</p>';
            // }
    	endwhile;
    ?>
    
        <?php
            $count = 0;

            $args = array(
               'post_type' => 'card',
               'post_status' => 'publish',
               'posts_per_page' => -1, //limited myself to 3 posts
               'meta_key' => 'wpcf-content-date', //name of custom field
               'meta_query'   => array(
                    array(
                        'key' => 'wpcf-content-date'
                    ),
                    array(
                       'key' => 'wpcf-sticky',
                    )
                ),
            );
            add_filter('posts_orderby','customorderby');
            $the_query = null;
            $the_query = new WP_Query($args);
            remove_filter('posts_orderby','customorderby');

            if ($the_query->have_posts()) {
                while ($the_query->have_posts()) : $the_query->the_post();

                $customFields = get_post_meta(get_the_ID());
		$cardType = $customFields['wpcf-card-type'][0];


                if ($count % 2 == 0) {
			echo "\n<!-- Card row -->\n";
			echo '<div class="row card-row equal vcenter">' . "\n";
                }

                $side = 'card-right';
                if ($count % 2 == 0) {
                    $side = 'card-left';
                }


                $cardStyle = '';
                $socialLink = '';
                if( $cardType == 1 ) {
                        $cardStyle = 'twitter';
                        $socialLink = $customFields['wpcf-tweet-link'][0];
                }
                else if( $cardType == 2 ) {
                        $cardStyle = 'facebook';
                        $socialLink = $customFields['wpcf-facebook-link'][0];
                }
                else if( $cardType == 3 ) {
                        $cardStyle = 'tumblr';
                        $socialLink = $customFields['wpcf-tumblr-link'][0];
                }
                else if( $cardType == 4 ) {
                        $cardStyle = 'press';
                }
                else if( $cardType == 5 ) {
                        $cardStyle = 'announce';
                }
                else if( $cardType == 6 ) {
                        $cardStyle = 'appstore';
                }


		echo "\n<!-- Card item -->\n";
                echo '<div class="card-item ' . $side . ' ' . $cardStyle .  '">' . "\n";
                echo '<div class="vcenter">' . "\n";
		echo "\n<!-- Card content -->\n";

		echo '<div class="card-top">';
		echo '<span>' . date('M d, Y', $customFields['wpcf-content-date'][0]) . '</span>';
		echo '<span class="social-icon"><a href="' . $socialLink . '" target="__blank"><i class="fa fa-' . $cardStyle . '"></i></a></span>';
		echo '</div>';


                the_content();

		echo "\n<!-- end Card content -->\n";
        ?>
        
        <!-- Card footer -->

        <?php
	    // Twitter footer 
	    if ($customFields['wpcf-card-type'][0] == 1) : ?>
            <div class="card-footer">
		<?php
		/*
                <div class="published-date">
                    <?php 
                        echo date('M d, Y', $customFields['wpcf-content-date'][0]); 
                    ?>
                </div>
		*/
		?>
                <div class="sharing-group">
                    <ul class="list-inline">
                        <li><a class="share twitter" href="https://twitter.com/intent/tweet?in_reply_to=<?php echo $customFields['wpcf-tweet-id'][0]; ?>" target="_blank"><i class="fa fa-reply"></i></a></li>
                        <li><a class="share twitter" href="https://twitter.com/intent/retweet?tweet_id=<?php echo $customFields['wpcf-tweet-id'][0]; ?>" target="_blank"><i class="fa fa-retweet"></i></a></li>
                        <li><a class="share twitter" href="https://twitter.com/intent/favorite?tweet_id=<?php echo $customFields['wpcf-tweet-id'][0]; ?>" target="_blank"><i class="fa fa-star"></i></a></li>
                    </ul>
                </div>
            </div>
        <?php endif; ?>

        <?php
	    // Facebook footer 
	    if ($customFields['wpcf-card-type'][0] == 2) : ?>
            <div class="card-footer">
                <?php
                /*
                <div class="published-date">
                    <?php 
                        echo date('M d, Y', $customFields['wpcf-content-date'][0]); 
                    ?>
                </div>
		*/
		?>
                <div class="sharing-group">
                    <ul class="list-inline">
                        <!-- <li><a class="share facebook" href="http://www.facebook.com/plugins/like.php?href=<?php echo urlencode(the_permalink());?>&amp;width&amp;layout=button&amp;action=like&amp;show_faces=true&amp;height=30&amp;width=60&amp;appId=62534090745" target="_blank"><i class="fb-like"></i></a></li> -->
                        <li><iframe src="http://www.facebook.com/plugins/like.php?href=<?php echo urlencode(the_permalink());?>&amp;width&amp;layout=button&amp;action=like&amp;show_faces=true&amp;height=20&amp;width=50&amp;appId=62534090745" scrolling="no" frameborder="0" style="border:none; overflow:hidden; height:20px;width:50px;padding-top:0px;" allowTransparency="true"></iframe></li>
                        <li><a class="share link-facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink();?>" target="__blank"><i class="fa fa-share-square-o"></i></a></li>
                        <li><a class="share facebook" href="<?php echo $customFields['wpcf-facebook-link'][0]; ?>" target="_blank"><i class="fa fa-comment"></i></a></li>
                    </ul>
                </div>
            </div>
        <?php endif; ?>

        <?php
	    // Tumblr footer 
	    if ($customFields['wpcf-card-type'][0] == 3) : ?>
            <div class="card-footer tumblr">
                <?php
                /*
                <div class="published-date">
                    <?php 
                        echo date('M d, Y', $customFields['wpcf-content-date'][0]); 
                    ?>
                </div>
		*/
		?>
                <div class="sharing-group">
                    <ul class="list-inline">
                        <li><a class="share" href="http://www.tumblr.com/follow/<?php echo $customFields['wpcf-tumblr-user'][0]; ?>" target="_blank">Follow</a></li>
                        <li><a class="source-link tumblr" href="<?php echo $customFields['wpcf-tumblr-link'][0]; ?>" target="__blank"><img src="<?php echo get_bloginfo('template_url'); ?>/img/logo-cards/tumblr.png" height="24" /></a></li>
                    </ul>
                </div>
            </div>
        <?php endif; ?>

        <?php
	    // Press footer 
	    if ($customFields['wpcf-card-type'][0] == 4) : ?>
            <div class="card-footer">
                <?php
                /*
                <div class="published-date">
                    <?php 
                        echo date('M d, Y', $customFields['wpcf-content-date'][0]); 
                    ?>
                </div>
		*/
		?>
                <div class="sharing-group">
                    <ul class="list-inline">
                        <li><span class="share-title">Share:</span></li>
                        <li><a class="share link-twitter" href="https://twitter.com/intent/tweet?text=<?php echo urlencode($customFields['wpcf-content-for-share'][0]); ?>" target="_blank"><i class="fa fa-twitter"></i></a></li>
                        <li><a class="share link-facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>" target="__blank"><i class="fa fa-facebook"></i></a></li>
                    </ul>
                </div>
            </div>
        <?php endif; ?>

        <?php
	    // Announcement footer 
	    if ($customFields['wpcf-card-type'][0] == 5) : ?>
            <div class="card-footer annoucement">
                <div class="sharing-group">
                    <ul class="list-inline">
                        <!-- http://www.facebook.com/dialog/feed?app_id=123050457758183&message=Facebook%20Dialogs%20are%20so%20easy!&-->
                        <li><span class="share-title">Share:</span></li>
                        <li><a class="share link-twitter" href="https://twitter.com/intent/tweet?text=<?php echo urlencode($customFields['wpcf-content-for-share'][0]); ?>" target="_blank"><i class="fa fa-twitter"></i></a></li>
                        <li><a class="share link-facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>" target="__blank"><i class="fa fa-facebook"></i></a></li>
                    </ul>
                </div>
            </div>
        <?php endif; ?>

        <?php
	    // App Store footer 
	    if ($customFields['wpcf-card-type'][0] == 6) : ?>
            <div class="card-footer">
                <?php
                /*
                <div class="published-date">
                    <?php 
                        echo date('M d, Y', $customFields['wpcf-content-date'][0]); 
                    ?>
                </div>
		*/
		?>
                <div class="sharing-group">
                    <ul class="list-inline">
                        <li><span class="share-title">Share:</span></li>
                        <li><a class="share link-twitter" href="https://twitter.com/intent/tweet?text=<?php echo urlencode($customFields['wpcf-content-for-share'][0]); ?>" target="_blank"><i class="fa fa-twitter"></i></a></li>
                        <li><a class="share link-facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>" target="__blank"><i class="fa fa-facebook"></i></a></li>
                    </ul>
                </div>
            </div>
        <?php endif; ?>

	<!-- end Card footer -->

        <?php
                echo '</div>'; //End col-xs-12 col-md-6
                echo '</div>'; //End vcenter
		echo "\n<!-- end Card item -->\n";

		// one extra box if number of post is odd
		if( ($count == $the_query->post_count - 1) && ($count % 2 == 0) )
		    echo '<div class="card-item card-right">&nbsp;</div>';

                if (($count % 2 == 1) || ($count == $the_query->post_count - 1)) echo '</div>'; //End row equal vcenter
               
            // one extra box if number of post is odd 
                $count++;
                endwhile;
            } // END if have_posts loop

            wp_reset_query();
        ?>
    </div>
    </div> 
<!-- End Card Page -->
<?php get_footer(); ?>

<script type="text/javascript">
        $('.share').click(function(){
            return windowpop(this.href, 545, 433);
        });

        function windowpop(url, width, height) {
            var leftPosition, topPosition;
            //Allow for borders.
            leftPosition = (window.screen.width / 2) - ((width / 2) + 10);
            //Allow for title and status bars.
            topPosition = (window.screen.height / 2) - ((height / 2) + 50);
            //Open the window.
            window.open(url, "Window2", "status=no,height=" + height + ",width=" + width + ",resizable=yes,left=" + leftPosition + ",top=" + topPosition + ",screenX=" + leftPosition + ",screenY=" + topPosition + ",toolbar=no,menubar=no,scrollbars=no,location=no,directories=no");
        }

    </script>

<?php 
function customorderby($orderby) {
    return 'mt2.meta_value DESC, mt1.meta_value DESC';
}
?>
