<?php
// Do not delete these lines
	if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('Please do not load this page directly. Thanks!');

	if ( post_password_required() ) { ?>
		<p class="nocomments">This post is password protected. Enter the password to view comments.</p>
	<?php
		return;
	}
?>

<!-- You can start editing here. -->

<?php if ( have_comments() ) : ?>
	<hr/>	
	<div id="comments">
	
	 <?php else : // this is displayed if there are no comments so far ?>

	<?php if ( comments_open() ) : ?>
	<hr/>	<!-- If comments are open, but there are no comments. -->

	 <?php else : // comments are closed ?>
		<!-- If comments are closed. -->
		<!--<p class="nocomments">Comments are closed.</p>-->

	<?php endif; ?>
<?php endif; ?>


<?php if ( comments_open() ) : ?>
<!-- CommentOpen -->
<div id="respond">

<p><?php comment_form_title( 'Leave a Comment', 'Leave a Comment to <em>%s</em>' ); ?></p>

<p class="cancel-comment-reply">
	<?php cancel_comment_reply_link('<input type="button" value="Cancel" tabindex="5" id="cancel" name="cancel"/>'); ?>
</p>

<?php if ( get_option('comment_registration') && !is_user_logged_in() ) : ?>
<p>You must be <a href="<?php echo wp_login_url( get_permalink() ); ?>">logged in</a> to post a comment.</p>
<?php else : ?>

<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">

<?php if ( is_user_logged_in() ) : ?>

<p>Logged in as <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="Log out of this account">Log out &raquo;</a></p>

<?php else : ?>

<p><input type="text" name="author" id="author" value="<?php echo esc_attr($comment_author); ?>" size="22" tabindex="1" <?php if ($req) echo "aria-required='true'"; ?> />
<label for="author">Name <small><?php if ($req) echo "(required)"; ?></small></label></p>

<p><input type="text" name="email" id="email" value="<?php echo esc_attr($comment_author_email); ?>" size="22" tabindex="2" <?php if ($req) echo "aria-required='true'"; ?> />
<label for="email">Email <small><?php if ($req) echo "(required)"; ?></small></label></p>

<p><input type="text" name="url" id="url" value="<?php echo esc_attr($comment_author_url); ?>" size="22" tabindex="3" />
<label for="url">Website</label></p>

<?php endif; ?>

<!--<p><small><strong>XHTML:</strong> You can use these tags: <code><?php echo allowed_tags(); ?></code></small></p>-->

<p><textarea name="comment" id="comment" cols="58" rows="10" tabindex="4"></textarea></p>

<p><input name="submit" type="submit" id="submit" tabindex="5" value="Submit Comment" />
<input name="redirect_to" type="hidden" id="redirect_to" value="<?php echo(currentPageURL()) ?>" />
<?php comment_id_fields(); ?>
</p>
<?php do_action('comment_form', $post->ID); ?>

</form>

<?php endif;  ?>

</div>

		<?php 
			$diff = 0;
			
			function comment_count2( $count ) {
				if ( ! is_admin() ) {
					global $id;
					//$oriComments = get_comments(array(
						//'post_id' => $id,
						//'status' => 'approve' 
					//));
					$oriComments = get_comments('status=approved&number=1000&post_id=' . $id);
					//$oriComments = get_comments('status=approved&post_id=' . $id);
					$comments_by_type = separate_comments($oriComments);
					
					//$comments_by_type = separate_comments(get_comments('status=approved&post_id=' . $id));
					
					return count($comments_by_type['comment']);
				} else {
					return $count;
				}
			}
			
			$comment_count = comment_count2(0);
			
			if ($comment_count < 1)
			{
				echo("No Comments.");
			} else {
				echo($comment_count . " Comments");
			}
		?> <em>(<a href="#respond">+add yours?</a>)</em>
<?php if ( have_comments() ) : ?>
</div>
<?php endif; ?>


	<div id="real-pagging" class="comment-nav">
	</div>
	
	<ol class="commentlist">
	<?php //wp_list_comments('type=comment&callback=mytheme_comment&per_page='.$comment_per_page.'&reverse_top_level=false&avatar_size=42');
		wp_list_comments('type=comment&callback=mytheme_comment&reverse_top_level=false&avatar_size=42');
	?>
	</ol>

	<div id="alt-pagging" class="comment-nav">
		<?php /*<span class="previous"><?php previous_comments_link('Older') ?></span>
		<span class="next"><?php next_comments_link('Newer') ?></span>*/?>
		<?php 
			paginate_comments_links("prev_text=Older ←&next_text=→ Newer");


		 ?>
	</div>

	<script>
		jQuery("#real-pagging").html(jQuery("#alt-pagging").html());
	</script>
<?php endif; // if you delete this the sky will fall on your head ?>
