<?php 

// change the default style.css to a new file
add_filter('stylesheet_uri', 'change_css');
function change_css() {
	return get_bloginfo('template_url') . '/pcstyles.css';
}

// modify/remove class attributes in nav. menu
add_filter('nav_menu_css_class', 'my_css_attributes_filter', 100, 1);
add_filter('nav_menu_item_id', 'my_css_attributes_filter', 100, 1);
add_filter('page_css_class', 'my_css_attributes_filter', 100, 1);

//function my_css_attributes_filter($var) {
  //return is_array($var) ? array() : '';
//}

// keep particular classes if needed
function my_css_attributes_filter($var) {
  return is_array($var) ? array_intersect($var, array('current', 'current_home', 'current_page_item', 'current-menu-item', 'current-menu-parent', 'current-page-ancestor')) : '';
}

// Remove empty classes in custom menu list
function remove_empty_classes($menu) {
    $menu = preg_replace('/ class=""/','',$menu);
    return $menu;
}
add_filter ('wp_nav_menu','remove_empty_classes');

add_theme_support( 'menus' );
//Register WordPress Menus
function register_menu() {
register_nav_menus(array('primary'=>'HomeNav', 'secondary'=>'NotesplusappNav', 'product_menu'=>'ProductNav', 'about_menu'=>'AboutNav', 'notesabout_menu'=>'NotesaboutNav', 'notesdevelopment_menu'=>'NotesdevelopmentNav', 'notessupport_menu'=>'NotessupportNav'));
}
add_action( 'init' , 'register_menu' );


//sidebar widgets
if ( function_exists('register_sidebar') ) {
	/*register_sidebar(array(
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h4 class="widgettitle">',
		'after_title' => '</h4>',
	));
	*/
	register_sidebar(array(
		'before_widget' => '<div class="roundBox">',
		'after_widget' => '</div></div>
            <div class="roundBoxBottom">&nbsp;</div>
        </div>',
		'before_title' => '<div class="roundBoxTop"><h4 class="widgettitle">',
		'after_title' => '</h4></div><div class="roundBoxBody"><div id="%1$s" class="widget %2$s">',
	));
}


//custom comment template
function mytheme_comment($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?>
   <li id="comment-<?php comment_ID() ?>">
	<div class="comment-item" id="commententry-<?php comment_ID() ?>">
		<p class="comment-author">
			<?php echo get_avatar($comment,$size='42' ); ?>
			<?php printf(__('<cite>%s</cite>'), get_comment_author_link()) ?><br />
			<small><?php comment_date('M d, Y'); ?> @ <?php comment_time('H:i:s'); ?><?php edit_comment_link('Edit',' [',']') ?></small>
		</p>
		<div class="commententry">
			<?php if ($comment->comment_approved == '0') : ?>
			<p><em><?php _e('Your comment is awaiting moderation.') ?></em></p>
			<?php endif; ?>
			<?php 
				$comment_ID = 0;
				$comment = get_comment( $comment_ID );
				$comment_content = $comment->comment_content;
				echo nl2br($comment_content); 
			?>
			<?php //comment_text() ?>
			<?php //echo get_comment_text() ?>
		</div>
	
		<div class="reply">
		<?php comment_reply_link(array_merge( $args, array('add_below' => 'commententry', 'depth' => $depth, 'max_depth' => $args['max_depth'], 'reply_text' => 'Reply ↓'))) ?>
		</div>
	</div>
<?php
        }


/**
* add a default-gravatar to options
*/
if ( !function_exists('fb_addgravatar') ) {
function fb_addgravatar( $avatar_defaults ) {
    $myavatar = "http://notesplusapp.com/wp-content/themes/notesplusapp-lighttheme/img/defaultavatar.png";
    $avatar_defaults[$myavatar] = 'Test 2';

    return $avatar_defaults;
}

add_filter( 'avatar_defaults', 'fb_addgravatar' );
}


function currentPageURL() {
 $pageURL = 'http';
 if ($_SERVER["HTTPS"] == "on") {$pageURL .= "s";}
 $pageURL .= "://";
 if ($_SERVER["SERVER_PORT"] != "80") {
  $pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
 } else {
  $pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
 }
 return $pageURL;
}

/**
* Modify the permalink of the Ticket
**/

add_action('init', 'init_general');

function init_general() {
    global $wp_rewrite;
	$wp_rewrite->add_rewrite_tag("%ticket_title%", '([^/]+)', "post_type=ticket&name=");
}

add_filter('post_link', 'ticket_permalink', 10, 3);
add_filter('post_type_link', 'ticket_permalink', 10, 3);
 
function ticket_permalink($permalink, $post_id, $leavename) {
	if (strpos($permalink, '%ticket_title%') === FALSE) return $permalink;
				
		// Get post
		$post = get_post($post_id);
		if (!$post && strpos($post->post_type, 'ticket') === FALSE) return $permalink;
 
		$ticket_number = get_post_meta($post->ID,'wats_ticket_number',true);
		
		$permalink = str_replace($post->ID, $ticket_number, $permalink);
		$permalink = str_replace('%ticket_title%', $post->post_name, $permalink);
		
		return $permalink;
}

/**
* Allow to input ticket number
**/

function redirectToFullTicketPath()
{
	if (strpos($_SERVER['REQUEST_URI'], "/ticket/") !== FALSE) 
	{
		$requestURI = explode("/", $_SERVER['REQUEST_URI']);
		$ticket_number = $requestURI[sizeof($requestURI) - 1];
		
		global $wpdb;																			
		$tickets = $wpdb->get_results($wpdb->prepare("SELECT $wpdb->posts.* 
														FROM $wpdb->posts, $wpdb->postmeta 
														WHERE $wpdb->posts.ID = $wpdb->postmeta.post_id 
														AND $wpdb->posts.post_type = 'ticket'
														AND $wpdb->postmeta.meta_key = 'wats_ticket_number' 
														AND	$wpdb->postmeta.meta_value = '".$ticket_number."'"));
		
		foreach ($tickets as $ticket)
		{
			$temp = home_url( '/ticket/').$ticket->post_name;
			break;
		}
			
		wp_redirect( $temp );
	}
}
 
// add our function to template_redirect hook
add_action('template_redirect', 'redirectToFullTicketPath');



add_action('get_comment_text', 'add_auto_p_in_comment_text', 1);

function add_auto_p_in_comment_text($comment_text = "", $comment = "") {
	return wpautop($comment_text);
	//return $comment_text;
}

add_action('bbp_get_reply_author', 'bbp_get_reply_author_alternative', 1);

function bbp_get_reply_author_alternative($author = "", $reply_id = "") {
	if(isset($author) == false || $author == "") {
		$author = "Guest";
			
		if(isset($_POST["bbp_anonymous_name"]) && $_POST["bbp_anonymous_name"] != "") {
			$author = $_POST["bbp_anonymous_name"];
		} else if(isset($_POST["bbp_anonymous_email"]) && $_POST["bbp_anonymous_email"] != "") {
			$author = $_POST["bbp_anonymous_email"];
		}
		
		$author = "'" . $author . "'";
	}
	
	return $author;
}

add_editor_style('npstyles.css');

?>