<?php
/*
Template Name: Reset password page
*/
?>

<?php get_header(); ?>

<style>
	#content {
		width: 865px;
	}
</style>
<div id="content">

<h2>Reset password</h2>

<?php if(isset($_GET["lerror"])) { ?>
	<p style="color: red; font-weight:bold"><?php echo($_GET["lerror"]); ?></p>
<?php } ?>

<form name="resetpassform" id="resetpassform" action="<?php echo esc_url( site_url( 'wp-login.php?action=resetpass&key=' . urlencode( $_GET['key'] ) . '&login=' . urlencode( $_GET['login'] ), 'login_post' ) ); ?>" method="post">
    <input type="hidden" id="user_login" value="<?php echo esc_attr( $_GET['login'] ); ?>" autocomplete="off" />

    <p>
        <label for="pass1"><?php _e('New password') ?><br />
        <input type="password" name="pass1" id="pass1" class="input" size="20" value="" autocomplete="off" /></label>
    </p>
    <p>
        <label for="pass2"><?php _e('Confirm new password') ?><br />
        <input type="password" name="pass2" id="pass2" class="input" size="20" value="" autocomplete="off" /></label>
    </p>

    <div id="pass-strength-result" class="hide-if-no-js"><?php _e('Strength indicator'); ?></div>
    <p class="description indicator-hint"><?php _e('Hint: The password should be at least seven characters long. To make it stronger, use upper and lower case letters, numbers and symbols like ! " ? $ % ^ &amp; ).'); ?></p>

    <br class="clear" />
    <p class="submit">
    <input type="submit" name="wp-submit" id="wp-submit" class="button-primary" value="<?php esc_attr_e('Reset Password'); ?>" tabindex="100" />
    <input type="hidden" name="redirect_to" id="redirect_to" value="<?php echo get_option('home'); ?>/forums-reset-password" />
    </p>
    <p>
<a href="forums-login"><?php _e( 'Log in' ); ?></a>
<?php if ( get_option( 'users_can_register' ) ) : ?>
 | <a href="forums-register"><?php _e( 'Register' ); ?></a>
<?php endif; ?>
</p>

    </form>

</div>
<?php get_footer(); ?>
