<?php 

// change the default style.css to a new file
add_filter('stylesheet_uri', 'change_css');
function change_css() {
	return get_bloginfo('template_url') . '/pcstyles.css';
}

// modify/remove class attributes in nav. menu
add_filter('nav_menu_css_class', 'my_css_attributes_filter', 100, 1);
add_filter('nav_menu_item_id', 'my_css_attributes_filter', 100, 1);
add_filter('page_css_class', 'my_css_attributes_filter', 100, 1);

//function my_css_attributes_filter($var) {
  //return is_array($var) ? array() : '';
//}

// keep particular classes if needed
function my_css_attributes_filter($var) {
  return is_array($var) ? array_intersect($var, array('current', 'current_home', 'current_page_item', 'current-menu-item', 'current-menu-parent', 'current-page-ancestor')) : '';
}

// Remove empty classes in custom menu list
function remove_empty_classes($menu) {
    $menu = preg_replace('/ class=""/','',$menu);
    return $menu;
}
add_filter ('wp_nav_menu','remove_empty_classes');

add_theme_support( 'menus' );
//Register WordPress Menus
function register_menu() {
register_nav_menus(array('primary'=>'HomeNav', 'secondary'=>'NotesplusappNav', 'product_menu'=>'ProductNav', 'about_menu'=>'AboutNav', 'notesabout_menu'=>'NotesaboutNav', 'notesdevelopment_menu'=>'NotesdevelopmentNav', 'notessupport_menu'=>'NotessupportNav'));
}
add_action( 'init' , 'register_menu' );


//sidebar widgets
if ( function_exists('register_sidebar') ) {
	/*register_sidebar(array(
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h4 class="widgettitle">',
		'after_title' => '</h4>',
	));
	*/
	register_sidebar(array(
		'before_widget' => '<div class="roundBox">',
		'after_widget' => '</div></div>
            <div class="roundBoxBottom">&nbsp;</div>
        </div>',
		'before_title' => '<div class="roundBoxTop"><h4 class="widgettitle">',
		'after_title' => '</h4></div><div class="roundBoxBody"><div id="%1$s" class="widget %2$s">',
	));
}


//custom comment template
function mytheme_comment($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?>
   <li id="comment-<?php comment_ID() ?>">
	<div class="comment-item">
		<p class="comment-author">
			<?php echo get_avatar($comment,$size='42' ); ?>
			<?php printf(__('<cite>%s</cite>'), get_comment_author_link()) ?><br />
			<small><?php comment_date('M d, Y'); ?> @ <?php comment_time('H:i:s'); ?><?php edit_comment_link('Edit',' [',']') ?></small>
		</p>
		<div class="commententry">
			<?php if ($comment->comment_approved == '0') : ?>
			<p><em><?php _e('Your comment is awaiting moderation.') ?></em></p>
			<?php endif; ?>
		
			<?php comment_text() ?>
		</div>
	
		<div class="reply">
		<?php comment_reply_link(array_merge( $args, array('add_below' => 'commententry', 'depth' => $depth, 'max_depth' => $args['max_depth'], 'reply_text' => 'Reply ↓'))) ?>
		</div>
	</div>
<?php
        }


/**
* add a default-gravatar to options
*/
if ( !function_exists('fb_addgravatar') ) {
function fb_addgravatar( $avatar_defaults ) {
    $myavatar = "http://notesplusapp.com/wp-content/themes/notesplusapp-lighttheme/img/defaultavatar.png";
    $avatar_defaults[$myavatar] = 'Test 2';

    return $avatar_defaults;
}

add_filter( 'avatar_defaults', 'fb_addgravatar' );
}


function currentPageURL() {
 $pageURL = 'http';
 if ($_SERVER["HTTPS"] == "on") {$pageURL .= "s";}
 $pageURL .= "://";
 if ($_SERVER["SERVER_PORT"] != "80") {
  $pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
 } else {
  $pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
 }
 return $pageURL;
}

/**
* Modify the permalink of the Ticket
**/

add_action('init', 'init_general');

function init_general() {
    global $wp_rewrite;
	$ticket_structure = "/%post_id%-%ticket_title%";
	$wp_rewrite->add_rewrite_tag("%post_id%", '([^/]+)', "post=");
	$wp_rewrite->add_rewrite_tag("%ticket_title%", '([^/]+)', "post_type=ticket&name=");
	$wp_rewrite->add_permastruct('ticket', $ticket_structure, false);
}

add_filter('post_link', 'ticket_permalink', 10, 3);
add_filter('post_type_link', 'ticket_permalink', 10, 3);
 
function ticket_permalink($permalink, $post_id, $leavename) {
	if (strpos($permalink, '%ticket_title%') === FALSE) return $permalink;
				
		// Get post
		$post = get_post($post_id);
		if (!$post && strpos($post->post_type, 'ticket') === FALSE) return $permalink;
 
		$ticket_number = get_post_meta($post->ID,'wats_ticket_number',true);
		
		global $wp_rewrite;
		$permalink = $wp_rewrite->get_extra_permastruct('ticket');
		$permalink = str_replace('%post_id%', $post->ID, $permalink);
		$permalink = str_replace('%ticket_title%', $post->post_name, $permalink);
		//$permalink = str_replace($post->ID, $ticket_number, $permalink);
		$permalink = home_url(user_trailingslashit($permalink));
		return $permalink;
}
?>
